#include "leg/support/graphics/graphics.h"
#include "leg/libs/window/window.h"
#include "leg/support/utils/error.h"
#include "leg/libs/graphics/graphics.h"

#include <iostream>

using namespace leg::support::maths;
using namespace leg::support::graphics;
using namespace leg::libs::window;
using namespace leg::libs::graphics::lighting;
using namespace leg::libs::graphics::shadows;
using namespace std;

GLfloat matrix[16];
GLfloat l_pos[4] = {20,20,20,1};
GLfloat p_equ[4] = {0,1,0,0};


   void
   GenerateShadow()
   {
      real dot = l_pos[0] * p_equ[0] + l_pos[1] * p_equ[1] + l_pos[2] * p_equ[2] + l_pos[3] * p_equ[3];
      int i, j;
      
      for (i=0; i<16; i++)
	 matrix[i] = 0;
      
      for (i=0; i<4; i++)
	 matrix[5*i] = dot;
      
      for (i=0; i<4; i++)
	 for (j=0; j<4; j++)
	    *(&matrix[0] + 4 * i + j ) -= (  ( * ( l_pos + j ) )  *  ( * ( p_equ + i ) )  ) ;
   }

void DrawSurface()
{
   GLfloat a[4] = {.15,.5,.1,.7};
   glMaterialfv (GL_FRONT,GL_AMBIENT,a);

   glBegin (GL_QUADS);
   glNormal3f (0,1,0);
   glVertex3f (-20,0,-20);
   glVertex3f (-20,0,20);
   glVertex3f (20,0,20);
   glVertex3f (20,0,-20);
   glEnd();
}

void DrawShadower()
{
   GLfloat am[4] = {.6,.1,.7,1.};
   glMaterialfv (GL_FRONT,GL_AMBIENT,am);
   
   static float a = .0;
   if ((a+=.25) == 360)
      a = 0;
   static float x = 0;
   x += .0001;
   glTranslatef (0,2,0);
   glPushMatrix();
   glRotatef (a,0,1,0);
   glPushMatrix();
   glBegin (GL_TRIANGLES);
   glNormal3f (0,0,0);
   glVertex3f (-1,0,1);
   glVertex3f (1,0,0);
   glVertex3f (0,0,-1);
   glEnd();
   glPopMatrix();
   glPopMatrix();
}

class MyDrawer
{
   protected:

   MyDrawer () : l1 (NULL), l2 (NULL), l3 (NULL)
   {
   }

   ~MyDrawer()
   {
     delete l1;
     delete l2;
     delete l3;
   }

   PointLight *l1;
   SpotLight *l2;
   InfiniteLight *l3;

   Quadric *quadric;

   void Draw()
   {
      static bool first=true;
      if(first){
	 first=!first;/*
	 std::cout << "Drawing." << std::endl;

	 glEnable (GL_LIGHTING);

	 GLfloat amb[] = { 0., 0., 0. };
	 glLightModelfv (GL_LIGHT_MODEL_AMBIENT, amb);

	 l1 = new PointLight (Point<3> (0., 0., 0.));
	 l1->SetDiffuse (Color (1., 0.5, 0.5));
	 l1->Enable ();

	 l2 = new SpotLight (Point<3> (0., 0., 1.));
	 l2->SetSpotCutoff (30.);
	 l2->SetSpotExponent (100.);
	 l2->Enable ();
	 l2->SetDiffuse (Color (1., 1., 1.));

	 l3 = new InfiniteLight (Point<3> (1., 1., 2.));
	 //l3->Enable ();
	 l3->SetDiffuse (Color (0., 0.5, 0.5));

	 quadric = new Quadric ();
	 quadric->SetNormals (GLU_SMOOTH);*/
   glClearColor (0.,0.,0.,0.);
   glShadeModel (GL_SMOOTH);
   glDisable (GL_CULL_FACE);
   glEnable (GL_DEPTH_TEST);
   glEnable (GL_LIGHTING);
   glEnable (GL_LIGHT0);
   GenerateShadow();
      }/*
      static float a=0;
      if ((a+=.1)>360)
	 a-=360;

      glMatrixMode (GL_PROJECTION);
      glLoadIdentity();
      gluPerspective (90, 4/3, 0.125, 10);
      glMatrixMode (GL_MODELVIEW);

      l1->SetLoc (Point<3> (cos (DegToRad (a)), 0., sin (DegToRad (a))));
      l2->SetSpotDirection (Vector<3> (cos (DegToRad (a)) * 1.414, sin (DegToRad (a)) * 1.414, -1.));

      GLConfig depth;
      depth.SetOption (GL_DEPTH_TEST, true);

      glPushMatrix();
      {
        glTranslatef (0., 0., -2.);

	l1->Draw ();
	l2->Draw ();
	l3->Draw ();
	 
	depth.Push ();

	glMaterialf (GL_FRONT, GL_SHININESS, 0.5);
	GLfloat diffuse[] = { 1., 1., 1. };
	glMaterialfv (GL_FRONT, GL_DIFFUSE, diffuse);
	quadric->DrawSphere (0.5, 50, 50);

	glMaterialf (GL_FRONT, GL_SHININESS, 1.);
	GLfloat diffuse1[] = { 1., 0.5, 0.5 };
	glMaterialfv (GL_FRONT, GL_DIFFUSE, diffuse1);

	glPushMatrix();
	{
	  glTranslatef (1,1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glPushMatrix();
	{
	  glTranslatef (-1,1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glPushMatrix();
	{
	  glTranslatef (1,-1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glPushMatrix();
	{
	  glTranslatef (-1,-1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glMaterialf (GL_FRONT, GL_SHININESS, 0.);
	GLfloat diffuse2[] = { 0.25, 0.25, 1. };
	glMaterialfv (GL_FRONT, GL_DIFFUSE, diffuse2);

	glPushMatrix();
	{
	  glTranslatef (-1,0,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glPushMatrix();
	{
	  glTranslatef (1,0,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	glPushMatrix();
	{
	  glTranslatef (0,-1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();

	depth.Pop ();

	glPushMatrix();
	{
	  glTranslatef (0,1,0);
	  quadric->DrawSphere (0.5, 50, 50);
	}
	glPopMatrix();
      }
      glPopMatrix();*/
   glMatrixMode (GL_MODELVIEW);
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
   
   glPushMatrix();
   gluLookAt (4,4,4,0,0,0,0,1,0);
   
   glPushMatrix();
   glLightfv (GL_LIGHT0, GL_POSITION, l_pos);

   glPushMatrix();
   glPushClientAttrib (GL_ALL_ATTRIB_BITS);

   glColorMask (GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
   glDepthMask (GL_FALSE);
   glEnable (GL_STENCIL_TEST);
   glStencilFunc (GL_ALWAYS, 1, 0xffffffff);
   glStencilOp (GL_REPLACE, GL_REPLACE, GL_REPLACE);
   
   DrawSurface();
   
   glColorMask (GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
   glDepthMask (GL_TRUE);
   glStencilFunc (GL_EQUAL, 1, 0xffffffff);
   glStencilOp (GL_KEEP, GL_KEEP, GL_KEEP);
   
   glEnable (GL_BLEND);
   DrawSurface();
   glDisable (GL_BLEND);
   
   glPushMatrix();
   glDisable (GL_LIGHTING);
   glDisable (GL_DEPTH_TEST);
   glEnable (GL_BLEND);
   glStencilOp (GL_KEEP, GL_KEEP, GL_INCR);
   glColor4f (.2,.2,.2,.7);
   glMultMatrixf (matrix);
   
   DrawShadower();
   
   glEnable (GL_DEPTH_TEST);
   glDisable (GL_BLEND);
   glEnable (GL_LIGHTING);
   glPopMatrix();
   
   glDisable (GL_STENCIL_TEST);

   glPopAttrib();
   
   glPopMatrix();
   DrawShadower();
   glPopMatrix();
   glPopMatrix();
   }
};

struct MyHudDrawer
{
   MyHudDrawer(){}
   ~MyHudDrawer(){}
   
   void
   HudDraw()
   {
      ;
   }
};

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;
   typedef leg::libs::graphics::Drawer<MyDrawer,MyHudDrawer,MyWindow> ADrawer;

   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   cout << "Constructing window." << endl;
   leg::support::window::Window *win = new MyWindow (*dc);
   
   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   
   cout << "Creating window." << endl;
   win->Create();

   cout << "Making drawer." << endl;
   ADrawer drawer (static_cast<MyWindow&> (*win));
   leg::support::window::Event events (dc->Get(),win->GetAttributes());
  
   cout << "Running. (Press and release a key to stop the test)." << endl;
   
   while(1>0){
      events.Update();
      drawer.Draw();
   }

   delete win;
   win = 0;
   dc->Close();
   delete dc;
   dc = 0;

   return 0;
}

