#include "leg/support/graphics/graphics.h"
#include "leg/libs/window/window.h"
#include "leg/support/utils/error.h"
#include "leg/libs/graphics/graphics.h"
#include "leg/support/graphics/glextensions.h"
#include "leg/support/system/graphiccard.h"

#include <iostream>

using namespace std;
using namespace leg;

class MyDrawer
{
   protected:

   MyDrawer()
   {
   }

   ~MyDrawer()
   {
   }

   void Draw()
   {
   }
};

struct MyHudDrawer
{
   MyHudDrawer(){}
   ~MyHudDrawer(){}
   
   // the leg windowing should take care about if users want to draw Hud or not.
   void
   HudDraw()
   {
      ;
   }
};

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;
   typedef leg::libs::graphics::Drawer<MyDrawer,MyHudDrawer,leg::support::window::Window> MyDrawer;

   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   leg::support::window::Window *win = new MyWindow (*dc);
   
   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   //win->GetAttributes().SetDecorationUse (false);
   
   win->Create();

   support::system::GraphicCard gc;
   std::cout << gc.GetNameFromGl() << std::endl;
   std::string gl_ext = gc.GetExtensionsFromGl();
   std::string glu_ext = gc.GetExtensionsFromGlu();
   std::cout << gc.GetVendorFromGl() << std::endl;
   std::cout << gc.GetVersionFromGl() << std::endl;

   typedef leg::support::graphics::Extensions Ext;
   Ext::Load();
   Ext::CoutExtensionsSupport();

   if (Ext::IsExtensionSupported ("GL_EXT_vertex_array"))
      cout << "first is true" << endl;
   if (Ext::IsExtensionSupported ("blablabla"))
      cout << "second is true" << endl;
   
   delete win;
   delete dc;
   return 0;
}

