/*
 * this program tests all first layer of support/utils
 */

#include <loki/SmartPtr.h>
#include <iostream>

//using namespace leg;
using namespace Loki;
using namespace std;

/* How to use functors:  
   
   We declare a Loki functor with defining its template arguments with first 
   the return type of the communication function, then obligatory a typelist
   of the arguments of the function TYPELIST are not in the Loki namespace !
   
   *  typedef Loki::Functor<int,TYPELIST_1 (int)> Functor;
   
   Then we have the possibility to create a class having a member function
   matching the communication function interface given previously in the
   functor declaration. We instantiate an object of this type:
   
   *  button_responder = new ButtonResponder;

   We could now instantiate some functor:
   
   *  Functor *fc = new Functor (*button_responder);

   And make it communicate giving some specific arguments
   
   *  (*fc)(1);
*/

// this class is not compatible with the one we will
// provide, so we can use the default sp with it.
class Test
{
   int i;

   public:

   Test():i( 1){}

   inline int GetValue(){return i;}
};

int main( int argc, char **argv)
{
//   using namespace support::loki;

   // we define a new smart pointer owning Test pointers
   // and test different functions on it.
   SmartPtr<Test> sp( new Test);
   SmartPtr<Test> sp2( sp);

   // a way to get our pointee (new Test)
   cout << "Value in sp pointee: " << sp->GetValue() << endl;

   Test* tmp=0;
   Release( sp, tmp);

   if( !tmp){
      cout << "tmp has not been released." << endl;
   }
   else{
      // we just test a bit its integrity
      cout << "Value of pointee tmp get after release: " << tmp->GetValue() << endl;
      if( !GetImpl( sp))
	 cout << "sp is now null" << endl;
      else
	 cout << "Value of pointee in sp: " << sp->GetValue() << endl;
      cout << "Value of pointee in sp2: " << sp2->GetValue() << endl;
   }

   SmartPtr<Test> psp( sp2);
   Test *ptest= new Test;
   Reset( psp, ptest);

   SmartPtr<Test> psp2( ptest);
   
   Release( psp, tmp);
   Test *tmp2= 0;
   Release( psp2, tmp2);

//   if( tmp2)
//	   std::cout << "Error: tmp2 should have been null as already released before !" << std::endl;
   
   return 0;
}
