#include <iostream>
#include <leg/support/maths/maths.h>

using namespace leg::support::maths;
using namespace std;

int main( int argc, char **argv)
{
  Vector<3> v1 (3, -4, 1), v2 (-2, -1, 3);

  cout << v1 << endl << v2 << endl;

  cout << v1.Cross (v2) << endl;
  cout << v1.Dot (v2) << endl;
  cout << v1.Outer (v2) << endl;


  cout << endl << endl;

  Vector<4> v3;
  v3 (0) = 1;
  v3 (1) = 2;
  v3 (2) = -3;
  v3 (3) = 4;

  Vector<5> v4;
  v4 (0) = -4;
  v4 (1) = -4;
  v4 (2) = 1;
  v4 (3) = 5;
  v4 (4) = 3;

  Matrix<3, 4> m1 = v1.Outer (v3);
  Matrix<3, 4> m2 = v2.Outer (v3);
  Matrix<4, 5> m3 = v3.Outer (v4);

  cout << m1 << endl << endl << m2 << endl << endl << m3 << endl << endl;
  cout << m1 + m2 << endl << endl;
  cout << m2 * m3 << endl << endl;
  cout << m1.Minor (1, 2) << endl << endl;

  Matrix<5, 5> m4;
  m4 (0, 0) = 1; m4 (0, 1) = 6; m4 (0, 2) = 4; m4 (0, 3) = 2; m4 (0, 4) = 7;
  m4 (1, 0) = 3; m4 (1, 1) = 7; m4 (1, 2) = 7; m4 (1, 3) = 6; m4 (1, 4) = 9;
  m4 (2, 0) = 2; m4 (2, 1) = 0; m4 (2, 2) = 4; m4 (2, 3) = 1; m4 (2, 4) = 4;
  m4 (3, 0) = 1; m4 (3, 1) = 8; m4 (3, 2) = 7; m4 (3, 3) = 2; m4 (3, 4) = 7;
  m4 (4, 0) = 5; m4 (4, 1) = 8; m4 (4, 2) = 9; m4 (4, 3) = 0; m4 (4, 4) = 6;
  cout << m4 << endl << endl;
  cout << m4.Determinant () << endl << endl;
  cout << m4.Inverse () * m4 << endl << endl;


  cout << endl;

  Polynomial p (5, 3., 6., 0., 10., 5., 2.);

  cout << p << endl << p.Derivative () << endl << p.Derivative (2) << endl;
  cout << p.Derivative (3) << endl << p.Derivative (4) << endl;
  cout << p.Derivative (5) << endl << p.Derivative (6) << endl;

  cout << endl << endl << p.Antiderivative () << endl << p.Antiderivative (2) << endl;
  cout << p.Antiderivative (3) << endl;

  cout << endl << p.Integral (1., 2.) << endl;

  cout << endl << p (2) << endl;

  cout << pi << endl;



/*  Vector<4> mv;
  Vector<4> mv1 (1,1,1,1);
  Vector<4> mv2 = mv1;

  cout << mv << endl;
  cout << mv1 << endl;
  cout << mv2 << endl;
*/
  return 0;
}
