#include <leg/support/threads/thread.h>
#include <leg/support/threads/condmutex.h>
#include <iostream>

using namespace leg;

// this is the simple minimalistic class
// interface needed for making threads, synchronization and
// condition waitings using Leg.
struct MyThread:  public support::threads::Thread,
		  public support::threads::CondMutex
{
   int i;
   
   MyThread () :  support::threads::Thread (),
		  support::threads::CondMutex (),
		  i (0)
   {
   }
   
   void*
   Go (void *args= 0)
   {
      usleep( 1000); // we wait here in order not to throw the signal too early before main has
		     // realized it has to wait for it, avoiding system hangs. This is here just
		     // for the demo, programms will tend to order things. Another possibility
		     // is to reverse signal and wait from this class and main function.
      Lock ();
      Signal ();
      i=1;
      Unlock ();
      while (true){
	 Lock ();
	 ++i;
	 std::cout << "thread i: " << i << std::endl;
	 Unlock ();
	 //usleep (1);
      }
      return 0;
   }
};

int main (int argc, char **argv)
{
   MyThread my_thread;
   my_thread.Create ();

   while (true)
      {
	 my_thread.Lock ();
	 my_thread.Wait ();
	 if (my_thread.i==1){
	    my_thread.Unlock();
	    break;
	 }
	 my_thread.Unlock ();
      }
   
   while (true)
      {
	 my_thread.Lock ();
	 --my_thread.i;
	 std::cout << "main i: " << my_thread.i << std::endl;
	 my_thread.Unlock ();

	 //usleep (1);
      }
   
   return 0;
}
