#include <leg/libs/timing/timing.h>
#include <iostream>

using namespace leg;

struct MyTimer : libs::timing::Timer
{
  MyTimer (libs::timing::Timing &timing)
    : libs::timing::Timer (timing),
      count (0)
  {
  }

  void *Go (void *)
  {
    std::cout << ++count << " " << GetTiming ().GetCurrentTime () << std::endl;

    if (count == 10)
      {
	Unset (3);
      }
    if (count == 20)
      {
	exit (0);
      }

    return NULL;
  }

  int count;
};

int main (int argc, char **argv)
{
  libs::timing::Timing timing;
  MyTimer timer (timing);

  timer.Set (1.0);
  timer.Set (2.0);
  timer.SetRepeating (3.0, 1.0);
  timer.SetRepeating (3.5, 1.0);

  std::cout << "Current time is " << timing.GetCurrentTime () << "." << std::endl;

  for (;;);

  return 0;
}
