#include "leg/libs/window/window.h"
#include "leg/libs/graphics/graphics.h"
#include "leg/libs/threads/sync.h"
#include <iostream>

using namespace std;

struct MyDrawer
{
   MyDrawer(){}
   ~MyDrawer(){}
   void 
   Draw()
   {
      static bool first=true;
      if(first){
	 first=!first;
	 std::cout << "Drawing." << std::endl;
      }
      gluLookAt (0,0,1,0,0,0,0,1,0);
      static float a=0;
      static float b=0;
      if ((a+=.1)>360)
	 a-=360;
      if ((b+=.125)>360)
	 b-=360;
      glPushMatrix();
	 glScalef (.5,.5,.5);
	 glRotatef (a,1,0,0);
         glRotatef (b,0,1,0);
         glBegin (GL_LINES);
	    glColor3f (1,0,0);
            glVertex3f (0,0,0);
            glVertex3f (1,0,0);
	    glColor3f (0,1,0);
	    glVertex3f (0,0,0);
	    glVertex3f (0,1,0);
	    glColor3f (0,0,1);
	    glVertex3f (0,0,0);
	    glVertex3f (0,0,1);
	 glEnd();
      glPopMatrix();
   }
};

using leg::libs::window::Osd;

struct MyHudDrawer
{
   MyHudDrawer(){}
   ~MyHudDrawer(){}
   
   void
   HudDraw()
   {
      glPushMatrix();
      glColor3f (1,1,1);
      Osd::Locate (350,310,0);
      Osd::Print ("Hi world from GNU/Leg !");
      int h = 290;
      unsigned int j = 0;
      Osd::FontIterator i = Osd::GetFontIterator();
      for (;j<Osd::GetPatternedFontsSize();h-=10,++i,++j){
	 Osd::Locate (350,h);
	 Osd::Print (**i);
      }
      glPopMatrix();
   }
};

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;
   typedef leg::libs::graphics::Drawer<MyDrawer,MyHudDrawer,MyWindow> MyDrawer;

   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   leg::support::window::Window *win = new MyWindow (*dc);

   // testing our window could synchronize with threads.
   leg::libs::threads::Sync<>& sync_win = dynamic_cast <leg::libs::threads::Sync<>&> (*win);

   
   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   //win->GetAttributes().SetDecorationUse (false);
   
   win->Create();
   MyDrawer drawer (static_cast<MyWindow&> (*win));
   leg::support::window::Event events (dc->Get(),win->GetAttributes());
   leg::support::window::UserEvent *ev = 0;

   Osd::Connect (dc->Get());
   Osd::LoadFont ("fixed");
   /*
   if (!Osd::CheckFontsAvailability ("f*"))
      leg::support::utils::Error ("There's no font matching the wishes.","main()");
   else
      cout << "font seems available" << endl;
   
   Osd::LoadMatchedFonts();
   Osd::SelectFont (**Osd::GetFontIterator()); // should be well if we could select from an iterator directly too.
   */
   cout << "Running. (Press and release a key to stop the test)." << endl;
   
   while(1>0){
      events.Update();
      if (!(ev = events.GetLastEvent()))
	 ;//continue;
      else if (ev->type == leg::support::window::UserEvent::key_release)
	 break;
      drawer.Draw();

      // thread sync test
      sync_win.Lock();
      sync_win.Unlock();
   }

   delete win;
   win = 0;
   dc->Close();
   delete dc;
   dc = 0;

   return 0;
}

