/*
	lfs-install creates a LFS-system
	Copyright (C) 2002 Daniel Baumann <danielbaumann@linuxmail.org>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include<stdio.h>
#include<stdlib.h>

void print_usage(void);
void print_help(void);
void print_copyright(void);
void print_version(void);

void get_lfs(void);

void get_disk(void);
void get_package(void);
void get_prefile(void);
void get_precompile(void);
void get_file(void);
void get_compile(void);
void get_config(void);

int main(int argc, char *argv[])
{
	if (argc!=2)
	{
		print_usage();
		exit(EXIT_FAILURE);
	}

	if ((strcmp(argv[1],"-h")==0)||(strcmp(argv[1],"--help")==0))
	{
		print_help();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--version")==0)
	{
		print_version();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--create-lfs")==0)
	{
		get_lfs();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--temp")==0)
	{
		get_config();
		exit(EXIT_SUCCESS);
	}

	print_usage();
	exit(EXIT_FAILURE);
}

void print_usage(void)
{
	fprintf(stderr, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stderr, "Type `lfs-install --help' for details\n");
}

void print_help(void)
{
	fprintf(stdout, "lfs-install creates a LFS-system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Arguments:\n");
	fprintf(stdout, "  --create-lfs                         Create a LFS-system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "  --copyright                          Print the copyright information\n");
	fprintf(stdout, "  -h, --help                           Print this help\n");
	fprintf(stdout, "  --version                            Print version information\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Please report bugs to Daniel Baumann <danielbaumann@linuxmail.org> and\n");
	fprintf(stdout, "check `http://savannah.gnu.org/projects/lfs-install/' for updates.\n");
}

void print_copyright(void)
{
	fprintf(stdout, "lfs-install, Copyright (C) 2002 Daniel Baumann\n");
	fprintf(stdout, "lfs-install comes with ABSOLUTELY NO WARRANTY; for details see `COPYING'.\n");
	fprintf(stdout, "This is free software, and you are welcome to redistribute it\n");
	fprintf(stdout, "under certain conditions; see `COPYING' for details.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "lfs-install depends on LFS:\n");
	fprintf(stdout, "Linux From Scratch version 3.3, Copyright (C) 1999-2002 Gerard Beekmans\n");
	fprintf(stdout, "see `http://www.linuxfromscratch.org/' for more information.\n");
}

void print_version(void)
{
	fprintf(stdout, "lfs-install version 0.0.1-20020617\n");
}

void get_lfs(void)
{
	get_disk();
	get_package();
	get_prefile();
	get_precompile();
	get_file();
	get_compile();
	get_config();
}

void get_disk(void)
{
	char disk_name[100];
	char partition_name[100];
	char set_disk[100];
	char set_partition[100];
	char set_filesystem[100];

	fprintf(stdout, "Enter disk name (e.g. /dev/hda): ");
	fscanf(stdin, "%s", &disk_name);
	sprintf(set_disk, "fdisk %s", disk_name);
	system(set_disk);

	fprintf(stdout, "Enter partition name (e.g. /dev/hda1): ");
	fscanf(stdin, "%s", &partition_name);
	sprintf(set_partition, "mke2fs -L LFS %s", partition_name);
	system(set_partition);

	sprintf(set_filesystem, "if [ ! -d /mnt/lfs ]; then mkdir /mnt/lfs; fi && mount %s /mnt/lfs -t ext2 && if [ ! -d /mnt/lfs/proc ]; then mkdir /mnt/lfs/proc; fi && mount proc /mnt/lfs/proc -t proc", partition_name);
	system(set_filesystem);
}

void get_package(void)
{
	char mirror_number[100];
	char mirror_name[100];
	char set_package[1000];

	fprintf(stdout, "Instead of downloading the required packages to build your\n");
	fprintf(stdout, "LFS system from the official distribution sites, you can\n");
	fprintf(stdout, "download all of them conviniently from one of our FTP sites.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Please pick a mirror site that's geographically closest to\n");
	fprintf(stdout, "your location.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "North America\n");
	fprintf(stdout, "  1. Fremont, California, USA [8 Mbit]\n");
	fprintf(stdout, "  2. Lufkin, Texas, USA [6 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Europe\n");
	fprintf(stdout, "  3. Univ. of Twente, The Netherlands [100 Mbit]\n");
	fprintf(stdout, "  4. Oslo, Norway [100 Mbit]\n");
	fprintf(stdout, "  5. Vienna Univ. of Tech., Austria [64 Mbit]\n");
	fprintf(stdout, "  6. Karlskrona, Sweden [10 Mbit]\n");
	fprintf(stdout, "  7. Freising, Germany [4 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Australia\n");
	fprintf(stdout, "  8. Brisbane, Australia [155 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Other\n");
	fprintf(stdout, "  0. Custom server\n");
	fprintf(stdout, "\n");

	fprintf(stdout, "Enter mirror number (e.g. 1): ");
	fscanf(stdin, "%s", &mirror_number);

	if (strcmp(mirror_number,"1")==0)
	{
		sprintf(mirror_name, "ftp://ftp.linuxfromscratch.org/");
	}

	if (strcmp(mirror_number,"2")==0)
	{
		sprintf(mirror_name, "ftp://linuxfromscratch.idge.net/linuxfromscratch/");
	}
	
	if (strcmp(mirror_number,"3")==0)
	{
		sprintf(mirror_name, "ftp://ftp.snt.utwente.nl/pub/linux/lfs/");
	}
	
	if (strcmp(mirror_number,"4")==0)
	{
		sprintf(mirror_name, "ftp://ftp.no.linuxfromscratch.org/mirrors/lfs/");
	}
	
	if (strcmp(mirror_number,"5")==0)
	{
		sprintf(mirror_name, "ftp://ftp.at.linuxfromscratch.org/pub/lfs/");
	}
	
	if (strcmp(mirror_number,"6")==0)
	{
		sprintf(mirror_name, "ftp://ftp.se.linuxfromscratch.org/lfs/");
	}
	
	if (strcmp(mirror_number,"7")==0)
	{
		sprintf(mirror_name, "ftp://ftp.de.linuxfromscratch.org/mirrors/ftp.linuxfromscratch.org/");
	}
	
	if (strcmp(mirror_number,"8")==0)
	{
		sprintf(mirror_name, "ftp://ftp.planetmirror.com/pub/lfs/");
	}

	if (strcmp(mirror_number,"0")==0)
	{
		fprintf(stdout, "Enter custom server (e.g. ftp://localhost/mirror/lfs/): ");
		fscanf(stdin, "%s", &mirror_name);
	}

	sprintf(set_package, "if [ ! -d linuxfromscratch ]; then mkdir linuxfromscratch; fi && cd linuxfromscratch && if [ ! -e lfs-package-3.3.tar ]; then wget -c %slfs-packages/3.3/lfs-packages-3.3.tar; fi", mirror_name);
	system(set_package);
}

void get_prefile(void)
{
	char set_directory[100];
	char set_package[100];
	char set_lfsinstall[100];

	sprintf(set_directory, "cd commands && ./create_directories");
	system(set_directory);

	sprintf(set_package, "cd commands && ./copy_packages");
	system(set_package);

	sprintf(set_lfsinstall, "make lfs-install");
	system(set_lfsinstall);
}

void get_precompile(void)
{
	char preset_bash[100];
	char preset_binutils[100];
	char preset_bzip2[100];
	char preset_diffutils[100];
	char preset_fileutils[100];
	char preset_gawk[100];
	char preset_gcc[100];
	char preset_grep[100];
	char preset_gzip[100];
	char preset_linux[100];
	char preset_make[100];
	char preset_patch[100];
	char preset_sed[100];
	char preset_shutils[100];
	char preset_tar[100];
	char preset_texinfo[100];
	char preset_textutils[100];
	char set_files[100];
	
	sprintf(preset_bash, "cd commands && ./precompile_bash");
	system(preset_bash);
	
	sprintf(preset_binutils, "cd commands && ./precompile_binutils");
	system(preset_binutils);
	
	sprintf(preset_bzip2, "cd commands && ./precompile_bzip2");
	system(preset_bzip2);
	
	sprintf(preset_diffutils, "cd commands && ./precompile_diffutils");
	system(preset_diffutils);
	
	sprintf(preset_fileutils, "cd commands && ./precompile_fileutils");
	system(preset_fileutils);
	
	sprintf(preset_gawk, "cd commands && ./precompile_gawk");
	system(preset_gawk);
	
	sprintf(preset_gcc, "cd commands && ./precompile_gcc");
	system(preset_gcc);

	sprintf(preset_grep, "cd commands && ./precompile_grep");
	system(preset_grep);

	sprintf(preset_gzip, "cd commands && ./precompile_gzip");
	system(preset_gzip);

	sprintf(preset_linux, "cd commands && ./precompile_linux");
	system(preset_linux);

	sprintf(preset_make, "cd commands && ./precompile_make");
	system(preset_make);

	sprintf(preset_patch, "cd commands && ./precompile_patch");
	system(preset_patch);

	sprintf(preset_sed, "cd commands && ./precompile_sed");
	system(preset_sed);

	sprintf(preset_shutils, "cd commands && ./precompile_shutils");
	system(preset_shutils);

	sprintf(preset_tar, "cd commands && ./precompile_tar");
	system(preset_tar);

	sprintf(preset_texinfo, "cd commands && ./precompile_texinfo");
	system(preset_texinfo);

	sprintf(preset_textutils, "cd commands && ./precompile_textutils");
	system(preset_textutils);

	sprintf(set_files, "cd commands && ./create_files");
	system(set_files);
}

void get_file(void)
{
	char set_source[100];
	char set_package[100];

	sprintf(set_source, "cd /mnt/lfs/usr/src && rm -rf *");
	system(set_source);

	sprintf(set_package, "cd commands && ./copy_packages");
	system(set_package);
}

void get_compile(void)
{
	char set_chroot[100];
	char compile_glibc[100];
	char set_devices[100];
	char compile_manpages[100];
	char compile_findutils[100];
	char compile_gawk[100];
	char compile_ncurses[100];
	char compile_vim[100];
	char compile_gcc[100];
	char compile_bison[100];
	char compile_less[100];
	char compile_groff[100];
	char compile_man[100];
	char compile_perl[100];
	char compile_m4[100];
	char compile_texinfo[100];
	char compile_autoconf[100];
	char compile_automake[100];
	char compile_bash[100];
	char compile_flex[100];
	char compile_file[100];
	char compile_libtool[100];
	char compile_bin86[100];
	char compile_binutils[100];
	char compile_bzip2[100];
	char compile_ed[100];
	char compile_gettext[100];
	char compile_kbd[100];
	char compile_diffutils[100];
	char compile_e2fsprogs[100];
	char compile_fileutils[100];
	char compile_grep[100];
	char compile_gzip[100];
	char compile_lilo[100];
	char compile_make[100];
	char compile_modutils[100];
	char compile_netkitbase[100];
	char compile_patch[100];
	char compile_procinfo[100];
	char compile_procps[100];
	char compile_psmisc[100];
	char compile_reiserfsprogs[100];
	char compile_sed[100];
	char compile_shutils[100];
	char compile_nettools[100];
	char compile_shadow[100];
	char compile_sysklogd[100];
	char compile_sysvinit[100];
	char compile_tar[100];
	char compile_textutils[100];
	char compile_utillinux[100];
	char compile_bootscripts[100];
	char compile_linux[100];
	
	sprintf(set_chroot, "chroot /mnt/lfs /usr/lib/lfs-install/enter_chroot");
	system(set_chroot);

	sprintf(compile_glibc, "chroot /mnt/lfs /usr/lib/lfs-install/compile_glibc");
	system(compile_glibc);

	sprintf(set_devices, "chroot /mnt/lfs /usr/lib/lfs-install/set_devices");
	system(set_devices);

	sprintf(compile_manpages, "chroot /mnt/lfs /usr/lib/lfs-install/compile_manpages");
	system(compile_manpages);

	sprintf(compile_findutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_findutils");
	system(compile_findutils);

	sprintf(compile_gawk, "chroot /mnt/lfs /usr/lib/lfs-install/compile_gawk");
	system(compile_gawk);

	sprintf(compile_ncurses, "chroot /mnt/lfs /usr/lib/lfs-install/compile_ncurses");
	system(compile_ncurses);

	sprintf(compile_vim, "chroot /mnt/lfs /usr/lib/lfs-install/compile_vim");
	system(compile_vim);

	sprintf(compile_gcc, "chroot /mnt/lfs /usr/lib/lfs-install/compile_gcc");
	system(compile_gcc);

	sprintf(compile_bison, "chroot /mnt/lfs /usr/lib/lfs-install/compile_bison");
	system(compile_bison);

	sprintf(compile_less, "chroot /mnt/lfs /usr/lib/lfs-install/compile_less");
	system(compile_less);
	
	sprintf(compile_groff, "chroot /mnt/lfs /usr/lib/lfs-install/compile_groff");
	system(compile_groff);
	
	sprintf(compile_man, "chroot /mnt/lfs /usr/lib/lfs-install/compile_man");
	system(compile_man);

	sprintf(compile_perl, "chroot /mnt/lfs /usr/lib/lfs-install/compile_perl");
	system(compile_perl);

	sprintf(compile_m4, "chroot /mnt/lfs /usr/lib/lfs-install/compile_m4");
	system(compile_m4);

	sprintf(compile_texinfo, "chroot /mnt/lfs /usr/lib/lfs-install/compile_texinfo");
	system(compile_texinfo);

	sprintf(compile_autoconf, "chroot /mnt/lfs /usr/lib/lfs-install/compile_autoconf");
	system(compile_autoconf);

	sprintf(compile_automake, "chroot /mnt/lfs /usr/lib/lfs-install/compile_automake");
	system(compile_automake);
	
	sprintf(compile_bash, "chroot /mnt/lfs /usr/lib/lfs-install/compile_bash");
	system(compile_bash);

	sprintf(compile_flex, "chroot /mnt/lfs /usr/lib/lfs-install/compile_flex");
	system(compile_flex);
	
	sprintf(compile_file, "chroot /mnt/lfs /usr/lib/lfs-install/compile_file");
	system(compile_file);
	
	sprintf(compile_libtool, "chroot /mnt/lfs /usr/lib/lfs-install/compile_libtool");
	system(compile_libtool);

	sprintf(compile_bin86, "chroot /mnt/lfs /usr/lib/lfs-install/compile_bin86");
	system(compile_bin86);

	sprintf(compile_binutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_binutils");
	system(compile_binutils);

	sprintf(compile_bzip2, "chroot /mnt/lfs /usr/lib/lfs-install/compile_bzip2");
	system(compile_bzip2);

	sprintf(compile_ed, "chroot /mnt/lfs /usr/lib/lfs-install/compile_ed");
	system(compile_ed);

	sprintf(compile_gettext, "chroot /mnt/lfs /usr/lib/lfs-install/compile_gettext");
	system(compile_gettext);
	
	sprintf(compile_kbd, "chroot /mnt/lfs /usr/lib/lfs-install/compile_kbd");
	system(compile_kbd);

	sprintf(compile_diffutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_diffutils");
	system(compile_diffutils);
	
	sprintf(compile_e2fsprogs, "chroot /mnt/lfs /usr/lib/lfs-install/compile_e2fsprogs");
	system(compile_e2fsprogs);

	sprintf(compile_fileutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_fileutils");
	system(compile_fileutils);
	
	sprintf(compile_grep, "chroot /mnt/lfs /usr/lib/lfs-install/compile_grep");
	system(compile_grep);
	
	sprintf(compile_gzip, "chroot /mnt/lfs /usr/lib/lfs-install/compile_gzip");
	system(compile_gzip);
	
	sprintf(compile_lilo, "chroot /mnt/lfs /usr/lib/lfs-install/compile_lilo");
	system(compile_lilo);
	
	sprintf(compile_make, "chroot /mnt/lfs /usr/lib/lfs-install/compile_make");
	system(compile_make);
	
	sprintf(compile_modutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_modutils");
	system(compile_modutils);
	
	sprintf(compile_netkitbase, "chroot /mnt/lfs /usr/lib/lfs-install/compile_netkitbase");
	system(compile_netkitbase);
	
	sprintf(compile_patch, "chroot /mnt/lfs /usr/lib/lfs-install/compile_patch");
	system(compile_patch);
	
	sprintf(compile_procinfo, "chroot /mnt/lfs /usr/lib/lfs-install/compile_procinfo");
	system(compile_procinfo);
	
	sprintf(compile_procps, "chroot /mnt/lfs /usr/lib/lfs-install/compile_procps");
	system(compile_procps);
	
	sprintf(compile_psmisc, "chroot /mnt/lfs /usr/lib/lfs-install/compile_psmisc");
	system(compile_psmisc);
	
	sprintf(compile_reiserfsprogs, "chroot /mnt/lfs /usr/lib/lfs-install/compile_reiserfsprogs");
	system(compile_reiserfsprogs);
	
	sprintf(compile_sed, "chroot /mnt/lfs /usr/lib/lfs-install/compile_sed");
	system(compile_sed);
	
	sprintf(compile_shutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_shutils");
	system(compile_shutils);
	
	sprintf(compile_nettools, "chroot /mnt/lfs /usr/lib/lfs-install/compile_nettools");
	system(compile_nettools);
	
	sprintf(compile_shadow, "chroot /mnt/lfs /usr/lib/lfs-install/compile_shadow");
	system(compile_shadow);
	
	sprintf(compile_sysklogd, "chroot /mnt/lfs /usr/lib/lfs-install/compile_sysklogd");
	system(compile_sysklogd);
	
	sprintf(compile_sysvinit, "chroot /mnt/lfs /usr/lib/lfs-install/compile_sysvinit");
	system(compile_sysvinit);
	
	sprintf(compile_tar, "chroot /mnt/lfs /usr/lib/lfs-install/compile_tar");
	system(compile_tar);
	
	sprintf(compile_textutils, "chroot /mnt/lfs /usr/lib/lfs-install/compile_textutils");
	system(compile_textutils);
	
	sprintf(compile_utillinux, "chroot /mnt/lfs /usr/lib/lfs-install/compile_utillinux");
	system(compile_utillinux);
	
	sprintf(compile_bootscripts, "chroot /mnt/lfs /usr/lib/lfs-install/compile_bootscripts");
	system(compile_bootscripts);

	sprintf(compile_linux, "chroot /mnt/lfs /usr/lib/lfs-install/compile_linux");
	system(compile_linux);
}

void get_config(void)
{
	char config_vim[100];
	char config_glibc[100];
	char config_dynamicloader[100];
	char config_sysklogd[100];
	char config_shadow[100];
	char config_sysvinit[100];
	char config_var[100];
	char config_rootpasswd[100];
	char config_setlock[100];
	char config_hostname[100];
	char config_network[100];
	char config_gateway[100];
	char config_interface[100];
	char config_fstab[100];

	sprintf(config_vim, "chroot /mnt/lfs /usr/lib/lfs-install/config_vim");
	system(config_vim);

	sprintf(config_glibc, "chroot /mnt/lfs /usr/lib/lfs-install/config_glibc");
	system(config_glibc);

	sprintf(config_dynamicloader, "chroot /mnt/lfs /usr/lib/lfs-isntall/config_dynamicloader");
	system(config_dynamicloader);

	sprintf(config_sysklogd, "chroot /mnt/lfs /usr/lib/lfs-isntall/config_sysklogd");
	system(config_sysklogd);

	sprintf(config_shadow, "chroot /mnt/lfs /usr/lib/lfs-install/config_shadow");
	system(config_shadow);

	sprintf(config_sysvinit, "chroot /mnt/lfs /usr/lib/lfs-install/config_sysvinit");
	system(config_sysvinit);

	sprintf(config_var, "chroot /mnt/lfs /usr/lib/lfs-install/config_var");
	system(config_var);

	sprintf(config_rootpasswd, "chroot /mnt/lfs /usr/lib/lfs-install/config_rootpasswd");
	system(config_rootpasswd);

	sprintf(config_setlock, "chroot /mnt/lfs /usr/lib/lfs-install/config_setlock");
	system(config_setlock);

	sprintf(config_hostname, "chroot /mnt/lfs /usr/lib/lfs-install/config_hostname");
	system(config_hostname);

	sprintf(config_network, "chroot /mnt/lfs /usr/lib/lfs-install/config_network");
	system(config_network);

	sprintf(config_gateway, "chroot /mnt/lfs /usr/lib/lfs-install/config_gateway");
	system(config_gateway);

	sprintf(config_interface, "chroot /mnt/lfs /usr/lib/lfs-install/config_interface");
	system(config_interface);

	sprintf(config_fstab, "chroot /mnt/lfs /usr/lib/lfs-install/config_fstab");
	system(config_fstab);
}
