/*
	lfs-install creates a LFS-system
	Copyright (C) 2002 Daniel Baumann <danielbaumann@linuxmail.org>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include<stdio.h>
#include<stdlib.h>

void print_copyright(void);
void print_help(void);
void print_usage(void);
void print_version(void);

void create_system(void);

int main(int argc, char *argv[])
{
	if (argc!=2)
	{
		print_usage();
		exit(EXIT_FAILURE);
	}

	if (strcmp(argv[1],"--copyright")==0)
	{
		print_copyright();
		exit(EXIT_SUCCESS);
	}

	if ((strcmp(argv[1],"-h")==0)||(strcmp(argv[1],"--help")==0))
	{
		print_help();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--version")==0)
	{
		print_version();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--create-system")==0)
	{
		create_system();
		exit(EXIT_SUCCESS);
	}
	
	print_usage();
	exit(EXIT_FAILURE);
}

void print_copyright(void)
{
	fprintf(stdout, "lfs-install, Copyright (C) 2002 Daniel Baumann\n");
	fprintf(stdout, "lfs-install comes with ABSOLUTELY NO WARRANTY; for details see `COPYING'.\n");
	fprintf(stdout, "This is free software, and you are welcome to redistribute it\n");
	fprintf(stdout, "under certain conditions; see `COPYING' for details.\n");
}

void print_help(void)
{
	fprintf(stdout, "lfs-install creates a LFS-system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Arguments:\n");
	fprintf(stdout, "  --create-system                      create LFS system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "  --copyright                          print copyright information\n");
	fprintf(stdout, "  -h, --help                           print this help information\n");
	fprintf(stdout, "  --version                            print version information\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Please report bugs to Daniel Baumann <danielbaumann@linuxmail.org>,\n");
	fprintf(stdout, "check `http://savannah.gnu.org/projects/lfs-install/' for updates.\n");
}

void print_usage(void)
{
	fprintf(stderr, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stderr, "Type 1lfs-install --help' for details\n");
}

void print_version(void)
{
	fprintf(stdout, "lfs-install version 0.0.1-pre1\n");
}

void create_system(void)
{
	char prepare_precompilation[100];
	char precompile_packages[100];
	char prepare_compilation[100];
	char compile_packages[100];
	char finish_compilation[100];

	sprintf(prepare_precompilation, "cd scripts && ./prepare_precompilation");
	system(prepare_precompilation);

	sprintf(precompile_packages, "cd scripts && ./precompile_packages");
	system(precompile_packages);

	sprintf(prepare_compilation, "cd scripts && ./prepare_compilation");
	system(prepare_compilation);

	sprintf(compile_packages, "cd scripts && ./compile_packages");
	system(compile_packages);

	sprintf(finish_compilation, "cd scripts && ./finish_compilation");
	system(finish_compilation);
	
	fprintf(stdout, "Finish\n");
	fprintf(stdout, "Please edit /mnt/lfs/fstab, /etc/lilo.conf and run lilo\n");
}
