#!/bin/bash
# compile_lfs-static.sh
source scripts/scripts_settings


function PackageInstall ()
{
	cp ../lfs-packages/$1* $DIRECTORY_LFS/usr/src/

	cd $DIRECTORY_LFS/usr/src/

	for filename in *.tar.bz2; do
		tar xfjv $filename
		rm $filename
	done

	for filename in *.patch.bz2; do
		bzip2 -dv $filename
	done

	cd -

	../lfs-commands/$2

	rm -rf $DIRECTORY_LFS/usr/src/$1*
}

function PackagePrecompile ()
{
	PackageInstall bash		chapter5/Bash-2.05a
	PackageInstall binutils		chapter5/Binutils-2.13
	PackageInstall bzip2		chapter5/Bzip2-1.0.2
	PackageInstall diffutils	chapter5/Diffutils-2.8.1
	PackageInstall fileutils	chapter5/Fileutils-4.1
	PackageInstall findutils	chapter5/Findutils-4.1
	PackageInstall gawk		chapter5/Gawk-3.1.1
	PackageInstall gcc		chapter5/GCC-3.2
	PackageInstall grep		chapter5/Grep-2.5
	PackageInstall gzip		chapter5/Gzip-1.2.4a
	PackageInstall make		chapter5/Make-3.79.1
	PackageInstall patch		chapter5/Patch-2.5.4
	PackageInstall sed		chapter5/Sed-3.02
	PackageInstall sh-utils		chapter5/Sh-utils-2.0
	PackageInstall tar		chapter5/Tar-1.13
	PackageInstall texinfo		chapter5/Texinfo-4.2
	PackageInstall textutils	chapter5/Textutils-2.1
	PackageInstall util-linux	chapter5/Util-linux-2.11u
}

function main ()
{
	mkdir -p $DIRECTORY_LFS/usr/src/
	mkdir -p $DIRECTORY_LFS/static/

	PackagePrecompile

	rm -rf $DIRECTORY_LFS/usr/src/
}

main
