#!/bin/bash
source lfs-install.conf
for i in *.func; do source $i; done

function main
{
	# test if the user is root
	if [ ! $UID = 0 ]
	then
		echo 'Error: no permission (user is not root)'
		exit 1
	fi

	# test if it is already running
	if [ -e /var/lock/lfs-install.lock ]
	then
		echo 'Error: process locked (lfs-install is already running)'
		exit 1
	fi
        # manage the lock file
	trap 'test -e /var/lock/lfs-install.lock && rm -f /var/lock/lfs-install.lock; exit 0' 0 2 15
	touch /var/lock/lfs-install.lock

	# lfs chapter 4
	creating_partition
	creating_filesystem
	mounting_partition

	# lfs chapter 3
	if [ ! -d $LFSINSTALL_CACHE ]
	then
		download_packages
		verify_packages
	fi

	if [ ! -d $LFSINSTALL_SWAP ]
	then
		unpack_packages
	fi

	# lfs chapter 5
	optimize_packages
	precompile_packages

	# lfs chapter 6
	compile_packages

	# lfs chapter 7
	configure_packages

	# lfs chapter 8
	configure_packages2

	# lfs chapter 9
	configure_packages3

	# lfs-install cdrom
	echo -n 'Build cdrom: '
	read cdrom
	if [ $cdrom = y ]
	then
		build_cdrom
	else
		exit
	fi
}

main
