#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5_pass1)
		cd $LFS_SOURCES
		tar xfz gcc-core-3.3.1.tar.gz
		cd gcc-3.3.1

		mkdir ../gcc-build
		cd ../gcc-build
		../gcc-3.3.1/configure --prefix=/tools \
			--with-local-prefix=/tools \
			--disable-nls --enable-shared \
			--enable-languages=c
		make BOOT_LDFLAGS="-static" bootstrap
		make install
		ln -sf gcc /tools/bin/cc

		cd ..
		rm -rf gcc-{3.3.1,build}
		;;

	chapter5_pass2)
		cd $LFS_SOURCES
		tar xfz gcc-core-3.3.1.tar.gz
		tar xfz gcc-g++-3.3.1.tar.gz
		tar xfz gcc-testsuite-3.3.1.tar.gz
		cd gcc-3.3.1

		expect -c "spawn ls"
		patch -Np1 -i ../gcc-3.3.1-no_fixincludes-2.patch
		patch -Np1 -i ../gcc-3.3.1-specs-2.patch
		mkdir ../gcc-build
		cd ../gcc-build
		../gcc-3.3.1/configure --prefix=/tools \
			--with-local-prefix=/tools \
			--enable-clocale=gnu --enable-shared \
			--enable-threads=posix --enable-__cxa_atexit \
			--enable-languages=c,c++
		make
		#make -k check
		#../gcc-3.3.1/contrib/test_summary | more
		make install

		cd ..
		rm -rf gcc-3.3.1
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz gcc-core-3.3.1.tar.gz
		tar xfz gcc-g++-3.3.1.tar.gz
		tar xfz gcc-testsuite-3.3.1.tar.gz
		cd gcc-3.3.1

		patch -Np1 -i ../gcc-3.3.1-no_fixincludes-2.patch
		patch -Np1 -i ../gcc-3.3.1-suppress-libiberty.patch
		mkdir ../gcc-build
		cd ../gcc-build
		../gcc-3.3.1/configure --prefix=/usr \
			--enable-shared --enable-threads=posix \
			--enable-__cxa_atexit --enable-clocale=gnu \
			--enable-languages=c,c++
		make
		#make -k check
		make install
		ln -s ../usr/bin/cpp /lib
		ln -s gcc /usr/bin/cc

		cd ..
		rm -rf gcc-3.3.1
		;;
esac
