#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5)
		cd $LFS_SOURCES
		tar xfz perl-5.8.0.tar.gz
		cd perl-5.8.0

		patch -Np1 -i ../perl-5.8.0-libc-3.patch
		chmod u+w hints/linux.sh
		echo 'static_ext="IO re Fcntl"' >> hints/linux.sh
		./configure.gnu --prefix=/tools
		make perl utilities
		cp perl pod/pod2man /tools/bin
		mkdir -p /tools/lib/perl5/5.8.0
		cp -R lib/* /tools/lib/perl5/5.8.0

		cd ..
		rm -rf perl-5.8.0
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz perl-5.8.0.tar.gz
		cd perl-5.8.0

		./configure.gnu --prefix=/usr
		make
		echo "127.0.0.1 localhost $(hostname)" > /etc/hosts
		#make test
		make install

		cd ..
		rm -rf perl-5.8.0
		;;
esac
