#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter6)
		cd $LFS_SOURCES
		tar xfz shadow-4.0.3.tar.gz
		cd shadow-4.0.3

		touch /var/run/utmp /var/log/{btmp,lastlog,wtmp}
		chmod 644 /var/run/utmp /var/log/{btmp,lastlog,wtmp}
		touch /usr/bin/passwd
		patch -Np1 -i ../shadow-4.0.3-newgrp-fix.patch
		./configure --prefix=/usr --libdir=/usr/lib --enable-shared
		make
		make install
		cp etc/{limits,login.access} /etc
		sed -e 's%/var/spool/mail%/var/mail%' \
			-e 's%#MD5_CRYPT_ENAB.no%MD5_CRYPT_ENAB yes%' \
			etc/login.defs.linux > /etc/login.defs
		ln -s vipw /usr/sbin/vigr
		rm /bin/vipw
		mv /bin/sg /usr/bin
		mv /usr/lib/lib{shadow,misc}.so.0* /lib
		ln -sf ../../lib/libshadow.so.0 /usr/lib/libshadow.so
		ln -sf ../../lib/libmisc.so.0 /usr/lib/libmisc.so
		rm /bin/groups
		/usr/sbin/pwconv
		/usr/sbin/grpconv

		cd ..
		rm -rf shadow-4.0.3
		;;
esac
