#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5)
		cd $LFS_SOURCES
		tar xfz ncurses-5.3.tar.gz
		cd ncurses-5.3

		patch -Np1 -i ../ncurses-5.3-etip-2.patch
		patch -Np1 -i ../ncurses-5.3-vsscanf.patch
		./configure --prefix=/tools --with-shared \
			--without-debug --without-ada --enable-overwrite
		make
		make install

		cd ..
		rm -rf ncurses-5.3
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz ncurses-5.3.tar.gz
		cd ncurses-5.3

		patch -Np1 -i ../ncurses-5.3-etip-2.patch
		patch -Np1 -i ../ncurses-5.3-vsscanf.patch

		./configure --prefix=/usr --with-shared \
			--without-debug
		make
		make install
		chmod 755 /usr/lib/*.5.3
		chmod 644 /usr/lib/libncurses++.a
		mv /usr/lib/libncurses.so.5* /lib
		ln -sf ../../lib/libncurses.so.5 /usr/lib/libncurses.so
		ln -sf libncurses.so /usr/lib/libcurses.so

		cd ..
		rm -rf ncurses-5.3
		;;
esac
