/*

  libassh - asynchronous ssh2 client/server library.

  Copyright (C) 2013-2020 Alexandre Becoulet <alexandre.becoulet@free.fr>

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301 USA

*/

/**
   @file
   @short IO events handling and IO related helper functions

   This header provides @hl helper functions designed to handle
   @hl events generated by the @hl{transport layer}.

   It also provides terminal related @hl helper functions.
*/

#ifndef ASSH_HELPER_FD_H_
#define ASSH_HELPER_FD_H_

#include "assh.h"

#ifdef CONFIG_ASSH_STDIO
# include <stdio.h>
#endif

/** @This can be used to handle the @ref ASSH_EVENT_READ and @ref
    ASSH_EVENT_WRITE events by reading from and writing to a file
    descriptor. The amount of transferred data is returned.

    @This takes care of calling the @ref assh_event_done function.
*/
size_t
asshh_fd_event(struct assh_session_s *s,
	      struct assh_event_s *e, int fd);

/** @This read characters on the file descriptor until a new line is
    found. The terminal echo is disabled. Characters beyond the
    specified length are read but ignored. @This fails if the
    file descriptor is not a tty. */
ASSH_WARN_UNUSED_RESULT assh_status_t
asshh_fd_get_password(struct assh_context_s *c, const char **pass,
		     size_t max_len, int fd, assh_bool_t echo);

#ifdef CONFIG_ASSH_STDIO

/** @This writes a string to the passed stream, filtering out terminal
    control characters. */
void
asshh_print_string(FILE *out, const struct assh_cbuffer_s *str);

/** @This prints a list of algorithms selected by the kex exchange. */
void
asshh_print_kex_details(struct assh_session_s *s, FILE *out,
		       const struct assh_event_s *event);

#endif /* CONFIG_ASSH_STDIO */

#endif
