/********************************************************************************
	libeddml - parses eddml files to extract error information
	Copyright (C) 2004 by Pete Rowley
	pete@openrowley.com

    This file is part of the libeddml project.

    libeddml is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    libeddml is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*********************************************************************************/

#if !defined(_EDDML_H_)
#define _EDDML_H_

typedef struct _eddml_translator eddml_translator;

/* start up / shutdown */
/**
 * \brief Initialize libeddml.
		   *
		   * This function initializes the library and should be called once only
		   * before the calling application creates any threads.
		   *
		   * Applications which use libxml2 may wish to skip calling this function
		   * and initialize libxml2 directly.
		   * @return error code, zero for success, non-zero otherwise
 */
int eddml_init(void);
void eddml_done(void);

/* translator configuration */
int eddml_get_translator(eddml_translator **translator);
int eddml_use_translation_files(eddml_translator *translator, const char **filepaths, char **bad_paths);
int eddml_use_translation_paths(eddml_translator *translator, const char **paths, char **bad_paths);
int eddml_use_translation_defaults(eddml_translator *translator);
int eddml_translation_free(eddml_translator **translator);

/* translation enumeration */
int eddml_translate(eddml_translator *translator, char *errorText, long error, const char **errorsets);
int eddml_first_error(eddml_translator *translator);
int eddml_next_error(eddml_translator *translator);

/* translation data */
int eddml_get_name(eddml_translator *t, char **to);
int eddml_get_version(eddml_translator *t, char **to);
int eddml_get_authority(eddml_translator *t, char **to);
int eddml_get_docs(eddml_translator *t, char **to);

int eddml_get_error_code(eddml_translator *t, char **to);
int eddml_get_error_desc(eddml_translator *t, char **to);
int eddml_get_error_severity(eddml_translator *t, char **to);

int eddml_get_error_note_titles(eddml_translator *t, char ***to);
int eddml_get_error_note_bodies(eddml_translator *t, char ***to);
int eddml_get_error_symbol_languages(eddml_translator *t, char ***to);
int eddml_get_error_symbol_bodies(eddml_translator *t, char ***to);

#endif /* _EDDML_H_ */
