-- This file is part of a Liberty Eiffel library.
-- See the full copyright at the end.
--
class REFERENCE[E_]
   --
   -- This class is useful to share a common volatile expanded value between different objects or as the
   -- result of a once function.
   -- So in most cases the E_ type is expanded and the reference to the REFERENCE[E_] container object
   -- shared.
   --

inherit
   ANY_REFERENCE

create {ANY}
   default_create, set_item

feature {ANY}
   item: E_

   set_item (i: like item) assign item
      do
         item := i
      ensure
         item = i
      end

   clear
         -- Reset `item' with the default value.
      local
         default_item: like item
      do
         item := default_item
      end

end -- class REFERENCE
--
-- Copyright (C) 2009-2016: by all the people cited in the AUTHORS file.
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this software and associated documentation files (the "Software"), to deal
-- in the Software without restriction, including without limitation the rights
-- to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
-- copies of the Software, and to permit persons to whom the Software is
-- furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
-- OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
-- THE SOFTWARE.
