#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by 
Liberty Eiffel The GNU Eiffel Compiler, Eiffel tools and libraries
    release 2016.05 (Alexander Graham Bell)

Copyright (C), 2011-2016 - C.ADRIAN, P.REDAELLI, R.MACK
    http://www.liberty-eiffel.org

Original SmartEiffel code:
Copyright (C), 1994-2002 - INRIA - LORIA - ESIAL UHP Nancy 1 - FRANCE
Copyright (C), 2003-2005 - INRIA - LORIA - IUT Charlemagne Nancy 2 - FRANCE
D.COLNET, P.RIBET, C.ADRIAN, V.CROIZIER, F.MERIZEN
    http://smarteiffel.loria.fr
C Compiler options used: -pipe -O2
*/

#ifdef __cplusplus
}
#endif
#include "compile_to_c.h"
#ifdef __cplusplus
extern "C" {
#endif
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
/*
  This file (SmartEiffel/sys/runtime/base.c) is included for _all_ modes of
  compilation (-boost, -no_check, ... -all_check).
*/

/*
  Byte swapping function
*/
void copy_swap_16(const uint16_t *src, uint16_t *dest, int count){
  while (count--) {
	*dest++ = (*src << 8) | (*src >> 8);
	src++;
  }
}


void se_check_malloc(const void*result, const char*format, ...) {
  if (result == NULL) {
	handle(SE_HANDLE_NO_MORE_MEMORY, NULL);
#ifdef SE_EXCEPTIONS
	internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
	error0("No more memory.", NULL);
#else
	va_list arg;
	va_start(arg, format);
	vfprintf(SE_ERR,format, arg);
	va_end(arg);
	exit(EXIT_FAILURE);
#endif
  }
}

/*
  The wrapper for `malloc' (generated C code is supposed to use
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
   return se_malloc_(size, malloc);
}

void* se_malloc_(size_t size, void*(*alloc)(size_t)) {
  void *result = malloc(size);
  se_check_malloc(result, "No more memory (malloc failed).\n");
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
   return se_calloc_(nmemb, size, calloc);
}

void* se_calloc_(size_t nmemb, size_t size, void*(*alloc)(size_t,size_t)) {
  void *result = calloc(nmemb,size);
  se_check_malloc(result, "No more memory (calloc failed: %lu x %lu).\n", nmemb, size);
  return result;
}

/*
  The wrapper for `realloc' (generated C code is supposed to use
  only `se_realloc' instead of direct `realloc').
*/
void* se_realloc(void* src, size_t size) {
  void *result = realloc(src, size);
  se_check_malloc(result, "No more memory (realloc failed).\n");
  return result;
}

/* ---------------------------------------------------------------------- */

void se_die (int code) {
  handle(SE_HANDLE_DIE_WITH_CODE, &code);
  exit(code);
}

/*
	Runtime hooks
 */

static se_runtime_handler_t** handlers = NULL;
int handlers_count=0;

void register_handler(se_runtime_handler_t*handler) {
  int new_count = handlers_count + 1;
  handlers = (se_runtime_handler_t**)se_realloc(handlers, (new_count) * sizeof(void*));
  handlers[handlers_count] = handler;
  handlers_count = new_count;
}

void _handle(se_handler_action_t action, void*data) {
  int i;
  for (i = 0; i < handlers_count; i++) {
	handlers[i](action, data);
	/* *** Check type of this array. Function pointer may have different size from data pointer. (PH 17/07/08) */
  }
}
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#ifdef WIN32
#define SIMULATED_MODE
/* The simulated mode for WIN32.
*/
typedef struct _SIMULATED_DIR {
  HANDLE handle;
  WIN32_FIND_DATA data;
  int entry_used;
  char * pattern;
} SIMULATED_DIR;

static SIMULATED_DIR* simulated_opendir(char* path) {
  int len = strlen((char*)path);
  char* pattern = se_malloc(len + 5);
  SIMULATED_DIR* result = se_malloc(sizeof(SIMULATED_DIR));

  pattern = strcpy(pattern,(char*)path);
  if (pattern[len - 1] != '\\') pattern[len++] = '\\';
  pattern[len++] = '*';
  pattern[len++] = '.';
  pattern[len++] = '*';
  pattern[len++] = 0;
  result->handle = FindFirstFile(pattern,&(result->data));
  if (result->handle == INVALID_HANDLE_VALUE) {
    free(pattern);
    free(result);
    return NULL;
  } else {
    result->pattern = pattern;
  }
  result->entry_used = 0;
  return result;
}

static void* simulated_readdir(SIMULATED_DIR* dirstream) {
  if (dirstream->entry_used) {
    if (FindNextFile(dirstream->handle,&(dirstream->data))) {
      dirstream->entry_used = 1;
      return dirstream;
    }
    else {
      return NULL;
    }
  }
  else {
    dirstream->entry_used = 1;
    return dirstream;
  }
}

#define simulated_get_entry_name(x) ((x)->data.cFileName)

static int simulated_closedir(SIMULATED_DIR* dirstream) {
  FindClose(dirstream->handle);
  free(dirstream->pattern);
  free(dirstream);
  return 0;
}


/* GCC(MingW32) doesn't need these prototypes; whereas, LCC needs them. */
char * getcwd(char* buffer, int maxlen);
int chdir(const char* buffer);
int mkdir(const char* directory_path);
int rmdir(const char* directory_path);


#define simulated_getcwd(x, y) getcwd(x, y)
#define simulated_chdir(x) chdir(x)
#define simulated_rmdir(x) rmdir(x)

int simulated_mkdir(const char* directory_path, int perm) {

  mkdir(directory_path);
  return 0;
}

#endif  /* WIN32 */

#ifdef AMIGA
#define SIMULATED_MODE
/* The simulated mode for AmigaOS 2.04+
   Author: Thomas Aglassinger <agi@rieska.oulu.fi>

   Normally this shouldn't be necessary as all compilers include a
   simulation of the Un*x directory API. However, they differ in
   certain details, often resulting into compiler errors. Thus a
   implementation using native AmigaDOS calls seems preferable.

   Note that many of the happenings below have to deal with the
   various idiosyncracies of the "dos.library", which are not all
   documented clearly in the Autodocs. The biggest surprises should
   be reflected in comments. But consider reading chapter 17 of
   Ralph Babel's "Amiga Guru Book" before changing anything.
*/
#include <exec/types.h>
#include <dos/dos.h>
#include <dos/dostags.h>

#include <proto/exec.h>
#include <proto/dos.h>

typedef struct _SIMULATED_DIR {
  struct FileInfoBlock *info;
  BPTR lock;
} SIMULATED_DIR;


/* Release all resources allocated during `simulated_opendir'; also
   works correctly if structure was only partially initialized.
*/
static void free_simulated_dir(SIMULATED_DIR * dir) {
  if (dir != NULL) {
    if (dir->lock != NULL) {
      UnLock(dir->lock);
    }
    if (dir->info != NULL) {
      FreeDosObject(DOS_FIB, dir->info);
    }
    free(dir);
  }
}

static SIMULATED_DIR * simulated_opendir(char *path) {
  BOOL ok = FALSE;
  SIMULATED_DIR *result = se_malloc(sizeof(SIMULATED_DIR));

  if (result != NULL) {
    result->lock = NULL;
    result->info = (struct FileInfoBlock *) AllocDosObject(DOS_FIB, NULL);
    if (result->info != NULL) {
      result->lock = Lock(path, ACCESS_READ);
      if (result->lock != NULL) {
	ok = (Examine(result->lock, result->info) != DOSFALSE);
	if (ok) {
	  /* Ensure we are scanning a directory, not a file */
	  ok = (result->info->fib_DirEntryType >= 0)
	    && (result->info->fib_DirEntryType != ST_SOFTLINK);
	}
      }
    }
  }
  if (!ok) {
    free_simulated_dir(result);
    result = NULL;
  }
  return result;
}

static void * simulated_readdir(SIMULATED_DIR * dirstream) {
  BOOL ok;
  SIMULATED_DIR *result = NULL;

  ok = (ExNext(dirstream->lock, dirstream->info) != DOSFALSE);

  if (ok) {
    result = dirstream;
  }
  return (void *) result;
}

#define simulated_get_entry_name(entry) ((entry)->info->fib_FileName)

static int simulated_closedir(SIMULATED_DIR * dirstream) {
  free_simulated_dir(dirstream);
  return 0;
}


static EIF_POINTER simulated_getcwd(char *buffer, size_t maximum_length) {
     EIF_POINTER result = NULL;
     BPTR lock = Lock("", ACCESS_READ);
     if (lock != NULL) {
       if (NameFromLock(lock, buffer, maximum_length) != DOSFALSE) {
         result = (EIF_POINTER) buffer;
       }
       UnLock(lock);
     }
     return result;
   }

static int simulated_chdir(char *name) {
  int result = -1;
  BPTR lock = Lock(name, ACCESS_READ);
  if (lock != NULL) {
    /* Change the current working directory (CWD) of the task
     */
    BPTR old_lock = CurrentDir(lock);

    /* Attempt to update internal buffer of the process.
       If we are not running in a process, but a plain task, this
       call does not cause any harm.
    */
    /* FIXME: What's the result of SetCurrentDirName() in a plain
       task? If it is FALSE, the below code won't work.
    */
    if (SetCurrentDirName(name)) {
      /* If this was successful, unlock `old_lock' because we
	 are not going to restore it later; this routine is one
	 of the few cases where such behavior is appropriate.
      */
      UnLock(old_lock);
      result = 0;
    }
    else {
      /* If it fails, restore the previous CWD and make the
	 whole routine fail.
      */
      CurrentDir(old_lock);
    }
  }
  return result;
}

static void strip_trailing_slash(char *path, size_t *length,
				 BOOL * stripped) {
  /* Used in `simulated_mkdir' and `simulated_rmdir' to temporarily
     blank out a possible traling slash (/) in the directory path.
     `restore_trailing_slash' puts it back in place afterwards.
  */
  *length = strlen(path);
  if ((*length > 0) && (path[*length - 1] == '/')) {
    *stripped = TRUE;
    path[*length - 1] = '\0';
  } else {
    *stripped = FALSE;
  }
}

static void restore_trailing_slash(char *path, size_t *length,
				   BOOL * stripped) {
  if (*stripped) {
    path[*length - 1] = '/';
  }
}

static int simulated_mkdir(char *directory_path, int permission) {
  BPTR lock;
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  lock = CreateDir(directory_path);
  if (lock != NULL) {
    UnLock(lock);
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}

static int simulated_rmdir(char *directory_path) {
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  if (DeleteFile(directory_path)) {
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}
#endif /* AMIGA */

/*--------------------------------------------------------------------
  At his point, either this is a Linux/POSIX platform or some
  SIMULATED_MODE is defined. Unsupported platform should add their own
  SIMULATED_MODE before.
*/

EIF_POINTER directory_open(EIF_POINTER path) {
#ifndef SIMULATED_MODE
  return (opendir(((char*) path)));
#else
  return (simulated_opendir(((char*) path)));
#endif
}

EIF_POINTER directory_read_entry(EIF_POINTER dirstream) {
#ifndef SIMULATED_MODE
  return readdir((DIR*)dirstream);
#else
  return simulated_readdir((SIMULATED_DIR*)dirstream);
#endif
}

EIF_POINTER directory_get_entry_name(EIF_POINTER entry) {
#ifndef SIMULATED_MODE
  return (((struct dirent*)entry)->d_name);
#else
  return simulated_get_entry_name((SIMULATED_DIR*)entry);
#endif
}

EIF_BOOLEAN directory_close(EIF_POINTER dirstream) {
  int status;
#ifndef SIMULATED_MODE
  status = (closedir((DIR*)dirstream) == 0);
#else
  status = (simulated_closedir((SIMULATED_DIR*)dirstream) == 0);
#endif
  return ((EIF_BOOLEAN)(status ? 1 : 0));
}

EIF_POINTER directory_cwd(void) {
  static char* buf = NULL;
#ifdef WIN32
  /* MS Windows requires size to be an int; whereas in non-windows systems,
     it needs to be size_t
  */
  static int size = 0;
#else
  static size_t size = 0;
#endif
  int status;
  if (buf == NULL) {
    size = 256;
    buf = (char*)se_malloc(size);
  }


#ifndef SIMULATED_MODE
  status = (getcwd(buf,size) != NULL);
#else
  status = (simulated_getcwd(buf,size) != NULL);
#endif


  if (status) {
    return buf;
  }
  else {
    free(buf);
    size = size * 2;
    buf = (char*)se_malloc(size);
    return directory_cwd();
  }
}

EIF_BOOLEAN directory_chdir(EIF_POINTER destination) {
  int status;
#ifndef SIMULATED_MODE
  status = (chdir((char*)destination));
#else
  status = simulated_chdir((char*)destination);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN directory_mkdir(EIF_POINTER directory_path){
  int status;
#ifndef SIMULATED_MODE
  status = (mkdir((char*)directory_path,0777));
#else
  status = simulated_mkdir((char*)directory_path,0777);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN directory_rmdir(EIF_POINTER directory_path){
  int status;
#ifndef SIMULATED_MODE
  status = rmdir((char*)directory_path);
#else
  status = simulated_rmdir((char*)directory_path);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#if basic_exec_system == basic_exec_system_posix
static char** envp(void) {
  static char* result[] = {"PATH=/sbin:/usr/sbin:/bin:/usr/bin", NULL};
  return result;
}

static int arr_size(char** arr){
  int size = 0;
  while(arr[size] != NULL) {
    size++;
  }
  return size;
}

static int find_variable(char** env, char* var){
  int location;
  int src_size;
  if(var == NULL || env == NULL)
    return -1;
  src_size = strchr(var, '=') - var + 1;
  for(location = 0; env[location] != NULL; location++){
    if(strncasecmp(env[location], var, src_size) == 0){
      return location;
    }
  }
  return -1;
}

static void check_write(int expected, int actual) {
   if (actual != expected) {
    handle(SE_HANDLE_RUNTIME_ERROR, NULL);
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Routine_failure);
#elif !defined(SE_BOOST)
    error0("Routine failure: could not write.", NULL);
#else
    fprintf(SE_ERR,"Routine failure (write returned %d but expected %d).\n", actual, expected);
    exit(EXIT_FAILURE);
#endif
  }
}

EIF_BOOLEAN basic_exec_posix_execute(se_exec_data_t*data, char*prog, char**args, EIF_BOOLEAN keep_env, char**add_env, int* in_fd, int* out_fd, int* err_fd) {
  int id = fork();
  if (id == 0) {
    /* child */

    if(in_fd) {
      dup2(in_fd[0], 0);
      close(in_fd[1]);
    }

    if(out_fd) {
      dup2(out_fd[1], 1);
      close(out_fd[0]);
    }

    if(err_fd) {
      dup2(err_fd[1], 2);
      close(err_fd[0]);
    }

    if (prog == NULL && args == NULL) {
      data->running = 1;
      data->child = 1;
#ifdef SE_SEDB
      sedb_duplicate();
#endif
      return 1;
    } else {
      if (add_env == NULL && keep_env) {
        execvp(prog, args); /* NO RETURN in child */
        se_print_run_time_stack();
        exit(1);
      }else{
        char** new_env;
        char** old_env;
        int old_size, add_size;
        int src, dest = 0;
        if(keep_env){
          old_env = environ;
        }else{
          old_env = envp();
        }
        old_size = arr_size(old_env);
        add_size = arr_size(add_env);
        new_env = malloc(sizeof(void*) * (old_size + add_size));

        /* we first copy the pointers from the old env */
        for(src = 0; src < old_size; src++){
          new_env[dest++] = old_env[src];
        }

        /* now the ones from add_env */
        for(src = 0; src < add_size; src++){
          int override = find_variable(old_env, add_env[src]);
          if (override >= 0){
            new_env[override] = add_env[src];
          }else{
            new_env[dest++] = add_env[src];
          }
        }

        execve(prog, args, new_env); /* NO RETURN in child */
        se_print_run_time_stack();
        exit(1);
      }
    }
  }
  else if (id > 0) {
    /* father */
    data->id = id;
    data->running = 1;
    data->child = 0;
    if(in_fd) close(in_fd[0]);
    if(out_fd) close(out_fd[1]);
    if(err_fd) close(err_fd[1]);
    return 1;
  } else {
    return 0; /* ... in father only */
  }
}

EIF_BOOLEAN basic_exec_is_finished(se_exec_data_t*data) {
  EIF_BOOLEAN result = (EIF_BOOLEAN)0;
  int status;
  if (data->running) {
    int id = waitpid(data->id, &status, WNOHANG);
    if (id == data->id) {
      /* child is finished */
      result = (EIF_BOOLEAN)(id == data->id);
      basic_exec_cleanup(data, status);
    }
  }
  else{
    result = (EIF_BOOLEAN)1;
  }
  return result;
}

void basic_exec_wait(se_exec_data_t*data) {
  int status;
  if (data->running) {
    int id = waitpid(data->id, &status, 0);
    if (id == data->id) {
      basic_exec_cleanup(data, status);
    }
  }
}

void basic_exec_cleanup(se_exec_data_t*data, int status) {
  data->status = WEXITSTATUS(status);
  data->running = 0;
}

EIF_INTEGER basic_exec_posix_get_character (EIF_INTEGER fd) {
  EIF_INTEGER result = -1;
  char buf[1];
  ssize_t r = read(fd, buf, 1);
  if (r > 0) {
    result = 0xff & ((EIF_INTEGER)(buf[0]));
  }
  return result;
}

void basic_exec_posix_put_character(EIF_INTEGER fd, EIF_CHARACTER c) {
  check_write(1, write(fd, &c, 1));
}

void basic_exec_posix_wait_any(se_exec_data_t*data) {
  data->id = wait(&data->status);
}

void basic_exec_posix_any_finished(se_exec_data_t*data) {
  data->id = waitpid(-1, &data->status, WNOHANG);
}

/*
 * See http://stackoverflow.com/questions/282176/waitpid-equivalent-with-timeout
 *
 * (with specific adaptation to Liberty Eiffel)
 */
static int waitpid_selfpipe[2];
static EIF_OBJECT waitpid_input;

static void waitpid_sigh(int n) {
   check_write(1, write(waitpid_selfpipe[1], "", 1));
}

void basic_exec_waitpid_init(EIF_OBJECT obj) {
   waitpid_input = obj;
}

EIF_INTEGER basic_exec_waitpid_fd(void) {
   static int init = 0;
   static struct sigaction act;
   if (!init) {
      init = 1;
      if (pipe(waitpid_selfpipe) == -1) {
         waitpid_selfpipe[0] = -1;
      }
      else {
         fcntl(waitpid_selfpipe[0], F_SETFL, fcntl(waitpid_selfpipe[0], F_GETFL) | O_NONBLOCK);
         fcntl(waitpid_selfpipe[1], F_SETFL, fcntl(waitpid_selfpipe[1], F_GETFL) | O_NONBLOCK);
         memset(&act, 0, sizeof(act));
         act.sa_handler = waitpid_sigh;
         sigaction(SIGCHLD, &act, NULL);
      }
   }
   return waitpid_selfpipe[0];
}

EIF_INTEGER basic_exec_waitpid_read_buffer(void*data) {
   static char dummy[4096];
   char *buffer = (char*)data;
   int pid, status;

   while (read(waitpid_selfpipe[0], dummy, sizeof(dummy)) > 0);

   while ((pid = waitpid(-1, &status, WNOHANG)) > 0) {
      oob_info(waitpid_input, pid, status);
   }

   buffer[0] = 0;
   return 1;
}
#else
EIF_INTEGER basic_exec_posix_get_character (EIF_INTEGER fd) {
  return 0;
}

void basic_exec_posix_put_character(EIF_INTEGER fd, EIF_CHARACTER c) {
}

void basic_exec_posix_wait_any(se_exec_data_t*data) {
}

void basic_exec_posix_any_finished(se_exec_data_t*data) {
}

EIF_BOOLEAN basic_exec_posix_execute(se_exec_data_t*data, char*prog, char**args, EIF_BOOLEAN keep_env, char**add_env, int* in_fd, int* out_fd, int* err_fd) {
  return 0;
}
#endif
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#if basic_exec_system == basic_exec_system_none
/* Dummy implementation that always reports an error back to the Eiffel side */

EIF_BOOLEAN basic_exec_execute(se_exec_data_t*data, char*prog, char**args, EIF_BOOLEAN keep_env, char**add_env, int* in_fd, int* out_fd, int* err_fd) {
  return 0;
}

EIF_BOOLEAN basic_exec_is_finished(se_exec_data_t*data) {
  return (EIF_BOOLEAN)0;
}

void basic_exec_wait(se_exec_data_t*data) {
}

EIF_INTEGER basic_exec_get_character (EIF_INTEGER fd) {
  return (EIF_INTEGER)0;
}

void basic_exec_put_character(EIF_INTEGER fd, EIF_CHARACTER c) {
}

void basic_exec_cleanup(se_exec_data_t*data, int status) {
}

void basic_exec_waitpid_init(EIF_OBJECT obj) {
}

EIF_INTEGER basic_exec_waitpid_fd(void) {
   return -1;
}

EIF_INTEGER basic_exec_waitpid_read_buffer(void*data) {
   return -1;
}
#else
#endif
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#if basic_exec_system == basic_exec_system_win32
static char* envp(void) {
  static char* result = "\0";/* *** Maybe call GetFullPathName to set =C: and friends */
  return result;
}

EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, HANDLE*in_h, HANDLE*out_h, HANDLE*err_h) {
  STARTUPINFO start_info;
  EIF_BOOLEAN result = 0;

  ZeroMemory( &start_info, sizeof(STARTUPINFO) );

  start_info.cb = sizeof(STARTUPINFO);
  if(in_h) {
    start_info.hStdInput = in_h[0];
    SetHandleInformation(in_h[1], HANDLE_FLAG_INHERIT, 0);
  } else {
    start_info.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
  }
  if(INVALID_HANDLE_VALUE == start_info.hStdInput) goto leave;
  if(out_h) {
    start_info.hStdOutput = out_h[1];
    SetHandleInformation(out_h[0], HANDLE_FLAG_INHERIT, 0);
  } else {
    start_info.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
  }
  if(INVALID_HANDLE_VALUE == start_info.hStdOutput) goto leave;
  if(err_h) {
    start_info.hStdError = err_h[1];
    SetHandleInformation(err_h[0], HANDLE_FLAG_INHERIT, 0);
  } else {
    start_info.hStdError = GetStdHandle(STD_ERROR_HANDLE);
  }
  if(INVALID_HANDLE_VALUE == start_info.hStdError) goto leave;
  start_info.dwFlags |= STARTF_USESTDHANDLES;

  if(CreateProcess(NULL, args,
                   NULL,                                /* process security attributes          */
                   NULL,                                /* primary thread security attributes   */
                   TRUE,                                /* handles are inherited                */
                   0,                                   /* creation flags                       */
                   keep_env?NULL:envp(),
                   NULL,                                /* use parent's current directory       */
                   &start_info,                         /* STARTUPINFO pointer                  */
                   &data->process_information)) {       /* receives PROCESS_INFORMATION         */
    CloseHandle(data->process_information.hThread);
    data->running = 1;
    result = 1;
  }
 leave:
  if(in_h) CloseHandle(in_h[0]);
  if(out_h) CloseHandle(out_h[1]);
  if(err_h) CloseHandle(err_h[1]);
  return result;
}

EIF_BOOLEAN basic_exec_init_pipe(HANDLE*pipe) {
  SECURITY_ATTRIBUTES security_attributes;

  // Set the bInheritHandle flag so pipe handles are inherited.

  security_attributes.nLength = sizeof(SECURITY_ATTRIBUTES);
  security_attributes.bInheritHandle = TRUE;
  security_attributes.lpSecurityDescriptor = NULL;

  return CreatePipe(pipe, pipe+1, &security_attributes, 0);
}

EIF_BOOLEAN basic_exec_is_finished(se_exec_data_t*data) {
  EIF_BOOLEAN result = (EIF_BOOLEAN)0;
  if (data->running) {
    result = (WaitForSingleObject(data->process_information.hProcess, 0) == WAIT_OBJECT_0);
    if (result) {
      /* child is finished */
      DWORD status;
      GetExitCodeProcess(data->process_information.hProcess, &status);
      /* *** Could have failed */
      basic_exec_cleanup(data, status);
    }
  }
  else{
    result = (EIF_BOOLEAN)1;
  }
  return result;
}

void basic_exec_wait(se_exec_data_t*data) {
  if (data->running) {
    DWORD status;
    WaitForSingleObject(data->process_information.hProcess, INFINITE);
    GetExitCodeProcess(data->process_information.hProcess, &status);
    /* *** Any of these calls could have failed, right? */
    basic_exec_cleanup(data, status);
  }
}

EIF_INTEGER basic_exec_win32_get_character (HANDLE h) {
  char result;
  DWORD num_read;

  ReadFile(h, &result, 1, &num_read, NULL);
  if(!num_read) return -1;
  return result;
}

void basic_exec_win32_put_character(HANDLE h, EIF_CHARACTER c) {
  DWORD num_written;

  WriteFile(h, &c, 1, &num_written, NULL);
  /* *** Do something if num_written!=1 or WriteFile returned 0. */
}

void basic_exec_cleanup(se_exec_data_t*data, int status) {
  data->status = status;
  data->running = 0;
  CloseHandle(data->process_information.hProcess);
}

EIF_BOOLEAN basic_exec_win32_wait_any(HANDLE*handles, DWORD count, se_exec_data_t*data) {
  DWORD result = WaitForMultipleObjects(count, handles, FALSE, INFINITE);
  EIF_BOOLEAN success = (result < (WAIT_OBJECT_0 + count));
  if(success) {
    int index = result - WAIT_OBJECT_0;
    HANDLE handle = handles[index];
    GetExitCodeProcess(handle, &data->status);
    data->process_information.hProcess = handle;
  }
  return success;
}

EIF_BOOLEAN basic_exec_win32_any_finished(HANDLE*handles, DWORD count, se_exec_data_t*data ) {
  DWORD result = WaitForMultipleObjects(count, handles, FALSE, 0);
  EIF_BOOLEAN success = (result < (WAIT_OBJECT_0 + count));
  if(success) {
    int index = result - WAIT_OBJECT_0;
    HANDLE handle = handles[index];
    GetExitCodeProcess(handle, &data->status);
    data->process_information.hProcess = handle;
  }
  return success;
}

void basic_exec_waitpid_init(EIF_OBJECT obj) {
}

EIF_INTEGER basic_exec_waitpid_fd(void) {
   return -1;
}

EIF_INTEGER basic_exec_waitpid_read_buffer(void*data) {
   return -1;
}
#else
EIF_INTEGER basic_exec_win32_get_character (void *h) {
  return 0;
}

void basic_exec_win32_put_character(void *h, EIF_CHARACTER c) {
}

EIF_BOOLEAN basic_exec_win32_wait_any(void*handles, int count, se_exec_data_t*data) {
  return 0;
}

EIF_BOOLEAN basic_exec_win32_any_finished(void*handles, int count, se_exec_data_t*data) {
  return 0;
}

EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, void*in_h, void*out_h, void*err_h) {
  return 0;
}
#endif
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
EIF_BOOLEAN mbi_inc (int32_t *p) {
    if ((++(*p)) == 0) {
      return 1;
    }
    else {
      return 0;
    }
}

EIF_BOOLEAN mbi_add (int32_t a, int32_t b, int32_t *p) {
  (*p) = a + b;
  if (((uint32_t)(*p)) < ((uint32_t)(a))) {
    return 1;
  }
  else {
    return 0;
  }
}

EIF_BOOLEAN mbi_add_with_inc (int32_t a, int32_t b, int32_t *p) {
  (*p) = a + b + 1;
  if (((uint32_t)(*p)) <= ((uint32_t)(a))) {
    return 1;
  }
  else {
    return 0;
  }
}

EIF_BOOLEAN mbi_dec (int32_t *p) {
    if (((*p)--) == 0) {
      return 1;
    }
    else {
      return 0;
    }
}

EIF_BOOLEAN mbi_subtract (int32_t a, int32_t b, int32_t *p) {
  (*p) = a - b;
  if (((uint32_t)(*p)) > ((uint32_t)(a))) {
    return 1;
  }
  else {
    return 0;
  }
}

EIF_BOOLEAN mbi_subtract_with_dec (int32_t a, int32_t b, int32_t *p) {
  (*p) = a - b - 1;
  if (((uint32_t)(*p)) >= ((uint32_t)(a))) {
    return 1;
  }
  else {
    return 0;
  }
}

EIF_INTEGER mbi_multiply (int32_t a, int32_t b, int32_t *p) {
  uint64_t x;
  x = ((uint64_t)((uint32_t)(a))) * ((uint32_t)(b));
  (*p) = (uint32_t)(x);
  return ((uint32_t)(x >> 32));
}

EIF_INTEGER mbi_multiply_with_add (int32_t a, int32_t b, int32_t c, int32_t *p) {
  uint64_t x;
  x = ((uint64_t)((uint32_t)(a))) * ((uint32_t)(b)) + ((uint32_t)(c));
  (*p) = (uint32_t)(x);
  return ((uint32_t)(x >> 32));
}

EIF_INTEGER mbi_multiply_with_2_add (int32_t a, int32_t b, int32_t c, int32_t d, int32_t *p) {
  uint64_t x;
  x = ((uint64_t)((uint32_t)(a))) * ((uint32_t)(b)) + ((uint32_t)(c)) + ((uint32_t)(d));
  (*p) = (uint32_t)(x);
  return ((uint32_t)(x >> 32));
}

EIF_INTEGER mbi_divide (int32_t a, int32_t b, int32_t d, int32_t *r) {
  uint64_t x;
  x = (((uint64_t)((uint32_t)(a))) << 32) + ((uint32_t)(b));
  (*r) = (uint32_t)(x % ((uint32_t)(d)));
  return ((uint32_t)(x / ((uint32_t)(d))));
}
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/

EIF_INTEGER fstat_st_size(EIF_POINTER path) {

	struct stat buf;
	int test;

	test = stat(path, &buf);
	return (test == 0 ? buf.st_size : -1);

}

EIF_INTEGER_64 fstat_st_mtime(EIF_POINTER path) {

	struct stat buf;
	int test;

	test = stat(path, &buf);
	return (test == 0 ? buf.st_mtime : -1);

}

EIF_BOOLEAN fstat_st_is_file(EIF_POINTER path) {
#if defined S_ISREG
  struct stat buf;

  return stat((const char *)path, &buf)?0:!!S_ISREG(buf.st_mode);
#elif defined WIN32
  EIF_BOOLEAN result;
  HANDLE h=CreateFile((LPCTSTR)path, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE,
		      NULL, OPEN_EXISTING, 0, NULL);

  if(INVALID_HANDLE_VALUE == h) {
    return 0;
  }
  result = (GetFileType(h) == FILE_TYPE_DISK)
    && !(GetFileAttributes((LPCTSTR) path) & FILE_ATTRIBUTE_DIRECTORY);
  CloseHandle(h);
  return result;
#else
  printf("fstat_st_is_file (in SmartEiffel/sys/io/c/fstat.c)\nnot yet implemented for this architecture.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
}

EIF_BOOLEAN fstat_st_is_dir(EIF_POINTER path) {
#if defined S_ISDIR
  struct stat buf;

  return stat((const char *)path, &buf)?0:!!S_ISDIR(buf.st_mode);
#elif defined WIN32
  DWORD attr =GetFileAttributes((LPCTSTR) path);
  return (attr != INVALID_FILE_ATTRIBUTES)  && (attr & FILE_ATTRIBUTE_DIRECTORY);
#else
  printf("fstat_st_is_dir (in SmartEiffel/sys/io/c/fstat.c)\nnot yet implemented for this architecture.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
}
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
/* macro read is used of read_stdin */

int io_copy (char*source, char*target) {
     /* We use the low-level descriptor functions rather than stream-oriented functions.
      * This allows us to copy the file's permissions. */

     int src;
     int tgt;
     struct stat info;
     static char *buffer = NULL;
     static int bufsize = 0;
     int read_count, write_count, written;

     src = open(source, O_RDONLY);
     if (fstat (src, &info))
          return 0; /* Ooops */
     if (bufsize < info.st_blksize)
          buffer = se_realloc (buffer, info.st_blksize);
     tgt = creat(target, info.st_mode);
     do {
          read_count = read(src, buffer, info.st_blksize);
          write_count = 0; written = 0;
          while ((write_count < read_count) && (written >= 0)) {
               written = write(tgt, buffer + write_count, read_count - write_count);
               write_count += written;
          }
     } while ((read_count > 0) && (written >= 0));
     close (src);
     close (tgt);

     return written >= 0;
}

int io_same_physical_file(char*path1,char*path2) {
  struct stat info1, info2;
  if (stat(path1, &info1))
    return 0; /* oops */
  if (stat(path2, &info2))
    return 0; /* oops */
  return (info1.st_dev == info2.st_dev) && (info1.st_ino == info2.st_ino);
}

#else
#define IO_COPY_BUFSIZE 4096

int read_stdin(EIF_CHARACTER *buffer, int size) {
  int c;
  c = getc(stdin);
  if (c==EOF)
    return 0;
  *buffer = (EIF_CHARACTER)c;
  return 1;
}

int io_copy(char*source, char*target) {
     static char *buffer = NULL;
     int read_count;
     FILE*src = fopen(source, "rb");
     FILE*tgt = fopen(target, "wb");

     if (!buffer)
          buffer = (char*)se_malloc(IO_COPY_BUFSIZE);

     while ((read_count = fread(buffer, 1, IO_COPY_BUFSIZE, src)), read_count) {
          size_t dummy = fwrite(buffer, 1, read_count, tgt);
          if (errno)
               return 0;
     }
     fclose(src);
     fclose(tgt);

     return 1;
}

int io_same_physical_file(char*path1,char*path2) {
  /* default implementation returns true only if the paths are the same */
  return !strcmp(path1, path2);
}
#endif

int io_file_exists(char*source) {
  FILE*src=fopen(source, "rb");
  if (src!=NULL) {
    fclose(src);
    return 1;
  }
  else {
    return (errno != ENOENT);
  }
}
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
EIF_INTEGER basic_microsecond_microsecond = 0;
EIF_INTEGER_64 basic_microsecond_time = 0;

void _basic_microsecond_update(void) {
#ifndef WIN32
  struct timeval t;

  gettimeofday (&t, NULL);
  basic_microsecond_time = t.tv_sec;
  basic_microsecond_microsecond = t.tv_usec;
#else
  static DWORD ref_uptime = -1; /* max value as ref_uptime is unsigned */
  static time_t ref_time;
  DWORD uptime;

  /*  uptime = timeGetTime();*/
  uptime = GetTickCount();

  if (uptime < ref_uptime) {
    /* !!! this test manages first call AND 50th day ;-)  */
    ref_uptime = uptime;
    time(&ref_time);
  }

  basic_microsecond_time = ref_time + (uptime - ref_uptime)/1000;
  basic_microsecond_microsecond = ((uptime - ref_uptime) % 1000) * 1000;
#endif
}
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
void sprintf_real_64(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real64_t r) {
  char fmt[32];
  fmt[0]='%';
  fmt[1]='.';
  sprintf(fmt+2, "%d%c", f, m);
  sprintf((char*)b, fmt, r);
}

void sprintf_real_extended(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real_extended_t r) {
  char fmt[32];
  fmt[0]='%';
  fmt[1]='.';
  sprintf(fmt+2, "%dL%c", f, m);
  sprintf((char*)b, fmt, r);
}


int se_cmpT295(T295* o1,T295* o2){
int R=0;
R = R || ((o1->_last_delete_succeeded) != (o2->_last_delete_succeeded));
R = R || ((o1->_last_rename_succeeded) != (o2->_last_rename_succeeded));
return R;
}/*--*/

int se_cmpT546(T546* o1,T546* o2){
int R=0;
R = R || ((o1->_current_entry) != (o2->_current_entry));
R = R || ((o1->_directory_stream) != (o2->_directory_stream));
return R;
}/*--*/

int se_cmpT351(T351* o1,T351* o2){
int R=0;
R = R || ((o1->_mangling) != (o2->_mangling));
return R;
}/*--*/

int se_cmpT711(T711* o1,T711* o2){
int R=0;
R = R || se_cmpT295(&(o1->_file_tools), &(o2->_file_tools));
return R;
}/*--*/

int se_cmpT790(T790* o1,T790* o2){
int R=0;
R = R || ((o1->_hashed_string_memory) != (o2->_hashed_string_memory));
R = R || ((o1->_column) != (o2->_column));
R = R || ((o1->_line) != (o2->_line));
return R;
}/*--*/
T940 M940=/*init:REVERSE_COLLECTION_SORTER[POSITION]*/0/*empty expanded*/;
T944 M944=/*init:COLLECTION_SORTER[STRING]*/0/*empty expanded*/;
T951 M951={951,NULL};
T952 M952={952,NULL};
T957 M957=/*init:COLLECTION_SORTER[FIXED_STRING]*/0/*empty expanded*/;

int se_cmpT726(T726* o1,T726* o2){
int R=0;
R = R || ((o1->_time_memory) != (o2->_time_memory));
return R;
}/*--*/

int se_cmpT491(T491* o1,T491* o2){
int R=0;
R = R || se_cmpT726(&(o1->_time), &(o2->_time));
R = R || ((o1->_microsecond) != (o2->_microsecond));
return R;
}/*--*/

int se_cmpT990(T990* o1,T990* o2){
int R=0;
R = R || ((o1->_comparator) != (o2->_comparator));
return R;
}/*--*/
T990 M990=/*init:COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/{(void*)0};
T994 M994={994,NULL};
T1026 M1026={1026,NULL};
T1029 M1029={1029,NULL};
T1048 M1048={1048,NULL};

int se_cmpT348(T348* o1,T348* o2){
int R=0;
R = R || ((o1->_class_name) != (o2->_class_name));
R = R || ((o1->_feature_name) != (o2->_feature_name));
R = R || ((o1->_hash_code) != (o2->_hash_code));
return R;
}/*--*/
T1068 M1068={1068,NULL};
T1071 M1071={1071,NULL};
T1076 M1076={1076,NULL};
T1087 M1087={1087,NULL};
T1090 M1090={1090,NULL};

int se_cmpT324(T324* o1,T324* o2){
int R=0;
R = R || ((o1->_item_memory) != (o2->_item_memory));
R = R || ((o1->_capacity) != (o2->_capacity));
return R;
}/*--*/

int se_cmpT542(T542* o1,T542* o2){
int R=0;
R = R || ((o1->_group) != (o2->_group));
R = R || ((o1->_direct_error) != (o2->_direct_error));
R = R || ((o1->_keep_environment) != (o2->_keep_environment));
R = R || ((o1->_direct_input) != (o2->_direct_input));
R = R || ((o1->_direct_output) != (o2->_direct_output));
return R;
}/*--*/
T1112 M1112={1112,NULL};
T1115 M1115={1115,NULL};
T1120 M1120={1120,NULL};
T1121 M1121={1121,NULL};
T1158 M1158={1158,NULL};
T1163 M1163={1163,NULL};
T1166 M1166={1166,NULL};
T1169 M1169={1169,NULL};
T1172 M1172={1172,NULL};
T1182 M1182={1182,NULL};
T1186 M1186={1186,NULL};
T1189 M1189={1189,NULL};
T1195 M1195={1195,NULL};
T1198 M1198={1198,NULL};
T1205 M1205={1205,NULL};
T1206 M1206={1206,NULL};
T1209 M1209={1209,NULL};
T1214 M1214={1214,NULL};
T1218 M1218={1218,NULL};
T1221 M1221={1221,NULL};
T1224 M1224={1224,NULL};
T1230 M1230={1230,NULL};
T1233 M1233={1233,NULL};
T1238 M1238={1238,NULL};
T1239 M1239={1239,NULL};
T1242 M1242={1242,NULL};
T1247 M1247={1247,NULL};
T1262 M1262={1262,NULL};
T1265 M1265={1265,NULL};
T1271 M1271={1271,NULL};
T1275 M1275={1275,NULL};
T1277 M1277={1277,NULL};
T1282 M1282={1282,NULL};
T1285 M1285={1285,NULL};
T1288 M1288={1288,NULL};
T1299 M1299={1299,NULL};
T1306 M1306={1306,NULL};
T1309 M1309={1309,NULL};
T1312 M1312=/*init:SAFE_EQUAL[LIVE_TYPE]*/0/*empty expanded*/;
T1316 M1316={1316,NULL};
T1319 M1319={1319,NULL};
T1327 M1327={1327,NULL};
T1330 M1330={1330,NULL};
T1331 M1331=/*init:COLLECTION_SORTER[INTEGER_32]*/0/*empty expanded*/;

int se_cmpT767(T767* o1,T767* o2){
int R=0;
R = R || ((o1->_first_error) != (o2->_first_error));
R = R || ((o1->_first_error_character) != (o2->_first_error_character));
R = R || ((o1->_first_error_index) != (o2->_first_error_index));
return R;
}/*--*/
T1360 M1360=/*init:SAFE_EQUAL[STRING]*/0/*empty expanded*/;
T1364 M1364={1364,NULL};
T1367 M1367={1367,NULL};
T1370 M1370={1370,NULL};
T1371 M1371={1371,NULL};
T1374 M1374={1374,NULL};
T1385 M1385={1385,NULL};
T1389 M1389=/*init:SAFE_EQUAL[POSITION]*/0/*empty expanded*/;
T1399 M1399={1399,NULL};
T1404 M1404={1404,NULL};
T1420 M1420=/*init:COLLECTION_SORTER[LIVE_TYPE]*/0/*empty expanded*/;
T1427 M1427=/*init:REVERSE_COLLECTION_SORTER[INTEGER_32]*/0/*empty expanded*/;
T1432 M1432=/*init:COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/0/*empty expanded*/;
T1444 M1444={1444,NULL};
T1463 M1463=/*init:SAFE_EQUAL[INTEGER_32]*/0/*empty expanded*/;
T1467 M1467={1467,NULL};
T29 M29=/*init:COMPILE_TO_C*/{(void*)0,0,0};
T296 M296=/*init:STRING_COMMAND_LINE*/0/*empty expanded*/;
T113 M113=/*init:SYSTEM_TOOLS*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,{(void*)0,(void*)0},0};
T126 M126=/*init:ECHO*/{(void*)0,(void*)0,(void*)0,0,0};
T903 M903=/*init:C_PLUGIN_FACTORY*/(void*)0;
T104 M104=/*init:EIFFEL_PARSER*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0,0,0,0,{(void*)0,0,0},'\0',0,0,0,0,0,0,0,0};
T283 M283=/*init:ACE*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'\0',0,0,0,0,{(void*)0,0,0},0,0,0};
T117 M117=/*init:C_PRETTY_PRINTER*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
T111 M111=/*init:SMART_EIFFEL*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0,0,0,0,0,0,0/*empty expanded*/,0,0,0,0,0,0,0};
T291 M291=/*init:ID_PROVIDER*/{0,0};
T281 M281=/*init:STRING_ALIASER*/(void*)0;
T297 M297=/*init:MEMORY_HANDLER_FACTORY*/0/*empty expanded*/;
T7 M7=/*init:STRING*/{7,(void*)0,0,0,0,0,0,0};
T909 M909=/*init:FAST_ARRAY[STRING]*/{909,(void*)0,0,0,0};
T293 M293=/*init:ERROR_HANDLER*/{(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T86 M86=/*init:CECIL_POOL*/{(void*)0,0};
T910 M910=/*init:REFERENCE[CECIL_POOL]*/{(void*)0};
T295 M295=/*init:FILE_TOOLS*/{0,0};
T554 M554=/*init:SERC_FACTORY*/0/*empty expanded*/;
T546 M546=/*init:BASIC_DIRECTORY*/{(void*)0,(void*)0};
T78 M78=/*init:STD_INPUT_OUTPUT*/{78,(void*)0};
T911 M911=/*init:HASHED_DICTIONARY[STRING,STRING]*/{911,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T557 M557=/*init:UNIX_DIRECTORY_NOTATION*/{557,(void*)0,(void*)0};
T561 M561=/*init:WINDOWS_DIRECTORY_NOTATION*/{561,(void*)0,(void*)0};
T562 M562=/*init:MACINTOSH_DIRECTORY_NOTATION*/{562};
T563 M563=/*init:AMIGA_DIRECTORY_NOTATION*/{563};
T564 M564=/*init:OPENVMS_DIRECTORY_NOTATION*/{564};
T565 M565=/*init:CYGWIN_DIRECTORY_NOTATION*/{565};
T912 M912=/*init:REFERENCE[DIRECTORY_NOTATION]*/{(void*)0};
T913 M913=/*init:REFERENCE[BOOLEAN]*/{0};
T102 M102=/*init:TEXT_FILE_READ*/{(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,'\0'};
T556 M556=/*init:SE_C_MODE*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T545 M545=/*init:SYSTEM*/0/*empty expanded*/;
T464 M464=/*init:TEXT_FILE_WRITE*/{464,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T665 M665=/*init:LINES_OUTPUT_STREAM*/{665,(void*)0,(void*)0};
T81 M81=/*init:STD_ERROR*/{81,(void*)0};
T69 M69=/*init:STD_OUTPUT*/{69,(void*)0,(void*)0,0,0};
T467 M467=/*init:TMP_FEATURE*/{467,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T123 M123=/*init:PARSER_BUFFER*/{(void*)0,(void*)0,(void*)0,0};
T708 M708=/*init:C_SPLITTER_NO_SPLIT*/{708,(void*)0,(void*)0,0};
T709 M709=/*init:C_SPLITTER_BY_LIVE_TYPE*/{709,(void*)0,0/*empty expanded*/,(void*)0,(void*)0,(void*)0,0,0};
T704 M704=/*init:C_SPLITTER_LEGACY*/{704,(void*)0,(void*)0,0,0};
T914 M914=/*init:FAST_ARRAY[HASHED_STRING]*/{(void*)0,0,0,0};
T107 M107=/*init:HASHED_STRING*/{(void*)0,0};
T566 M566=/*init:DIRECTORY*/{(void*)0,(void*)0,0/*empty expanded*/,{(void*)0,(void*)0},(void*)0,0};
T710 M710=/*init:UNIVERSE*/{710,(void*)0,(void*)0,0,{(void*)0,(void*)0}};
T351 M351=/*init:POSITION*/{0};
T437 M437=/*init:COMMENT*/{437,(void*)0,{0},0};
T915 M915=/*init:ARRAY[STRING]*/{915,(void*)0,0,0,0,0};
T333 M333=/*init:UNICODE_STRING*/{(void*)0,(void*)0,(void*)0,0,0,0};
T711 M711=/*init:CLASSES_TREE_FACTORY*/{{0,0}};
T916 M916=/*init:FAST_ARRAY[CLUSTER]*/{(void*)0,0,0,0};
T447 M447=/*init:CLUSTER*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,'\0'};
T790 M790=/*init:TOKEN_BUFFER*/{(void*)0,0,0};
T588 M588=/*init:C_HEADER_PASS_0*/{588,0,{(void*)0},(void*)0};
T621 M621=/*init:C_HEADER_PASS_1*/{621,(void*)0};
T622 M622=/*init:C_HEADER_PASS_2*/{622,(void*)0};
T623 M623=/*init:C_HEADER_PASS_3*/{623,(void*)0};
T624 M624=/*init:C_HEADER_PASS_4*/{624,(void*)0};
T625 M625=/*init:C_LIVE_TYPE_COMPILER*/{625,(void*)0};
T637 M637=/*init:C_MAPPER*/{637};
T638 M638=/*init:C_INITIALIZER*/{638};
T639 M639=/*init:C_TARGET_MAPPER*/{639,(void*)0,(void*)0};
T641 M641=/*init:C_ARG_MAPPER*/{641,(void*)0};
T642 M642=/*init:C_CODE_COMPILER*/{642,(void*)0};
T646 M646=/*init:C_COMPOUND_EXPRESSION_COMPILER*/{646,(void*)0,(void*)0,(void*)0,0};
T647 M647=/*init:C_NATIVE_FUNCTION_MAPPER*/{647,(void*)0,(void*)0,(void*)0,(void*)0};
T648 M648=/*init:C_NATIVE_PROCEDURE_MAPPER*/{648,(void*)0,(void*)0,(void*)0,(void*)0};
T649 M649=/*init:C_NATIVE_C_DEFINITION*/{649,(void*)0,(void*)0,(void*)0};
T650 M650=/*init:C_INTROSPECTION_FUNCTION*/{650,0};
T651 M651=/*init:C_INTROSPECTION_DISPLAY*/{651,0};
T652 M652=/*init:C_TYPE_FOR_TARGET*/{652};
T654 M654=/*init:C_TYPE_FOR_RESULT*/{654};
T655 M655=/*init:C_TYPE_FOR_EXTERNAL*/{655};
T653 M653=/*init:C_TYPE_FOR_ARGUMENT*/{653};
T656 M656=/*init:C_TYPE_FOR_VA_ARG*/{656};
T657 M657=/*init:C_NEED_STRUCT*/{657,0};
T658 M658=/*init:C_NATIVE_NEED_WRAPPER*/{658,(void*)0,(void*)0,0};
T917 M917=/*init:HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T552 M552=/*init:STATUS*/{(void*)0,(void*)0,0,{{0},0},0,0,0};
T97 M97=/*init:CLASS_TEXT*/{97,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0};
T91 M91=/*init:INTROSPECTION_HANDLER*/{(void*)0,(void*)0,{0},(void*)0,(void*)0,(void*)0,(void*)0,0,{0},0};
T383 M383=/*init:LIVE_TYPE*/{383,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,0,0,0,0};
T110 M110=/*init:ASSIGNMENT_HANDLER*/(void*)0;
T95 M95=/*init:CLASS_NAME*/{(void*)0,(void*)0,(void*)0,0,0,{0},0};
T286 M286=/*init:TYPE*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T89 M89=/*init:FEATURE_STAMP*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T919 M919=/*init:HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/{(void*)0,(void*)0,0,0,0,0};
T920 M920=/*init:HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T921 M921=/*init:FAST_ARRAY[INTEGER_32]*/{(void*)0,0,0,0};
T306 M306=/*init:FIXED_STRING*/{306,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0};
T108 M108=/*init:MANIFEST_STRING_POOL*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T116 M116=/*init:MANIFEST_GENERIC_POOL*/(void*)0;
T125 M125=/*init:ONCE_ROUTINE_POOL*/(void*)0;
T124 M124=/*init:AGENT_POOL*/{0};
T127 M127=/*init:ASSIGNMENT_TEST_POOL*/(void*)0;
T452 M452=/*init:STRING_TYPE_MARK*/{452,(void*)0,(void*)0,(void*)0,0};
T923 M923=/*init:ARRAY[TYPE_MARK]*/{(void*)0,0,0,0,0};
T924 M924=/*init:HASHED_DICTIONARY[TYPE,HASHED_STRING]*/{(void*)0,(void*)0,0,0,0,0};
T925 M925=/*init:ARRAY[INTEGER_32]*/{(void*)0,0,0,0,0};
T341 M341=/*init:CODE_ACCUMULATOR*/{(void*)0,(void*)0,0,0};
T120 M120=/*init:FEATURE_ACCUMULATOR*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T290 M290=/*init:FEATURE_NAME*/{{0},(void*)0,(void*)0,0,0};
T926 M926=/*init:FAST_ARRAY[LIVE_TYPE]*/{(void*)0,0,0,0};
T441 M441=/*init:ANY_TYPE_MARK*/{441,(void*)0,(void*)0,(void*)0,0};
T929 M929=/*init:HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T587 M587=/*init:TYPE_ALIASING*/0/*empty expanded*/;
T930 M930=/*init:HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T931 M931=/*init:HASHED_SET[HASHED_STRING]*/{(void*)0,(void*)0,0,0,0,0};
T932 M932=/*init:REFERENCE[INTEGER_32]*/{0};
T727 M727=/*init:NO_GC*/{727,0};
T728 M728=/*init:BDW_GC*/{728,(void*)0,(void*)0,(void*)0,0};
T729 M729=/*init:GC_HANDLER*/{729,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T318 M318=/*init:PARTIALLY_FILLED_STRING*/{318,(void*)0,(void*)0,(void*)0,(void*)0};
T935 M935=/*init:FAST_ARRAY[POSITION]*/{(void*)0,0,0,0};
T936 M936=/*init:RECYCLING_POOL[TAGGED_ERROR]*/{(void*)0,0,0,0};
T719 M719=/*init:TAGGED_ERROR*/{(void*)0,(void*)0,0};
T551 M551=/*init:RUN_TIME_SET*/{(void*)0,(void*)0};
T937 M937=/*init:HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/{(void*)0,(void*)0,0,0,0,0};
T938 M938=/*init:FAST_ARRAY[FIXED_STRING]*/{(void*)0,0,0,0};
T720 M720=/*init:TAGGED_ERRORS*/{720,(void*)0};
T939 M939=/*init:RING_ARRAY[TAGGED_ERROR]*/{(void*)0,0,0,0,0,0};
T340 M340=/*init:CECIL_FILE*/{(void*)0,(void*)0,(void*)0};
T943 M943=/*init:HASHED_DICTIONARY[CECIL_FILE,STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T807 M807=/*init:XDG*/0/*empty expanded*/;
T804 M804=/*init:SERC_CHAIN*/{804,(void*)0};
T806 M806=/*init:SERC_DEFAULTS*/{806,(void*)0,(void*)0,0};
T945 M945=/*init:STACK[STRING]*/{(void*)0,0,0,0};
T946 M946=/*init:REFERENCE[STRING]*/{(void*)0};
T59 M59=/*init:STRING_RECYCLING_POOL*/{0/*empty expanded*/,(void*)0,{(void*)0,0}};
T805 M805=/*init:SERC*/{805,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T947 M947=/*init:HASHED_DICTIONARY_NODE[STRING,STRING]*/{(void*)0,(void*)0,(void*)0};
T953 M953=/*init:HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/{(void*)0,(void*)0,(void*)0};
T954 M954=/*init:HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/{(void*)0,(void*)0,0,0,0,0};
T80 M80=/*init:AT_EXIT*/0/*empty expanded*/;
T955 M955=/*init:FAST_ARRAY[FEATURE_NAME]*/{(void*)0,0,0,0};
T959 M959=/*init:FAST_ARRAY[CLASSES]*/{(void*)0,0,0,0};
T106 M106=/*init:INI_PARSER*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0,0,{(void*)0,0,0},0,0,0,0,'\0'};
T962 M962=/*init:FAST_ARRAY[INTEGER_16]*/{(void*)0,0,0,0};
T783 M783=/*init:CLASSES_TREE*/{783,{(void*)0,(void*)0},(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T825 M825=/*init:LOADPATH*/{825,{(void*)0,(void*)0},(void*)0,(void*)0,(void*)0,(void*)0,0};
T964 M964=/*init:HASHED_DICTIONARY[CLASSES,STRING]*/{(void*)0,(void*)0,0,0,0,0};
T966 M966=/*init:HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/{(void*)0,(void*)0,0,0,0,0};
T968 M968=/*init:HASHED_SET[CLASS_NAME]*/{(void*)0,(void*)0,0,0,0,0};
T970 M970=/*init:HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/{(void*)0,(void*)0,0,0,0,0};
T785 M785=/*init:CLUSTER_POOL_DATA*/{(void*)0,(void*)0};
T491 M491=/*init:MICROSECOND_TIME*/{{0},0};
T973 M973=/*init:RING_ARRAY[FORMAL_ARG_LIST]*/{973,(void*)0,0,0,0,0,0};
T367 M367=/*init:FORMAL_ARG_LIST*/{367,{0},(void*)0,(void*)0};
T974 M974=/*init:RING_ARRAY[LOCAL_VAR_LIST]*/{974,(void*)0,0,0,0,0,0};
T407 M407=/*init:LOCAL_VAR_LIST*/{407,{0},(void*)0,(void*)0};
T975 M975=/*init:FAST_ARRAY[FEATURE_TEXT]*/{(void*)0,0,0,0};
T462 M462=/*init:FEATURE_TEXT*/{(void*)0,(void*)0,0,0,{0},(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T433 M433=/*init:INDEX_CLAUSE*/{(void*)0,(void*)0,(void*)0};
T395 M395=/*init:MANIFEST_STRING*/{395,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,{0},0};
T439 M439=/*init:FORMAL_GENERIC_LIST*/{{0},(void*)0,0};
T440 M440=/*init:FORMAL_GENERIC_ARG*/{(void*)0,(void*)0,0};
T505 M505=/*init:FORMAL_GENERIC_TYPE_MARK*/{505,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T514 M514=/*init:LIKE_CURRENT_TYPE_MARK*/{514,(void*)0,(void*)0,{0},0};
T516 M516=/*init:LIKE_FEATURE_TYPE_MARK*/{516,{0},(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T121 M121=/*init:PRETTY_PRINTER*/{0,0};
T517 M517=/*init:LIKE_ARGUMENT_TYPE_MARK*/{517,{0},(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T458 M458=/*init:ARRAY_TYPE_MARK*/{458,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T423 M423=/*init:NATIVE_ARRAY_TYPE_MARK*/{423,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T480 M480=/*init:WEAK_REFERENCE_TYPE_MARK*/{480,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T418 M418=/*init:CLASS_TYPE_MARK*/{418,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T449 M449=/*init:REAL_TYPE_MARK*/{449,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T455 M455=/*init:NON_EMPTY_TUPLE_TYPE_MARK*/{455,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T453 M453=/*init:EMPTY_TUPLE_TYPE_MARK*/{453,(void*)0,(void*)0,(void*)0,(void*)0,0};
T456 M456=/*init:AGENT_TYPE_MARK*/{456,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T396 M396=/*init:BOOLEAN_TYPE_MARK*/{396,(void*)0,(void*)0,(void*)0,0};
T450 M450=/*init:CHARACTER_TYPE_MARK*/{450,(void*)0,(void*)0,(void*)0,0};
T422 M422=/*init:INTEGER_TYPE_MARK*/{422,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T448 M448=/*init:NATURAL_TYPE_MARK*/{448,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T451 M451=/*init:POINTER_TYPE_MARK*/{451,(void*)0,(void*)0,(void*)0,0};
T459 M459=/*init:USER_GENERIC_TYPE_MARK*/{459,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T518 M518=/*init:CLIENT_TYPE_MARK*/{518,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T504 M504=/*init:TYPE_MARK_LIST*/{(void*)0,(void*)0};
T292 M292=/*init:CLIENT_LIST*/{(void*)0,(void*)0,{0}};
T461 M461=/*init:FEATURE_NAME_LIST*/{(void*)0,(void*)0};
T436 M436=/*init:CREATION_CLAUSE*/{(void*)0,(void*)0,(void*)0,{0}};
T282 M282=/*init:MINI_BUFFER*/{(void*)0,(void*)0,0,0};
T486 M486=/*init:NATIVE_BUILT_IN*/{486,(void*)0};
T488 M488=/*init:NATIVE_PLUG_IN*/{488,(void*)0,(void*)0,(void*)0,(void*)0,0};
T489 M489=/*init:NATIVE_C_PLUS_PLUS*/{489,(void*)0,(void*)0,(void*)0};
T490 M490=/*init:NATIVE_C*/{490,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T438 M438=/*init:EXTERNAL_TYPE*/{(void*)0,(void*)0,{0},(void*)0,(void*)0};
T976 M976=/*init:FAST_ARRAY[PARENT_EDGE]*/{(void*)0,0,0,0};
T289 M289=/*init:PARENT_EDGE*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T497 M497=/*init:RENAME_PAIR*/{(void*)0,(void*)0};
T977 M977=/*init:FAST_ARRAY[EXPRESSION]*/{(void*)0,0,0,0};
T538 M538=/*init:OLD_MANIFEST_ARRAY*/{538,(void*)0,{0}};
T507 M507=/*init:CALL_PREFIX_NOT*/{507,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T416 M416=/*init:ASSIGNMENT_TEST*/{416,(void*)0,(void*)0,(void*)0};
T493 M493=/*init:OPEN_OPERAND*/{493,(void*)0,{0},(void*)0,0};
T386 M386=/*init:INTEGER_CONSTANT*/{386,(void*)0,(void*)0,0,{0},0};
T494 M494=/*init:REAL_CONSTANT*/{494,(void*)0,(void*)0,(void*)0,{0}};
T495 M495=/*init:MANIFEST_GENERIC*/{495,(void*)0,{0},(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,{0}};
T370 M370=/*init:EFFECTIVE_ARG_LIST_N*/{370,{0},{0},(void*)0,(void*)0,0};
T361 M361=/*init:FUNCTION_CALL_0*/{361,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T364 M364=/*init:FUNCTION_CALL_1*/{364,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T366 M366=/*init:FUNCTION_CALL_N*/{366,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T355 M355=/*init:PROCEDURE_CALL_0*/{355,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T359 M359=/*init:PROCEDURE_CALL_1*/{359,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T360 M360=/*init:PROCEDURE_CALL_N*/{360,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T509 M509=/*init:CALL_PREFIX_PLUS*/{509,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T510 M510=/*init:CALL_PREFIX_MINUS*/{510,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T511 M511=/*init:CALL_PREFIX_FREEOP*/{511,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T499 M499=/*init:MANIFEST_TUPLE*/{499,(void*)0,(void*)0,{0}};
T400 M400=/*init:E_TRUE*/{400,{0}};
T471 M471=/*init:E_FALSE*/{471,{0}};
T481 M481=/*init:CHARACTER_CONSTANT*/{481,{0},(void*)0,'\0'};
T500 M500=/*init:PRECURSOR_EXPRESSION*/{500,(void*)0,(void*)0,(void*)0,(void*)0,{0}};
T535 M535=/*init:FAKE_TARGET*/{535,(void*)0,(void*)0,{0}};
T536 M536=/*init:CREATE_EXPRESSION*/{536,(void*)0,(void*)0,(void*)0,0,{0}};
T978 M978=/*init:STACK[TMP_FEATURE]*/{(void*)0,0,0,0};
T979 M979=/*init:ARRAY[ARGUMENT_NAME_DEF]*/{979,(void*)0,0,0,0,0};
T468 M468=/*init:ARGUMENT_NAME_DEF*/{468,(void*)0,(void*)0,(void*)0,(void*)0,0,{0}};
T469 M469=/*init:DECLARATION_GROUP*/{469,(void*)0};
T980 M980=/*init:ARRAY[LOCAL_ARGUMENT_DEF]*/{980,(void*)0,0,0,0,0};
T406 M406=/*init:DECLARATION_1*/{406,(void*)0};
T981 M981=/*init:ARRAY[DECLARATION]*/{(void*)0,0,0,0,0};
T684 M684=/*init:REQUIRE_ASSERTION*/{684,(void*)0,(void*)0,0,0};
T982 M982=/*init:FAST_ARRAY[ASSERTION]*/{(void*)0,0,0,0};
T435 M435=/*init:ASSERTION*/{435,(void*)0,(void*)0,(void*)0,(void*)0};
T983 M983=/*init:ARRAY[LOCAL_NAME_DEF]*/{983,(void*)0,0,0,0,0};
T403 M403=/*init:LOCAL_NAME_DEF*/{403,(void*)0,(void*)0,(void*)0,(void*)0,0,{0},0,0};
T537 M537=/*init:CHECK_COMPOUND*/{537,(void*)0,(void*)0,0};
T984 M984=/*init:FAST_ARRAY[MANIFEST_STRING]*/{(void*)0,0,0,0};
T496 M496=/*init:DEBUG_COMPOUND*/{496,(void*)0,(void*)0,{0},0};
T427 M427=/*init:IFTHEN*/{427,(void*)0,(void*)0,{0},0};
T413 M413=/*init:IFTHENELSE*/{413,(void*)0,(void*)0,(void*)0,(void*)0,{0},0};
T985 M985=/*init:FAST_ARRAY[WHEN_CLAUSE]*/{(void*)0,0,0,0};
T371 M371=/*init:WHEN_CLAUSE*/{371,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,{0},0};
T384 M384=/*init:IMPLICIT_CURRENT*/{384,(void*)0,(void*)0,{0}};
T376 M376=/*init:OTHER_INSPECT_STATEMENT*/{376,(void*)0,(void*)0,(void*)0,(void*)0,{0},(void*)0,(void*)0,{0},0};
T498 M498=/*init:MANIFEST_STRING_INSPECT_STATEMENT*/{498,(void*)0,(void*)0,(void*)0,(void*)0,{0},(void*)0,(void*)0,{0},0};
T443 M443=/*init:ASSERTION_LIST*/{443,(void*)0,(void*)0,{0},0};
T484 M484=/*init:LOOP_VARIANT*/{484,(void*)0,(void*)0,(void*)0,(void*)0};
T485 M485=/*init:LOOP_INSTRUCTION*/{485,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,{0},0};
T378 M378=/*init:RESULT*/{378,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,{0}};
T419 M419=/*init:CREATE_INSTRUCTION*/{419,(void*)0,{0},(void*)0,(void*)0,0,0};
T482 M482=/*init:C_INLINE*/{482,(void*)0,(void*)0,0,0,{0}};
T513 M513=/*init:PRECURSOR_INSTRUCTION*/{513,(void*)0,(void*)0,(void*)0,(void*)0,{0},0};
T503 M503=/*init:WRITTEN_CURRENT*/{503,(void*)0,(void*)0,{0}};
T381 M381=/*init:ASSIGNMENT*/{381,(void*)0,(void*)0,0};
T409 M409=/*init:ASSIGNMENT_ATTEMPT*/{409,(void*)0,(void*)0,0,0};
T483 M483=/*init:ASSIGNMENT_CALL_ASSIGNER*/{483,(void*)0,(void*)0,0};
T477 M477=/*init:RETRY_INSTRUCTION*/{477,{0},0};
T410 M410=/*init:COMPOUND*/{410,(void*)0,0};
T680 M680=/*init:ENSURE_ASSERTION*/{680,{0},(void*)0,(void*)0,0,0};
T502 M502=/*init:AGENT_CREATION*/{502,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,{0}};
T472 M472=/*init:EXPRESSION_WITH_COMMENT*/{472,(void*)0,(void*)0};
T411 M411=/*init:E_VOID*/{411,{0}};
T473 M473=/*init:IFTHEN_EXP*/{473,(void*)0,(void*)0,{0}};
T475 M475=/*init:IFTHENELSE_EXP*/{475,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,{0}};
T512 M512=/*init:E_OLD*/{512,(void*)0,{0},(void*)0};
T534 M534=/*init:CALL_INFIX_FREEOP*/{534,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T533 M533=/*init:CALL_INFIX_POWER*/{533,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T529 M529=/*init:CALL_INFIX_TIMES*/{529,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T530 M530=/*init:CALL_INFIX_INT_DIV*/{530,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T531 M531=/*init:CALL_INFIX_INT_REM*/{531,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T532 M532=/*init:CALL_INFIX_DIV*/{532,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T528 M528=/*init:CALL_INFIX_PLUS*/{528,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T389 M389=/*init:CALL_INFIX_MINUS*/{389,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T412 M412=/*init:BUILT_IN_EQ_NEQ*/{412,(void*)0,(void*)0,{0},0};
T524 M524=/*init:CALL_INFIX_LE*/{524,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T525 M525=/*init:CALL_INFIX_GE*/{525,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T526 M526=/*init:CALL_INFIX_LT*/{526,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T527 M527=/*init:CALL_INFIX_GT*/{527,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T417 M417=/*init:CALL_INFIX_AND_THEN*/{417,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T523 M523=/*init:CALL_INFIX_AND*/{523,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T520 M520=/*init:CALL_INFIX_OR_ELSE*/{520,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T521 M521=/*init:CALL_INFIX_OR*/{521,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T522 M522=/*init:CALL_INFIX_XOR*/{522,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T519 M519=/*init:CALL_INFIX_IMPLIES*/{519,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T476 M476=/*init:ADDRESS_OF*/{476,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T479 M479=/*init:EXPORT_LIST*/{(void*)0,(void*)0,(void*)0,{0}};
T478 M478=/*init:EXPORT_ITEM*/{(void*)0,(void*)0};
T988 M988=/*init:ARRAY[EXPORT_ITEM]*/{(void*)0,0,0,0,0};
T446 M446=/*init:FEATURE_CLAUSE*/{(void*)0,(void*)0,(void*)0,(void*)0};
T784 M784=/*init:CLUSTER_CLASS*/{(void*)0,(void*)0,(void*)0};
T470 M470=/*init:TAG_NAME*/{{0},(void*)0};
T372 M372=/*init:ARGUMENT_NAME_REF*/{372,(void*)0,(void*)0,0,{0},0,0};
T425 M425=/*init:WRITABLE_ATTRIBUTE_NAME*/{425,(void*)0,(void*)0,(void*)0,(void*)0};
T408 M408=/*init:LOCAL_NAME_REF*/{408,(void*)0,(void*)0,(void*)0,0,{0},0,0};
T989 M989=/*init:HASHED_SET[LIVE_TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T421 M421=/*init:RUN_FEATURE_2*/{421,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T993 M993=/*init:FAST_ARRAY[EXTERNAL_ROUTINE]*/{(void*)0,0,0,0};
T995 M995=/*init:HASHED_DICTIONARY_NODE[RUN_FEATURE,NATIVE]*/{(void*)0,(void*)0,(void*)0};
T997 M997=/*init:FAST_ARRAY[INTEGER_64]*/{(void*)0,0,0,0};
T998 M998=/*init:HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/{(void*)0,(void*)0,0,0,0,0};
T463 M463=/*init:PARENT_LISTS*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T999 M999=/*init:HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/{(void*)0,(void*)0,0,0,0,0};
T445 M445=/*init:FEATURE_CLAUSE_LIST*/{(void*)0};
T460 M460=/*init:CREATION_CLAUSE_LIST*/{(void*)0};
T1000 M1000=/*init:HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T442 M442=/*init:CLASS_INVARIANT*/{442,(void*)0,(void*)0,{0},0};
T415 M415=/*init:EXTERNAL_FUNCTION*/{415,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T1001 M1001=/*init:HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1002 M1002=/*init:ARRAY[TYPE]*/{(void*)0,0,0,0,0};
T101 M101=/*init:THREAD_POOL*/{(void*)0};
T1004 M1004=/*init:FAST_ARRAY[RUN_FEATURE]*/{(void*)0,0,0,0};
T701 M701=/*init:WRITABLE_ATTRIBUTE*/{701,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T1005 M1005=/*init:FAST_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/{(void*)0,0,0,0};
T1010 M1010=/*init:STACK[ANONYMOUS_FEATURE]*/{(void*)0,0,0,0};
T1011 M1011=/*init:HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T543 M543=/*init:GRAPH_NODE*/{(void*)0,(void*)0,0};
T1013 M1013=/*init:HASHED_SET[TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1014 M1014=/*init:HASHED_DICTIONARY[INTEGER_8,TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1017 M1017=/*init:FAST_ARRAY[TYPE]*/{(void*)0,0,0,0};
T1018 M1018=/*init:HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1021 M1021=/*init:HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1022 M1022=/*init:FAST_ARRAY[CLASS_TEXT]*/{(void*)0,0,0,0};
T1023 M1023=/*init:FAST_ARRAY[FEATURE_STAMP]*/{(void*)0,0,0,0};
T1024 M1024=/*init:HASHED_DICTIONARY_NODE[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/{(void*)0,(void*)0,(void*)0};
T1027 M1027=/*init:HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]*/{(void*)0,(void*)0,(void*)0};
T1031 M1031=/*init:FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/{(void*)0,0,0,0};
T1036 M1036=/*init:HASHED_SET[STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1037 M1037=/*init:HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1038 M1038=/*init:HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1039 M1039=/*init:HASHED_SET[MANIFEST_GENERIC]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1040 M1040=/*init:FAST_ARRAY[NON_VOID_NO_DISPATCH]*/{(void*)0,0,0,0};
T547 M547=/*init:NON_VOID_NO_DISPATCH*/{547,(void*)0,(void*)0,(void*)0};
T1041 M1041=/*init:HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1042 M1042=/*init:FAST_ARRAY[AGENT_CREATION]*/{(void*)0,0,0,0};
T581 M581=/*init:AGENT_ARGS*/{(void*)0,(void*)0};
T1044 M1044=/*init:HASHED_SET[AGENT_ARGS]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1045 M1045=/*init:HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1046 M1046=/*init:FAST_ARRAY[HASHED_SET[TYPE]]*/{(void*)0,0,0,0};
T1049 M1049=/*init:HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]*/{(void*)0,(void*)0,(void*)0};
T1051 M1051=/*init:FAST_ARRAY[FAST_ARRAY[CODE]]*/{(void*)0,0,0,0};
T1052 M1052=/*init:FAST_ARRAY[CODE]*/{(void*)0,0,0,0};
T1053 M1053=/*init:HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1054 M1054=/*init:FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/{(void*)0,0,0,0};
T660 M660=/*init:ANONYMOUS_FEATURE_MIXER*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T1055 M1055=/*init:HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/{(void*)0,(void*)0,0,0,0,0};
T1056 M1056=/*init:QUEUE[TYPE]*/{(void*)0,0,0,0,0,0};
T1057 M1057=/*init:HASHED_SET[ABSOLUTE_FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T348 M348=/*init:ABSOLUTE_FEATURE_NAME*/{(void*)0,(void*)0,0};
T1058 M1058=/*init:HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1063 M1063=/*init:HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1064 M1064=/*init:ARRAY[ARRAY[INTEGER_8]]*/{(void*)0,0,0,0,0};
T1065 M1065=/*init:ARRAY[INTEGER_8]*/{(void*)0,0,0,0,0};
T1066 M1066=/*init:FAST_ARRAY[ANONYMOUS_FEATURE]*/{(void*)0,0,0,0};
T1069 M1069=/*init:HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/{(void*)0,(void*)0,(void*)0};
T1072 M1072=/*init:HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]*/{(void*)0,(void*)0,0};
T1075 M1075=/*init:HASHED_SET_NODE[HASHED_STRING]*/{(void*)0,(void*)0};
T1079 M1079=/*init:HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/{(void*)0,(void*)0,0,0,0,0};
T842 M842=/*init:BDW_ASSIGN_NATIVE_ARRAY*/{842,(void*)0,(void*)0,(void*)0};
T843 M843=/*init:LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/(void*)0;
T844 M844=/*init:BDW_GC_DEFINE2*/{844,(void*)0,(void*)0,(void*)0};
T846 M846=/*init:C_GARBAGE_COLLECTOR_HEADER_COMPILER*/{846,(void*)0};
T848 M848=/*init:C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/{848,(void*)0,(void*)0,(void*)0};
T849 M849=/*init:C_GARBAGE_COLLECTOR_INFO_COMPILER*/{849};
T850 M850=/*init:C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/{850};
T851 M851=/*init:C_GARBAGE_COLLECTOR_NEED_MARK*/{851,0};
T1080 M1080=/*init:FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/{(void*)0,0,0,0};
T845 M845=/*init:C_GARBAGE_COLLECTOR_TAG*/{845,(void*)0,0,0};
T852 M852=/*init:C_GARBAGE_COLLECTOR_TAGGER*/{852,(void*)0,(void*)0};
T1081 M1081=/*init:FAST_ARRAY[ABSTRACT_STRING]*/{(void*)0,0,0,0};
T1084 M1084=/*init:AVL_SET[LIVE_TYPE]*/{(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0};
T1086 M1086=/*init:HASHED_DICTIONARY_NODE[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/{(void*)0,(void*)0,0};
T1089 M1089=/*init:FAST_ARRAY[CECIL_ENTRY]*/{(void*)0,0,0,0};
T583 M583=/*init:CECIL_ENTRY*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T1091 M1091=/*init:HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]*/{(void*)0,(void*)0,(void*)0};
T1093 M1093=/*init:REFERENCE[FIXED_STRING]*/{(void*)0};
T1095 M1095=/*init:RING_ARRAY[SE_CONFIG]*/{(void*)0,0,0,0,0,0};
T1096 M1096=/*init:FAST_ARRAY[STRING_RECYCLING_ITEM]*/{(void*)0,0,0,0};
T324 M324=/*init:STRING_RECYCLING_ITEM*/{(void*)0,0};
T747 M747=/*init:STRING_RECYCLING_ITEM_SORTER*/0/*empty expanded*/;
T1098 M1098=/*init:HASHED_DICTIONARY[SE_C_MODE,STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1101 M1101=/*init:RING_ARRAY[PROCEDURE[TUPLE]]*/{(void*)0,0,0,0,0,0};
T1105 M1105=/*init:ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0};
T1106 M1106=/*init:ORDERED_DICTIONARY[STRING,STRING]*/{1106,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T542 M542=/*init:PROCESS_FACTORY*/{(void*)0,0,0,0,0};
T1108 M1108=/*init:HASHED_DICTIONARY[CLUSTER,STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T809 M809=/*init:POSIX_PATH_NAME*/{809,(void*)0};
T1110 M1110=/*init:FAST_ARRAY[TEXT_FILE_READ]*/{(void*)0,0,0,0};
T1111 M1111=/*init:HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1113 M1113=/*init:HASHED_DICTIONARY_NODE[CLASSES,STRING]*/{(void*)0,(void*)0,(void*)0};
T1116 M1116=/*init:HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]*/{(void*)0,(void*)0,(void*)0};
T1119 M1119=/*init:HASHED_SET_NODE[CLASS_NAME]*/{(void*)0,(void*)0};
T1122 M1122=/*init:HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]*/{(void*)0,(void*)0,0};
T1124 M1124=/*init:HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/{(void*)0,(void*)0,0,0,0,0};
T726 M726=/*init:TIME*/{0};
T699 M699=/*init:CST_ATT_CHARACTER*/{699,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T696 M696=/*init:CST_ATT_STRING*/{696,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T584 M584=/*init:ONCE_FUNCTION*/{584,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T700 M700=/*init:CST_ATT_REAL*/{700,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T1128 M1128=/*init:FAST_ARRAY[FORMAL_ARG_LIST]*/{1128,(void*)0,0,0,0};
T1130 M1130=/*init:FAST_ARRAY[LOCAL_VAR_LIST]*/{1130,(void*)0,0,0,0};
T693 M693=/*init:CST_ATT_BOOLEAN*/{693,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T686 M686=/*init:DEFERRED_FUNCTION*/{686,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T689 M689=/*init:EXTERNAL_PROCEDURE*/{689,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T691 M691=/*init:E_PROCEDURE*/{691,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T698 M698=/*init:CST_ATT_INTEGER*/{698,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T692 M692=/*init:E_FUNCTION*/{692,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T688 M688=/*init:DEFERRED_PROCEDURE*/{688,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T690 M690=/*init:ONCE_PROCEDURE*/{690,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T697 M697=/*init:CST_ATT_UNIQUE*/{697,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T432 M432=/*init:INDEX_LIST*/{(void*)0};
T1132 M1132=/*init:ARRAY[FORMAL_GENERIC_ARG]*/{(void*)0,0,0,0,0};
T1133 M1133=/*init:HASHED_DICTIONARY[TYPE_MARK,TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1134 M1134=/*init:HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1135 M1135=/*init:FAST_ARRAY[TYPE_MARK]*/{(void*)0,0,0,0};
T713 M713=/*init:RENAME_LIST*/{(void*)0};
T1142 M1142=/*init:FAST_ARRAY[REQUIRE_ASSERTION]*/{(void*)0,0,0,0};
T1146 M1146=/*init:FAST_ARRAY[IFTHEN]*/{(void*)0,0,0,0};
T763 M763=/*init:WHEN_ITEM_2*/{763,(void*)0,(void*)0,(void*)0,(void*)0};
T1148 M1148=/*init:FAST_ARRAY[WHEN_ITEM]*/{(void*)0,0,0,0};
T394 M394=/*init:WHEN_ITEM_1*/{394,(void*)0,(void*)0};
T465 M465=/*init:COMPOUND_EXPRESSION*/{465,(void*)0};
T675 M675=/*init:CREATE_WRITABLE*/{675,(void*)0,(void*)0,(void*)0};
T1149 M1149=/*init:FAST_ARRAY[INSTRUCTION]*/{(void*)0,0,0,0};
T1150 M1150=/*init:FAST_ARRAY[OPEN_OPERAND]*/{(void*)0,0,0,0};
T676 M676=/*init:CLOSED_OPERAND*/{676,(void*)0,(void*)0,0,0,{0}};
T1151 M1151=/*init:FAST_ARRAY[CLOSED_OPERAND]*/{(void*)0,0,0,0};
T1152 M1152=/*init:FAST_ARRAY[IFTHEN_EXP]*/{(void*)0,0,0,0};
T1153 M1153=/*init:HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/{(void*)0,(void*)0,0,0,0,0};
T1157 M1157=/*init:HASHED_SET_NODE[LIVE_TYPE]*/{(void*)0,(void*)0};
T1162 M1162=/*init:HASHED_DICTIONARY_NODE[INTEGER_8,CLASS_TEXT]*/{(void*)0,(void*)0,0};
T1165 M1165=/*init:HASHED_DICTIONARY_NODE[TAGGED_DATA,FIXED_STRING]*/{(void*)0,(void*)0,(void*)0};
T1167 M1167=/*init:FAST_ARRAY[FEATURE_CLAUSE]*/{(void*)0,0,0,0};
T1168 M1168=/*init:FAST_ARRAY[CREATION_CLAUSE]*/{(void*)0,0,0,0};
T1170 M1170=/*init:HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0};
T428 M428=/*init:NO_INVARIANT_WRAPPER*/{428,(void*)0,0};
T1173 M1173=/*init:HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]*/{(void*)0,(void*)0,(void*)0};
T1176 M1176=/*init:HASHED_DICTIONARY[EXPRESSION,TYPE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1180 M1180=/*init:HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1185 M1185=/*init:HASHED_SET_NODE[TYPE]*/{(void*)0,(void*)0};
T1188 M1188=/*init:HASHED_DICTIONARY_NODE[INTEGER_8,TYPE]*/{(void*)0,(void*)0,0};
T1193 M1193=/*init:HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0,(void*)0};
T1196 M1196=/*init:HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1199 M1199=/*init:HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1204 M1204=/*init:HASHED_SET_NODE[STRING]*/{(void*)0,(void*)0};
T1207 M1207=/*init:HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]*/{(void*)0,(void*)0,(void*)0};
T1210 M1210=/*init:HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]*/{(void*)0,(void*)0,(void*)0};
T1213 M1213=/*init:HASHED_SET_NODE[MANIFEST_GENERIC]*/{(void*)0,(void*)0};
T1216 M1216=/*init:HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]*/{(void*)0,(void*)0,(void*)0};
T1220 M1220=/*init:HASHED_SET_NODE[AGENT_ARGS]*/{(void*)0,(void*)0};
T1222 M1222=/*init:HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]*/{(void*)0,(void*)0,(void*)0};
T1229 M1229=/*init:HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0};
T1234 M1234=/*init:HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0};
T1237 M1237=/*init:HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]*/{(void*)0,{(void*)0,(void*)0,0}};
T1240 M1240=/*init:HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/{(void*)0,{(void*)0,(void*)0,0},(void*)0};
T1243 M1243=/*init:HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1248 M1248=/*init:HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/{(void*)0,(void*)0,(void*)0};
T879 M879=/*init:C_GARBAGE_COLLECTOR_STRUCTER*/{(void*)0};
T1250 M1250=/*init:FAST_ARRAY[RUN_FEATURE_2]*/{(void*)0,0,0,0};
T1253 M1253=/*init:FAST_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/{(void*)0,0,0,0};
T1254 M1254=/*init:AVL_SET_NODE[LIVE_TYPE]*/{(void*)0,(void*)0,(void*)0,0,0/*empty expanded*/};
T1255 M1255=/*init:RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/{1255,(void*)0,0,0,0};
T1256 M1256=/*init:HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/{(void*)0,(void*)0,0,0,0,0};
T369 M369=/*init:FAKE_ARGUMENT*/{369,0,{0},(void*)0,(void*)0};
T1259 M1259=/*init:HASHED_SET[GRAPH_NODE]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1263 M1263=/*init:HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]*/{(void*)0,(void*)0,(void*)0};
T1268 M1268=/*init:HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]*/{(void*)0,(void*)0,(void*)0};
T1269 M1269=/*init:ITERATOR_ON_TRAVERSABLE[STRING]*/{1269,(void*)0,0,0};
T801 M801=/*init:PROCESS_POSIX*/{801,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0};
T802 M802=/*init:PROCESS_WIN32*/{802,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0,0,0};
T803 M803=/*init:PROCESS_NONE*/{803,(void*)0,0,0,0};
T798 M798=/*init:PROCESS_GROUP_POSIX*/{798,(void*)0,(void*)0};
T799 M799=/*init:PROCESS_GROUP_WIN32*/{799,(void*)0,(void*)0,0};
T800 M800=/*init:PROCESS_GROUP_NONE*/{800};
T1273 M1273=/*init:HASHED_DICTIONARY_NODE[CLUSTER,STRING]*/{(void*)0,(void*)0,(void*)0};
T1278 M1278=/*init:HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]*/{(void*)0,(void*)0,(void*)0};
T1281 M1281=/*init:HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]*/{(void*)0,(void*)0,(void*)0};
T1283 M1283=/*init:FAST_ARRAY[INDEX_CLAUSE]*/{(void*)0,0,0,0};
T1286 M1286=/*init:HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1289 M1289=/*init:HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1291 M1291=/*init:FAST_ARRAY[RENAME_PAIR]*/{(void*)0,0,0,0};
T1300 M1300=/*init:HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]*/{(void*)0,(void*)0,(void*)0};
T1304 M1304=/*init:HASHED_DICTIONARY_NODE[EXPRESSION,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1308 M1308=/*init:HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/{(void*)0,(void*)0,(void*)0};
T1315 M1315=/*init:HASHED_DICTIONARY_NODE[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/{(void*)0,(void*)0,(void*)0};
T1318 M1318=/*init:HASHED_SET_NODE[GRAPH_NODE]*/{(void*)0,(void*)0};
T1320 M1320=/*init:RING_ARRAY[INTEGER_32]*/{(void*)0,0,0,0,0,0};
T1321 M1321=/*init:HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/{(void*)0,(void*)0,0,0,0,0};
T1322 M1322=/*init:HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/{(void*)0,(void*)0,0,0,0,0};
T1325 M1325=/*init:HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]*/{(void*)0,(void*)0,0};
T1328 M1328=/*init:HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]*/{(void*)0,(void*)0,0};
T61 M61=/*init:STD_INPUT*/{(void*)0,(void*)0,0};
T811 M811=/*init:MICROSOFT_PATH_NAME*/{811,(void*)0,(void*)0,'\0',0};
T767 M767=/*init:UTF8_PARSER*/{(void*)0,0,0};
T682 M682=/*init:SEDB*/{682,0,{0},'\0'};
T1335 M1335=/*init:HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1336 M1336=/*init:TUPLE[TYPE,TYPE]*/{(void*)0,(void*)0};
T1337 M1337=/*init:HASHED_DICTIONARY[TYPE,TYPE]*/{(void*)0,(void*)0,0,0,0,0};
T1338 M1338=/*init:HASHED_SET[NATIVE_PLUG_IN]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1340 M1340=/*init:HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T1343 M1343=/*init:HASHED_DICTIONARY[PLUGIN,STRING]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0};
T702 M702=/*init:EFFECTIVE_ARG_LIST_0*/{702,{0},{0},0};
T667 M667=/*init:NULL_POINTER*/{667,(void*)0,{0}};
T580 M580=/*init:VOID_CALL*/{580,(void*)0,(void*)0,{0}};
T548 M548=/*init:INLINE_MEMO*/{(void*)0};
T1344 M1344=/*init:FAST_ARRAY[INLINE_MEMO]*/{(void*)0,0,0,0};
T668 M668=/*init:NO_DISPATCH*/{668,(void*)0,(void*)0};
T672 M672=/*init:DYNAMIC_DISPATCH_TEMPORARY1*/{672,(void*)0,(void*)0,(void*)0};
T671 M671=/*init:DYNAMIC_DISPATCH_TEMPORARY2*/{671,(void*)0,(void*)0};
T673 M673=/*init:DYNAMIC_DISPATCH_TEMPORARY1_ID*/{673,(void*)0};
T670 M670=/*init:INTERNAL_LOCAL2*/{670,{0},(void*)0,(void*)0,(void*)0,0};
T681 M681=/*init:UNUSED_EXPRESSION*/{681,(void*)0,0};
T666 M666=/*init:NATURAL_CONSTANT*/{666,(void*)0,(void*)0,0,{0},0};
T683 M683=/*init:RUN_TIME_ERROR_INSTRUCTION*/{683,(void*)0,0,0/*empty expanded*/,{0},0};
T342 M342=/*init:EXCEPTIONS*/0/*empty expanded*/;
T1345 M1345=/*init:STACK[AGENT_CREATION]*/{(void*)0,0,0,0};
T1346 M1346=/*init:AVL_SET[POSITION]*/{(void*)0,(void*)0,(void*)0,0,0,0,{0},0};
T544 M544=/*init:IMPLICIT_CAST*/{544,(void*)0,(void*)0,(void*)0};
T677 M677=/*init:AGENT_EXPRESSION*/{677,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T578 M578=/*init:VOID_PROC_CALL*/{578,(void*)0,(void*)0,{0},0};
T685 M685=/*init:AGENT_INSTRUCTION*/{685,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T764 M764=/*init:MANIFEST_STRING_INSPECTOR*/{(void*)0,{0},(void*)0,0,{0}};
T765 M765=/*init:CODE_COMPARATOR*/{765,(void*)0,(void*)0,0};
T1348 M1348=/*init:REFERENCE[E_OLD]*/{(void*)0};
T1349 M1349=/*init:FAST_ARRAY[FAST_ARRAY[E_OLD]]*/{(void*)0,0,0,0};
T1350 M1350=/*init:FAST_ARRAY[E_OLD]*/{(void*)0,0,0,0};
T320 M320=/*init:NUMBER_TOOLS*/0/*empty expanded*/;
T128 M128=/*init:PRECOMPUTABLE_ROUTINE_DETECTOR*/{128,0,0};
T1351 M1351=/*init:HASHED_SET[FEATURE_STAMP]*/{(void*)0,(void*)0,0,0,0,0};
T1352 M1352=/*init:FAST_ARRAY[ADDRESS_OF]*/{(void*)0,0,0,0};
T770 M770=/*init:RUN_FEATURE_8*/{770,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T122 M122=/*init:EXCEPTIONS_HANDLER*/{0};
T1357 M1357=/*init:ARRAY[FEATURE_STAMP]*/{(void*)0,0,0,0,0};
T429 M429=/*init:STATIC_CALL_0_C*/{429,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T426 M426=/*init:RAW_CREATE_INSTRUCTION*/{426,(void*)0,{0},(void*)0,(void*)0,0,0};
T380 M380=/*init:GENERATOR_GENERATING_TYPE*/{380,{0},(void*)0,'\0'};
T820 M820=/*init:RUN_FEATURE_1*/{820,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T663 M663=/*init:RUN_FEATURE_6*/{663,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T818 M818=/*init:RUN_FEATURE_9*/{818,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T771 M771=/*init:RUN_FEATURE_7*/{771,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T669 M669=/*init:NATIVE_ARRAY_ITEM*/{669,{0},(void*)0,(void*)0,(void*)0};
T553 M553=/*init:RUN_FEATURE_3*/{553,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0,0};
T1359 M1359=/*init:ARRAY[RUN_FEATURE_2]*/{(void*)0,0,0,0,0};
T819 M819=/*init:RUN_FEATURE_4*/{819,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T662 M662=/*init:RUN_FEATURE_5*/{662,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,0};
T350 M350=/*init:COUNTER*/{0};
T1361 M1361=/*init:FAST_ARRAY[POINTER]*/{(void*)0,0,0,0};
T871 M871=/*init:EXEC_OUTPUT_STREAM_POSIX*/{871,(void*)0,(void*)0,(void*)0,0,0};
T873 M873=/*init:EXEC_INPUT_STREAM_POSIX*/{873,(void*)0,(void*)0,0,0,0,0,'\0',0,'\0'};
T874 M874=/*init:EXEC_OUTPUT_STREAM_WIN32*/{874,(void*)0,(void*)0,(void*)0,(void*)0,0};
T875 M875=/*init:EXEC_INPUT_STREAM_WIN32*/{875,(void*)0,(void*)0,(void*)0,0,0,0,'\0',0,'\0'};
T1363 M1363=/*init:HASHED_DICTIONARY_NODE[TUPLE[TYPE,TYPE],TYPE]*/{(void*)0,(void*)0,(void*)0};
T1365 M1365=/*init:HASHED_DICTIONARY_NODE[TYPE,TYPE]*/{(void*)0,(void*)0,(void*)0};
T1369 M1369=/*init:HASHED_SET_NODE[NATIVE_PLUG_IN]*/{(void*)0,(void*)0};
T1372 M1372=/*init:HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]*/{(void*)0,(void*)0,(void*)0};
T1375 M1375=/*init:HASHED_DICTIONARY_NODE[PLUGIN,STRING]*/{(void*)0,(void*)0,(void*)0};
T1378 M1378=/*init:FAST_ARRAY[AVL_SET_NODE[POSITION]]*/{(void*)0,0,0,0};
T1379 M1379=/*init:AVL_SET_NODE[POSITION]*/{0,{0},(void*)0,(void*)0,0/*empty expanded*/};
T1380 M1380=/*init:RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/{1380,(void*)0,0,0,0};
T674 M674=/*init:FAKE_TUPLE*/{674,(void*)0,{0}};
T869 M869=/*init:TUPLE_STRING_POOL*/{(void*)0,(void*)0,(void*)0,0,0,0,0};
T738 M738=/*init:INTEGER_64_NUMBER*/{738,0};
T1384 M1384=/*init:HASHED_SET_NODE[FEATURE_STAMP]*/{(void*)0,(void*)0};
T1390 M1390=/*init:AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/{(void*)0,(void*)0,(void*)0,0,0,0,0,0,0};
T1392 M1392=/*init:LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/{(void*)0,(void*)0,(void*)0,(void*)0,0,0,0};
T1393 M1393=/*init:TUPLE[CHARACTER,INTEGER_32]*/{0,'\0'};
T1394 M1394=/*init:FAST_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/{(void*)0,0,0,0};
T1395 M1395=/*init:FAST_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/{(void*)0,0,0,0};
T1396 M1396=/*init:AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/{(void*)0,(void*)0,0,0/*empty expanded*/,0,0};
T1400 M1400=/*init:LINKED_LIST_NODE[TUPLE[CHARACTER,INTEGER_32]]*/{(void*)0,(void*)0};
T1401 M1401=/*init:HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1405 M1405=/*init:HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/{(void*)0,(void*)0,(void*)0};
T904 M904=/*init:C_PLUGIN*/{(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,{0},0,0,{(void*)0,(void*)0},(void*)0,(void*)0,0};
T577 M577=/*init:INTERNAL_C_LOCAL*/{(void*)0,(void*)0,0,0};
T659 M659=/*init:INTERNAL_C_LOCAL_LIST*/{0};
T1409 M1409=/*init:FAST_ARRAY[CODE_CONTEXT]*/{(void*)0,0,0,0};
T1412 M1412=/*init:ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/{(void*)0,0,0,0,0};
T571 M571=/*init:CODE_CONTEXT_DIRECT_CALL*/{571,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T572 M572=/*init:CODE_CONTEXT_CREATE_INSTRUCTION*/{572,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T573 M573=/*init:CODE_CONTEXT_CREATE_EXPRESSION*/{573,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T574 M574=/*init:CODE_CONTEXT_INSIDE_TWIN*/{574,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T575 M575=/*init:CODE_CONTEXT_PRECURSOR*/{575,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T576 M576=/*init:CODE_CONTEXT_INSIDE_SOME_WRAPPER*/{576,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0,(void*)0};
T1426 M1426=/*init:ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/{1426,(void*)0,0,0};
T824 M824=/*init:C_SPLITTER_LEGACY_ITERATOR*/{824,0,0};
T1434 M1434=/*init:FAST_ARRAY[RUN_FEATURE_6]*/{(void*)0,0,0,0};
T841 M841=/*init:TAGGED_FLAG*/{841,0};
T1435 M1435=/*init:HASHED_DICTIONARY[AGENT_ARGS,STRING]*/{(void*)0,(void*)0,0,0,0,0};
T1436 M1436=/*init:FAST_ARRAY[RUN_FEATURE_5]*/{(void*)0,0,0,0};
T743 M743=/*init:MUTABLE_BIG_INTEGER*/{(void*)0,0,0,0,0};
T1437 M1437=/*init:RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/{1437,(void*)0,0,0,0};
T1438 M1438=/*init:FAST_ARRAY[INTERNAL_C_LOCAL]*/{(void*)0,0,0,0};
T1442 M1442=/*init:HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]*/{(void*)0,(void*)0,(void*)0};
T740 M740=/*init:BIG_INTEGER_NUMBER*/{740,(void*)0,0,0};
T1461 M1461=/*init:STACK[EXPRESSION]*/{(void*)0,0,0,0};
T816 M816=/*init:TAGGED_INTERNAL_C_LOCAL*/{816,(void*)0};
T1462 M1462=/*init:HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/{(void*)0,(void*)0,0,0,0,0};
T814 M814=/*init:TAGGED_INTEGER*/{814,0};
T1464 M1464=/*init:FAST_ARRAY[CHARACTER]*/{(void*)0,0,0,0};
T1466 M1466=/*init:HASHED_DICTIONARY_NODE[TAGGED_INTEGER,INTEGER_32]*/{(void*)0,(void*)0,0};
/*Aliased storage area or unicode storage.*/
char*s358_1195446850A=". (See the next error report for details.)";
char*s113_0A="";
char*s117_1418906530A="void se_msi";
char*s33_424424A="low_16";
char*s647_25969530A=",a1ptr->_";
char*s121_9A="\011""";
char*s111_10A="\n";
char*s33_424430A="low_32";
char*s381_1114345928A="Void cannot be assigned to an expanded entity.";
char*s660_1983193131A="To fix this ambiguous Precursor call you have to remove direct repeated inheritance. You may thus consider to add a new class which inherit ";
char*s30_199827552A=": level is already set to ";
char*s117_1564992795A="int se_general_trace_switch";
char*s647_59375621A="Class NATIVE_ARRAY has been tampered with. Unknown function: ";
char*s117_1772404517A="&local_profile,";
char*s104_1078639380A="Expression expected after \'implies\'.";
char*s436_772854717A="Feature `manifest_put\' must be a procedure.";
char*s104_1138390195A="Prefix operator name expected.";
char*s117_523400916A="Precomputed once function";
char*s104_393689A="bottom";
char*s483_218994080A="Replacing assign to \173""";
char*s117_12331A="NULL";
char*s694_32A=" ";
char*s625_5794275A="=(u->CL_";
char*s729_1880914324A="gc_agent*gcu=(gc_agent*)u;\nif (gcu->header.flag==FSOH_UNMARKED)\173""\ngcu->header.flag=FSOH_MARKED;\n";
char*s104_34A="\"";
char*s729_1607908341A="Adding SmartEiffel Garbage Collector.\n";
char*s33_38A="&";
char*s117_40A="(";
char*s117_41A=")";
char*s640_7233618A="INT8_MIN";
char*s33_42A="*";
char*s33_43A="+";
char*s117_44A=",";
char*s117_36951A="(T0*)";
char*s113_45A="-";
char*s467_46A=".";
char*s113_47A="/";
char*s638_48A="0";
char*s126_1071750288A="SmallEiffel";
char*s29_1889925553A="compile_to_c";
char*s425_532898088A=" See also the next message for more information.";
char*s625_1664036235A="set_dump_stack_top(caller);/*unlink*/\nreturn C;\n";
char*s488_58A=":";
char*s625_1023028228A=";\nu->afp=afp_";
char*s648_59A=";";
char*s121_60A="\n\n";
char*s33_60A="<";
char*s33_61A="=";
char*s647_2017590A="floor((";
char*s844_1752899740A="GC_REGISTER_FINALIZER_NO_ORDER(R, bdw_finalizeT";
char*s33_62A=">";
char*s30_63A="\?";
char*s805_1883030297A=" (discarded)\n";
char*s33_64A="@";
char*s106_1684808173A="Invalid empty file";
char*s650_1216329562A="if (!strcmp(attr,\"";
char*s104_67A="C";
char*s104_1268871407A="Bad inline agent definition (\"do...end\" routine body expected).";
char*s647_219498506A="Unknown \"$";
char*s30_1202957293A=": missing file path name after -output_error_warning_on flag.\n";
char*s34_212160365A="require_check";
char*s642_80037A="else ";
char*s33_12376A="REAL";
char*s120_325166540A="Can\'t join these two concrete features. What\'s called a concrete feature here is a feature which is not deferred. You may consider to undefine one feature or to add a redefine.";
char*s117_77A="M";
char*s437_77A="\011"" ";
char*s825_79A="\011""\"";
char*s117_1206795525A="c_plus_plus";
char*s117_441192857A="initialize_eiffel_runtime(argc,argv);\n";
char*s625_82A="R";
char*s552_251231528A="generating";
char*s625_84A="T";
char*s117_2189840A="se_ums(";
char*s115_301485A="Cygwin";
char*s117_392938270A="init_profile(agent_profile+";
char*s625_585895143A="(se_dump_stack*caller,";
char*s640_91A="[";
char*s117_93A="]";
char*s33_94A="^";
char*s104_916596A=" items.";
char*s825_2008215484A=" (not in a loadpath)";
char*s729_152877053A="(/*malloc*/(T";
char*s113_99A="c";
char*s848_101A="e";
char*s283_376816512A="external_header_path";
char*s113_273430505A="return 0;\n";
char*s30_104A="h";
char*s642_105A="i";
char*s101_283093730A="tuple_args";
char*s113_109A="m";
char*s447_178490A=" class";
char*s33_112335826A="signal_number";
char*s117_114A="r";
char*s97_772983982A="Problem with undefine of \"";
char*s702_115A="s";
char*s577_1399364920A="/*auto-unlock tmp";
char*s30_118A="v";
char*s495_123A="\173""";
char*s33_124A="\174""";
char*s729_125A="\175""";
char*s33_126A="\176""";
char*s117_273430530A="return 1;\n";
char*s117_391886489A="])(FILE*,void*)";
char*s554_876265439A="/lang/eiffel/.liberty-eiffel";
char*s727_6284A="(((T";
char*s377_1485085274A="..... unique buffer 1 .....";
char*s117_545126362A="*(volatile ";
char*s409_1089483711A=" must not be expanded. (";
char*s647_579867211A="(T6)(C==a1)";
char*s104_629850238A="An expression has a result value. This is not an instruction.";
char*s117_1629400044A="#define SE_BOOST 1\n";
char*s33_80109A="fifth";
char*s642_252339A="=NULL;";
char*s120_612971904A="\n\nSecond \"insert\" path (from parent to child):\n   ";
char*s447_202915491A="Same class name appears twice.";
char*s407_446205995A="Same local name appears twice in this \"local\" variable list.";
char*s642_6305A=")&&(";
char*s104_280897875A=" for the left-hand side of an assignment.";
char*s415_1324593410A="Overflow of infix \"*\" with INTEGER_32 operands. (";
char*s34_1473988901A="c_linker_options";
char*s583_168A="\011""\173""";
char*s435_145102259A="(The type of this expression is actually ";
char*s104_339436953A="Compiler limitation: separate classes are not supported. SCOOP attempt implementation currently abandoned (December 2006).";
char*s113_539873441A="\" (default mode) selected.\n";
char*s467_1876110531A="Value out of INTEGER_32 range.";
char*s650_51065777A="\173""\nstatic ";
char*s104_470853074A="The base type is no longer used. Class PROCEDURE now has only one formal argument. Just remove this unused type mark.";
char*s702_1257264577A=" while the actual argument list has no argument.";
char*s582_6330A="();\n";
char*s113_180A="\"\n";
char*s33_961210799A="allocated_bytes";
char*s117_116813823A="default:\nerror0(\"Internal error in agent launcher (";
char*s117_30942A=") */ ";
char*s117_37095A="(T6)(";
char*s844_61699A="NULL,";
char*s33_269315573A="notify_all";
char*s34_436911A="rescue";
char*s642_1341914655A="/*count*/=((";
char*s105_1604340919A="Bad clients list.";
char*s283_1341859296A="Keyword \"system\" expected. Invalid ACE file.";
char*s104_194A=" \"";
char*s660_42706587A="The type ";
char*s111_195A="%\n";
char*s117_475921520A="memcpy(sorted_agent_switch_profile, agent_switch_profile, ";
char*s365_788380019A="The feature called has no formal argument while the actual argument list has 1 argument.";
char*s624_619030689A="fprintf(file,\"\\n\\t]\");\n";
char*s293_200A=" (";
char*s642_117385886A="/*[inspect";
char*s729_786221024A="GC support: generating switch functions.\n";
char*s117_6355A=" R;\n";
char*s728_1409981632A=")REVEAL_POINTER(";
char*s117_204A="\"\"";
char*s640_205A="!(";
char*s844_85966583A="(o);\nGC_enable();\n";
char*s110_580488532A=" nodes and ";
char*s848_212314278A="->first_object)));\n";
char*s104_639285944A="Missing \')\' to end `c_inline_c\' call.";
char*s427_1085830094A="ifthen (empty)";
char*s111_215A=")\n";
char*s395_905138318A="Invalid unicode string at index ";
char*s283_216A="\".";
char*s342_2070057757A="Loop_invariant";
char*s33_217A="#*";
char*s488_218A=" :";
char*s33_218A="#+";
char*s647_160146A="))))))";
char*s117_993675817A="if(fd.assertion_flag)\173""\nfd.assertion_flag=0;\n";
char*s33_220A="#-";
char*s104_873294598A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a function using the previous manifest STRING as target).";
char*s33_54688766A="se_atexit";
char*s647_4638080A="(T6)((!(";
char*s640_226A="!=";
char*s104_1922692108A="Replaced misspelled \"True\".";
char*s117_227A=" C";
char*s283_1302880443A="Error in the \"";
char*s342_1306325004A="Void_call_target";
char*s117_585944489A="Define C main function.\n";
char*s639_230A="&(";
char*s433_230A=",\n";
char*s642_236A="\')";
char*s623_237A=" M";
char*s117_240A="((";
char*s113_240A=".\n";
char*s111_241A="\'.";
char*s33_241A="()";
char*s554_242A="* ";
char*s640_36137368A="INT64_MIN";
char*s844_6395A=" R=(";
char*s621_244A=" T";
char*s117_245A=")(";
char*s727_246A="))";
char*s625_247A=" W";
char*s33_1682815431A="manifest_make";
char*s117_249A="),";
char*s117_251A="*)";
char*s104_251A=").";
char*s293_252A=", ";
char*s625_254A=",\"";
char*s647_255A="+(";
char*s589_255A=" _";
char*s111_542094038A="Expanded Target Procedure Call";
char*s619_257A=" a";
char*s117_257A="*/";
char*s117_258A=",&";
char*s625_259A=" c";
char*s642_259A=",\'";
char*s727_6411A="(-1)";
char*s111_262A=". ";
char*s34_10703002A="no_check";
char*s117_1312728230A="print_profile(profile_file, &runinit_profile);\n";
char*s640_263A="):";
char*s642_264A=");";
char*s647_265A="-(";
char*s647_1665734122A="strlen(se_argv[";
char*s640_184795A="(T0*)(";
char*s625_436987A="resexp";
char*s456_1428348580A="This type mark is not a TUPLE type mark.";
char*s293_43325A=": and";
char*s113_270A="--";
char*s415_190952A=" with ";
char*s435_271A=".)";
char*s117_272A="&R";
char*s647_6425A="))/(";
char*s640_1097836905A="/*$*/(void*)&";
char*s105_116346440A="Unknown special character.";
char*s117_1017947719A="manifest_initialize(";
char*s565_276A="..";
char*s117_277A=" u";
char*s117_277C="*C";
char*s117_277B="/*";
char*s825_277A="./";
char*s386_278A=".0";
char*s111_1255776138A="Overflow while computing \"";
char*s111_1131876546A="Starting collect";
char*s117_282A="0*";
char*s33_282A="//";
char*s117_284B="0,";
char*s117_284A="(T";
char*s543_287A="->";
char*s625_287A="&a";
char*s848_1854022405A=")))return;\nif(((char*)p)>((char*)(b+(c->count_minus_one))))return;\nif(((char*)p)<((char*)b))return;\nif(((((char*)p)-((char*)b))%sizeof(*p))==0)\173""\nif(p->header.flag==FSOH_UNMARKED)\173""\n";
char*s543_80251A="empty";
char*s653_293A="10";
char*s653_294A="11";
char*s495_594795843A=", each bunch must have exactly ";
char*s653_295A="12";
char*s647_296A=")[";
char*s33_296A="/=";
char*s113_297A=".C";
char*s642_244699380A="default:;\n";
char*s113_298A="-I";
char*s447_299A=".E";
char*s293_300A=":\n";
char*s113_301A="-L";
char*s904_302A=".H";
char*s117_6455A="));\n";
char*s495_305A=";\n";
char*s117_1754886761A="se_agent*);\n";
char*s33_430881A="notify";
char*s117_317A=",a";
char*s33_406284A="fourth";
char*s33_42134669A="Precursor";
char*s436_325449730A=" not correctly equiped for manifest generic creation (missing definition of feature `manifest_put\').";
char*s117_1238750212A="get_profiler_started(&master_profile);\n";
char*s104_1088075316A="Cannot use a formal generic argument as a valid parent.";
char*s289_90592250A="Cannot undefine ";
char*s283_322A=": ";
char*s729_35343969A="FSOC_SIZE";
char*s801_324A="-c";
char*s113_326A="-e";
char*s625_327A="*u";
char*s647_197159A=";\n*((T";
char*s113_327A=".a";
char*s367_327A="; ";
char*s32_329A=".c";
char*s589_1710309A="Tid id;";
char*s32_331A=".e";
char*s117_10739979A="mspalloc";
char*s625_815493762A="\n/*agent launcher*/";
char*s113_333A="-l";
char*s113_334A="/c";
char*s32_334A=".h";
char*s120_107193812A="It is useless to mark as \"redefine\" this deferred feature.";
char*s35_336A="-o";
char*s583_142931125A=" has no creation list. You must use the default creation method (named `default_create\' in class ANY, or just omit the method name).";
char*s113_340A="-s";
char*s113_341A=".o";
char*s554_342A="> ";
char*s640_345A="=(";
char*s33_1501191A="Current";
char*s489_348A="::";
char*s34_437070A="prefix";
char*s765_351A=":=";
char*s117_1243560324A="se_frame_descriptor fd=\173""\"<global-once-";
char*s122_1568216255A="internal_exception_handler(Void_call_target)";
char*s111_36611104A="You seem to have too classes named ";
char*s33_1578334651A="open_arguments";
char*s678_301503927A="Incompatible actual argument for agent call. Cannot pass `Void\' into formal argument of type ";
char*s538_360A="<<";
char*s386_360A="0x";
char*s33_361A="<=";
char*s420_1136256141A="Cannot use such a strange create expression for type ";
char*s488_2140868216A="Value expected";
char*s728_8033571A="]!=NULL)";
char*s642_366A="==";
char*s105_1700247488A="Unexpected character in hexadecimal ascii code.";
char*s33_371A=">=";
char*s538_372A=">>";
char*s625_376A="C)";
char*s467_1223342011A=" has an argument list.";
char*s409_376A="\?=";
char*s848_377A="=H";
char*s848_166455A="(*o);\n";
char*s117_379A="C,";
char*s506_2054176037A="class_text_name";
char*s33_548214405A="REAL_GENERAL";
char*s481_898426A=".......";
char*s113_1561265653A="No default configuration file for Liberty Eiffel was found.\nPlease just re-run the Liberty Eiffel installation program.\nOn Unix-like system, just \"cd\" to the Liberty Eiffel directory and\nthen, type \"make\".\nOn Windows-like system, re-run the \"install.exe\" of Liberty Eiffel.\nNote: if you prefer, you can still rely on the \"";
char*s117_175857472A="manifest_make(";
char*s117_382A="=M";
char*s104_1761000927A="Added \':\' before type mark.";
char*s582_6534A="*((T";
char*s624_197373672A="fprintf(file,\"";
char*s113_62728285A="The configuration file seems invalid. Correct the above errors first.";
char*s33_10377126A="is_empty";
char*s640_1639500234A="NULL/*_POINTER*/";
char*s117_396A="C=";
char*s125_397A="BC";
char*s729_6550A=") \173""\n";
char*s115_402A="CC";
char*s625_2054563574A="se_frame_descriptor fd=\173""\"create expression wrapper\",0,0,\"\",1\175"";\nse_dump_stack ds;\nds.fd=&fd;\nds.p=0;\nds.caller=caller;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s412_1442631340A=". (See explaination below.)";
char*s34_9909665A="creation";
char*s117_6559A="*/\nT";
char*s848_1748680500A="=n->header.next;\n\175""\nelse if(";
char*s104_1011636926A="Void cannot be used after unary \"-\" operator.";
char*s625_1484470448A="rc.top_of_ds=&ds;\n";
char*s729_411A="CL";
char*s625_1212159A="==a2->c";
char*s104_1733505988A="Unexpected \"reference\" keyword.";
char*s117_1601653158A="se_local_profile_t local_profile, *parent_profile;\n";
char*s647_419A="=r";
char*s367_892535123A="Same argument name appears twice in this formal argument list.";
char*s117_1957408550A="invariant of ";
char*s117_781060556A="Internal stacks size used: ";
char*s117_726728775A="=2;\175""\nelse\173""\n";
char*s436_1604599495A="Feature `manifest_semicolon_check\' must be a constant (INTEGER or BOOLEAN).";
char*s420_343527626A=" Actually, just replace this create expression with ";
char*s105_74239A="]foo\"";
char*s729_6580A="*);\n";
char*s393_1808265259A="This is not an CHARACTER expression.";
char*s619_86545A="open_";
char*s447_205111678A="\" in cluster \"";
char*s105_696478167A="Bad (empty\?) ascii code.";
char*s648_82239308A="se_thread_lock_notify((";
char*s467_1604408825A="Must not use such a non-static type mark for a constant-attribute definition.";
char*s286_38905513A="This is not a constant feature.";
char*s660_1447552176A=" the conforming parent(s) for ";
char*s33_1603529235A="to_natural_8";
char*s101_313227818A="Collecting thread root call for type ";
char*s848_526175446A="*)(&(c->first_object)));\nif((c->header.state_type==FSO_STORE_CHUNK)&&(((char*)p)>=((char*)store";
char*s33_80416A="first";
char*s117_1793244543A="fclose(profile_file);\175""\n";
char*s648_1395477828A="/*se_fault*/\173""int*i=0;*i=0;\175""\n";
char*s844_733445699A="void bdw_finalizeT";
char*s33_878996813A="TYPED_INTERNALS";
char*s111_408537579A=". The number of dots\ngives the number of \"when\" clauses:\n";
char*s117_10666295A="\175""/*--*/\n";
char*s117_339308075A="/*The generic se_agent0 definition:*/\nstruct _se_agent0\173""\nTid id;\nTid creation_mold_id;\nvoid(*afp)(";
char*s415_1297676933A=" would give ";
char*s848_6614A="((gc";
char*s342_1489034545A="Routine_failure";
char*s904_1935504882A="Strange dependency: location <";
char*s117_471A="R=";
char*s653_471A="T3";
char*s678_1084920002A="Bad number of actual arguments for agent call. (The agent you are trying to call has ";
char*s653_474A="T6";
char*s437_1240817101A="Bad comment to end a class.";
char*s653_476A="T8";
char*s113_1192507148A="Unknown os \"";
char*s33_1639475718A="UNICODE_STRING";
char*s648_529853775A=");\n\175""\nelse\173""\n";
char*s675_1937147216A="Cannot assign newly created ";
char*s111_1459577427A="Void target Function Call";
char*s447_397816412A="   include ";
char*s113_1721407046A="Math=IEEE Parameters=Both Code=Far";
char*s489_1577658176A="... unique local buffer ...";
char*s625_283801480A="void*afp;\n";
char*s660_1655357614A="Keyword \"require\" replaced with \"require else\" because there is an inherited require assertion.";
char*s104_1363289683A="\' expected to end arguments list.";
char*s117_548663546A=");\nreturn ((T0*)C);\n";
char*s811_498A="X:";
char*s352_1155816456A=" for extra arguments.";
char*s34_2073386A="inspect";
char*s104_2117894368A="Void is not a valid BOOLEAN expression (just after keyword \"until\" of a loop).";
char*s582_6655A=")->_";
char*s352_1753601396A="Synthetizing ";
char*s30_613587359A="Flag or argument \"";
char*s640_506A="])";
char*s582_215791A="(void)";
char*s642_1181502A="==0 \174""\174"" ";
char*s844_1544707291A="void*bdw_na_assignT";
char*s104_1524784203A="Exponent part of a real value expected.";
char*s904_1942892277A="Including header ";
char*s117_365905049A="init_profile(&root_profile, \"<root>\");\n";
char*s728_1970645590A="#define BDW_GC 1\n#define GC_I_HIDE_POINTERS 1\n#include <gc/gc.h>\n#define malloc(s) GC_MALLOC(s)\n#define calloc(n,s) GC_MALLOC_IGNORE_OFF_PAGE((s)*(n))\n#define realloc(p,s) GC_REALLOC((p),(s))\n#define free(p) p=NULL\n";
char*s484_334725631A="Error in variant part of loop definition.";
char*s805_1000694404A="].\nOriginal definition ";
char*s728_722650754A="se_malloc(sizeof(void*))";
char*s727_6671A="*/))";
char*s349_25373399A="Incompatible signatures. (One has a result type and not the other.)";
char*s117_526A="]=";
char*s728_1477636806A="#ifndef GC_DEBUG\n#define GC_DEBUG \"";
char*s642_1084495643A="\175""\175""/*manifest INSPECT]*/\n";
char*s415_889865702A=" which is out of INTEGER_8 range.)";
char*s33_534A="a1";
char*s647_535A="a2";
char*s113_6687A=" To ";
char*s510_2057854492A=" is 9223372036854775808 which is out of INTEGER_64 range.";
char*s117_932172292A="]=root_profile;\n";
char*s104_955638361A="Bad use of predefined type ARRAY.";
char*s33_548A="[]";
char*s104_9897510A="built_in";
char*s34_10315778A="indexing";
char*s126_605800239A="\175"" variable used";
char*s33_552A="\\\\";
char*s117_12855A="TLS(";
char*s488_1490203324A="Unexpected keys found\n";
char*s637_6706A="*/0)";
char*s104_2030568676A=" is not writable (reached through closure). Cannot use ";
char*s117_1901889757A="/*\nANSI C code generated by ";
char*s124_557A="_R";
char*s848_25822456A=";\ngc_free";
char*s709_559A="_T";
char*s104_1471861047A="Syntax error inside \"local\" variable list definition. Encountered keyword \"";
char*s642_550508910A="assertion_depth=1;\nfree_exception_frames();\n";
char*s34_1532343833A="cpp_compiler_path";
char*s805_68224A="The \'";
char*s381_1744510279A=" Cannot assign ";
char*s293_22396357A=" columns ";
char*s640_570A="\\n";
char*s127_570A="__";
char*s642_1832703325A="/*UNUSED_EXPRESSION:*/(void)(";
char*s34_54418471A="reference";
char*s104_1228072329A="Such a constant cannot be used in \"when\" part of an inspect statement.";
char*s117_1988895671A="start_profile(parent_profile, &local_profile);\n";
char*s117_273430980A="return C;\n";
char*s589_166654A="* o1,T";
char*s283_1476966395A="More than one class in the system is named ";
char*s117_1290234339A="int se_argc";
char*s104_1961160815A="The \"separate\" keyword is still a reserved keyword in case of a new implementation attempt...";
char*s412_1037594318A=" (Error occurs while checking the code in ";
char*s104_751585121A="Error while reading hexadecimal number.";
char*s34_2233396A="runtime";
char*s727_273418685A="se_calloc(";
char*s30_1724187394A=": missing output name after -o flag.\n";
char*s34_48390502A="all_check";
char*s108_589A="bc";
char*s653_591A="_t";
char*s113_2077353217A="\" (alternate mode) selected.\n";
char*s283_2132072515A="\" ACE file.\n";
char*s35_594A="cc";
char*s848_596A="o)";
char*s33_9713026A="as_32_ne";
char*s33_36193081A="INTEGER_8";
char*s530_2080244194A="Division by zero.";
char*s34_600A="as";
char*s105_1317175740A="Too long hexadecimal sequence for a single unicode value.";
char*s113_1398953286A="Too many root classes";
char*s111_1463938603A="Polymorphic Proceduire Call";
char*s115_603A="cl";
char*s848_604A="o1";
char*s848_6755A="++;\n";
char*s104_1207921682A="Manifest real value not compatible with this type.";
char*s111_801894175A="Unknown prefix operator \"";
char*s104_437331A="result";
char*s420_1260488135A=" and you are done.";
char*s104_611A="do";
char*s33_548331507A="NATIVE_ARRAY_INTERNALS";
char*s113_614A="gc";
char*s729_185146A="(T0*o)";
char*s117_1419097826A="),c,(int16_t*)s,sc,lsv,lsi);return (T0*)";
char*s111_427937988A="Total Number of Merged \"when\" clauses (cumulated): ";
char*s113_179868158A="Unknown system name in file\n\"";
char*s647_475042348A="internal_exception_number";
char*s447_620A="es";
char*s625_68284A="a1->c";
char*s642_6775A="))\173""\n";
char*s625_5395051A="(void**)";
char*s117_625A="\173""\n";
char*s506_625A="id";
char*s117_5395053A="(void*)0";
char*s34_627A="if";
char*s642_693716559A="error1(\"Invalid ::= assignment (inserted type).\",";
char*s126_354654986A="Environment variable $\173""";
char*s33_51915068A="is_normal";
char*s120_1661847054A="\" come from the same original feature via multiple \"inherit\" paths.\nBelow, you get the feature evolution step by step. Note that in the end (type ";
char*s105_85511833A="Right hand side expression of ::= assignment expected here.";
char*s640_1367878466A="se_manifest";
char*s117_811016135A=">\",0,0,\"\",1\175"";\n";
char*s117_635A="\175""\n";
char*s33_636A="io";
char*s100_1861287086A="not_computed";
char*s490_449661A="struct";
char*s34_640A="is";
char*s642_2251910A="switch(";
char*s637_5395074A="(void)0;";
char*s111_1174466439A="during inlining of dynamic dispatch";
char*s117_651A="p[";
char*s34_1690381566A="invariant_check";
char*s728_12955A="]);\n";
char*s729_19622345A="(&(u->CA_";
char*s33_1744399653A="type_attribute_generating_type";
char*s647_6810A="))\174""(";
char*s108_660A="ms";
char*s283_661A="no";
char*s110_97543221A="Recompute RUN_TIME_SETs..";
char*s637_4570857A="/*:RF1*/";
char*s642_1175100011A=" /* has_empty */ if (";
char*s33_669A="or";
char*s647_670A="\176""(";
char*s34_670A="os";
char*s111_671A="\175"".";
char*s30_525197655A="\" specified for the -is_output_error_warning_on flag.\n";
char*s414_925886099A=" (this is not BOOLEAN).";
char*s647_351281A="a1ptr=";
char*s115_674A="sc";
char*s104_1135641353A=" is not writable.";
char*s113_676A="se";
char*s104_1284231066A="Character \'%\"\' inserted after \"alias\".";
char*s660_378711602A="Keyword \"ensure then\" replaced with \"ensure\" (There is no inherited ensure assertion here).";
char*s113_1087245292A="#: config file corrupted!";
char*s91_685A="ti";
char*s113_686A="rt";
char*s113_689A="vc";
char*s117_1713607783A="if (expression != NULL) error2(expression,/*unknown-position*/0);\n";
char*s625_6845A="&CA_";
char*s729_1824264277A="void once_function_mark(void)";
char*s582_905827712A="manifest_string_mark";
char*s846_699A="\173""T";
char*s622_619166512A=";\n#define M";
char*s625_228498053A="se_dump_stack ds=\173""NULL,NULL,0,NULL,NULL,NULL\175"";\nds.caller=se_dst;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s289_875060418A="You cannot inherit \"";
char*s647_1375807179A="Unknown WEAK_REFERENCE built-in: ";
char*s33_1115958189A="open_argument_indices";
char*s33_1206543966A="object_attribute";
char*s637_4570907A="/*:RF3*/";
char*s29_1325879523A=": missing loadpath file path after -loadpath flag.\n";
char*s104_316863332A="No parent after \"inherit\" keyword (an empty list is not allowed here).";
char*s660_1197649626A="Precursor call is allowed only when the enclosing routine is redefined.";
char*s552_1899804731A="adapting features";
char*s625_10937200A="return (";
char*s117_6877A=");/*";
char*s115_13028A="UNIX";
char*s117_1403825006A="T0*_tuple_args=(void*)0;\n";
char*s33_80694A="floor";
char*s589_1290234494A="int se_cmpT";
char*s502_1767084619A="Please consider writing an explicit open argument list for your agent creation.";
char*s106_1385667261A=".\nIts retained value will be the last read.\n";
char*s33_849712179A="print_run_time_stack";
char*s637_4570932A="/*:RF4*/";
char*s292_740A="\173""\175""";
char*s554_1114764925A="\\LIBERTY.CFG";
char*s642_744A="\174""\174""";
char*s115_1772235A="Windows";
char*s625_750A="\175""\175""";
char*s642_1261705A="=NULL;\n";
char*s711_1601130656A="Duplicate directory";
char*s111_1460051321A="Unsafe covariant redefinition of argument number ";
char*s283_527202963A="The \"debug\" assertion level is deprecated. Please use \"all\" and debug statements.";
char*s117_1195084695A="ds.fd=&root;\nds.current=((void*)(&";
char*s577_2007779419A="/*reusing tmp";
char*s415_613384625A="Overflow of infix \"+\" with INTEGER_32 operands. (Adding ";
char*s104_1928025553A="After expression (";
char*s113_643573734A="If Liberty Eiffel is correctly installed, you should find\nmore information in the file \"";
char*s495_589832448A="Must not use the \";\" (semicolon) separator for manifest ";
char*s729_40031469A="RSOC_SIZE";
char*s848_10937240A="return((";
char*s113_1255020047A="Adding external library flag: ";
char*s637_4570957A="/*:RF5*/";
char*s506_1091323489A="is_user_expanded";
char*s648_68406039A="\n#if BYTE_ORDER == BIG_ENDIAN\n";
char*s552_1280946519A="collecting features";
char*s848_5161461A="(fsoc*c)";
char*s642_644847010A=";\nbreak;\n\175""\n";
char*s33_567319806A="to_integer_16";
char*s642_1124563501A="))\173""switch(((T0*)";
char*s118_6926A=",...";
char*s115_51699930A="lcc-win32";
char*s409_7867907A="Invalid ";
char*s33_1597390874A="Character_bits";
char*s33_567319812A="to_integer_32";
char*s117_7720290A="Function";
char*s648_1034063848A="se_thread_lock_wait((";
char*s637_4570982A="/*:RF6*/";
char*s122_899910547A="se_print_run_time_stack(),exit(1)";
char*s848_2092663259A="goto begin;\n";
char*s647_6946A=",0))";
char*s117_1994813154A="];\nse_profile_t sorted_all_profile[";
char*s33_567319829A="to_integer_64";
char*s117_220957020A="/*  - local vars*/\n";
char*s647_1738839292A="se_thread_lock_is_locked((";
char*s436_282823780A="Invalid creation procedure. A \"once\" procedure is not allowed as a creation procedure.";
char*s647_1824713404A="deep_memcmp(";
char*s33_9676326A="capacity";
char*s625_80771A="u->R=";
char*s283_1091711046A="\" (and there may be more). Search started from ";
char*s647_6965A=")<<(";
char*s637_4571007A="/*:RF7*/";
char*s650_8046326A="TLS(T0*)";
char*s621_1710532409A="/*BUG:NA@runtime!*/";
char*s33_1671553525A="WEAK_REFERENCE";
char*s117_1981256377A="Assignment test (\"\?:=\") function";
char*s113_10937305A="return;\n";
char*s625_173055A="*)u2;\n";
char*s490_55156846A="signature";
char*s552_958892525A="Total time spent ";
char*s104_52979396A="loop body";
char*s517_1083118122A="Type mark \"like <argument>\" must not reference another \"like <argument>\" type mark. (One level of indirection is always possible and always better ;-)";
char*s642_400650A="else\173""\n";
char*s642_86950A="rawci";
char*s34_400652A="elseif";
char*s647_427390771A=")==FP_SUBNORMAL";
char*s283_1707020207A="The \"use\" clause is not yet implemented.";
char*s637_4571032A="/*:RF8*/";
char*s625_345908476A="ds.caller=caller;\nds.exception_origin=NULL;\nds.locals=NULL;\nset_dump_stack_top(&ds);/*link*/\n";
char*s647_6995A=")==(";
char*s97_142319A="\" in \"";
char*s34_11251026A="undefine";
char*s436_170383550A="Manifest generic creation not yet implemented for expanded types (";
char*s113_373286592A="\".\nCurrently handled system names:\n";
char*s104_1275558331A="A routine must be ended with \"end\".";
char*s117_1860992059A="/*  - NO ensure*/\n";
char*s637_4571057A="/*:RF9*/";
char*s104_888875725A="Missing \";\" added.";
char*s848_1648235130A="->header.state_type=FSO_USED_CHUNK;\nn=";
char*s283_902457136A="Root procedure #";
char*s33_1498845794A="NATIVE_ARRAY[CHARACTER]";
char*s488_1331532446A="module_name";
char*s412_1769582063A=" Expression ";
char*s647_7025A=")>>(";
char*s844_719514099A="bdw_na_assignT";
char*s848_1288623074A=")(r+1));\n\175""\nreturn((T";
char*s505_672729595A="Invalid generic constraint cycle.";
char*s850_730579755A="=(void*)0;\n";
char*s283_1130154866A="Bad Environment variable.\n(Closing \"\175""\" not found.)";
char*s415_923532A=" minus ";
char*s904_7037A=" at ";
char*s111_1814748872A="\" from ACE file. (Parsing \"";
char*s349_345225764A="Different arguments types.";
char*s642_1291760099A=";\nbreak;\n\175""\nbreak;\n";
char*s33_80854A="flush";
char*s33_13194A="TYPE";
char*s286_1820580025A="Probably infinite or too long generic derivation of this type mark (see next warnings to find the cause of the problem... and good luck).";
char*s647_1689502217A="Bad prototype for C struture get external.";
char*s637_185428A="/*RF1:";
char*s640_686612424A="(/*OUTCL:LOCAL*/*";
char*s34_10193105A="expanded";
char*s32_831708366A="Feature `copy\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s33_10377643A="is_equal";
char*s637_185438A="/*RF3:";
char*s113_703496930A="\"[General] sys\" key is missing.";
char*s850_1295032451A=".store_chunk=NULL;\n";
char*s637_185443A="/*RF4:";
char*s678_501491947A=" is expanded. (The whole type of the agent your are trying to launch is ";
char*s637_185448A="/*RF5:";
char*s111_1786429697A=" cannot be a root class since it is a generic class.";
char*s637_185453A="/*RF6:";
char*s415_1552156565A=" which is out of range 0..15 because target type is INTEGER_16.";
char*s34_1975394A="cluster";
char*s33_1594034A="ROUTINE";
char*s104_75996531A="Discarded empty convert clause";
char*s33_2246041A="storage";
char*s637_185458A="/*RF7:";
char*s848_1012357115A="(unsigned int size)";
char*s117_1065055A="*s=M7;\n";
char*s111_1497652563A="\': anonymous feature not found";
char*s728_323156020A="int bdw_delayed_finalize";
char*s637_185463A="/*RF8:";
char*s282_51017327A="Bad external signature (missing \")\" delimiter.";
char*s117_934A="\"\n\"";
char*s111_24235874A="2011-2016";
char*s383_1809213019A="ref-status: ";
char*s467_1284372793A="A function cannot be an assigner.";
char*s482_1204053035A="c_inline_c(";
char*s34_1839765037A="Cyclic anchored definition.";
char*s637_185468A="/*RF9:";
char*s113_830570470A="-cc specified more than once; last is used.\n";
char*s589_481249030A=") != (o2->_";
char*s763_495673125A=") is not smaller than upper bound (";
char*s120_1752297822A="A frozen feature must not be undefined. What is frozen _is_ frozen.";
char*s117_1642367158A=", sizeof(se_profile_t), profile_comparator);\n";
char*s117_273431355A="return R;\n";
char*s283_708319A="\" and \"";
char*s126_7106A=" day";
char*s728_15009395A="\"\n#endif\n";
char*s848_915251302A=";\nif((o!=NULL)";
char*s111_902457224A="Root procedure \173""";
char*s439_171706123A=" which is the generic constraint.";
char*s113_50863580A="exit(0);\n";
char*s729_2046881533A="se_thread_lock_unlock(gc_lock);\n";
char*s482_1204053060A="c_inline_h(";
char*s554_1747846A="\\SE.CFG";
char*s642_7118A="-1)\?";
char*s33_1607595572A="to_character";
char*s660_557767498A=" in order to use it as a unique parent qualifier.";
char*s34_1992063831A="ensure_check";
char*s516_1962243783A="Bad anchor. Unknown feature name.";
char*s729_207160501A="#ifndef FIXED_STACK_BOTTOM\nint valid_stack_bottom = stack_bottom != NULL;\n#endif\n";
char*s650_124454155A=";\n*exp=1;\n";
char*s495_1496963692A="Wrong usage of \";\" (semicolon) separator in manifest notation. Each bunch-size must be a multiple of ";
char*s642_54714119A="sedb(&ds,";
char*s647_87090A="pow((";
char*s117_1586448448A="uint16_t lsv";
char*s848_77282146A=".space_used+=size;\n";
char*s647_185515A="(T6)((";
char*s456_540477054A=", this type mark is not a TUPLE. (This is actually ";
char*s86_1761241425A="Adding Cecil file: ";
char*s121_992A="   ";
char*s117_1500500537A=" live TYPEs:\n";
char*s506_259431724A="is_generic";
char*s104_1587734026A="Void cannot be the left-hand side of the binary \"\\\\\" operator.";
char*s844_903312259A="return wr->o;\n";
char*s844_167080A="*/));\n";
char*s848_160930A="))-1)\175""";
char*s104_1703575813A="Bad character constant. Closing \"\'\" expected.";
char*s589_948263A="/*init:";
char*s650_160937A="(*C)->";
char*s283_89867121A="\" section.";
char*s415_205616643A="Overflow of infix \"-\" with INTEGER_32 operands. (";
char*s117_514187710A="#ifdef __cplusplus\nextern \"C\" \173""\n#endif\n";
char*s460_1615634978A="Unable to find the default creation procedure for expanded type ";
char*s104_2080029331A="Slash \"/\" character expected after decimal value in CHARACTER constant.";
char*s104_266191698A="The keyword \'creation\' is now replaced by \'create\'. Please update your code.";
char*s113_851047233A="\nThe type of your operating system was automatically  computed. Please verify.\n";
char*s117_1346694814A="if (sedb_status != SEDB_EXIT_MODE) ";
char*s111_1365578385A="Starting simplify";
char*s104_1090616383A="Unable to find a class definition in \"";
char*s117_308580A="NULL;\n";
char*s689_247541875A="copy index";
char*s467_1436450217A="A string constant cannot be an assigner.";
char*s111_713806135A=" (For this call, the target ";
char*s358_646901709A="Call on a Void target.";
char*s104_1581435442A="Bad external clause (manifest string expected).";
char*s480_743946038A=" is expanded. The generic argument of WEAK_REFERENCE must not be expanded. (It does not makes sense to do so.)";
char*s848_1413869902A="gc_update_weak_ref_item_polymorph((Tgc*)&(o1->object));\n";
char*s706_1043A=" (+";
char*s411_736853937A="Actually, `Void\' has no accurate type. Keep in mind that `Void\' is just a way to denote the default value for a type or to denote the lack of an object. One can use `Void\' as the right-hand-side of an assignment or to replace some actual argument. (See \"http://wiki.liberty-eiffel.org/index.php/Void\" for details.) At time being, the type ANY will be used for this occurrence `Void\'. Please update your code with a more accurate expression, may be by adding an extra non-initialized local variable.";
char*s467_69279758A="A unique constant cannot be an assigner.";
char*s113_17494489A="compile_to_c: \"";
char*s707_1047A=" + ";
char*s647_397220332A="memcpy(&R,C,sizeof(R";
char*s293_7207A=" in ";
char*s34_10876026A="redefine";
char*s117_437780A="se_msi";
char*s848_1473891377A="\173""\173""FSOC_SIZE,FSO_STORE_CHUNK,\n(void(*)(mch*,void*))";
char*s104_1380562254A="Boolean expression expected (until).";
char*s660_1092806174A=" The final export list is ";
char*s423_1719402393A=".............................................";
char*s110_23085765A=".(done).\n";
char*s729_1102979933A="gc_is_off=0;\n";
char*s848_1927410765A="=old_gc_free;\nc->next=fsocfl;\nfsocfl=c;\nc->header.state_type=FSO_FREE_CHUNK;\n\175""\n\175""\n";
char*s848_1574324912A="dead=0;\175""\nelse\173""\n";
char*s35_87180A="relax";
char*s97_439490016A="\" does not belong to a creation clause of ";
char*s111_385188989A="Before collect cycle";
char*s104_1934613587A="Simple identifier expected just after a dot. Nothing else but a simple feature name is meaningful just after a dot.";
char*s117_965818786A="No support found in directory sys/runtime for \"";
char*s640_7220A=")CA_";
char*s493_68732A="This ";
char*s117_1905187208A="se_prinT[0]=((void(*)(FILE*,void*))se_prinT0);\n";
char*s117_4620481A="(T0*)(g[";
char*s498_7232A=" is ";
char*s642_7235A=");\175""\n";
char*s467_1305581590A="An attribute cannot be an assigner.";
char*s415_156630152A=" which is out of INTEGER_64 range.)";
char*s30_1090A="\".\n";
char*s729_1102979958A="gc_is_off=1;\n";
char*s554_1027113524A="USERPROFILE";
char*s642_1348915394A="DynamicDispatch";
char*s117_1901755A="ac_req(";
char*s640_580292587A="/*SFN*/(C->";
char*s366_1839715989A="The feature called has no formal argument while the actual argument list has ";
char*s476_99702656A=" Feature `";
char*s621_302501127A="typedef union _se_agent se_agent;\ntypedef struct _se_agent0 se_agent0;\n";
char*s467_1630520481A="The type of this constant feature should be REAL.";
char*s117_197932A=";\n*C=M";
char*s825_1101A="\").";
char*s648_1034107223A="se_thread_lock_free((";
char*s479_1554555636A="Cannot change exportation status of ";
char*s104_879341913A="No more \"reference\" keyword allowed. The obsolete \"reference FOO\" notation is no longer accepted. Just use the REFERENCE class instead.";
char*s415_1277330071A="Violated assertion (target value is ";
char*s117_893005A="\"\\n\"),\n";
char*s848_2136427942A="............ unique local buffer ...................";
char*s495_1034900711A="Cannot pass Void into formal argument which is of type ";
char*s447_1112A="\". ";
char*s104_1617443474A="No sign allowed before an hexadecimal constant value.";
char*s117_588411932A="void se_atexit(void)";
char*s467_1051699101A="A constant cannot be an assigner.";
char*s538_1330923746A="\175"". See the next error message.";
char*s97_1121A="\".)";
char*s377_327012886A=" but there is _no_ when clause selected. (Also note that there is no else part for this inspect statment, hence this error message.)";
char*s104_1717397235A="Corresponding closing \')\' expected here.";
char*s104_1003875089A="No more \"expanded\" keyword allowed here. The obsolete \"expanded FOO\" notation is no longer accepted.";
char*s35_2141685A="no_main";
char*s640_1446625A="INT8_C(";
char*s358_1759986771A="This feature is only exported to ";
char*s117_4620546A="(T0*)(t[";
char*s117_1055242101A="/*[INIT CLOSURE LOCALS*/\n";
char*s848_7296A=" na=";
char*s551_927498134A="run-time-set-count: ";
char*s729_10322525A="\175""\nelse\173""\n";
char*s425_1099750743A="Feature found is not writable (i.e. not an attribute).";
char*s291_1133285999A="Cannot find the default class ";
char*s844_1524126691A=" bdw_mallocT";
char*s112_1645670452A="2016.05 (Alexander Graham Bell)";
char*s33_1157A="#//";
char*s341_1981041429A="CODE_ACCUMULATOR code_stack";
char*s117_273443870A="se_atexit(";
char*s619_7317A=" of ";
char*s117_1350760769A="assertion_depth++;\n\175""\n";
char*s111_1535001676A="Details regarding Monomorphic calls:\n";
char*s729_419443A="na_env";
char*s484_1867518592A="Expression of the loop variant must be of INTEGER type. (The actual ";
char*s113_1964046235A="\"[General] short\" key is missing.";
char*s117_1142598643A="local_profile.profile=inv_profile+";
char*s415_905382A=" gives ";
char*s844_1858599648A="void*bdw_weakref_new(int n)";
char*s283_305465997A="Quoted identifiers are deprecated. Please remove quotes here.";
char*s33_1944903A="ceiling";
char*s695_235492225A="Attributes cannot have a rescue compound.";
char*s33_55040341A="put_16_be";
char*s117_1196A=" C=";
char*s554_28418819A="/etc/serc";
char*s34_10648581A="obsolete";
char*s394_1552710436A="Internal error inside WHEN_ITEM_1 (compiler error).";
char*s104_1819737650A="Must use exactly 4 hexadecimal digits for INTEGER_16.";
char*s111_1206593669A="Monomorphic Procedure/Function Call";
char*s17_1210A=".\n\n";
char*s35_2246326A="verbose";
char*s113_1215A="\'.\n";
char*s283_767646015A="\" while the second is in the cluster \"";
char*s286_1641573945A="The following path was misdetected as an inheritance cycle";
char*s117_1319581398A="se_dump_stack ds=\173""NULL,NULL,0,NULL,NULL,NULL,0\175"";\nds.caller=se_dst;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s33_9529116A="add_last";
char*s640_11300605A="unsigned";
char*s647_52075585A=" cannot be converted to a memory address.)";
char*s126_1430004152A=" used in file \'";
char*s506_1297302480A="is_expanded";
char*s647_1671074150A="((uint32_t)(";
char*s415_1324951230A="Overflow of infix \"+\" with INTEGER_64 operands. (Adding ";
char*s32_1897129554A="Feature `is_equal\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s293_188916891A=" . The validation context is used to compute all anchored type marks.)";
char*s104_155929078A="Incorrect TUPLE (type expected).";
char*s111_646243744A="Symplify interrupted (infinite inlining ... or infinite recursion detected.).";
char*s640_1232A="\'*/";
char*s33_276937706A="slice_copy";
char*s844_1180476551A=",NULL,NULL,NULL);\n";
char*s33_1235A="#<<";
char*s640_1240A="(((";
char*s848_407207A="fsoc H";
char*s436_1700082283A="Invalid creation procedure. A function is not allowed as a creation procedure.";
char*s647_520388145A="((int64_t)(";
char*s33_55040391A="put_16_le";
char*s729_1246A="())";
char*s647_704592146A="Invalid usage of feature `to_pointer\' of class ANY. (The target which is of type ";
char*s33_1247A="#>>";
char*s647_837784A=");\n*((T";
char*s625_7400A="*CL_";
char*s479_1377394679A=" does not have feature ";
char*s104_445001496A="This is not a feature name, but a class name.";
char*s393_1088174660A="(The corresponding feature definition is in the next error message.)";
char*s729_52555395A="->header.flag)==FSOH_UNMARKED)\173""\n";
char*s30_513843490A=") is used.\n";
char*s33_55040401A="put_16_ne";
char*s117_499425548A="NULL/*Unused Target*/";
char*s293_4479182A=" column ";
char*s625_1485929081A="int (*eq)(se_agent*,se_agent*);\n";
char*s728_1208340604A="bdw_mallocT";
char*s33_2067995A="implies";
char*s647_870841390A="<<16)\174""((uint32_t)";
char*s117_1919660703A="];\nse_profile_t sorted_agent_switch_profile[";
char*s111_1265A=").\n";
char*s117_1271A=")))";
char*s625_1271A=" R=";
char*s97_74133124A="\" is not a creation procedure of this class).";
char*s849_1274A=")),";
char*s117_148900A="!=0)\173""\n";
char*s577_38182A="/*tmp";
char*s625_182255408A="Deferred \173""";
char*s648_1431664982A=">>24)&0xFF));\n#else\n";
char*s648_1280A=")+(";
char*s727_1281A="(0)";
char*s117_1284A="((T";
char*s640_1285A="),(";
char*s728_1286A="(1)";
char*s648_1291A="))=";
char*s675_1083579905A=" while building type ";
char*s117_81256A="evobt";
char*s117_1295B="*)(";
char*s117_1295A="*/\n";
char*s642_25900A=" && (";
char*s640_1298A=", &";
char*s447_1642232185A="Cannot find include \"";
char*s467_1952642401A="The type of this constant feature should be BOOLEAN.";
char*s729_666720494A="mark_stack_and_registers();\ngc_sweep();\n";
char*s637_1302A=")/*";
char*s642_685204250A=": switch(*(";
char*s638_7454A="\'\\0\'";
char*s637_1312A=")->";
char*s729_14757563A="\011""struct:\173""";
char*s33_259659630A="is_started";
char*s340_855586967A="Cannot use agents type marks or TUPLE type marks inside cecil files (Liberty Eiffel limitation, sorry). To work around, just use an extra Eiffel routine/object to perform agent or TUPLE manipulation in pure Eiffel.";
char*s34_1988096A="feature";
char*s625_7475A=" se_";
char*s33_747962924A="type_item_is_expanded";
char*s117_32080A=")));\n";
char*s552_902076231A="Type-system safety check not performed in this mode\n(use the -safety_check flag).\n";
char*s117_1326A="*/)";
char*s378_1686701A="Result.";
char*s34_945182441A="Environment";
char*s117_1330A=");\n";
char*s848_26635163A=")new_na(&";
char*s33_1245671098A="set_object_attribute";
char*s113_1335A=",-\n";
char*s418_13637A="The ";
char*s844_1542419950A="if(bdw_na_assign_innerT";
char*s104_2097430832A="Underscore notation _ not supported inside fractional part.";
char*s105_140920753A="You must use an even number of hexadecimal digits to denote a sequence of CHARACTERs.";
char*s625_37202594A="Feature \"";
char*s495_412142950A="Only static type can be used for this form of creation.";
char*s436_1304837581A="First argument of `manifest_put\' must be an INTEGER.";
char*s34_87466A="retry";
char*s117_411134193A="........ local buffer ........";
char*s289_413151726A=" because type ";
char*s286_1136866084A="\n      inserted as ";
char*s650_1068122514A="void* se_introspecT";
char*s729_2077255577A="fprintf(SE_GCINFO,\"C-stack=%d \",gc_stack_size());\nfprintf(SE_GCINFO,\"main-table=%d/%d \",gcmt_used,gcmt_max);\nfprintf(SE_GCINFO,\"fsoc:%d(\",fsoc_count);\nfprintf(SE_GCINFO,\"free=%d \",fsocfl_count());\nfprintf(SE_GCINFO,\"ceil=%d) \",fsoc_count_ceil);\nfprintf(SE_GCINFO,\"rsoc:%d(\",rsoc_count);\nfprintf(SE_GCINFO,\"ceil=%d)\\n\",rsoc_count_ceil);\nfprintf(SE_GCINFO,\"GC called %d time(s)\\n\",collector_counter);\nfprintf(SE_GCINFO,\"--------------------\\n\");\n";
char*s647_116864219A="local buffer...";
char*s436_1081673178A="First argument of `manifest_make\' must be an INTEGER.";
char*s640_1380A=")\?(";
char*s497_869266852A="Cannot rename feature `c_inline_c\' because this name is used as a keyword to handle the corresponding \"built_in\" feature of ANY.";
char*s349_590983311A="While checking this call in ";
char*s121_1382A="-- ";
char*s104_2001512180A="Expected expression after the \"then\" keyword.";
char*s381_762122588A=" Error detected while checking this code in the ";
char*s283_139303084A="c_compiler_options";
char*s625_2028521226A="se_dump_stack ds;\n";
char*s291_362867332A="). Cannot go on: please try removing your .id file or calling \"se clean\". If that fails, please send an e-mail at liberty-eiffel@gnu.org";
char*s105_996106634A="Invalid unicode notation (see also http://www.unicode.org as well as feature \173""UNICODE_STRING\175"".valid_unicode).";
char*s104_1910692676A="Routine body expected.";
char*s104_1466196812A="Error while reading real number.";
char*s844_1043020315A=";\nreturn R;\n";
char*s117_1618833880A="fd.assertion_flag=1;\n\175""\n";
char*s660_1846931416A=" is not a valid ancestor for this method.";
char*s283_86060043A="Just finished parsing of \"";
char*s904_1807195960A=" does not provide any .h or .c file, nor a cecil.se file!";
char*s577_7557A=" tmp";
char*s416_1127350535A="Void must not be the right-hand side of an assignment test (always True).";
char*s292_87520A="\173""ANY\175""";
char*s582_1407A=")=M";
char*s729_1994331A="gc_free";
char*s728_1582973561A="bdw_weakref_setlink((bdw_Twr*)(";
char*s415_1705796732A="Overflow of infix \"*\" with INTEGER_8 operands. (";
char*s846_1414A=" gc";
char*s105_181806522A="Unexpected new line in manifest string.";
char*s117_1417A="/* ";
char*s642_32175A=")) \173""\n";
char*s660_39109479A=" is different from the one explicitly listed here.";
char*s104_342864313A="An anchored type cannot be used to indicate exportation status in a client list.";
char*s420_1732344459A=" and the default creation procedure (see `default_create\' in class ANY) is not allowed. You must use one of the available creation procedure here.";
char*s104_2110077371A="Must use exactly 8 hexadecimal digits for INTEGER_32.";
char*s370_462870327A="BUG: trying to synthetize empty tuple for a function without arguments but with arguments... WTF";
char*s33_87541A="print";
char*s33_1427A="#\\\\";
char*s126_210310269A="Removing \"";
char*s124_489233515A="agent_launcher";
char*s111_1459510708A=" is of type ";
char*s844_1114679499A=" bdw_malloc_innerT";
char*s729_1028650A="(u->CL_";
char*s420_1382321814A="Cannot assign newly created object of type ";
char*s648_29107967A="*((int32_t*)(";
char*s117_1540494783A="]=((void(*)(FILE*,void*))se_prinT";
char*s113_1438A=".00";
char*s642_1241777620A="if (NULL==(";
char*s117_2087300232A="void*(*se_introspecT[";
char*s647_1124779458A="if(R)R=((C->_";
char*s30_941571923A="output_error_warning_on";
char*s707_1452A=" \174"" ";
char*s363_1440516445A="Invalid type for the target of this function call.";
char*s127_150325744A="can_assign_to";
char*s516_90494969A=" is a procedure. Anchored type is not valid.";
char*s728_308117350A="GC_enable();\n";
char*s283_1689176777A="external_c_plus_plus_files";
char*s117_1924772383A="/*Aliased storage area or unicode storage.*/\n";
char*s729_1246790712A="gc_mark(u->";
char*s488_486705491A="Unexpected trailing character";
char*s729_530955790A="GC support: generating functions.\n";
char*s846_81437A="fsoc*";
char*s117_1476A=")R)";
char*s648_813409A="))=*((T";
char*s449_1478A="0.0";
char*s117_188283590A="T0*se_ums(";
char*s637_1481A="/*`";
char*s642_1307328870A="/*until*/if(";
char*s349_934695142A="Different result types.";
char*s117_1273572186A="se_local_profile_t local_profile, master_profile;\n";
char*s30_579450289A=": the new name of the \"-trace\" flag is now \"-sedb\".\n";
char*s104_54634669A="precursor";
char*s117_1493A="/*l";
char*s33_1375414302A="type_generating_type";
char*s104_243230489A="This alias can be used only as infix, needing a Result type.";
char*s104_1744209811A="Bad use of predefined type NATIVE_ARRAY.";
char*s729_1770234694A="(!gc_is_off)";
char*s117_13801A="]=p[";
char*s117_586511651A=";while (i-->0) \173""\nprint_profile(profile_file, sorted_agent_profile+i);\n\175""\n";
char*s713_511703191A="Cannot rename ";
char*s848_479982486A="!=NULL)\173""\nn=";
char*s117_1404852998A="sedb_breakpoint(&ds,";
char*s409_35382059A="\?=  assignment (an assignment attempt).";
char*s104_49203356A="attribute";
char*s117_2142659303A="se_profile_t inv_profile";
char*s415_2480364A="Overflow for opposite of Minimum_integer_16.";
char*s352_1514297749A=" for missing arguments.";
char*s409_354065377A=" (\"::=\" is not necessary).";
char*s120_582925635A="Can\'t join these two attribute definitions. Because an attribute cannot be undefined (using an undefine clause), you may consider to modify parents themselves. May be.";
char*s104_2047201942A="Substitute with \",\".";
char*s104_1909979286A="Feature name expected here.";
char*s126_1680762272A="\" not found.\n";
char*s104_1642195503A="The !! notation is really old and ugly, it should not be used anymore. Please update your code and use the `create\' keyword.";
char*s33_880412606A="generating_type";
char*s34_2234341A="variant";
char*s283_1709309070A="Unable to load class \"";
char*s113_1102814319A="System is \"";
char*s647_1530A="->_";
char*s844_7682A="*R=M";
char*s104_833080669A="End of text expected.";
char*s647_1679636650A="((real32_t)(";
char*s490_413651A="inline";
char*s848_129037214A="(fsoc*c,gc";
char*s33_279656751A="std_output";
char*s415_2480394A="Overflow for opposite of Minimum_integer_32.";
char*s104_962885232A="Expression ";
char*s647_4178071A="*/)):0))";
char*s33_859431564A="type_attribute_generator";
char*s117_490869799A="_external_cpp";
char*s104_791727511A="Bad generic list. Expected \',\' or \']\', but found \'";
char*s117_1164920984A="se_profile_t profile";
char*s104_2099054905A="Correct the previous error";
char*s678_643795973A="Incompatible actual argument for agent call. Cannot pass ";
char*s729_1111954737A="void gc_mark_";
char*s34_1957581A="default";
char*s283_1553744164A="external_object_files";
char*s117_1565A="&ds";
char*s647_511943145A="),(double)(";
char*s104_2037548A="Bad create instruction (type expected).";
char*s625_491029751A="/*agent is_equal*/int ";
char*s848_1111960899A="void gc_sweep";
char*s117_1471782099A="switch (expression->id) \173""\n";
char*s104_955584028A="Expression expected after the \"elseif\" keyword.";
char*s34_407540A="frozen";
char*s33_438300A="second";
char*s117_432958168A="*C,void(*signal)(void*),void*sigdata)";
char*s356_242535516A="Invalid type for the target of this procedure call.";
char*s729_1760239413A="gcmt=((mch**)se_malloc((gcmt_max+1)*sizeof(void*)));\nstack_bottom=((void**)(void*)(&C));\n";
char*s727_161521A="))->o)";
char*s642_283285900A="while(1)\173""\n";
char*s33_1319421852A="native_data";
char*s117_1661632742A="]=atexit_profile;\n";
char*s729_2006740748A="\173""int i=o->id;\n";
char*s113_485672260A="\" environment variable\nwith the absolute path of your own hand-made LibertyEiffel\nconfiguration file.\n";
char*s33_761722990A="mark_native_arrays";
char*s495_1319735562A="Cannot use anchored type for this form of creation.";
char*s104_1208507031A="Obsolete manifest string expected.";
char*s625_1185483839A="ds.locals=NULL;\n";
char*s728_1370665846A="GC_stackbottom=(char*)(void*)&C;\n";
char*s126_3556890A="\" file.\n";
char*s105_1038536453A="Extra blank or tab character removed in multi-line manifest string.";
char*s624_1191155066A="(FILE* file,T";
char*s113_2011772281A="Unknown C mode: ";
char*s33_185934049A="NATURAL_16";
char*s728_1992734941A="GC_enable();\neiffel_root_object=NULL;\nGC_gcollect();\nhandle(SE_HANDLE_ENTER_GC,NULL);\n";
char*s641_1625A="(\173""\n";
char*s113_1626A="/Fe";
char*s415_2480479A="Overflow for opposite of Minimum_integer_64.";
char*s33_185934055A="NATURAL_32";
char*s30_7779A=".ACE";
char*s104_2055333675A="Slash \"/\" or decimal digit expected (inside CHARACTER constant).";
char*s117_1607940692A="se_profile_t agent_switch_profile";
char*s117_860532685A="handle(SE_HANDLE_NORMAL_EXIT, NULL);\n";
char*s113_2139128753A="The environment variable \"";
char*s729_1783951564A="if(gc_info_nb_agent)\n   fprintf(SE_GCINFO,\n   \"%d\\tagent(s) created. (store_left=%d).\\n\",\n   gc_info_nb_agent,store_left_agent);\n";
char*s117_1639A=";\nr";
char*s34_1532344910A="cpp_compiler_type";
char*s33_619776399A="Integer_bits";
char*s34_479921113A="c_compiler_type";
char*s488_522818189A="default_value";
char*s825_1644A=": \"";
char*s33_185934072A="NATURAL_64";
char*s648_32400A="));\n\175""";
char*s625_1923813010A="\",1\175"";\nse_dump_stack ds;\nds.fd=&fd;\nds.current=";
char*s624_1646A="*o)";
char*s479_2141380032A="Any given feature name should appear at most once in one export clause for each parent clause. Feature ";
char*s104_1254996328A="Cannot use hexadecimal notation for this type.";
char*s352_1788472558A=" May lose memory.";
char*s848_687744958A="o=(void*)o->_";
char*s117_1650A=";\n\175""";
char*s642_1650A=")\173""\n";
char*s848_1651A="*p)";
char*s436_265238926A="Feature `manifest_put\' must have at least two argument and the first one must be an INTEGER argument.";
char*s113_7809A=".BAT";
char*s642_180037A=" else ";
char*s619_386149138A="pending_c_function_counter_tag";
char*s440_123839750A="You should consider using another name for this formal generic argument. The common usage is to add an extra trailing underscore character (see for example COLLECTION, ARRAY or DICTIONARY).";
char*s104_401981819A="..........................................................";
char*s117_1164208A="#ifdef _BASE_H\n#define _HAD_BASE_H\n#endif\n";
char*s583_1046299075A=" (from -cecil \"";
char*s729_1676A="*u)";
char*s33_1326673961A="object_size";
char*s728_112977096A="(GC_gc_no)";
char*s647_32435A=")))\174""(";
char*s848_44739A="=((gc";
char*s467_154976132A=" has no result type.";
char*s650_57298260A="\nR=&_r;\n\175""\n";
char*s648_81730033A="se_thread_lock_unlock((";
char*s637_845936425A="Kernel classes don\'t have attributes!!! This class has been tampered with.";
char*s35_1994621A="gc_info";
char*s104_1289042164A="Void cannot be the left-hand side of the binary \"//\" operator.";
char*s647_32456A=")+.5)";
char*s117_1946737844A="Order of evaluation for pre-computed once functions:\n";
char*s117_14005A="[];\n";
char*s117_192841706A="NULL, NULL";
char*s383_1348774A="AT_EXIT";
char*s415_1337425939A=" which is out of range 0 ..63 because target type is INTEGER_64.";
char*s120_1875884480A="The local definition in ";
char*s554_142089811A="/etc/issue";
char*s117_7869A="&ds,";
char*s648_1185225610A=")->_native_data);\n";
char*s728_636642526A="(!GC_dont_gc)";
char*s293_2082988666A=" (The validation context is ";
char*s113_7878A=".CMD";
char*s642_1727A=":/*";
char*s425_183516812A="Attribute ";
char*s647_1586596820A="<<8)\174""((uint16_t)";
char*s648_29126717A="*((int16_t*)(";
char*s34_14036A="True";
char*s33_55926626A="std_input";
char*s117_48520827A="cecilcrea";
char*s642_1060489498A="requireresult=";
char*s622_161665A=" NULL\n";
char*s436_1857191624A=" not correctly equiped for manifest generic creation (missing definition of feature `manifest_semicolon_check\').";
char*s122_1797674551A="internal_exception_handler(Incorrect_inspect_value);\n";
char*s113_1744A=".cc";
char*s126_1758326604A="**** delete failed!\n";
char*s642_1115076A="=((T0*)";
char*s642_180128A=" else\173""";
char*s104_941240074A="Keyword \"end\" expected at the end of check clause.";
char*s283_608446371A="You have to fix the problem in your ACE file. Valid assertion level tags are: \"no\", \"require\", \"ensure\", \"invariant\", \"loop\", \"check\", \"all\", and \"debug\".";
char*s494_1753A="0e0";
char*s495_112048371A=" creation.";
char*s89_22612837A=" in type ";
char*s117_1765A="=((";
char*s420_176104896A=" ... << ... >> \175"" manifest creation notation.";
char*s386_1712194128A="\' is out of INTEGER_8 range.";
char*s105_256559978A="Useless keyword deleted.";
char*s117_1700132018A="se_frame_descriptor fd=\173""\"<thread root>\",0,0,\"\",1\175"";\nse_dump_stack ds;\nds.fd=&fd;\nds.p=0;\nds.caller=NULL;\nds.exception_origin=NULL;\nds.locals=NULL;\nds.depth=0;\n\nse_dst=&ds;\n";
char*s420_1458557644A="Creation clause exists for type ";
char*s97_1052333303A=" (compare usage and definition below).";
char*s117_1043020690A=";\nreturn C;\n";
char*s104_1296817101A="). Instruction or keyword \"";
char*s113_1775A=".id";
char*s29_1128710280A="Liberty Eiffel does not (yet) support precompiled headers for\nthis C compiler. Please drop an e-mail liberty-eiffel@gnu.org%N";
char*s104_376006259A="Missing manifest STRING for `c_inline_c\'.";
char*s117_1364588829A=" se_manifest";
char*s385_7506001A="Current.";
char*s117_36778611A="local_profile.profile=profile+";
char*s104_970900228A="\" while waiting for some local variable name. Cannot use \"";
char*s622_565063403A="/* C Header Pass 2: */\n";
char*s467_2108232434A="The type of this constant feature should be STRING.";
char*s117_4049151A="((T0*)C)";
char*s904_2108496933A="No linker options";
char*s848_1523807481A="*o1,*o2;\no1=((gc";
char*s510_920757291A="The value of ";
char*s409_1801A="::=";
char*s104_1917483795A="Error while reading manifest number.";
char*s660_1658151484A=" misses some clients of the conforming parent(s) for ";
char*s117_1630601156A="during C code generation (backend)";
char*s111_89019087A="\" in type ";
char*s34_2185421A="require";
char*s34_251171752A="flat_check";
char*s104_1778077539A="Void cannot be the left-hand side of the binary \"-\" operator.";
char*s33_312005144A="type_can_be_assigned_to_attribute";
char*s104_1665385073A="The base type is no longer used. Class FUNCTION now has only two formal generic arguments. Just remove this unused type mark.";
char*s362_1771711260A="Symplify interrupted (infinite inlining\?) in CALL_0.\n";
char*s554_1826A=".se";
char*s127_75639A="_from";
char*s495_1832A="<< ";
char*s647_1651828280A="/* same_dynamic_type */\n";
char*s349_1813679543A="In the redefinition context (i.e in ";
char*s647_1214258443A="0;\nerror0(\"Invalid is_deep_equal.\",NULL)";
char*s647_167916A="((uint";
char*s647_1840A="<<(";
char*s647_108351709A="),sizeof(T";
char*s729_869136A="*)newCL";
char*s33_94407393A="collection_off";
char*s33_14150A="Void";
char*s848_32605A="*)(&(";
char*s104_50040236A="else part";
char*s729_1697044300A="equivalent memory structure";
char*s117_1154403080A="print_profile(profile_file, &atexit_profile);\n";
char*s488_1468725331A="Required key \"";
char*s117_426087775A="#ifndef _HAD_BASE_H\nextern void*eiffel_root_object;\n\ntypedef T3*T9;\n#endif\n/* Available Eiffel routines via -cecil:\n*/\n";
char*s117_57150800A="atexit(se_atexit);\n";
char*s104_1021024803A="Manifest string expected for \"obsolete\" clause.";
char*s848_47598300A="o);\n\175""\n\175""\n\175""";
char*s286_1188332009A="This call should be some constant feature call (i.e. a statically computable value). (See the definition found in the next error message.)";
char*s104_603076667A="Writable entity expected here.";
char*s648_534333098A="<<8)&0xFF0000)\174""(((uint32_t)";
char*s848_692075493A="*)o)->header.flag==FSOH_UNMARKED))";
char*s117_107312226A="*sizeof(se_profile_t));\nqsort(sorted_agent_switch_profile, ";
char*s467_90390825A="Cannot use type ";
char*s729_1992679842A="gc_lock=se_thread_lock_alloc();\n";
char*s117_267478119A="if(se_rci(caller,C))";
char*s35_2191641A="profile";
char*s624_565069653A="/* C Header Pass 4: */\n";
char*s648_2001063662A="\173""/*slice_copy*/\nint a3tmp=";
char*s35_822199910A="style_warning";
char*s104_2047202317A="Substitute with \";\".";
char*s647_32650A="))>>(";
char*s623_2057228449A="\173""Tid id;T0*o;\175"";\n";
char*s624_832280A="(*o)->_";
char*s117_438660461A="Cannot produce C code.";
char*s104_502181838A="Missing \"\175""\" to terminate manifest generic creation.";
char*s33_403163040A="THREAD_CONTEXT";
char*s117_870017790A="/*  - require*/\n";
char*s104_307717976A="Error while reading a number. Missing \"\175""\" \?";
char*s111_327902A="TUPLE ";
char*s647_1900A=">>(";
char*s647_10089540A="floorf((";
char*s104_1938643327A="This call has a result value (and you must use it).";
char*s117_1580612071A="se_profile_t runinit_profile";
char*s589_1747685533A="typedef void*T";
char*s33_735034101A="storage_lower";
char*s104_376006384A="Missing manifest STRING for `c_inline_h\'.";
char*s467_573004463A="A character constant cannot be an assigner.";
char*s33_50778415A="exception";
char*s625_505232755A="/*agent creation*/T0*";
char*s640_36126743A="INT32_MIN";
char*s117_7918258A="SE_MAXID";
char*s846_413927315A="(x) (((se_agent0*)(x))->gc_mark_agent_mold((se_agent*)(x)))\n\n";
char*s729_172408303A="(/*calloc*/(T";
char*s729_1994852A="gc_mark";
char*s33_1530432238A="valid_generating_type_for_internals";
char*s647_887295984A="\n#if BYTE_ORDER == LITTLE_ENDIAN\n(";
char*s104_2061122069A="Error while reading a real. Missing separator after the value \?";
char*s104_1933A="C++";
char*s583_992810240A="The type for a creation procedure cannot be INTERNALS.\n";
char*s33_88048A="put_0";
char*s117_950675891A="local_profile.profile=&runinit_profile;\n";
char*s33_88049A="put_1";
char*s582_942808765A="void manifest_string_mark";
char*s104_246527867A="Incorrect hexadecimal notation. Wrong number of hexadecimal digits (";
char*s113_69601A="a.exe";
char*s33_55041091A="put_32_be";
char*s104_4492176A="........";
char*s625_2111741A="locals[";
char*s848_27909038A="if(NULL==gc_find_chunk(o))\nreturn; /* external NA */\n";
char*s33_36200588A="INTERNALS";
char*s583_724183788A="The type for a creation procedure cannot be deferred.\n";
char*s113_683870135A="cc/warning=disable=(embedcomment,longextern) ";
char*s33_261093457A="make_blank";
char*s650_1962A="C->";
char*s495_909851733A="Irregular number of items in bunches. The previous bunch is smaller.";
char*s33_1286698901A="element_sizeof";
char*s104_1505459217A="Keyword \"end\" added to terminate inherit/insert parent.";
char*s104_1421116705A="Slash \"/\" character expected after hexadecimal value in CHARACTER constant.";
char*s647_9794360A="deeptwin";
char*s113_1115301A="-x none";
char*s126_124992A="      ";
char*s625_2072064738A="struct rescue_context rc;\n";
char*s33_1680885744A="default_rescue";
char*s728_1933391A="bdw_ms[";
char*s904_1574596468A="No compiler options";
char*s728_1949186219A="/*mark_item*/";
char*s650_8131A=")_r=";
char*s117_11086084A="sizeof(T";
char*s625_4996600A="*a1=(se_";
char*s486_444860A="thread";
char*s104_676728857A="Error in manifest constant or \"\?:=\" type test \?";
char*s34_451011A="unique";
char*s33_55041141A="put_32_le";
char*s120_1127406485A="An attribute cannot be undefined.";
char*s111_2029530601A="Polymorphic Proceduire/Function Call";
char*s117_1492394528A=";while (i-->0) \173""\nsumup_profile(profile_file, sorted_all_profile+i);\n\175""\n";
char*s33_55041151A="put_32_ne";
char*s647_19199275A="!=NULL)\173""\n";
char*s126_1711985232A="Cannot write file \"";
char*s640_807791A="))->id)";
char*s104_1284361566A="Character \'%\"\' inserted after \"infix\".";
char*s111_1378502623A="Before simplify cycle";
char*s412_729510616A=" with expression ";
char*s642_28032126A="=((void*)";
char*s495_1646704683A="Unexpected \";\" (semicolon) separator in manifest generic expression. Less items found in this bunch than in the previous one.";
char*s117_1965252672A="]=((void*(*)(void*,char*,int*,int*))se_introspecT";
char*s640_161951A="((T0*)";
char*s286_1281353746A="\n      inherited as ";
char*s117_772432310A="local_profile.profile=agent_profile+";
char*s286_169314461A="No feature found for this call.";
char*s342_971287994A="Precondition";
char*s33_586229245A="type_is_expanded";
char*s647_484454800A="\" argument in external C inline definition.";
char*s650_1150927957A="*C,char*attr,int*id,int*exp)";
char*s848_917774306A="*obj_ptr=(gc";
char*s33_1395184171A="same_dynamic_type";
char*s647_10089690A="floorl((";
char*s117_1307483215A="(&ds,&local_profile,C);\n";
char*s111_891552598A=" cannot be a root class since it is a deferred class.";
char*s117_1724182721A="local_profile.profile=&prof;\n";
char*s647_476433922A="deep_twin_from(";
char*s111_1145029170A="Internal compiler error (set_agent_creation_error_trap).";
char*s377_1970431863A="inspectDynamicDispatchExpression";
char*s105_446380143A="Unexpected comma (deleted).";
char*s117_826425832A="se_dump_stack*caller";
char*s640_21020045A="((void*)(";
char*s647_9954400A="if(!R)\173""\n";
char*s35_2028737205A="flymake_mode";
char*s113_186217457A="... unique once buffer ...";
char*s647_162010A="));\n\175""\n";
char*s117_1656195746A=" main(int argc,char*argv[])";
char*s111_1483967746A="Polymorphic Distribution of \"inspect\" Statements. Measurement\ndone ";
char*s409_1747372019A=" The left-hand side expression must conform to the right-hand side. The expression ";
char*s640_162019A="((T3)\'";
char*s647_162020A="((T3)(";
char*s625_2095A="CA_";
char*s650_5279655A="*id=-1;\n";
char*s416_1993565801A=" can be normally assigned into the left-hand side which is of type ";
char*s117_506210947A="se_general_trace_switch=1;\n";
char*s33_1300046706A="last_result";
char*s33_2104A="ANY";
char*s648_32860A="));\175""\n";
char*s648_2110A=";\175""\n";
char*s648_140263367A="se_thread_lock_notify_all((";
char*s117_32869A="(&ds,";
char*s104_2001191A="current";
char*s625_1032053803A="se_dump_stack ds;\nds.fd=&fd;\nds.current=NULL;\nds.p=(caller->p);\nds.caller=caller;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s844_788978585A="if(o->bdw_markna==NULL)\173""\nT0**markna;\nGC_disable();\nbdw_in_assign=1;\nmarkna=se_malloc(sizeof(T0*));\nGC_REGISTER_FINALIZER_NO_ORDER(markna,(GC_finalization_proc)bdw_na_markT";
char*s495_1427483140A="Missing argument before << ... >> item list.";
char*s844_546112503A="void bdw_run_finalizers(void)";
char*s341_977955761A="SEDB object";
char*s34_408086A="export";
char*s117_531983658A="local_profile=global_profile;\n";
char*s552_1806821466A="specializing and checking";
char*s34_251916328A="cpp_strip_path";
char*s104_1176245553A="Anchor expected. An anchor could be `Current\', a feature name or an argument name.";
char*s97_1781104140A="Deferred class should not have creation clause (VGCP.1).";
char*s115_57487A="Amiga";
char*s117_451157A="unlink";
char*s104_1561427335A="Keyword \"is\" is deprecated.";
char*s846_321989A="TLS(gc";
char*s647_8291A="(int";
char*s641_8291A=";\n\175"")";
char*s494_2009909053A="...........................................................";
char*s647_162070A="((T5)(";
char*s34_69805A="Tools";
char*s506_412149904A=" called on non-static type mark";
char*s637_2150A="CL_";
char*s650_1113554587A="void*R=NULL;\n";
char*s117_654499311A="va_list pa;\nva_start(pa,argc);\nC=";
char*s117_10944785A="se_msi1(";
char*s117_389672A="char*p";
char*s117_389675A="char*s";
char*s582_147115629A="=/*alloc*/((T0*)(";
char*s848_1927425A="begin:\n";
char*s849_14464A="\\n\",";
char*s383_202031759A="STD_OUTPUT";
char*s104_2051403723A="Added \"end\" to finish this \"if\" statement.";
char*s642_162095A="((T6)(";
char*s727_2138778683A="se_malloc(sizeof(T";
char*s286_32926A=", ...";
char*s647_734603803A=")->_native_data)";
char*s415_900982204A="Overflow of infix \"+\" with INTEGER_16 operands. (Adding ";
char*s115_2178A="DOS";
char*s34_401994A="flavor";
char*s844_1744880961A=")se_calloc(*n, sizeof(T";
char*s33_2035472654A="type_attribute_count";
char*s844_42739336A="(&n);\nif(GC_should_invoke_finalizers())bdw_run_finalizers();\nreturn R;\n";
char*s105_2131871127A="Same identifier appears twice (local/closure).";
char*s904_482960256A=">. The plugin seems to depend on itself! Ignored.";
char*s113_69851A="a.out";
char*s552_1243691337A="getting started";
char*s117_1826935309A="memcpy(sorted_inv_profile, inv_profile, ";
char*s34_2032026A="exclude";
char*s647_1726920051A="se_deep_equal_start();\n";
char*s34_264667428A="assertion_flat_check";
char*s117_351488799A="/*unknown position*/";
char*s104_4750778A=" warning";
char*s117_383570A="agents";
char*s844_1005223232A="void bdw_na_markT";
char*s647_1240185282A="Bad prototype for C struture set external.";
char*s34_820292A="****** ";
char*s120_1585514726A=", features \"";
char*s117_1637927398A="se_local_profile_t*parent_profile";
char*s283_698011541A="Cluster tree:\n";
char*s403_529996976A="Conflict between local/feature name (VRLE).";
char*s120_1297180456A=" because there is a local definition in this class. Redefine has been automatically added. Please check.";
char*s33_1447702A="INTEGER";
char*s113_1255802680A="emxbind -qs";
char*s538_922867504A="This obsolete manifest ARRAY creation is no longer supported. See our \"SmartEiffel/tutorial/manifest_notation.e\" in order to use the new notation.";
char*s34_88336A="short";
char*s104_599810839A="There is no need for the \"expanded\" keyword in an \"insert\" clause.This keyword will be ignored.";
char*s33_451252A="unlock";
char*s648_376332712A=")->_native_data = se_thread_lock_alloc();\n";
char*s624_1112927266A="void se_prinT";
char*s362_206355982A=" Context type was ";
char*s33_840111968A="collection_on";
char*s495_115013643A="Actually, for class ";
char*s647_234933541A="_t)-((uint";
char*s32_1181006553A="Feature `default_rescue\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s104_1023251859A="Replaced misspelled \"False\".";
char*s764_2114672999A="Using range inside inspect of type STRING is not possible.";
char*s415_442652821A=" which is out of range -31..31 because target type is INTEGER_31.";
char*s111_601041072A="class-path: \"";
char*s436_797085749A=". An expanded type must have one unique creation procedure with no argument: the creation procedure used for automatic initialization.";
char*s33_1297432701A="is_infinity";
char*s848_5839580A=".store;\n";
char*s33_2067759348A="from_pointer";
char*s650_1236414794A=";\nif(_r==NULL)\173""R=&_r;*id=0;\175""else\173""\nswitch(_r->id)\173""\n";
char*s625_832670A="(*afp)(";
char*s650_8436A="*id=";
char*s447_408035024A=" is hiding the definition in ";
char*s660_1679625106A="The final client list for ";
char*s340_864187036A="Loading cecil entries:\n";
char*s729_1155996628A="/*mark_item*/\175""";
char*s33_1209184326A="object_invariant";
char*s104_700613496A=" is not a valid feature name to start a new feature definition. Parser lost. Sorry. Check before and after that point.";
char*s647_45355A="=*C;\n";
char*s120_1041926341A="The feature ";
char*s625_2301A="R&=";
char*s104_1689577436A="Expression expected after \"elseif\" keyword.";
char*s33_1604515261A="to_internals";
char*s647_1096165867A="is_deep_equal(";
char*s104_860582570A="\" cannot be a valid feature name or a valid local name (only lower case letters are allowed here). Furthermore \"";
char*s554_2003309199A="/etc/xdg/liberty-eiffel";
char*s647_245384155A="clear_all(";
char*s117_1816632501A="se_local_profile_t local_profile;\n";
char*s120_1811139659A=" type.\n\nFirst \"insert\" path (from parent to child):\n   ";
char*s33_728963476A="type_item_generating_type";
char*s637_156095A="\'*/CA_";
char*s33_9647090A="and then";
char*s729_8475A="(se_";
char*s848_945011211A="=(((void*)obj_ptr)<=((void*)item));\nobj_ptr = (T0*)(((char*)obj_ptr) + obj_size);\nif (swept != (((fso_header*)obj_ptr)->flag==FSOH_UNMARKED)) /* **** TODO: was FSOH_UNMARKED\?\?\?\? (incoherent with comment below) */\n/* (already swept) xor marked */\nitem->o=NULL;\n\175""\n";
char*s104_28789007A="Actually, a creation list must not be empty. You must have at least the `default_create\' procedure inherited from ANY. The `default_create\' indicates that one can also create an object with no creation procedure. The `default_create\' has been added here automatically.";
char*s104_1874765620A="A missing client clause is interpreted as \173""ANY\175"". It is better to be explicit.";
char*s115_395994A="distcc";
char*s647_8485A="(vc(";
char*s112_546635553A="SMART_EIFFEL_SHORT_VERSION";
char*s647_1553763390A=")==(a1ptr->_";
char*s117_20552830A="(&ds,C);\n";
char*s659_1664721281A="........... unique buffer ...............";
char*s104_1752914319A="Instruction expected here. False alone is not an instruction.";
char*s104_2020913390A="Added missing \"then\" keyword.";
char*s34_414461A="insert";
char*s729_8499A=")new";
char*s625_1426099398A=".............................";
char*s104_156243902A="Void cannot be the target of prefix operator \"";
char*s639_1476205446A="fcstrangeisnotunlock";
char*s642_1936367907A="/*inspect]*/\n";
char*s283_1955866577A="external_lib_path";
char*s33_10938831A="se_fault";
char*s659_1025503229A=" using range tmp0 .. tmp";
char*s117_273715710A="#ifdef SIGINT\n                                                    signal(SIGINT,se_signal_handler);\n#endif\n#ifdef SIGTERM\n                                                    signal(SIGTERM,se_signal_handler);\n#endif\n";
char*s461_914877497A="Same feature name appears twice.";
char*s848_1653483427A="typedef struct Sgc \173""Tid id;T0*o;\175"" Tgc;\n";
char*s904_1384629373A="No library paths";
char*s647_244793715A="deep_twin(";
char*s379_1360462097A="reference: ";
char*s801_1121854A="/bin/sh";
char*s349_2084982239A=" context, it appears to be a call to an obsolete feature:\n";
char*s33_175767198A="EXCEPTIONS";
char*s660_1238684603A="The client list computed from the \"export\" clauses";
char*s113_45436A=".make";
char*s848_737599544A="=o1;\n\175""\n\175""\n\175""\nelse\173""\nint dead=1;\ngc";
char*s117_419316052A="/*Force definition of non-live NATIVE_ARRAY[CHARACTER] for manifest strings*/\ntypedef T3* T9;\n";
char*s117_2382A="T0*";
char*s97_1452647150A="Forbidden creation call (i.e. exportation rules violated). Creation is only allowed from ";
char*s117_1898865296A=";\nva_start(pa,argc);\nwhile (i < imax) \173""\n";
char*s379_41841490A="FIXED_STRING";
char*s113_217674A=".h.gch";
char*s117_149822297A=";while (i-->0) \173""\nprint_profile(profile_file, sorted_agent_switch_profile+i);\n\175""\n";
char*s619_1359151955A="internal_c_local_tag";
char*s619_8545A=":*/\n";
char*s656_2394A="T11";
char*s117_1965511388A="/*INIT CLOSURE LOCALS]*/\n";
char*s117_2395A="R=(";
char*s656_2395A="T12";
char*s729_1418601377A="(/*malloc_closure*/(T";
char*s104_1478844272A="Removed that non-significant digit in integral part or real constant.";
char*s104_1223700793A="Inside a function, a Precursor call must be a function call (not a procedure call).";
char*s104_529554293A="Removed unexpected blank space(s) just before this dot (assume you really want to call a function using the previous manifest expression as the target).";
char*s293_63912A="Line ";
char*s104_2117988535A="Void is not a valid BOOLEAN expression (just after keyword \"elseif\").";
char*s554_2091317800A="ALLUSERSPROFILE";
char*s111_2114217978A="Monomorphic Function Call";
char*s729_1327517381A="#ifndef FIXED_STACK_BOTTOM\nif(!valid_stack_bottom) stack_bottom = NULL;\n#endif\n";
char*s642_2065182209A="if(!requireresult)\173""\n";
char*s117_1530032908A="fprintf(profile_file, \"\\n-------------------------------------------------------------------------------\\n\");\ni=";
char*s412_1222747401A=". (This would always yield to a ";
char*s111_768828206A="Looking for ";
char*s283_2070822678A="The \"adapt\" clause is not yet implemented.";
char*s34_76226A="adapt";
char*s104_439136A="select";
char*s104_1491933617A="Void is not a valid target (i.e. just before an alias \"[]\").";
char*s117_2417A="T7*";
char*s447_146113272A="The definition of ";
char*s97_2123229206A=" is obsolete:\n";
char*s283_763815152A="\nYou are in command line mode (i.e. no ACE file is used).\nThe load path can be changed using a file called\nloadpath.se in the current working directory.\nUsually, this loadpath.se file is a simple list of directories.\nIt is also possible to use system variables or include files. See\nthe documentation for the finder command for more information.\n";
char*s283_957054969A="-debug_check is deprecated. Please use -debug and another -*_check assertion level. This defaults to -all_check.";
char*s501_180503525A=".......................";
char*s115_2440A="OS2";
char*s283_556698697A=": error: No <Root-Class> in command line.\n";
char*s113_6159594A="C mode \"";
char*s844_82948679A=")bdw_malloc_innerT";
char*s623_199280A=",NULL\175""";
char*s467_1157128572A="A \"unique\" definition is actually a constant-attribute definition.";
char*s728_645592960A="s=(T7*)bdw_mallocT7(1);\n";
char*s624_1483857391A="0(file,(T0**)(&(";
char*s647_8779932A="Unknown ";
char*s647_168532A="*)R)=M";
char*s554_1646495986A="Configuration chain (the lower the more specific):";
char*s650_1956008156A="\175"" else \173"" *id=0; \175""\n";
char*s105_274238642A="Deleted extra comma.";
char*s33_2090604340A="full_collect";
char*s33_591414963A="standard_copy";
char*s118_1753572602A="Infinite inlining loop (bad recursion \?\?). ";
char*s104_614881029A="Syntax error while trying to parse a conversion clause. Expected either \'(\' or \':\'";
char*s621_11381817A="typedef ";
char*s642_48939825A="default:\n";
char*s105_332623945A="Bad creation/create (procedure name expected).";
char*s624_358648841A="7(file,(T7**)(&(";
char*s111_1272176911A="Loaded Classes";
char*s415_282345691A=" which is out of range -7..7 because target type is INTEGER_8.";
char*s582_1119207694A="&gc_local_profile";
char*s729_118716790A="fprintf(SE_GCINFO,\"==== Last GC before exit ====\\n\");\ngc_start();\n";
char*s642_48939847A="default: ";
char*s104_554066118A="\" is not valid identifier. For a better readability Liberty Eiffel _is_ case sensitive. Hence \"";
char*s104_1439398002A="A Precursor type mark annotation must not be anchored.";
char*s488_1917908900A="feature_name";
char*s104_1193216533A="A type mark is not a valid item for a manifest array. Keep in mind that Liberty Eiffel is case-sensitive and that ";
char*s642_279959115A="\173""\nse_dump_stack *caller=&ds;\n\173""\nse_dump_stack ds=\173""NULL,NULL,caller->p,caller,NULL,NULL\175"";\n";
char*s104_277837020A="Missing items in manifest creation \"<< ... >>\" list. The last bunch should have ";
char*s33_2504A="SET";
char*s106_1656731300A=" in the section [";
char*s729_49917876A="if(NULL!=";
char*s554_193194A="/.serc";
char*s115_207986277A="OpenVMS_CC";
char*s104_180894A=" error";
char*s844_2075405A="na=o->_";
char*s842_125876584A="GC_call_with_alloc_lock((GC_fn_type)bdw_na_assignT";
char*s296_1477688005A=": unsupported option \"";
char*s342_1777506207A="Check_instruction";
char*s290_1933944A="alias \"";
char*s34_402346A="ensure";
char*s647_33291A="((int";
char*s126_2537A="No ";
char*s104_761631659A="Cannot use an uppercase letter inside such an identifier. Yes, this rule is strict, but it is better for all of us to be able to distinguish at a glance a CLASS_NAME from another name. Furthermore, it would be really too bad for example to use `IsEmpty\' or `isEmpty\' at one place while all other places are using `is_empty\'. Finally, this strict constraint will help us to improve error messages of the compiler.";
char*s386_2126200255A="................................";
char*s122_584218374A="setup_signal_handler();\n";
char*s117_2545A="\n*/\n";
char*s104_784199689A=" digits). You must use exactly 2, 4, 8 or 16 digits only. A 2 digit value denotes an INTEGER_8, a 4 digit value denotes an INTEGER_16, an 8 digit value denotes an INTEGER_32, and, finally, a 16 digit value denotes an INTEGER_64. (See examples in file \"tutorial/manifest_notation.e\".)";
char*s625_1575353618A="static se_frame_descriptor fd=\173""\"Agent launcher\",0,0,\"\",1\175"";\n";
char*s844_886939850A="**markna,void*_)";
char*s589_33316A="* o2)";
char*s33_1223768616A="NATURAL_GENERAL";
char*s846_2082029949A="\173""0,NULL,NULL,NULL,(void(*)(T0*))";
char*s704_2565A="[1-";
char*s104_1909918820A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a procedure to the previous `False\' constant as target).";
char*s660_1711825865A="Multiple Precursor found (must use Precursor \173""...\175"" ancestor selection).";
char*s33_744845610A="valid_generating_type_for_native_array_internals";
char*s729_1637706318A="GC support: adding root functions.\n";
char*s415_1670460393A="Overflow of infix \"-\" with INTEGER_16 operands. (";
char*s554_64080A="Linux";
char*s647_2571A="]))";
char*s117_10028705A="s,e,c);\n";
char*s647_1079001A="(void*)";
char*s625_1489891655A=" features).\n";
char*s412_1182157125A="The declaration type of ";
char*s647_37173080A="R,a1-1);\n";
char*s589_3920780A="(&(o1->_";
char*s115_76405A="bcc32";
char*s120_305596576A=") there are two versions of the same initial feature with two different names. To  fix this, either use an \"insert\" link in place of one of the \"inherit\" links or rename the feature to get the same name in ";
char*s117_1361175839A="init_profile(profile+";
char*s283_22915075A=" items):\n";
char*s117_218061703A="*/\nse_signal_handler(14/*System_level_type_error*/);\n";
char*s113_98806116A=" Data=Auto";
char*s117_830104658A=" C,int i,int argc,...)";
char*s34_82570A="infix";
char*s729_411283072A="/*Ordinary once functions:*/\n";
char*s104_1731250773A="Empty generic list (deleted).";
char*s32_1194182360A="Feature `default_create\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s104_1564737054A=" after the $ operator. ";
char*s30_8771A=".ace";
char*s105_894954671A="In extended form of manifest string. Bad character after \'%\'.";
char*s583_950159899A="Error while loading features of cecil path file \"";
char*s104_2992013A="Unknown external language specification.";
char*s113_440518794A="\", flavor \"";
char*s117_2630A="];\n";
char*s29_569105454A="Usage: compile_to_c [options] <RootClass> <RootProcedure> ...\n   or: compile_to_c [options] <ACEfileName>.ace\n\nFor information about and examples of ACE files, have a look\nin the SmartEiffel/tutorial/ace directory.\n\nMost of the following options are not available when using\nan ACE file.\n\nOption summary:\n\nInformation:\n  -help               Display this help information\n  -version            Display Liberty Eiffel version information\n  -verbose            Display detailed information about what the compiler\n                       doing\n\nWarning and Error levels:\n  -style_warning      Do print warnings about style violations\n  -no_warning         Don\'t print any warnings\n  -relax              Performs less checks by considering less dead code, hence\n                       using less memory and less compilation time. Useful to\n                       prototype or to deliver safe code. (Useful too for very\n                       small computers.)\n\nOptimization and debugging levels (specify at most one; default is -a"
"ll_check):\n  -boost              Enable all optimizations,\n                       but disable all run-time checks\n  -no_check           Enable Void target and system-level checking\n  -require_check      Enable precondition checking (implies -no_check)\n  -ensure_check       Enable postcondition checking (implies -require_check)\n  -invariant_check    Enable class invariant checking (implies -ensure_check)\n  -loop_check         Enable loop variant and invariant checking\n                       (implies -invariant_check)\n  -all_check          Enable \'check\' blocks (implies -loop_check)\n  -debug              Enable \'debug\' blocks\n  -flat_check         Each assertion will be executed in no_check mode\n                      Use with any mode from require_check to all_check\n\nClass lookup:\n  -loadpath <file>    Specify an extra loadpath file to read\n\nC compilation and run-time system:\n  -cc <command>       Specify the C compiler to use\n  -c_mode <C mode>    Specify a C mode to use. This option is incompatible\n           "
"            with -cc\n  -cecil <file>       Take CECIL information from <file>\n                       (may be used more than once)\n  -o <file>           Put the executable program into <file>\n  -no_main            Don\'t include a main() in the generated executable\n  -no_gc              Disable garbage collection\n  -bdw_gc             Use Boehm-Demers-Weiser conservative GC\n  -gc_info            Enable status messages from the garbage collector\n  -no_strip           Don\'t run \'strip\' on the generated executable\n  -no_split           Generate only one C file\n  -split <split mode> Selects the split mode\n                       Either \'no\', \'legacy\', or \'by_type\'\n  -sedb               Enable sedb, the Liberty Eiffel debugger\n  -profile            Generates profile on Eiffel calls at program exit\n  -manifest_string_trace\n                      Enable the trace support to track non-once\n                      manifest string creation\n  -no_rescue          Don\'t compile rescue sections\n\nMiscellaneous:\n  -high_memory_comp"
"iler\n                      Allow the compile_to_c to use more memory; if you\n                      have enough physical memory, compilation should\n                      be faster (note: generated C code is not affected)\n";
char*s674_2113799934A="FAKE_TUPLE.resolve_in called";
char*s34_114085235A="# End of parallelizable section";
char*s117_1308400309A="#define SE_EXCEPTIONS 1\n";
char*s648_1773508175A="<<24\174""(((uint32_t)";
char*s113_8801A=".bat";
char*s117_470486490A=";\nint imax=i+argc";
char*s647_524787520A="((uint8_t)(";
char*s113_530877013A=" StripDebug";
char*s467_789877170A="Unique feature must have INTEGER type.";
char*s104_1098712729A="Manifest value not compatible with this type.";
char*s647_1116064705A="(T6)!memcmp(C,&a1,sizeof(T";
char*s648_1053613605A=";\nmemcpy(&((";
char*s582_2670A="]=(";
char*s117_33425A=")->id";
char*s381_292944046A=" Bad assignment.";
char*s848_1069766146A=".store_left;\n";
char*s33_88795A="third";
char*s825_480414235A="Unknown loadpath in ";
char*s370_1572647306A="The feature called has ";
char*s850_585110409A=".store->header.size=";
char*s848_8836A="*wr)";
char*s117_1082664800A="start_print_profile(profile_file);\n";
char*s807_1309286095A="XDG_CONFIG_HOME";
char*s123_138929174A="\" seems to be empty.";
char*s647_1263916320A="fpclassify(";
char*s30_1010347497A="Flag -is_output_error_warning_on must be used only once.\nYour command was:\n";
char*s34_2063276A="include";
char*s33_201970776A="force_to_integer_64";
char*s34_396356A="create";
char*s647_1023363018A=")=*C;\nse_deep_twin_register(((T0*)C),";
char*s488_1089314041A="An external \"plug_in\" must be described with an alias clause. (Have a look in our standard library or in our tutorial for examples.)";
char*s844_1866745094A="int i,c;T0*e;T0**na;T";
char*s33_201970793A="force_to_integer_32";
char*s286_2089269822A="The huge generic derivation related to the previous warning is: ";
char*s33_756809447A="Minimum_real";
char*s637_23647157A="/*empty*/";
char*s35_234165132A="manifest_string_trace";
char*s33_201970799A="force_to_integer_16";
char*s621_15019A="_t T";
char*s34_479922190A="c_compiler_path";
char*s729_2050807628A="c_struct_signature";
char*s647_15020A="_t)(";
char*s117_33475A="((se_";
char*s479_1172758533A="There should be at most one export clause with the \"all\" keyword in each parent clause. The client lists will be merged, but please fix the export clauses.";
char*s660_1912840703A="Keyword \"ensure\" replaced with \"ensure then\" because there is an inherited ensure assertion.";
char*s117_1934139A="caller,";
char*s349_1646268668A=" These two inherited features have the same name in type `";
char*s117_8880A=",lsi";
char*s113_8884A="-x c";
char*s729_633992455A="se_thread_lock_lock(gc_lock);\n";
char*s647_8885A=")\174""\174""(";
char*s552_520647979A="The system is type safe.\n";
char*s412_112006296A=" context.)";
char*s113_8889A=".com";
char*s117_941548611A="memcpy(sorted_all_profile+";
char*s729_1637595774A="(eiffel_root_object);\nmanifest_string_mark1();\nonce_function_mark();\n";
char*s32_8897A=".cpp";
char*s104_45224899A="Keyword \"until\" expected (in a loop).";
char*s112_1359484467A="(C) #(1) - #(2)";
char*s117_162838175A="se_dump_stack*caller,";
char*s33_30191860A="type_attribute_is_expanded";
char*s117_2753A="]=\173""";
char*s283_1251030042A="End of text expected (invalid ACE file).";
char*s648_851596A=" a1tmp=";
char*s117_900404594A="/* CECIL creation */\n\173""\n";
char*s29_1525604536A="Only the flags -verbose, -version, -help and -relax are allowed in ACE\nfile mode.\n";
char*s33_1673345408A="open_argument_count";
char*s33_954385774A="Pointer_bits";
char*s117_181146A="*C;\nC=";
char*s293_10926944A="prefix \"";
char*s439_1666936074A=" must insert ";
char*s648_1034090448A="se_thread_lock_lock((";
char*s117_1089314127A="#ifdef SIGQUIT\n                                                 signal(SIGQUIT,se_signal_handler);\n#endif\n#ifdef SIGILL\n                                                 signal(SIGILL,se_signal_handler);\n#endif\n#ifdef SIGABRT\n                                                 signal(SIGABRT,se_signal_handler);\n#endif\n#ifdef SIGFPE\n                                                 signal(SIGFPE,se_signal_handler);\n#endif\n#ifdef SIGSEGV\n                                                 signal(SIGSEGV,se_signal_handler);\n#endif\n#ifdef SIGBUS\n                                                 signal(SIGBUS,se_signal_handler);\n#endif\n#ifdef SIGSYS\n                                                 signal(SIGSYS,se_signal_handler);\n#endif\n#ifdef SIGTRAP\n                                                 signal(SIGTRAP,se_signal_handler);\n#endif\n#ifdef SIGXCPU\n                                                 signal(SIGXCPU,se_signal_handler);\n#endif\n#ifdef SIGXFSZ\n                                                 signal(SIGXFSZ,"
"se_signal_handler);\n#endif\n";
char*s104_1007106012A="Local name ";
char*s415_2004103151A="Overflow of infix \"+\" with INTEGER_8 operands. (Adding ";
char*s97_672350142A="\nassertion-level: ";
char*s728_1517878904A="GC_gcollect();\nif(GC_should_invoke_finalizers())bdw_run_finalizers();\n";
char*s440_142865912A="A formal generic argument should not use the name of some existing class (VCFG).";
char*s484_946986142A=" type is not allowed as a variant type.)";
char*s848_236525A="==1)\173""\n";
char*s33_827429162A="type_item_generator";
char*s728_1215237414A="#ifndef GC_DEBUG\n#define GC_DEBUG 1\n#endif\n";
char*s729_444775459A="\173""int i=SE_MAXID-1;\nwhile(i>=0)\173""\nif(t[i]!=NULL)gc_mark7(t[i]);\ni--;\175""\n\175""\n";
char*s341_311661671A="No SEDB objects added.\n";
char*s117_1140133715A="T0*c,int i0,int argc,...)";
char*s282_758913190A="Correct part: \"";
char*s844_1020256883A=")bdw_weakref_new(*n);\n*R=M";
char*s33_253393261A="for_object";
char*s117_1040899642A="C Compiler options used: ";
char*s282_319940936A=".... local unique buffer ....";
char*s34_1509818A="General";
char*s113_8976A=".exe";
char*s105_1581369567A="Decimal CHARACTER code out of range.";
char*s104_2137524537A="Inside an \"inspect\" statement for type STRING, the slice notation \"..\" is not allowed.";
char*s848_2830A="e;\n";
char*s729_1246644455A="gc_info();\n";
char*s117_1136523103A="union _se_agent\173""T0 s0;se_agent0 u0;\n";
char*s115_2833A="g++";
char*s436_1529695024A="Invalid manifest equipment (must be greater than 1).";
char*s349_556920526A=" is not a valid redefinition for ";
char*s447_1026844627A="\" (check your ACE file).";
char*s729_567426438A="u->gc_mark_agent_mold=gc_mark_";
char*s113_8991A="/fe=";
char*s647_2217200A="sizeof(";
char*s415_1143055473A=" which is out of range 0..31 because target type is INTEGER_31.";
char*s113_1331737400A="Local Loadpath";
char*s502_76659A="agenT";
char*s117_985140858A="])(void*,char*,int*,int*)";
char*s283_961330339A="Cannot open \"";
char*s648_177459204A="\n#if BYTE_ORDER == LITTLE_ENDIAN\n";
char*s425_936707889A=" not found in type ";
char*s120_612334905A="A frozen feature must not be redefined. What is frozen _is_ frozen.";
char*s113_1431838787A="\" environment\nvariable whatever the kind of your operating system is.\nIf you prefer that way, set the \"";
char*s104_483077794A="Bad procedure definition. Unable to parse definition of `";
char*s848_52067A="=c;\n*";
char*s418_1721243342A=" type cannot be used here. Actually this is only a compiler implementation facility.";
char*s117_400297641A="se_local_profile_t*parent_profile,";
char*s647_4204001A="((void*)";
char*s383_2870A="_P_";
char*s117_1746979137A=",expression,/*unknown-position*/0);\n";
char*s117_1591358844A="if(assertion_depth)\173""\nassertion_depth--;\n";
char*s33_52347889A="mark_item";
char*s33_76691A="agent";
char*s111_1574136045A="Finished optimization (";
char*s340_36115402A="All type marks used in a cecil file have to be static (no anchors).";
char*s395_527180488A=" of this Unicode manifest string. ";
char*s117_2883A="i++";
char*s104_1910823336A="\" has been automatically replaced with \"";
char*s848_618166083A="++;\n\175""\n\175""\nn->header.flag=FSOH_UNMARKED;\n";
char*s33_1095772782A="collector_counter";
char*s113_218174A="-s -d1";
char*s647_907447617A=";\nif(o1==o2)\173""\175""\nelse if(NULL==o1)\173""R=0;\175""\nelse if(NULL==o2)\173""R=0;\175""\nelse \173""R=";
char*s117_786180653A="se_frame_descriptor irfd=\173""\"<runtime init>\",0,0,\"\",1\175"";\nse_dump_stack ds = \173""NULL,NULL,0,NULL,NULL,0\175"";\nds.fd=&irfd;\n";
char*s844_1871081731A=";\nif(na)for(i=0;i<c;i++)\173""\ne=na[i];if(e)na[i]=(T0*)HIDE_POINTER(e);\175""\n";
char*s485_1057882626A="Expression of until must be of BOOLEAN type. (The actual ";
char*s290_15195A="_ix_";
char*s647_9045A=".is_";
char*s904_712467074A="No libraries";
char*s554_45953A="/lang";
char*s33_869539012A="sedb_breakpoint";
char*s625_1728089446A="se_frame_descriptor se_ifd";
char*s647_1671063525A="((uint64_t)(";
char*s86_522142839A="Collecting Cecil features.\n";
char*s844_15205A="o);\n";
char*s117_54734511A="se_prinT[";
char*s660_1691484858A="The export clause is ignored, the redefinition \"feature\" client list will be used instead.";
char*s647_520377520A="((int32_t)(";
char*s33_1574640467A="trace_switch";
char*s113_9073A=".lib";
char*s647_39831A=",NULL";
char*s619_1971245A="closed_";
char*s342_580435889A="Postcondition";
char*s33_48958735A="deep_twin";
char*s104_727272566A="Entity `Current\' is not writable. Cannot use `Current\' for the left-hand side of an assignment.";
char*s106_1377150320A="\'. Maybe the program name is incorrect, or process execution is not yet supported on this platform.";
char*s33_170256464A="FAST_ARRAY";
char*s104_1953566687A="The type mark must be specified just after the \"Precursor\" keyword.";
char*s660_81368369A="The client list computed from the \"export\" clauses is narrower than the one from";
char*s296_624587783A="string_command_line";
char*s846_1694775670A="typedef struct GC_B";
char*s125_2947A="fBC";
char*s650_1614701960A="_r=NULL;\n_r=";
char*s34_8054609A="Loadpath";
char*s113_9107A=".lnk";
char*s729_99483079A="se_thread_barrier(mark_stack_and_registers);\nse_thread_barrier(gc_sweep);\n";
char*s640_101328382A="(/*OUTCA*/";
char*s467_947318471A=" to define a constant.";
char*s729_1230018439A="gc_mark(u->CA_";
char*s113_9121A=".obj";
char*s383_181352A=" from ";
char*s729_497096041A="gcmt=((mch**)se_malloc((gcmt_max+1)*sizeof(void*)));\n#ifdef FIXED_STACK_BOTTOM\nif (!stack_bottom) stack_bottom=((void**)(void*)(&argc));\n#endif\n";
char*s904_387651299A=">, module_name <";
char*s647_2118444283A="R=(C->id==a1->id);\nif(R)\173""\n";
char*s117_9130A="=0;\n";
char*s810_1182938696A="a_file_name";
char*s113_2109537640A="...This is a local once buffer...";
char*s32_2057783129A="Feature `deep_twin\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s648_1213355397A=")->_native_data=se_thread_run((void(*)(T0*,void(*)(void*),void*))thread_run";
char*s625_759184012A="rc.next = rescue_context_top;\nrescue_context_top = &rc;\n";
char*s117_374291339A="char* se_atT[";
char*s117_712350300A="init_profile(&atexit_profile, \"<atexit>\");\n";
char*s113_415107A="lcclnk";
char*s104_1775667520A="In an object-oriented language, the receiver of a call is always associated to some existing object (i.e. `Current\' is never Void). Hence, such a weird comparison is not allowed.";
char*s729_679909928A="gc_mark(*(u->CL_";
char*s647_2996A="_t)";
char*s848_998144220A=".store=((rsoh*)(((char*)(";
char*s117_1582839830A="qsort(sorted_all_profile, ";
char*s33_180965424A="INTEGER_16";
char*s383_732402575A=" (magic count = ";
char*s650_3006A="_r=";
char*s33_180965430A="INTEGER_32";
char*s728_1110320023A="void* bdw_ms[";
char*s383_44462444A="c-type: T";
char*s117_1540564023A="r7from_external_sized_copy(";
char*s117_1281004126A="eiffel_root_object=((T";
char*s117_1450568746A="/* Void call detected in back-end (function called: \173""";
char*s104_188494264A="else of inspect";
char*s33_11001014A="set_item";
char*s33_180965447A="INTEGER_64";
char*s104_167445550A="Inside a procedure, a Precursor call must be a procedure call (not a function call).";
char*s904_698701270A="No source files";
char*s33_10945665A="print_on";
char*s117_3040A="ci(";
char*s582_1757386798A="se_frame_descriptor gcd=\173""\"Garbage Collector at work.\\n\"\n\"dispose called (during sweep phase)\",0,0,\"\",1\175"";\nse_dump_stack ds = \173""NULL,NULL,0,NULL,NULL\175"";\nds.fd=&gcd;\nds.caller=se_dst;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s105_1708886163A="Invalid free operator (the last character must be a member of this +-*/\\=<>@#\174""& character list.).";
char*s293_1661812564A="Internal Error";
char*s283_2028436769A="The \"case_insensitive\" option is no longer supported.";
char*s117_15351A="base";
char*s660_214672950A="The \"feature\" clause declares a client list that";
char*s33_2174354A="realloc";
char*s625_1111279623A="void**locals[";
char*s660_1961403182A=". This type should be marked as deferred.";
char*s650_2117730851A="**)C)+atoi(attr));\n";
char*s290_15370A="_px_";
char*s120_69115705A="FEATURE_STAMPs total number = ";
char*s113_9220A=".res";
char*s115_3069A="ccc";
char*s289_1492303331A=" is not generic.";
char*s113_9222A=".scf";
char*s104_723705127A="Dot expected here because a manifest-string alone is not an instruction.";
char*s120_1008693261A="Assigner feature is not a command in type ";
char*s283_3073A="all";
char*s33_3075A="and";
char*s104_1922694958A="Replaced misspelled \"Void\".";
char*s120_840703310A="\n\nSecond \"inherit\" path (from parent to child):\n   ";
char*s34_3085A="bin";
char*s640_101328511A="(/*OUTCA:`";
char*s34_51843716A="invariant";
char*s117_1145546877A="...........................";
char*s409_1896547075A="assignment attempt (\"\?=\").";
char*s488_1014770470A=":\" not found";
char*s113_3094A="dcc";
char*s625_1125599189A="return((T0*)u);\n";
char*s30_546820847A=". Bad flag ";
char*s115_1663868A="OpenVMS";
char*s35_89216A="split";
char*s650_138425A="\")) \173""\n";
char*s624_15405A="o->_";
char*s486_384465A="basic_";
char*s105_1923039443A="Underscore in number must group exactly 3 digits.";
char*s467_958494983A="Using a manifest constant for the feature value is suitable only for a constant-attribute definition. The constant found (i.e. ";
char*s729_1197879602A="gc_dispose_before_exit();\n";
char*s554_1213220196A="\\Liberty-Eiffel";
char*s33_1856946950A="Minimum_character_code";
char*s33_39154229A="PROCEDURE";
char*s126_3115A="s.\n";
char*s104_370754643A="Bad external alias clause.";
char*s104_188014584A="Replaced misspelled \"Current\".";
char*s117_1935236890A="*)&(C->_status)=R;\n*(volatile T6*)&(C->_is_finished)=1;\n";
char*s111_1066764899A="Void target Procedure/Function Call";
char*s848_33875A=");\n\173""\n";
char*s104_1502870799A="Bad empty character constant.";
char*s117_1737592965A="*/: return 1;\n";
char*s104_144939139A=" cannot be used just after agent keyword (it does not denote a feature call).";
char*s104_1409701608A="No more class BIT since release 2.1. Just use bit operations from  INTEGER_8, INTEGER_16, INTEGER_32, INTEGER or INTEGER_64.";
char*s104_1550836304A="Keyword \"class\" expected.";
char*s358_1186844731A="Bad target type. The expected type is ";
char*s386_30745830A="\' is out of INTEGER_32 range.";
char*s436_1134247532A="Found two possible default creation procedures for expanded type ";
char*s117_375072661A="char**se_argv";
char*s844_1278999019A="GC_invoke_finalizers();\nhandle(SE_HANDLE_EXIT_GC,NULL);\175""\n";
char*s767_849265556A=". Please check unicode charts.";
char*s111_298390A="Done.\n";
char*s104_734506354A="Opening \"<<\" of manifest generic creation expected.";
char*s113_721564652A=" NoVersion NoIcons";
char*s33_15448A="call";
char*s391_3147A="cpp";
char*s625_26975282A="(void*)&C";
char*s104_822318035A="Replaced misspelled \"Result\".";
char*s117_756717624A="Procedure without Current";
char*s33_207673214A="force_to_real_64";
char*s117_2057758694A="void thread_run";
char*s104_1926379486A="Ignored extra \",\".";
char*s659_1901947715A="/*[INTERNAL_C_LOCAL list*/\n";
char*s625_26975293A="(void**)&";
char*s499_1329824754A="Using `Void\' as an item of a manifest TUPLE is not good practice because `Void\' has no accurate type. You can work around by using an extra non-initialized local variable of some accurate type. Another work around is to use an explicit creation of the TUPLE. As an example `create \173""TUPLE[STRING,ANY]\175"".make_2(Void,Void)\' can be used to create a TUPLE[STRING,ANY] with default values.";
char*s283_2040665077A="Invalid collect value: must be either yes, no, or \"bdw\"";
char*s117_1811657197A="se_frame_descriptor fd=\173""\"<atexit wrapper>\",0,0,\"\",1\175"";\nse_dump_stack ds;\nds.fd=&fd;\nds.p=0;\nds.caller=NULL;\nds.exception_origin=NULL;\nds.locals=NULL;\nds.depth=0;\n";
char*s115_3169A="gcc";
char*s33_207673231A="force_to_real_32";
char*s728_26975309A="(void*)0,";
char*s642_3175A="if(";
char*s35_2248290A="version";
char*s34_3175A="end";
char*s647_653639191A="The `deep_twin\'/`is_deep_equal\' problem comes from this attribute.";
char*s120_938738041A="It is useless to undefine this deferred method.";
char*s848_884381655A="*)o)->header.flag=FSOH_MARKED;\n";
char*s729_3181A="elt";
char*s727_146599966A="*)se_malloc(sizeof(void*)))";
char*s729_156962A="(&(u->";
char*s705_46245A=".secd";
char*s105_1452518781A="Expected \"]\" (to finish generic argument list).";
char*s111_689013605A="Expanded Target Function Call";
char*s283_1389956963A="Please, also note that you can use the \"ace_check\" command\nto view all informations stored into your ACE file.\n";
char*s117_36460172A="Defining ";
char*s33_7095298A="FUNCTION";
char*s490_3196A="get";
char*s117_323348966A="se_general_trace_switch=(";
char*s117_2101369329A=";while (i-->0) \173""\nprint_profile(profile_file, sorted_profile+i);\n\175""\n";
char*s33_280482649A="Boolean_bits";
char*s104_279996728A="This alias can be used only as infix, needing exactly one argument.";
char*s648_3209A="\173""\nT";
char*s647_802840A="))))\174""((";
char*s647_1679626025A="((real64_t)(";
char*s625_3212A="u->";
char*s499_2088401A="make_..";
char*s642_602573626A="\173""int requireresult=1;\n";
char*s352_97896378A=" into formal type ";
char*s111_633144097A="The current directory ";
char*s33_1753751730A="free_native_data";
char*s113_9366A=".txt";
char*s104_1898638542A="Expression expected (\"inspect ... \").";
char*s104_1460213717A="End of manifest array expected.";
char*s105_92397395A="Closing \"\175""\" expected.";
char*s647_1278500877A="((T0*)se_string(";
char*s640_7224500A="INT16_C(";
char*s647_15533A="ceil";
char*s104_1452100558A="No more DOUBLE type mark (update your code). This DOUBLE type mark is automatically replaced with REAL which is actually equivalent to REAL_64. Also consider to use REAL_32 or REAL_80 when you prefer. Also consider command pretty to replace automatically all DOUBLE with REAL.";
char*s104_850458948A="Expression expected after the \"if\" keyword.";
char*s33_421505A="method";
char*s377_336696676A="\") this expression is the ";
char*s763_2068836731A="Overlapping slices. (Wrong inspect statement.)";
char*s104_1389575653A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a procedure using the previous CHARACTER constant as the target).";
char*s495_1088102843A="..........................";
char*s642_4179775A=")->id)\173""\n";
char*s120_2035830473A="\nFEATURE_STAMPs with rename  = ";
char*s104_638895319A="Missing \')\' to end `c_inline_h\' call.";
char*s640_40427625A="UINT16_C(";
char*s342_770157670A="Loop_variant";
char*s843_80501401A="Internal problem while searching for \"mark_item\".";
char*s424_835850355A=".....         local unique buffer          .....";
char*s111_498062040A="#(1)\nOriginal SmartEiffel code:\nCopyright (C), 1994-2002 - INRIA - LORIA - ESIAL UHP Nancy 1 - FRANCE\nCopyright (C), 2003-2005 - INRIA - LORIA - IUT Charlemagne Nancy 2 - FRANCE\nD.COLNET, P.RIBET, C.ADRIAN, V.CROIZIER, F.MERIZEN\n    http://smarteiffel.loria.fr\n";
char*s552_651043570A="specializing one type";
char*s625_1610470399A="\" is deferred in type ";
char*s848_834589410A="*)o)->header.flag==FSOH_UNMARKED)\173""\n";
char*s625_46337A="=(u->";
char*s283_1811847991A="Non empty unquoted name expected here.";
char*s117_660780608A="void se_prinT9(FILE* file, T9*o)";
char*s33_7704337A="PLATFORM";
char*s117_15589A="argc";
char*s647_1206509635A="o1,o2);\175""\n\175""\n";
char*s113_3291A="int";
char*s113_1346168095A="Unable to find the compiler type of \"";
char*s117_46350A="=1;\173""\n";
char*s33_33120277A="CHARACTER";
char*s729_38305571A="unsigned int rsoc_count_ceil";
char*s113_3294A="lcc";
char*s111_1255397791A="Will generate live type: ";
char*s117_616198177A="switch(((se_agent0*)a)->creation_mold_id)\173""\n";
char*s848_40205A="(o);\n";
char*s111_1928938448A=" formal generic arguments while the maximum allowed is ";
char*s349_70962A="Type ";
char*s117_960414291A="Agent call wrapper";
char*s126_1072344038A="SmartEiffel";
char*s101_15605A="args";
char*s475_1990220866A="Could not find any conformant common type to those expressions.";
char*s104_1725672511A="Type mark expected after a colon mark inside a local variable list.";
char*s117_2115332211A="\175""\nreturn 0;\n";
char*s125_287218105A=".... unique buffer ....";
char*s104_2008366323A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a function using the previous CHARACTER constant as the target).";
char*s111_1896793334A="\". This is not possible as this class is basically used by Liberty Eiffel internals. Please pick another name.";
char*s647_83277A="isinf";
char*s848_1316551052A="Unexpected closure on weak_ref\?!";
char*s286_1897894366A="Expanded classes can be inserted only.";
char*s489_1810101146A="Bad external \"C++\" definition.\nexternal \"";
char*s113_3320A="man";
char*s415_276773717A=" which is out of range -15..15 because target type is INTEGER_16.";
char*s483_1050501857A="` in class ";
char*s647_104084395A="((int8_t)(";
char*s583_13424808A="\011""create \173""";
char*s640_15629A="ddt1";
char*s370_83290A="item_";
char*s489_34086A="*)a1)";
char*s648_105695965A=")+a3tmp,((";
char*s660_58505493A="The Precursor routine is a deferred routine.";
char*s104_147793411A="Void is not a valid BOOLEAN expression (just after keyword \"if\").";
char*s34_1223234252A="debug_check";
char*s467_221949868A=" Actually, feature ";
char*s383_3337A="no ";
char*s844_835204573A="void*result=GC_MALLOC_ATOMIC(n*sizeof(bdw_Twr));\nse_check_malloc(result, \"No more memory (GC_MALLOC_ATOMIC failed).\\n\");\nreturn result;\n";
char*s104_1297544492A="\" is not valid keyword.\"";
char*s117_1125599439A="return((T0*)s);\n";
char*s729_259021955A="s=new7();\n";
char*s589_1500847347A="R = R \174""\174"" ((o1->_";
char*s113_150382995A="\"[General] bin\" key is missing.";
char*s291_360205908A="Too many live types (the maximum is ";
char*s104_1710947057A="Expression expected (";
char*s386_1731781A="Value `";
char*s104_760340765A="Syntax error while trying to parse the header of routine `";
char*s381_376260024A="Assignment of a reference type into an expanded type is not allowed.";
char*s117_562506158A=" se_manifest_args";
char*s767_1398420907A=" Missing character number ";
char*s648_129654140A=";\nmemcpy((";
char*s764_89481A="state";
char*s117_511465169A="Compiling routines for ";
char*s377_240593583A="\" (i.e. when the type of Current is \"";
char*s377_611824887A="In the context \"";
char*s625_3374A="new";
char*s495_192265186A="Cannot pass ";
char*s647_83345A="isnan";
char*s30_1102047298A="\" is not allowed when an ACE file (";
char*s104_1109293176A="Void cannot be used after unary \"+\" operator.";
char*s111_292482A="Class ";
char*s33_698215697A="Maximum_real";
char*s111_763853019A="\".\nToo long TUPLE (the TUPLE you want has ";
char*s642_23451005A="/*i*/=0;\n";
char*s117_3393A="lsv";
char*s104_883016350A="Missing \",\" added.";
char*s420_739187517A="Creation call on formal generic type (";
char*s117_693319512A="/*  - NO require*/\n";
char*s33_89510A="stdin";
char*s33_1297876698A="is_not_null";
char*s117_42279221A="Procedure";
char*s104_1390190909A="An expanded class cannot inherit from other classes, it can only have an \"insert\" clause (replaced).";
char*s642_2024156039A="/*[manifest INSPECT*/\n";
char*s648_1062582514A=")-a3tmp+1)*sizeof(T";
char*s283_1977886A="collect";
char*s34_3415A="old";
char*s678_22122412A=" because ";
char*s624_480740974A="if(*o==NULL)\173""fprintf(file, \"void\");return;\175""\n";
char*s115_15721A="dice";
char*s33_3421A="not";
char*s117_5164112A=", agent_profile, ";
char*s647_1338608648A="R=se_deep_twin_search((void*)C);\nif(NULL==R)\173""\n";
char*s844_1808489692A="(void*obj,void*_)";
char*s117_3430A="\175"";\n";
char*s642_169510A="++;\n\175""\n";
char*s117_1855175789A="se_profile_t atexit_profile";
char*s104_1166362205A="\'. Missing function type\?";
char*s113_759424351A=" is not supported as a C++ compiler. I will continue, but expect some problems.\n";
char*s104_2060176323A="Expression expected.";
char*s490_83406A="macro";
char*s33_15751A="code";
char*s108_1449185201A="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
char*s111_3451A="\175"".`";
char*s117_2123070311A=", agent_switch_profile, ";
char*s848_1242450095A="if (size<=(";
char*s104_239621812A="Bad create expression (\'\175""\' expected).";
char*s117_3457A="orp";
char*s289_1534075159A=" does not have ";
char*s412_362752532A="Invalid comparison of expression ";
char*s356_1742784741A="Feature found is not a procedure.";
char*s377_1485100899A="..... unique buffer 2 .....";
char*s104_95110222A="Added missing \")\"";
char*s33_3460A="\174""<<";
char*s729_1203674198A="#ifndef FIXED_STACK_BOTTOM\nif(!valid_stack_bottom) stack_bottom = (void**)(void*)&valid_stack_bottom;\n#endif\n";
char*s113_1067454155A="Reading loadpath files\n";
char*s848_46525A=">1)\173""\n";
char*s33_3472A="\174"">>";
char*s113_270309168A="Currently handled compiler names:\n";
char*s33_3474A="pow";
char*s117_3475A="se_";
char*s117_2038260346A="else fprintf(SE_ERR, \"Cannot open profile.se for writing.\\n\");\n\175""\n";
char*s904_10220290A="function";
char*s113_423056960A="                      ";
char*s640_3485A="vc(";
char*s113_592781506A="Local Cluster";
char*s647_1821634438A="(((se_agent*)C)->u0.eq==((se_agent*)a1)->u0.eq)&&(((se_agent*)C)->u0.eq((se_agent*)C,(se_agent*)a1))";
char*s637_22854451A="/*:RF2*/)";
char*s117_120095614A=";while (i-->0) \173""\nprint_profile(profile_file, sorted_inv_profile+i);\n\175""\n";
char*s33_1418282620A="INTEGER_GENERAL";
char*s625_20240284A="),&(a2->c";
char*s115_3494A="tcc";
char*s117_325655889A="#define SE_SEDB 1\n";
char*s490_3496A="set";
char*s383_1317154036A="live id-field: ";
char*s416_176211197A=" which is of type ";
char*s377_1984383762A="For inspect statement, the expression type can be only INTEGER, CHARACTER, STRING, or FIXED_STRING. (Actually ";
char*s33_3501A="put";
char*s104_46597328A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a function using the previous `True\' constant as target).";
char*s104_1631593164A="Void cannot be the left-hand side of the binary \"*\" operator.";
char*s848_1173325215A="void gc_update_weak_ref_item";
char*s122_253892190A="exceptions";
char*s497_1387816739A="Cannot rename feature `c_inline_h\' because this name is used as a keyword to handle the corresponding \"built_in\" feature of ANY.";
char*s849_136857117A=",(unsigned long)(";
char*s624_1199805276A="fprintf(file,\"\\n\\t[ \");\n";
char*s416_256961544A="The left-hand side of an assignment attempt must not be expanded. (Actually, the left-hand side is of type ";
char*s120_1129671576A="Assigned feature is not a query in type";
char*s91_3520A="ti_";
char*s113_15828A="cpml";
char*s848_1058430701A="o1->header.next=gc_free";
char*s117_1728206941A="((/*UT*/(void)(";
char*s117_333756789A="/*  - routine body*/\n";
char*s33_15831A="copy";
char*s33_1947246A="bit_set";
char*s29_1767481079A="precompile_header";
char*s111_1225577982A="Reference Target Monomorphic Procedure Call";
char*s104_1522646678A="Missing \'(\' after `c_inline_c\'.";
char*s33_1947251A="bit_put";
char*s729_1713875121A="GC support: generating header.\n";
char*s34_77350A="alias";
char*s117_1571473322A=";\nwhile (i < argc) \173""\n";
char*s439_1379248421A="Formal generic name appears twice in formal generic list (VCFG.2).";
char*s104_201048978A=" cannot be used just after agent keyword. The type of the target must be given. Consider using the curly braces notation, e.g. `\173""TARGET_TYPE\175""\'.";
char*s805_789213750A=" (kept)\nRedundant definition ";
char*s33_3545A="run";
char*s849_692716864A=".space_used);\n";
char*s640_4622950A="/*NAI*/(";
char*s650_646768902A=";\n\173""\nstatic ";
char*s708_1499315956A="No split enabled.\n";
char*s91_1462938943A="NATIVE_ARRAY[NATIVE_ARRAY[...]] is not currently supported by the introspection system.";
char*s577_3557A="tmp";
char*s117_1965730A="break;\n";
char*s105_176469602A="In extended form of manifest string. Bad character before \'%\'.";
char*s283_2100317873A="Unquoted filenames are deprecated. Please add quotes here.";
char*s104_3567A="top";
char*s625_9720A="=CA_";
char*s843_936093505A="native_array_collector_tag";
char*s765_858562A=" _NULL ";
char*s640_23186700A="/*NVND*/(";
char*s727_28273584A=",sizeof(T";
char*s117_357794960A="T0* se_manifest";
char*s104_161325869A="Empty manifest array is not a valid notation. If you want to create an empty ARRAY, just use an ordinary creation call of class ARRAY.";
char*s647_304601115A="signal_exception_number";
char*s729_9980517A="gc_sweep";
char*s34_3595A="sys";
char*s848_1645106999A=",\n(void(*)(mch*))";
char*s489_852437A="*)a1)->";
char*s117_77412A="case ";
char*s34_3601A="use";
char*s97_1229059519A="Bad root procedure name (\"";
char*s117_726227573A="*sizeof(se_profile_t));\nqsort(sorted_profile, ";
char*s117_434116584A="*sizeof(se_profile_t));\nqsort(sorted_agent_profile, ";
char*s729_15915A="if((";
char*s104_1061217192A="Classes with an external type must be expanded or deferred.";
char*s126_1342164121A="It is now ignored and replaced by a lookup of the LibertyEiffel variable. Please update your file.\n";
char*s727_1193180751A="s=((T7*)se_malloc(sizeof(T7)));\n";
char*s95_1554312113A=".... local buffer ....";
char*s848_239388241A="n->object=";
char*s625_9775A="=CL_";
char*s33_279523519A="to_pointer";
char*s283_551231644A="Multiple ACE files in the command line: \"";
char*s97_620670284A="\nparent-count: ";
char*s552_965507650A="inlining dynamic dispatch";
char*s904_1676707A="Plugin ";
char*s117_1065652086A="\173""\nFILE *profile_file = fopen(\"profile.se\", \"w\");\nif (profile_file!=NULL) \173""\nint i;\nse_profile_t sorted_profile[";
char*s846_882069342A=";\nstruct GC_B";
char*s729_1549077634A="handle(SE_HANDLE_ENTER_GC,NULL);\n";
char*s642_206626A=";\nelse";
char*s554_1015749028A="/usr/local/etc/liberty-eiffel";
char*s283_3645A="yes";
char*s649_54686040A="return ((";
char*s30_1009954795A="\". Must not use Eiffel source file suffix with option \"-o <executable_name>\".";
char*s728_1527912055A="GC_disable();\n";
char*s117_1723513855A="stop_profile(parent_profile, &local_profile);\n";
char*s34_89771A="trace";
char*s729_961294240A="if(!gc_is_off && !garbage_delayed())\173""\n";
char*s111_2106290588A="Exponent of infix \"^\" must be a positive INTEGER. Exponent actual value is \"";
char*s104_1522646803A="Missing \'(\' after `c_inline_h\'.";
char*s33_577213499A="is_not_a_number";
char*s467_82722309A="Bad constant-attribute definition. ";
char*s104_375534514A="Bad creation instruction (type or \'!\' expected).";
char*s33_3669A="xor";
char*s659_1750246116A="Declared INTERNAL_C_LOCAL: ";
char*s624_1199620901A="fprintf(file,\"\\n\\t  \");\n";
char*s506_79148593A="is_empty_expanded";
char*s33_911175911A="internals_from_generating_type";
char*s642_1631421108A="/*storage*/=((";
char*s904_28287A="\" at ";
char*s647_755813960A="]), se_argv[";
char*s33_169371474A="DISPOSABLE";
char*s104_57337161A="This alias can be used only as prefix, needing exactly zero argument.";
char*s291_1539722017A=" correct items).\n";
char*s34_16001A="else";
char*s126_852938266A="**** Renaming failed!\n";
char*s117_395316170A=" */\nif (expression == NULL) return 1;\n";
char*s33_1947419A="bit_xor";
char*s117_1565125654A="];\nse_profile_t sorted_inv_profile[";
char*s462_1087076085A="Double definition of feature ";
char*s420_581709925A=" is not in the creation list of type ";
char*s362_1687352176A="Missing anonymous feature for this call.";
char*s729_89821A="store";
char*s117_1773201687A="\n#ifdef __cplusplus\n\175""\n#endif\n";
char*s97_1914699291A="Wrong number of generic argument";
char*s120_429361964A="Can\'t join these two concrete features. What\'s called a concrete feature here is a feature which is not deferred. You may consider to undefine one feature. May be.";
char*s104_1453066751A="Must use exactly 16 hexadecimal digits for INTEGER_64.";
char*s117_56845112A="volatile ";
char*s435_1288915017A="... unique buffer ...";
char*s415_1469170081A="Overflow of infix \"*\" with INTEGER_64 operands. (";
char*s825_1635136368A="\" (resolved as \"";
char*s34_937397683A="The $ operator must be followed by the final name of a feature which is not a constant attribute or by the name of some local variable as well.";
char*s117_926388A="/*PCO:\173""";
char*s349_1524252299A=". Signature of the redefined feature is not valid.";
char*s342_560316788A="No_more_memory";
char*s33_2218105A="rounded";
char*s113_89862A="strip";
char*s291_411001267A=" in any cluster. Don\'t expect the compilation to succeed.\n";
char*s416_1933023161A=".) Invalid assignment test.";
char*s117_671483818A="se_thread_register();\n";
char*s414_1140411454A="The declaration type of this expression is ";
char*s33_203589551A="manifest_initialize";
char*s647_9905A="C->_";
char*s647_34510A="))\174""\174""(";
char*s117_449414272A="#define SE_THREAD 1\n";
char*s642_3760A="\175""\175""\n";
char*s97_510352234A="A class cannot be expanded and deferred (VTEC.1).";
char*s409_1128496981A=" can be assigned into ";
char*s104_407741255A="_inline_agent";
char*s117_22971612A="];\nmemcpy(sorted_profile, profile, ";
char*s764_560556710A="\") in the same inspect.";
char*s117_1316373138A="/*se_evobt*/";
char*s415_944882A=" times ";
char*s625_403595A="u->CA_";
char*s647_2030510390A=",C->_capacity);\n";
char*s506_52976196A="long_name";
char*s111_956422775A="Simplify done";
char*s425_1931700734A="Here is the corresponding feature definition (not an attribute).";
char*s580_638047023A="Call on a Void target in the live code (when the type of Current is ";
char*s283_1737556726A=". The first one is in the cluster \"";
char*s33_275488632A="Maximum_double";
char*s283_2044479327A="\nEiffel class file searching is being done according to the ACE file \"";
char*s35_77608A="cecil";
char*s647_9980719A="if(R)R=r";
char*s117_122027336A="init_profile(&prof, \"se_msi";
char*s848_40705A=")n);\n";
char*s34_2593373A="cpp_linker_options";
char*s126_113009974A=" in file \'";
char*s479_907165587A=" appears at least twice. The client lists will be merged, but please fix the export clauses.";
char*s651_2187411A="se_atT[";
char*s904_1760616840A="Could not load the plugin; one dependancy is not satisfied: location <";
char*s283_1799491166A="\" in any known cluster.";
char*s447_892969089A="   default assertion (";
char*s111_1194472660A="Reference Target Monomorphic Function Call";
char*s104_1943393816A="Argument name ";
char*s489_9808515A="delete((";
char*s805_65332A="] in ";
char*s625_2187432A="return ";
char*s728_357653724A=")GC_call_with_alloc_lock((GC_fn_type)bdw_weakref_getlink,(bdw_Twr*)(";
char*s625_403650A="u->CL_";
char*s105_372047073A="Deleted extra separator.";
char*s678_1864907075A="To many actual arguments for agent call. (The agent you are trying to call has no arguments.)";
char*s117_1595351811A="(/*thread context*/T";
char*s104_1786174287A="Must use exactly two hexadecimal digits for a CHARACTER constant.";
char*s33_440571A="target";
char*s104_2082787810A="Error while reading a real. Missing \"\175""\" \?";
char*s283_1059495149A="Root class #";
char*s111_388205767A="Total Number of \"inspect\" used for Dynamic dispatch: ";
char*s33_1604522960A="to_integer_8";
char*s293_2064444A="infix \"";
char*s33_2187464A="se_argc";
char*s117_697705640A="sorted_all_profile[";
char*s291_188525860A="Corrupted *.id file (after ";
char*s34_49076540A="assertion";
char*s281_1587749191A="Aliased STRINGs: ";
char*s113_143937264A="-subsystem";
char*s111_1131498768A=" does not belong to any known cluster.";
char*s283_452889A="system";
char*s117_1450791030A="[hc]\" not found).";
char*s850_1411018665A=".store_left=0;\n\175""\n";
char*s436_2134616155A=" is expanded).";
char*s412_333554149A="Such a weird comparison with Void is not allowed because it would be always ";
char*s117_397592212A="\",1\175"";\nse_dump_stack ds;\n";
char*s35_16177A="help";
char*s412_461679483A="Cannot compare an expanded expression with a reference expression.";
char*s33_2187483A="se_argv";
char*s648_1502256459A="]),&a1tmp,sizeof(T";
char*s104_1491971992A="Void is not a valid target (i.e. just before an alias \"()\").";
char*s623_11241768A="struct S";
char*s34_59251A="False";
char*s293_1224218969A="The source lines involved by the message are the following:\n\n";
char*s293_1750778A="Warning";
char*s112_2107398012A="\nLiberty Eiffel The GNU Eiffel Compiler, Eiffel tools and libraries\n    release #(1)\n\nCopyright (C), #(2) - #(3)\n    http://www.liberty-eiffel.org\n";
char*s106_745978733A="\' is defined more than once";
char*s117_2123661269A="/*  - NO user expanded*/\n";
char*s848_384078512A="\173""rsoh*h=((rsoh*)o)-1;\nif((h->header.magic_flag)==RSOH_UNMARKED)\173""\nh->header.magic_flag=RSOH_MARKED;\n\173""\n";
char*s111_2045223723A="Cannot collect feature \173""";
char*s678_191115496A=". Its type is ";
char*s370_2082970A="item_xx";
char*s117_522691310A="ds.caller=NULL;\nds.exception_origin=NULL;\nds.locals=NULL;\n";
char*s110_1442714837A="Assignment graph: ";
char*s113_1056930268A="You can also have a look at http://liberty-eiffel.blogspot.com/wiki/index.php/";
char*s648_2187545A="se_die(";
char*s104_1687580001A="Void is not a valid expression inside \"when\" part of an inspect statement.";
char*s104_1301660112A="Bad formal arguments list.";
char*s117_1266427187A="if (!prof_init)\173""memset(&prof,0,sizeof(prof));prof_init=1;\175""\n";
char*s504_455005721A="Same type appears more than once.";
char*s117_1136118256A="............ unique buffer ...........";
char*s485_779913846A="Error in until part of loop definition.";
char*s381_389128515A=" Cannot assign Void into ";
char*s660_7440512A="Feature ";
char*s647_77767A="ceilf";
char*s117_2060090728A="fprintf(file, \"NATIVE_ARRAY[CHARACTER]#%p\\n\",(void*)*o);";
char*s283_641030424A="Non empty quoted string expected here.";
char*s647_77773A="ceill";
char*s848_1869083728A="void gc_update_weak_ref_item_polymorph(Tgc* item)";
char*s34_16264A="from";
char*s34_9790205A="deferred";
char*s621_1476287022A="typedef T0 T";
char*s844_646707803A=")se_malloc((*n)*sizeof(T";
char*s104_99041221A="\' instead.";
char*s848_1847665958A="=o1;\n\175""\n\175""\nif(dead)\173""\ngc_free";
char*s640_7225250A="INT32_C(";
char*s640_2187584A="se_cmp1";
char*s640_2187585A="se_cmp2";
char*s34_265093627A="loop_check";
char*s117_1234811086A="memcpy(sorted_all_profile, profile, ";
char*s414_435568604A="\"if\" (or \"elseif\" as well) must be followed by a BOOLEAN expression.";
char*s729_34749A="*)new";
char*s32_635943583A="Feature `is_deep_equal\' not found in class ANY. Really, you should not try to write or modify the ANY class provided with Liberty Eiffel.";
char*s105_175744216A="Added \"(\".";
char*s117_700572143A="init_profile(inv_profile+";
char*s33_1223936132A="deep_memcmp";
char*s640_40428375A="UINT32_C(";
char*s342_1207039342A="Void_attached_to_expanded";
char*s415_511502716A="Cannot divide ";
char*s33_37186806A="NATURAL_8";
char*s825_1847764413A="Cycle detected:\n";
char*s625_2187619A="se_cmpT";
char*s642_809795A="((T0*)(";
char*s383_4488096A=" feature";
char*s625_208313786A="ds.caller=caller;\n";
char*s105_175744241A="Added \")\".";
char*s33_77832A="blank";
char*s283_1667312535A="Cluster path expected after cluster name.";
char*s283_90141A="wedit";
char*s403_1814961148A="Unused local variable.";
char*s467_161769183A=") cannot be used as the definition of the feature ";
char*s379_432936020A="Cannot find Base Class for ";
char*s117_889346373A="global_profile=local_profile;\n";
char*s117_4980205A=",NULL);\n";
char*s104_872019014A=" or the whole expression as well. It\'s up to you to decide now.";
char*s120_7612837A="In type ";
char*s342_41769343A="Os_signal";
char*s283_1984169029A="Cannot find the class \"";
char*s104_1476889913A="Empty list not allowed for manifest generic creation.";
char*s729_2039472678A="stack_bottom=((void**)(void*)(&argc));\n";
char*s583_26108906A="Unknown feature name ";
char*s33_65574A="TUPLE";
char*s117_1417828020A="T0* se_manifest_args";
char*s33_197002151A="force_to_natural_64";
char*s642_440120430A=")->_storage_lower;\n";
char*s729_533301931A="void(*gc_mark_agent_mold)(se_agent*);\n";
char*s648_388821092A="Class NATIVE_ARRAY has been tampered with. Unknown procedure: ";
char*s104_1160088831A="\" cannot be a valid class name (only upper case letters are allowed in class names). \"";
char*s104_902126A=" first.";
char*s642_2089246593A="if(requireresult)\173""\n";
char*s647_234855416A="_t)(((uint";
char*s33_550709268A="NATIVE_ARRAY_COLLECTOR";
char*s117_253935823A="];\nse_profile_t sorted_agent_profile[";
char*s97_1468715266A=". This creation call is thus not allowed.";
char*s33_197002168A="force_to_natural_32";
char*s104_732932648A="Load class \"";
char*s625_657822788A="ds.fd=&se_ifd";
char*s642_2353775A="\175""else\173""\n";
char*s105_1836169859A="Unexpected character in hexadecimal unicode.";
char*s34_434665A="option";
char*s105_175744316A="Added \",\".";
char*s117_2060613700A="T0*se_string(";
char*s425_626532654A="This feature name is not an expression (no result and not writable).";
char*s33_197002174A="force_to_natural_16";
char*s489_397949195A="\"\n_________";
char*s408_647790517A="This variable is used in a closure. Beware, each time the method is called, a lot of memory may be wasted.";
char*s117_1922677534A="/*  - NO local vars*/\n";
char*s117_2114508771A="int c,char*e)";
char*s283_1805205737A="Files are being searched for in the following list of clusters (";
char*s33_573080478A="raise_exception";
char*s412_2089449608A="An expanded value can be compared only with the same other expanded value. Expression ";
char*s767_1139569132A="Invalid byte in UTF-8 sequence. This character is  number ";
char*s113_1832417772A="Bad use of command `";
char*s648_84085A="\174""(1<<";
char*s104_1732402521A="Instruction expected.";
char*s642_47187A="==0) ";
char*s619_1152812249A="/* Extra external prototype for line ";
char*s120_1248054333A="Add undefine or redefine to all inherited version of feature ";
char*s33_53339A="ARRAY";
char*s30_1335263213A=": missing file name after -cecil flag.\n";
char*s729_1085305030A="gc_align_mark";
char*s291_838840612A="Previous IDs reloaded (max_id = ";
char*s110_1616517694A="destination-graph-nodes: ";
char*s621_1476281050A="typedef uint";
char*s589_742356033A="typedef struct S";
char*s844_1456062714A=",NULL,NULL,NULL);\no->bdw_markna=(void*)HIDE_POINTER(markna);\n*markna=(T0*)o;\nGC_GENERAL_REGISTER_DISAPPEARING_LINK(&(o->bdw_markna),markna);\nbdw_in_assign=0;\nGC_enable();\nif(bdw_delayed_finalize)\173""\nbdw_delayed_finalize=0;\nreturn NULL;\175""\175""\nreturn o;\n";
char*s33_49076823A="clear_all";
char*s117_1858528797A="\n(fprintf(SE_ERR,\"%s\\n\",";
char*s625_1949908058A="*u=(void*)new_agent(";
char*s117_10940631A="se_evobt";
char*s727_870210728A="fprintf(SE_ERR,\"No GC compiled in, no information available\\n\");\n";
char*s111_218672210A=".............. once unique buffer ......................";
char*s447_397660162A="   exclude ";
char*s30_375350487A=": the \"-case_insensitive\" flag is no longer supported.\n";
char*s113_1361085152A="@linkit.com\ndelete linkit.com;";
char*s366_556780396A=" arguments.";
char*s729_1403828457A="store_chunk";
char*s493_1610077639A=" open operand expression is out of \"agent\" keyword scope.";
char*s117_16487A="int ";
char*s104_398318341A="\' does not fit on INTEGER_64).";
char*s370_731327330A="Agent calls need a tuple!";
char*s105_595894613A="Unexpected character in decimal ascii code.";
char*s104_1174611449A="Separator expected to end hexadecimal constant.";
char*s764_2027238465A="Only manifest strings are accepted in \"when\" clauses of \"inspect\" (in order to ensure that the STRING won\'t change at runtime). Note that even a constant of type STRING can have its content changed at runtime.";
char*s34_78002A="check";
char*s377_165601417A="CHARACTER ";
char*s767_1927020241A="Invalid unicode value: 0x";
char*s349_1246984134A=") this type mark is resolved as ";
char*s728_1062817045A="GC support (root functions).\n";
char*s117_1617526527A="se_dump_stack ds;\nds.fd=&fd;\nds.p=0;\nds.caller=caller;\nds.exception_origin=NULL;\nds.locals=NULL;\nds.depth=0;\n";
char*s642_16510A="\175""\n\175""\n";
char*s33_1202672333A="with_capacity";
char*s104_897447412A="Cannot use ";
char*s113_19761224A=" Data=Far";
char*s825_1959331451A="Empty loadpath: \"";
char*s848_1990989A="if(((gc";
char*s104_521861207A="The convert support is EXPERIMENTAL (work in progress).";
char*s117_5367889A="*eiffel_root_object";
char*s104_586311386A="Bad creation instruction (\'!\' expected).";
char*s625_422487A="locexp";
char*s117_47278A="==0)\173""";
char*s104_1093012317A="Second identifier of a \"rename\" pair expected.";
char*s104_1437345301A="Syntax error while trying to parse the beginning of a new feature definition. Feature name expected. Class name ";
char*s904_2072196164A="The default key \"function\" was not found. Invalid auto_init file.";
char*s33_1744612358A="is_basic_expanded_type";
char*s104_1759774576A="You are probably trying to use the new inherit/insert mechanism. With Liberty Eiffel, this can be achieved thanks to the new \"insert\" clause. The new \"insert\" clause comes just after the traditional \"inherit\" clause with a similar syntax.";
char*s456_1118729658A="When the context of the validation is ";
char*s117_2096892436A="p[0]=\"\?\?\?\";\n";
char*s420_1061310076A="). No create constraint specified.";
char*s104_4235A=" \011""\000""\n";
char*s111_1610926534A="Void target Procedure Call";
char*s104_1154110220A="Cannot use anchored type mark definition as a valid parent.";
char*s282_956361723A="Remainder: \"";
char*s117_1110850242A="fprintf(profile_file, \"\\n===============================================================================\\n\");\n";
char*s117_1377391529A="Executable is up-to-date (no C compilation, no linking done).\n";
char*s647_884813300A=";\nT0*o2=a1ptr->_";
char*s647_4881995A="->id)==(";
char*s117_1197714671A="(T0* expression)";
char*s642_840791A="((void)";
char*s105_543076045A="Type mark expected.";
char*s650_4256A="\n_r=";
char*s729_280766651A="store_left";
char*s106_42698349A="The key \'";
char*s705_928596125A="\" not changed.\n";
char*s117_246893097A="v=ac_lvc(c++,v,";
char*s117_1911279888A=")));\nC[i]=element;\ni++;\n\175""\nva_end(pa);\nreturn C;\n";
char*s104_1454703466A="Void is not a valid target (i.e. just before a dot).";
char*s409_332834879A="forced assignment (\"::=\").";
char*s383_78082A="dead ";
char*s113_1223801083A="Selecting C++ compiler: ";
char*s416_1907958363A=". (This assignment test is always True.)";
char*s495_94643563A=" is deferred. (Cannot create object.)";
char*s89_650029656A=". Compiler lost! ";
char*s647_17743770A=")\n#endif\n";
char*s117_1964848975A="start_sumup_profile(profile_file);\ni=";
char*s728_871385705A="GC_dump();\n";
char*s104_688657949A="Empty \"when\" clause in \"inspect\" statement.";
char*s34_90408A="until";
char*s848_1314337673A=".store_left))\173""\nrsoh*r=";
char*s105_1242149539A="Right hand side expression of := assignment expected here.";
char*s33_7748406A="REAL_128";
char*s538_840796792A="Empty manifest array not allowed. (If you really need to do it, just replace it with something like:\ncreate \173""ARRAY[ANY]\175"".make(1, 0)";
char*s640_3934795A="(((T0*)(";
char*s729_4308A="\011""id:";
char*s342_198146473A="Class_invariant";
char*s104_126038302A="Writable entity expected here (`Current\' is not writable).";
char*s33_16616A="last";
char*s113_2121681051A="Unknown C++ compiler type \"";
char*s640_36122993A="INT16_MIN";
char*s844_182705A="0*));\n";
char*s415_1718483009A="Overflow for opposite of Minimum_integer_8.";
char*s34_16630A="jobs";
char*s106_1784452489A="Could not execute \'";
char*s34_10208843A="external";
char*s34_56255230A="undefined";
char*s113_725963810A="\". Please fix your configuration file or choose another C mode.";
char*s33_16639A="item";
char*s33_78150A="atan2";
char*s104_2016523575A="In compound (";
char*s456_1888871872A="TUPLE type expected for open arguments of agent type. (See also the next fatal error message.)";
char*s34_1730514379A="cpp_compiler_options";
char*s512_1879799154A="Must not use old inside some old expression (VAOL.2).";
char*s642_1553642381A="default: error1(\"Invalid ::= assignment (inserted type).\",";
char*s687_1166590709A="Deferred feature must not have rescue compound.";
char*s848_1396798042A=".store_left-=size;\nif(";
char*s33_705019679A="die_with_code";
char*s33_1339128A="BOOLEAN";
char*s624_25641730A="(file,(&(";
char*s33_451899881A="type_attribute_name";
char*s33_1297145705A="is_finished";
char*s115_59731A="Elate";
char*s551_2014364610A="run-time-set:\n";
char*s113_39204698A="SCOPTIONS";
char*s113_61342149A="No information available about the system used (check your\nLiberty Eiffel installation).\n";
char*s104_768172015A="Hexadecimal digit expected while reading CHARACTER constant.";
char*s488_1979303915A="\":\" expected";
char*s647_17743865A=")\n#else\n(";
char*s370_416499A="item_1";
char*s105_1226144723A="Variable `Result\' is valid only inside a function.";
char*s370_416500A="item_2";
char*s377_61858840A=" which is not allowed.)";
char*s33_16686A="make";
char*s848_1279738389A="++;\n\175""\nelse\173""\nc=gc_fsoc_get1();\nif(";
char*s371_881547256A="Cannot use here a manifest STRING because the previous one used in this \"inspect\" statement is not a manifest STRING.";
char*s35_385751A="c_mode";
char*s33_999658760A="THREAD_LOCK";
char*s849_666336072A=")\nfprintf(SE_GCINFO,\"%d\\t%lu\\t%d\\t";
char*s849_41300A=";\nif(";
char*s704_355003A="][0-9]";
char*s844_1037766A="(int n)";
char*s117_561301605A="*/: error2(expression,/*unknown-position*/0);break;\n";
char*s117_988839165A="se_frame_descriptor root=\173""\"<system root>\",1,0,\"";
char*s386_31214580A="\' is out of INTEGER_16 range.";
char*s647_106047655A="),a1ptr->_";
char*s283_2085574777A="external_lib";
char*s846_1006394131A="TLS(na_env)";
char*s104_996097357A="Prefix functions cannot have arguments.";
char*s113_84381A="mieee";
char*s283_416541A="legacy";
char*s642_4425A="\nif(";
char*s624_1511378937A="fprintf(file,\"#%p\",(void*)*o);\n";
char*s33_90544A="upper";
char*s117_280139425A="uint16_t s";
char*s409_29037A=" ::= ";
char*s728_255799920A="GC_invoke_finalizers();\nhandle(SE_HANDLE_EXIT_GC,NULL);\n";
char*s767_888288799A="Overlong sequence, must be refused by any UTF-8 complient decoder for security reasons.";
char*s34_427898753A="# Beginning of parallelizable section";
char*s642_847125A=");\nif (";
char*s647_111269879A="R=se_deep_equal_search(C,a1);\n";
char*s349_2084824380A=" (More explaination below.)";
char*s282_988261007A="Bad external signature (missing opening \"(\" delimiter.";
char*s117_1240218271A="se_argc=argc;\nse_argv=argv;\n";
char*s105_175744666A="Added \":\".";
char*s709_1085938891A="By-type splitter enabled.\n";
char*s554_32450971A="C:\\SE.CFG";
char*s554_311952415A="liberty-eiffel";
char*s640_920950A="/*IC*/(";
char*s34_78263A="debug";
char*s642_958274895A="!=NULL)\173""error1(\"Invalid ::= assignment (inserted type).\",";
char*s648_804085A="&(\176""(1<<";
char*s117_561947515A=" element=((";
char*s34_16761A="like";
char*s763_786403659A="Internal error inside WHEN_ITEM_2 (compiler error).";
char*s117_758545786A="*)c;\nva_list pa;\nint i=i0";
char*s104_1559455194A="Expression \"old\" can be used in ensure clause only (VAOL.1).";
char*s117_21391495A=",((void)(";
char*s105_175744691A="Added \";\".";
char*s104_1421961899A="The basic = operator cannot be redefined. (This is a hard-coded builtin that we must trust.)";
char*s363_1479430694A="This call has no result.";
char*s447_597973944A="Could not load class in cluster ";
char*s117_16782A="link";
char*s34_84443A="local";
char*s710_161074567A="<Universe>";
char*s420_182862A=" into ";
char*s111_1914558593A="The root class must not be expanded (sorry, but this is a limitation of the compiler).";
char*s111_1450022771A="Unknown feature `";
char*s625_430519127A="ds.locals=locals;\n";
char*s104_611217054A="Error in constant or manifest creation.";
char*s409_138555764A=" by using an ordinary \":=\" assignment ";
char*s113_1615398571A="..................................";
char*s790_1400894751A="... once unique buffer ..................................";
char*s117_2086571326A=");\n\175""\nva_end(pa);\nreturn c;\n";
char*s108_1880881887A="................";
char*s767_263008962A=" bytes sequence.";
char*s33_839855894A="TEXT_FILE_WRITE";
char*s104_1075925125A="Must not use local variable in ensure assertions (VEEN).";
char*s104_488830629A="Void cannot be the left-hand side of infix operator \"";
char*s349_2050169721A="In the parent context (i.e in ";
char*s647_1174230416A="_t)((((uint";
char*s111_1661328107A=". Yours is in the cluster \"";
char*s33_2126626A="or else";
char*s117_179423058A="if(ds.fd->assertion_flag)\173""\nds.fd->assertion_flag=0;\n";
char*s111_42846255A="No such TUPLE definition in file \"";
char*s409_1816745449A="::= assignment (a forced assignment).";
char*s488_56907446A="type_name";
char*s729_614557109A="/*NON_VOID_NO_DISPATCH:*/\n";
char*s488_10559665A="location";
char*s589_1208522276A="typedef int T";
char*s729_1215177661A="\173""int i=SE_MAXID-1;\nwhile(i>=0)\173""\nif(g[i]!=NULL)gc_mark7(g[i]);\ni--;\175""\n\175""\n";
char*s120_576322499A=" cannot be an assigner of the feature ";
char*s415_1592935176A=" which is out of range 0..7 because target type is INTEGER_8.";
char*s33_324411A="STRING";
char*s33_1739790308A="type_generator";
char*s97_15142174A="Bad root class (this class has no creation clause).";
char*s647_195246A="->id))";
char*s589_1502207936A="R = R \174""\174"" se_cmpT";
char*s713_1345295929A="Multiple rename for the same feature is not allowed.";
char*s113_149455415A="Unknown compiler type \"";
char*s647_1605175681A="se_deep_twin_start();\n";
char*s370_22271191A=" argument";
char*s467_375578482A="Value out of INTEGER_8 range.";
char*s625_948421114A=";\nds.current=((void*)&C);\n";
char*s625_35330A=" afp_";
char*s33_16877A="lock";
char*s120_784841421A="Unable to solve cyclic anchored types.";
char*s104_107634778A="Because of the usual low priority of prefix minus, `-foo.bar\' is actually equivalent to `-(foo.bar)\'. In order to avoid a possible mistake here, it is mandatory for you to add extra parentheses here. You can wrap ";
char*s415_350193314A="Overflow of infix \"-\" with INTEGER_64 operands. (";
char*s729_269141588A="\173""/*mark_item*/\n";
char*s106_1043946153A="Unexpected text continuation";
char*s113_1515266530A="You must choose either -cc or -c_mode, but you cannot use them both.";
char*s117_1065942137A="print_profile(profile_file, &root_profile);\n";
char*s104_104977558A="Inline agent or expression expected after agent keyword.";
char*s412_401707956A=" is obviously expanded (i.e. the written type mark is \"";
char*s489_16902A="new ";
char*s436_1878889060A="Feature `manifest_make\' must have at least one INTEGER argument.";
char*s117_18131599A="se_dump_stack*,";
char*s554_1185594A="/sys/rc";
char*s848_784300160A=";\no2=o1+c->count_minus_one;\nfor(;o1<=o2;o1++)\173""\nif((o1->header.flag)==FSOH_MARKED)\173""\no1->header.flag=FSOH_UNMARKED;\n";
char*s501_850294241A="Actual argument list of Precursor call doesn\'t match the procedures signature.";
char*s33_243411981A="bit_rotate";
char*s33_1419919903A="Maximum_character_code";
char*s104_2102385657A="Empty Cecil file (use -verbose flag for details).";
char*s415_211605167A="Overflow of infix \"-\" with INTEGER_8 operands. (";
char*s104_762747069A="\"retry\" cannot be outside of a rescue clause.";
char*s113_466551816A="$ link/exe=";
char*s113_2009849A="generic";
char*s117_1743948446A="==2, \"Recursive once function.\");\n\175""\n";
char*s850_1682659883A=".chunk_list=NULL;\n";
char*s848_1007239A="*b=((gc";
char*s807_630125369A="**** Fatal error: no $#(1) defined!";
char*s104_2028592127A="Removed unexpected blank space(s) just before this dot (assume you really want to call a procedure using the previous manifest expression as the target).";
char*s97_1838187926A="class-name: ";
char*s104_214231661A="This alias can be used only as prefix, needing a Result type.";
char*s489_1163823042A="\nSee SmartEiffel/tutorial/external/C++ directory for more information.\n (Internal state = ";
char*s807_17725666A="#(1)/#(2)";
char*s33_1770803725A="from_external_sized_copy";
char*s34_16942A="loop";
char*s764_989731302A="Second occurrence of this value (\"";
char*s409_897982986A=" (\"\?=\" is not necessary).";
char*s111_1783880762A="Collecting done";
char*s844_1038016A="(int*n)";
char*s34_10049231A="generate";
char*s642_206419907A="fd.assertion_flag=1;\nfree_exception_frames();\n";
char*s848_931143030A="=n->header.next;\n\175""\nelse\173""\nif(c==NULL)c=gc_fsoc_get2();\n";
char*s637_810433A="(/*RF2:";
char*s286_1973946666A="TUPLE type expected for open arguments of agent type.";
char*s104_1062177790A="Extra \",\" ignored.";
char*s904_1994165009A="No support found for this external \"plug_in\" (plugin: \"";
char*s625_46733806A="static se_frame_descriptor fd=\173""";
char*s286_1838870713A=" has two conflicting external types";
char*s642_1008067448A="internal_exception_handler(";
char*s111_485115581A=" (magic_count=";
char*s485_2101296982A=" type is not allowed.)";
char*s113_1097945864A="-x \"c++\" -lstdc++";
char*s101_2219026A="routine";
char*s848_90782A="void ";
char*s904_1508488213A=" defined in ";
char*s650_1511667A="T32767*";
char*s642_20481355A=") break;\n";
char*s655_90792A="void*";
char*s34_78490A="class";
char*s35_78495A="clean";
char*s113_146157A=" /link";
char*s729_1428771266A="void  gc_info(void)";
char*s370_931579788A="Cannot pass Void as argument (the formal type is expanded).";
char*s904_1942675017A="Including source ";
char*s647_252669317A="((void*)a1);\n";
char*s33_41849945A="Real_bits";
char*s126_27561173A="Trying to read file \"";
char*s117_1533928773A=".......................................";
char*s825_2007377394A="Unknown loadpath";
char*s105_1658160521A="Expected \"[\" (to start generic argument list).";
char*s647_933501A="(NULL!=";
char*s490_1136691048A="\"set\", \"get\", or \"access\" keyword expected.";
char*s117_1170250908A="(/*UA*/((void)(";
char*s383_35157672A="Adapting ";
char*s104_1436398529A="Keyword \"loop\" expected (in a loop).";
char*s727_1657834530A="Compiling without Garbage Collector!\n";
char*s844_1619999729A="void bdw_weakref_setlink(bdw_Twr*wr,T0*r)";
char*s647_626047338A="((T6)((C->id==a1->id)\?!memcmp(C,a1,sizeof(*C/*";
char*s729_178014651A="se_thread_checkpoint();\n";
char*s33_447584A="stderr";
char*s104_1414519430A="Error while reading fractional part of a real value (digit expected after the dot).";
char*s117_1404148845A="parent_profile,";
char*s117_958964069A=" agent wrapper: ";
char*s650_90405963A="*id=(*((T0**)R))->id;\n";
char*s729_1494814589A="void*gc_lock";
char*s497_439056951A="New name and old name must be different.";
char*s358_767649523A="..... unique target buffer .....";
char*s33_1554777A="POINTER";
char*s33_447600A="status";
char*s17_1216703285A="Some feature is not yet implemented (i.e. feature `not_yet_implemented\' of\nclass ANY has been called somewhere). Just run this code under the debugger\nto know the `not_yet_implemented\' caller.\n\nThe error occured in the type";
char*s463_22861847A=" insert: ";
char*s117_530940601A="\" (i.e. file(s) \"";
char*s117_724500276A="((/*agent*/void*)a)";
char*s493_1723490337A=" open operand cannot be the target of an agent call.";
char*s33_591417242A="standard_twin";
char*s647_10895A="EIF_";
char*s104_2096474678A="**** Found potentially assignable expression";
char*s904_1439959996A=">. Strange dependency!";
char*s656_11205716A="uint32_t";
char*s728_1061058398A="(GC_get_heap_size())";
char*s647_10430693A="isnormal";
char*s111_445497083A="Finished inlining of dynamic dispatch.\n";
char*s848_176986A="--;\nn=";
char*s117_997623147A="),\nfprintf(SE_ERR,\"-manifest_string_trace: line ";
char*s625_1623721137A="... once unique buffer ...";
char*s117_2055072316A="(T7*)se_string(";
char*s113_631091213A="\"[General] flavor\" key is missing.";
char*s33_1735712398A="object_as_pointer";
char*s33_51906905A="is_locked";
char*s848_73472312A="(&(o1->object));\n";
char*s97_625881326A=" is a generic class (missing actual generic";
char*s34_78591A="boost";
char*s642_379993A="ac_civ";
char*s727_1750560930A="se_malloc(1)";
char*s111_1224226011A="C.ADRIAN, P.REDAELLI, R.MACK";
char*s415_163270777A=" which is out of INTEGER_32 range.)";
char*s386_561523426A="...........";
char*s416_1490189105A=" while expression ";
char*s349_1060258809A="Incompatible number of arguments.";
char*s283_2108992007A="external_c_files";
char*s33_1192911276A="object_memory";
char*s34_10990481A="separate";
char*s647_1514442508A="((void*)(&a1));\n";
char*s104_1632732392A="Slash (\"/\") expected (inside CHARACTER constant).";
char*s33_167970159A="TEXT_FILE_READ";
char*s104_264380934A="Infix functions must have exactly one argument.";
char*s117_1253959973A="Function without Current";
char*s621_565060278A="/* C Header Pass 1: */\n";
char*s647_78629A="ds.p,";
char*s111_1605895597A="\" redefined as \"";
char*s106_126291003A="Bad program.\n(Closing \")\" not found.)";
char*s729_790599008A="gc_set_dispose_before_exit(0);\n";
char*s283_1658492806A="\" file.\nACE file not found.";
char*s33_48856070A="arguments";
char*s33_1622700141A="deep_twin_from";
char*s625_1694771411A="typedef struct _se_";
char*s117_78646A="ds.p=";
char*s289_722230651A=" which is actually already renamed as ";
char*s625_404651A="u->eq=";
char*s640_8087250A="UINT8_C(";
char*s642_119389596A="/*state*/=";
char*s104_1453916708A="Unexpected \";\" to end rename list (deleted).";
char*s104_844703215A="Infix operator name expected.";
char*s117_2237652A="static ";
char*s30_1364794873A="Unable to remove existing the file \"";
char*s416_1256137461A="Invalid assignment test. The left-hand side expression must conforms with the right-hand side. The left-hand side is of type ";
char*s660_1465905014A=" is deferred in type ";
char*s106_618869258A="Inserted \':\'";
char*s29_1852009437A=": missing C mode name after -c_mode flag.\n";
char*s105_174945438A="Error inside multi-line manifest string.";
char*s35_1777434714A="safety_check";
char*s104_501268295A=" to rename a feature. (Feature name expected.)";
char*s642_380065A="ac_ens";
char*s111_313299890A="Cannot load root class ";
char*s624_605650769A=" = \");\nse_prinT";
char*s104_1950357785A="End of TUPLE expression expected.";
char*s104_2077708091A="Unable to find the feature name which is mandatory just after the \"frozen\" keyword.";
char*s684_1760457965A="require else";
char*s117_850522083A="init_profile(&runinit_profile, \"<runinit>\");\n";
char*s113_447734A="wcc386";
char*s117_824324978A="se_introspecT[";
char*s363_793028699A="Feature found is a procedure.";
char*s420_2007408328A=" which is a simple and predefined expanded type.";
char*s34_17176A="none";
char*s412_1090404950A=" result.) (VWEQ)";
char*s34_878084737A="LibertyEiffel";
char*s342_1492212881A="System_level_type_error";
char*s711_78239462A="Classes path set more than once";
char*s104_2141291014A="Empty formal argument list (deleted).";
char*s660_1548937422A="Keyword \"require else\" replaced with \"require\" (There is no inherited require assertion here).";
char*s34_17206A="note";
char*s126_210141519A="Renaming \"";
char*s34_2065491A="inherit";
char*s623_565066528A="/* C Header Pass 3: */\n";
char*s117_27063164A="init_profile(agent_switch_profile+";
char*s648_1719326284A="\173""/*dumb copy*/";
char*s126_349372A="Total ";
char*s117_106460275A="*)a)->afp(";
char*s554_1722217257A="C:\\LIBERTY.CFG";
char*s33_84881A="low_8";
char*s34_17221A="once";
char*s117_1917882A="agents ";
char*s409_1424594977A="The expression ";
char*s850_576790349A=".store_left>0)\173""\n";
char*s113_129391217A="\" does not contain name of a valid file.\n";
char*s33_2038667775A="like Current";
char*s763_1762204931A="Not a good slice. The lower bound (";
char*s848_1497878015A=";\nif(gc_find_chunk(na)!=NULL)\173""/* non external NA */\n   rsoh*h=((rsoh*)na)-1;\n   if((h->header.magic_flag)==RSOH_UNMARKED)\173""\n      h->header.magic_flag=RSOH_MARKED;\n";
char*s104_2127445170A="Character \'%\"\' inserted after \"prefix\".";
char*s33_50246319A="generator";
char*s729_790599133A="gc_set_dispose_before_exit(1);\n";
char*s283_926093361A="The valid values for split are either \"legacy\" or \"by_type\".";
char*s552_1134353920A="safety checking";
char*s642_1898591066A="creatinstexp";
char*s111_580671658A=" not found!";
char*s117_545118879A="Precursor routine";
char*s642_380168A="ac_inv";
char*s104_23410A=" \011""[\000""\n";
char*s117_508495830A=").\",NULL);\n";
char*s848_77562923A="(((rsoh*)o)-1)->header.magic_flag=RSOH_MARKED;\n";
char*s467_1790874766A="The type of this constant feature should be INTEGER or REAL.";
char*s377_7238542A="INTEGER ";
char*s104_469031018A="Expression expected after \"old\".";
char*s729_453998A="void X";
char*s647_1671077900A="((uint16_t)(";
char*s642_1952787551A="\173""int c=0;int v=0;\n";
char*s848_1739163321A=";o1++)\173""\nif((o1->header.flag)==FSOH_MARKED)\173""\no1->header.flag=FSOH_UNMARKED;\n";
char*s33_447851A="stdout";
char*s286_689575137A="Cyclic inheritance graph: ";
char*s495_29585A=" >> \175""";
char*s589_100561530A="), &(o2->_";
char*s33_2098363273A="is_subnormal";
char*s111_1004555549A="Internal compiler error. Definition of infix \"^\" of INTEGER_GENERAL is not coherent with compiler builtin simplifications.";
char*s117_104036848A="Threads don\'t support profile! Feel free to contribute.";
char*s33_349117293A="NATIVE_ARRAY";
char*s30_1812938425A="Bad executable name: \"";
char*s105_1861857328A="Deleted extra semi-colon.";
char*s120_1816788953A=". The assigner feature is expected to have exactly one more argument than the assigned feature.";
char*s660_1541882313A=" is inherited more than once.";
char*s554_4992A="    ";
char*s764_2131486419A="inspectManifestStringExpression";
char*s104_179688005A="Expected a non-empty types list.";
char*s104_928941315A="Constraint Class name expected.";
char*s111_1836299930A="Measurements done during inlining of dynamic dispatch:\n";
char*s126_195766720A="Unable to write error(s)/warning(s) redirection output file \"";
char*s104_1680421289A="Void cannot be the left-hand side of the binary \"+\" operator.";
char*s415_165614527A=" which is out of INTEGER_16 range.)";
char*s648_872295A=",(T0*)(";
char*s33_84969A="lower";
char*s625_2142146116A="int R=1;\nse_";
char*s642_380218A="ac_liv";
char*s844_101355036A="if(bdw_in_assign)bdw_delayed_finalize=1;\nelse\173""\nhandle(SE_HANDLE_ENTER_GC,NULL);\n";
char*s415_1057872442A=" which is out of range -63 ..63 because target type is INTEGER_64.";
char*s117_1717499533A="/*  - NO routine body*/\n";
char*s647_204519611A="if(R)\173""\nT0*o1=C->_";
char*s904_838816886A="). No description file found.";
char*s120_1998329594A="\" come from the same original feature via multiple \"insert\" paths, but none comes via an \"inherit\" path.\nBelow, you get the feature evolution step by step. Note that in the end (type ";
char*s844_800004081A="T0*bdw_weakref_getlink(bdw_Twr*wr)";
char*s104_75828399A="\" as a local variable name.";
char*s104_1204389280A="You are using a case sensitive language in which all class names must use only upper case letters. This decision was made to make the code more readable and to allow better error messages as well as syntax error recovery. The name \"";
char*s447_1628100917A="Unable to find file for class \"";
char*s105_1578831409A="Expression expected after assignment test \"\?:=\".";
char*s104_1307652273A="Expected a feature name to assign.";
char*s104_1690004585A="Writable entity expected here. Argument ";
char*s126_1018573728A="Obsolete $\173""";
char*s104_1741759101A="). Keyword \"";
char*s844_486352305A="mark_native_arrays(";
char*s436_1627141371A=" not correctly equiped for manifest generic creation (missing definition of feature `manifest_make\').";
char*s35_914215870A="high_memory_compiler";
char*s113_1588150185A="The selected system name is \"";
char*s113_91157A="wlink";
char*s805_1932458562A="\' key in the ini file must be an integer.\n";
char*s483_375013061A="Such an expression cannot be on the left-hand side of an assignment operator. There is no assigner to `";
char*s97_8198176A="TUPLE...";
char*s647_60405A="R=1;\n";
char*s727_1345708525A="\173""/*mark_item*/\175""\n";
char*s467_1875641781A="Value out of INTEGER_16 range.";
char*s848_1831440704A="\175"",NULL,(((FSOC_SIZE-sizeof(fsoc)+sizeof(double))/sizeof(gc";
char*s416_29662A=" \?:= ";
char*s763_1309017823A="The value is already part of previously encountered slice. (Wrong inspect statement.)";
char*s33_1487451A="NATURAL";
char*s283_1453633985A="Unknown assertion level tag.";
char*s283_1736752216A="The value of the environment variable \"LibertyEiffel\" is:\n\"";
char*s117_495363549A="stop_profile(&master_profile, &global_profile);\n";
char*s728_1240206596A="void gc_start(void)";
char*s104_1545228536A="Cannot open Cecil file (use -verbose flag for details).";
char*s409_277033810A=" while the expression ";
char*s104_973007162A="Empty debug key list (deleted).";
char*s113_561720547A="\": unknown C compiler name after -cc flag or in the ACE file.\n";
char*s371_197895058A="Must use here a manifest STRING because the previous one used in this \"inspect\" statement is a manifest STRING.";
char*s111_1889118664A="No Polymorphic Call Site in the Live Code.\n";
char*s625_1387812168A=");\nu->creation_mold_id=";
char*s394_668815628A="The slice includes an already encountered value. (Wrong inspect statement.)";
char*s104_2108887750A="The base type is no longer used. Class ROUTINE now has only one formal argument. Just remove this unused type mark.";
char*s33_240810599A="c_inline_c";
char*s554_165909873A="/etc/liberty-eiffel";
char*s117_2022630A="error0(";
char*s115_11253A="BeOS";
char*s113_2194860A="pthread";
char*s640_1127821710A="se_manifest_args";
char*s33_240810604A="c_inline_h";
char*s642_2022635A="error1(";
char*s121_128358027A="..................................................";
char*s34_392625A="assign";
char*s625_4999725A="*a2=(se_";
char*s104_199494346A="Keyword \"end\" expected at the end of a class.";
char*s625_706329A="\",1,0,\"";
char*s846_1777096676A="\n#define gc_mark";
char*s678_143852403A=". (The whole type of the agent your are trying to launch is ";
char*s660_831146693A="All ancestors are deferred, hence making this Precursor call not valid.";
char*s33_17422A="\174"">>>";
char*s33_2054549840A="manifest_put";
char*s104_1912621670A="This name cannot be used as a valid class name.";
char*s467_1141741445A="A procedure cannot have a \'then\'.";
char*s659_265537649A="/*INTERNAL_C_LOCAL list]*/\n";
char*s642_380343A="ac_req";
char*s678_167300030A=" into formal argument of type ";
char*s729_1384921237A="handle(SE_HANDLE_EXIT_GC,NULL);\n";
char*s104_922446006A="Overflow while reading integer constant. Value `";
char*s104_66884963A="Error while reading an integer constant. Missing \"\175""\" \?";
char*s104_134219969A="Error while reading an hexadecimal value. Missing \"\175""\" \?";
char*s30_53561911A="no_rescue";
char*s117_471553120A="parent_profile=&global_profile;\n";
char*s729_1374304640A="fprintf(SE_GCINFO,\"--------------------\\nNumber\\tTotal\\tStore\\tName\\ncreated\\tsize\\tleft\\n\");\n";
char*s642_504830035A=")) \173""switch(";
char*s393_128333478A="The corresponding feature definition.";
char*s113_262628264A="linkit.com";
char*s642_1888091524A="goto retry_tag;\n";
char*s489_1809088081A="data_member ";
char*s104_1701980726A="Removed unexpected blank space(s) just before this dot (assume you really want to apply a procedure using the previous STRING as target).";
char*s33_337331A="Result";
char*s117_17480A="se_i";
char*s97_1056980719A="Procedure \"";
char*s117_1680956616A="se_profile_t root_profile";
char*s104_2060540980A="Empty formal generic list (deleted).";
char*s650_5313505A="*exp=0;\n";
char*s475_1199044228A="Could not find any conformant common type to those expressions because they are all Void.";
char*s35_17498A="sedb";
char*s126_1293738877A=" is not set.\n";
char*s104_1046025807A="The old \"select\" option of the \"inherit\" clause is now obsolete. You have to update your code with the new \"insert\" mechanism. With Liberty Eiffel, this can be achieved thanks to the new \"insert\" clause. The new \"insert\" clause comes just after the traditional \"inherit\" clause with a similar syntax.";
char*s33_1483884743A="native_array_internals_from_generating_type";
char*s621_985967445A="; /*NATURAL_";
char*s648_2102695A="memcpy(";
char*s117_17507A="prof";
char*s660_139854341A="Signature of the redefined feature is not valid.";
char*s104_2176510A="plug_in";
char*s104_552734069A="The SCOOP attempt implementation has been abandoned (December 2006). ";
char*s846_1387277146A="object;union \173""void*flag;gc";
char*s111_1556970935A="Unsafe call site (see also next warning).";
char*s729_35966A=" elt=";
char*s650_5313530A="*exp=1;\n";
char*s648_1416678934A=">>8)&0xFF00)\174""(((uint32_t)";
char*s394_492964813A="Second occurrence for this value in the same inspect. (Wrong inspect statement.)";
char*s105_1538234998A="Index value expected (\"indexing ...\").";
char*s34_306165094A="smarteiffel_options";
char*s111_921818688A="Monomorphic Procedure Call";
char*s415_1505530135A="Overflow of infix \"*\" with INTEGER_16 operands. (";
char*s647_46980416A="_t)((uint";
char*s120_870131842A=" (given first) can\'t be accepted because a concrete feature is inherited. What\'s called a concrete feature here is a feature which is not deferred. You may consider to add a redefine or an undefine. May be.";
char*s117_2072467813A="&local_profile";
char*s415_177461A=" by 0.";
char*s370_572614135A=" formal argument";
char*s289_867234734A="Redefinition of ";
char*s848_97510A="\175""\175""\175""\175""\n";
char*s97_445214625A=" is invalid. A deferred class must not be expanded.";
char*s104_1275488910A="\'. A routine with arguments cannot be an attribute.";
char*s29_386614A="bdw_gc";
char*s283_929353692A="linker_options";
char*s621_1316811340A="/*BUG:WR@runtime!*/";
char*s538_637371887A="Cannot create an ARRAY with only `Void\' items.";
char*s729_558682149A="void*gc_mark_agent_mold;\n";
char*s117_51599861A="int argc)";
char*s554_1707891936A="/.liberty-eiffel";
char*s117_1416365293A="se_thread_stop();\n";
char*s554_11429A="HOME";
char*s111_170061979A="Target Type Prediction Score: ";
char*s625_1992695545A="rescue_context_top = rc.next;\nhandle(SE_HANDLE_EXCEPTION_CLEAR,NULL);\n";
char*s729_398948A="gc_lib";
char*s625_5284A="\" (\"";
char*s104_755120513A="Inside a client list, only plain class names are allowed. (Class names must use only uppercase letters.)";
char*s529_890319497A=" which is out of INTEGER_64 range.";
char*s104_2087550139A="Keyword \"end\" added to finish this \"if\" statement.";
char*s625_21632225A="*)u1;\nse_";
char*s729_328118105A="manifest_string_mark1();\n";
char*s848_775406525A="p=((void*)(o+((((h->header.size)-sizeof(rsoh))/sizeof(e))-1)));\nfor(;((void*)p)>=((void*)o);p--)\173""\ne=*p;\n";
char*s494_1370872538A="Invalid notation for 0.0.";
char*s647_520373770A="((int16_t)(";
char*s35_10714216A="no_split";
char*s647_1836091144A="Bad number of arguments of external signature.";
char*s123_300594A="File \"";
char*s625_2036521484A="handle(SE_HANDLE_EXCEPTION_SET,NULL);\nif(SETJMP(rc.jb)!=0)\173""/*rescue*/\n";
char*s33_1740332382A="Minimum_double";
char*s111_1379717706A="Now inlining dynamic dispatch (using inspect instructions)\n";
char*s104_1606714210A="Since february 2006, for SmartEiffel release 2.3, the old legacy NONE type mark is obsolete. Keep in mind that an empty class name list such as \173""\175"" does indicate no exportation at all, hence making NONE useless and probably misleading for newcomers. So, just remove this NONE class name now. Please update your code now.";
char*s33_1644425991A="manifest_semicolon_check";
char*s660_1677586033A=". This can lead to catcalls!";
char*s625_4434071A=" called.";
char*s642_4766225A=" while (";
char*s420_1119905623A="`manifest_create\' is not an ordinary creation procedure. Please use the \173""";
char*s844_1509872874A="*o=*markna;\nGC_disable();\n";
char*s648_1087446800A="se_thread_wait((";
char*s34_75797981A=" has no compiler-defined `deep_twin\' or `is_deep_equal\' because the corresponding allocated size is not part of the NATIVE_ARRAY object. The client class of this NATIVE_ARRAY type is supposed to use a `capacity\' attribute which contains the corresponding number of allocated items (see STRING or ARRAY for example).";
char*s729_49680837A="if (i <= ";
char*s846_8050871A="TLS(int)";
char*s105_744085684A="Right hand side expression of \?= assignment expected here.";
char*s117_1173628471A="]=runinit_profile;\n";
char*s577_146251545A=".unlock*/\n";
char*s33_267647687A="standard_is_equal";
char*s117_825893997A="/* Allocate an Eiffel STRING given its size and native storage */\n";
char*s490_380590A="access";
char*s844_1832086881A="(o)==NULL&&GC_should_invoke_finalizers())bdw_run_finalizers();\n";
char*s412_988692517A="\"). You can use the Void comparison only when other type mark is a reference type or, if it is an expanded type, it must be an anchor or some formal generic argument. Fix this error first.";
char*s392_5382A=" -- ";
char*s660_2025498932A=") of the concrete feature (inherited from type ";
char*s483_789350917A=" by a call to \173""";
char*s104_96053257A="No parent after \"insert\" keyword (an empty list is not allowed here).";
char*s283_17696A="root";
char*s104_1062283098A="Only simple and statically computable expression are allowed here (inside \"when\" of \"inspect\" statement).";
char*s293_1831619428A="Too many errors.\n";
char*s340_1262756502A="Parsing Cecil file: ";
char*s729_444175272A="#define SE_GC_LIB 1\n";
char*s34_17715A="then";
char*s283_880804011A="Keyword \"root\" expected. Invalid ACE file.";
char*s650_300665A="R=(*((";
char*s105_2004339522A="Added missing brackets to enclose the previous \"once\" manifest STRING.";
char*s349_1001314405A="Incompatible signatures. (One has argument(s) but not the other.)";
char*s289_92467250A="Cannot redefine ";
char*s293_878860A="------\n";
char*s647_537910373A="se_deep_twin_trats()\n";
char*s104_112999293A="Instruction expected here. True alone is not an instruction.";
char*s582_30034A="&(((T";
char*s104_568400887A="`indexing\' is an obsolete keyword, please use `note\' instead.";
char*s117_1968768303A="master_profile.profile=NULL;\n";
char*s104_783329131A="Total time spent in parser: ";
char*s625_180709512A="return u->R;\n";
char*s117_169662319A="/*  - ensure*/\n";
char*s104_1984637890A=" is not a feature name.";
char*s120_1605047378A=" type.\n\nFirst \"inherit\" path (from parent to child):\n   ";
char*s117_1435285930A="Define initialize stuff.\n";
char*s104_79251A="false";
char*s104_756929053A="Must use exactly 2 hexadecimal digits for INTEGER_8.";
char*s104_142936234A=" cannot be used as a feature name to start a new feature definition. Parser lost. Sorry. Check before and after that point.";
char*s904_1377638770A="No header files";
char*s660_21306364A="This Precursor call is ambiguous because the type ";
char*s117_738771309A="void initialize_eiffel_runtime(int argc,char*argv[])";
char*s111_295542551A="Polymorphic Function Call";
char*s625_386819A="caller";
char*s381_22401251A=" context.";
char*s647_358916317A="se_thread_lock_timed_wait((";
char*s105_348041349A="Error in inspect.";
char*s117_401124480A=" run classes :\n";
char*s349_1149307517A="Bad redefinition. An attribute must be redefined as an attribute only (VDRD.6).";
char*s436_1837585965A="Creation procedure not found.";
char*s729_1642168697A="void(*gc_mark_agent_mold)(se_";
char*s393_305790140A="This is not an INTEGER expression.";
char*s625_242108838A=" (1 feature).\n";
char*s625_56760755A="void*eq;\n";
char*s625_60837A="R=C->";
char*s625_1367040625A="retry_tag:\n";
char*s33_1979951A="dispose";
char*s498_1965077754A="Such an \"inspect\" statement is for type STRING or FIXED_STRING. (The type of ";
char*s117_471707221A="*sizeof(se_profile_t));\nqsort(sorted_inv_profile, ";
char*s476_1809998749A="\' not found.";
char*s115_17794A="vbcc";
char*s33_386854A="calloc";
char*s117_1844536619A="se_local_profile_t*,";
char*s624_1151663379A="fprintf(file,\"%llu\",(long long unsigned int)((uint64_t) *o));";
char*s104_776600004A="Explicit creation/create type mark should not be anchored.";
char*s846_1126647264A="*next;\175"" header;\175"";\n";
char*s391_2014931627A="External feature must not have rescue compound.";
char*s89_1331038845A="Cannot find the feature ";
char*s104_150329797A="Error while reading hexadecimal value.";
char*s117_802495724A="\");\nstart_profile(parent_profile, &local_profile);\n";
char*s126_1723571071A="................................................................";
char*s117_719604853A="=((T0*)eiffel_root_object);\n";
char*s115_39617954A="Macintosh";
char*s113_25704393A="/LIBPATH:";
char*s583_5515A="\").\n";
char*s104_397329363A="Inheritance option not at a correct place. The correct order is: \"rename... export... undefine... redefine...\".";
char*s117_1881374985A="memcpy(sorted_agent_profile, agent_profile, ";
char*s117_713312393A=", inv_profile, ";
char*s104_676769302A="Syntax error while trying to parse the beginning of a new feature definition. Expression ";
char*s33_1896328073A="alloc_native_data";
char*s33_79341A="count";
char*s625_882065083A=";\nstruct _se_";
char*s117_862271166A="ds.fd->assertion_flag=1;\n\175""\n";
char*s293_60894A="Error";
char*s33_48672249A="bit_clear";
char*s117_23988287A="#include ";
char*s117_1682814572A="manifest_put(";
char*s33_572288431A="to_natural_16";
char*s506_2099969245A="is_reference";
char*s111_1019367716A=" (For this call, the target is the implicit non written `Current\' which is of type ";
char*s552_1381550903A="simplifying";
char*s807_2078852867A="#(1)/.config";
char*s33_572288437A="to_natural_32";
char*s729_189437896A="unsigned int fsoc_count_ceil";
char*s104_1536599162A="__inline_agent__";
char*s729_1891487260A="(gc_memory_used())";
char*s111_91926102A=" starting from cluster ";
char*s625_560761477A="internal_exception_handler(Routine_failure);\n\175""\n";
char*s415_530141799A="Violated require assertion. Argument value is ";
char*s104_202933204A=" cannot be an expression. ";
char*s33_572288454A="to_natural_64";
char*s117_1672511676A="global_profile.profile=&root_profile;\n";
char*s728_6943896A="GC_DEBUG";
char*s104_120546715A="Left hand side expression of := assignment must be a feature call.";
char*s111_479236135A="Result type of a once function must not involve formal generic names nor anchored types (VFFD.8).";
char*s624_5580A="\");\n";
char*s111_1865554673A="Live_type_map size=";
char*s104_922212712A="Variant (INTEGER) Expression Expected.";
char*s111_1162901343A="Starting optimization (";
char*s625_674382779A="(void**)&R,";
char*s370_1546692995A=" while the actual argument list has ";
char*s495_1411247976A=". (Actual bunch size is ";
char*s728_1665893228A="Adding Boehm-Demers-Weiser Garbage Collector.\n";
char*s117_1842506892A="se_local_profile_t local_profile;\nstatic se_profile_t prof;\nstatic int prof_init=0;\n";
char*s117_4692662A="#define ";
char*s648_835985A="*/));\175""\n";
char*s849_5498450A="*sizeof(";
char*s844_2070967345A="typedef struct bdw_Swr\173""Tid id;T0*o;\175""bdw_Twr;\n";
char*s642_312808564A=")->_storage + ((";
char*s117_1994596535A="void(*se_prinT[";
char*s653_17916A="uint";
char*s111_5615A="\".)\n";
char*s844_42521A=")obj)";
char*s639_627106219A="userexpandedagent";
char*s117_1413407004A="Cecil (C function for external code) :\n";
char*s33_1680926299A="default_create";
char*s34_436196A="rename";
char*s495_1142240176A=" into formal argument which is of type ";
char*s805_602797481A="Redundant key definition found in section [";
char*s113_120239233A="1234567890";
char*s848_28263330A=",size));\n";
char*s33_17941A="wait";
char*s33_506823435A="manifest_creation";
char*s35_10554609A="loadpath";
char*s283_816126476A="Unused obsolete flag -wedit / option wedit.";
char*s104_1869854287A="Unexpected bracket after a comma.";
char*s104_2009918711A="Error inside feature name definition. Unable to find the synonymous name which must be just after the previous colon mark \",\".";
char*s704_861846863A="Legacy splitter enabled.\n";
char*s33_39002989A="PREDICATE";
char*s552_456083848A="The system is not type safe (read previous warnings carefully).";
char*s29_85614A="no_gc";
char*s642_521905705A=")->_count;\n";
char*s848_291421585A="size=(size*sizeof(";
char*s117_1586354711A="uint32_t lsi";
char*s728_1166044581A="GC_java_finalization=1;\nGC_finalize_on_demand=1;\nGC_finalizer_notifier=bdw_run_finalizers;\nGC_INIT();\nGC_stackbottom=(char*)(void*)&argc;\n";
char*s104_971408488A="Right hand side expression of ";
char*s502_1773984820A=" Replace your code with:\n\n      agent ";
char*s111_866669263A="Handling include of \"";
char*s489_1961687A="delete ";
char*s122_51895507A="error1(\"Invalid inspect (nothing selected).\",";
char*s117_36434A="*C=(T";
char*s848_1815688614A="*)(&(c->first_object)));\nif(c->header.state_type==FSO_STORE_CHUNK)\173""\nfor(;o1<";
char*s104_210812758A="\" does not contain class \"";
char*s409_1250079569A="The left-hand side of ";
char*s660_1722095007A="Signature (adapted in the type ";
char*s436_1333985363A="Feature `manifest_make\' must be a procedure.";
char*s117_2041682A="extern ";
char*s358_786054293A="Forbidden call (i.e. exportation rules violated) when the type of Current is ";
char*s625_988243818A="\173""Tid id;\nint creation_mold_id;\n";
char*s33_1937220099A="is_deep_equal";
char*s848_567878339A="*/))+sizeof(rsoh);\nsize=((size+(sizeof(double)-1))&\176""(sizeof(double)-1));\n";
char*s625_5720A="\",1\175""";
char*s848_598811726A=".store_left>sizeof(rsoh))\173""\nr->header.size=size;\n";
char*s112_1461366457A="Version of command \"#(1)\" is:";
char*s767_1613492996A="Invalid byte as first character of UTF-8 sequence.";
char*s104_18036A="true";
char*s33_247239028A="collecting";
char*s33_278061691A="timed_wait";
char*s728_1942608409A="gc_start();\n";
char*s729_41125176A="gcmt_tail_addr=(((char*)(gcmt[gcmt_used-1]))+(gcmt[gcmt_used-1])->size);\n((gc";
char*s849_1506490209A=")\nfprintf(SE_GCINFO,\"%d\\t%d\\t\\t";
char*s640_1406782500A="/*ND*/(T0*)(";
char*s29_425790270A=": missing split mode after -split flag.\n";
char*s104_1740357387A="Alias operator name expected.";
char*s117_2103819988A="int se_strucT";
char*s412_1816888147A=". Comparison not allowed (VWEQ).";
char*s104_1694969179A="Such an expression cannot be on the left-hand side of an assignment operator. A dot can never be used for the left-hand side part of an assignment operator. Valid left-hand side can be Result, some local or the name of an attribute of Current. See also http://SmartEiffel/wiki/en/Syntax_diagrams#Writable.php for details.";
char*s117_1836282258A="se_local_profile_t global_profile";
char*s640_1188262106A="/*$*/((void*)W";
char*s638_263576126A="0/*empty expanded*/";
char*s104_825716016A="Name of the current class expected.";
char*s848_1649648619A="o=(&(p->object));\n";
char*s117_273731430A="se_string(";
char*s33_1549680A="REAL_32";
char*s488_1848584263A="Double definition found for key ";
char*s349_1642968637A="\' but different signatures. According to the join rule, the signatures have to be identical in the final class.";
char*s848_1040644265A="*n;\nfsoc*c;\n";
char*s117_1042003640A="int(*eq)(se_agent*,se_agent*);\n\175"";\n";
char*s381_5787A=" := ";
char*s34_18090A="when";
char*s463_114137597A=" inherit: ";
char*s648_946895A="#endif\n";
char*s409_1721307786A="Void cannot be the right-hand side of a ";
char*s33_1549697A="REAL_64";
char*s117_1360840737A="Thread root function";
char*s117_1352413868A="int32_t c,uint16_t*s,int32_t sc,int16_t*lsv,int32_t*lsi)";
char*s619_11952A="T0**";
char*s33_1549703A="REAL_80";
char*s111_98784712A="\' in type ";
char*s282_1968202785A=" (See next message to locate the error.)";
char*s33_18110A="twin";
char*s117_1063704391A="fprintf(profile_file, \"\\n===============================================================================\\nDetailed profile:\\n\");\n";
char*s625_1566831588A="ds.exception_origin=NULL;\n";
char*s117_1339521386A="fprintf(profile_file, \"===============================================================================\\nSummary:\\n\");\n";
char*s283_374877A="_check";
char*s728_1635390646A="GC support (functions).\n";
char*s848_2021999449A="gc_update_weak_ref_item";
char*s660_1849347035A=") is not compatible with the deferred one comming from parent type ";
char*s117_1460025642A="start_profile(&master_profile, &global_profile);\n";
char*s848_484169497A=".store_left=0;\n\175""\n(r->header.magic_flag)=RSOH_UNMARKED;\n((void)memset((r+1),0,r->header.size-sizeof(rsoh)));\nreturn((T";
char*s495_14429929A=" not correctly equiped for manifest generic creation (`manifest_creation\' missing in the creation clause).";
char*s126_809686569A="\".\nCommand aborted.\n";
char*s642_6575105A=";break;\n";
char*s115_18144A="vpcc";
char*s104_18150A="void";
char*s117_457314246A="/*  - user expanded*/\n";
char*s120_290966604A=") there are two versions of the same initial feature with two different names. To  fix this, either use enough \"inherit\" links in place of \"insert\" links to have one \"inherit\" path or rename the feature to get the same name in ";
char*s848_322115272A="*)(wr->o);\nif (obj_ptr != NULL)\173""\nint swept = (((void*)obj_ptr) <= ((void*)wr));\nif (swept != (obj_ptr->header.flag == FSOH_MARKED)) /* **** TODO: was FSOH_UNMARKED\?\?\?\? (incoherent with comment below) */\n/* (already swept) xor marked */\nwr->o = NULL;\n\175""\n";
char*s648_2122389958A="se_print_run_time_stack();\n";
char*s117_1624663341A=")(va_arg(pa,";
char*s104_1320619413A="Added missing \":\" semicolon before this type mark.";
char*s104_442256615A="\" aborted.\n";
char*s640_112304676A="..........";
char*s468_2015374870A="Conflict between argument/feature name (VRFA).";
char*s625_472574902A="(se_agent*u1, se_agent*u2)";
char*s283_1325140408A=": cannot use -sedb with -boost flag.\n";
char*s104_2116282032A="An if-then-else expression must have an \'else\' part.";
char*s35_267875778A="no_warning";
char*s846_201266601A="TLS(fsoc*)";
char*s506_18186A="type";
char*s848_1985327250A="se_gc_check_id(o,";
char*s848_1196941282A="n->object=M";
char*s33_1176378494A="type_can_be_assigned_to_item";
char*s647_559906822A=" built-in: ";
char*s554_1096544670A="/lang/eiffel/.serc";
char*s33_55924644A="std_error";
char*s846_2097247A="na_env ";
char*s124_2120987577A="..... unique buffer .....";
char*s409_5912A=" \?= ";
char*s289_1153312264A=" not found in this class.";
char*s506_1985887020A="generic_list";
char*s117_163413385A="se_profile_t agent_profile";
char*s848_1800342110A="++;\n\175""\nelse if(";
char*s625_1992825354A="\173""\"invariant ";
char*s647_854330615A="\175""\nse_deep_equal_trats()\n";
char*s904_1067567332A="The plugin ";
char*s33_1673348567A="open_argument_index";
char*s111_5873980A="Unknown infix operator \"";
char*s656_399591A="double";
char*s97_1539816514A=" is not a generic class. (See file \"";
char*s126_44975894A="Writing \"";
char*s34_56927287A="c_linker_path";
char*s647_1709245815A=";\nerror0(\"Invalid deep_twin.\",NULL)";
char*s647_4680700A="!memcmp(";
char*s104_518055462A="Local variable name expected after comma inside local variable list.";
char*s495_84293096A="Wrong number of arguments for manifest generic creation.";
char*s33_1831158645A="INTERNALS_HANDLER";
char*s848_175186427A="*old_gc_free=gc_free";
char*s104_732257893A="\')\' expected in expression.";
char*s642_352968782A=");\nif(NULL!=(";
char*s117_49152444A="ds.caller";
char*s383_18257A="yes ";
char*s416_902517583A="........................";
char*s843_496139469A="Internal problem for \"mark_native_arrays\".";
char*s293_927785894A="Fatal Error";
char*s342_673829558A="Incorrect_inspect_value";
char*s371_1664909434A="Cannot use \'..\' with manifest strings.";
char*s365_1215781867A="Strange formal/actual arguments mismatch!";
char*s467_529299514A="A boolean constant cannot be an assigner.";
char*s104_1387339410A=" is not writable. Cannot use ";
char*s104_445504446A="\" expected.";
char*s111_1242126608A="Starting type safety check";
char*s35_10714862A="no_strip";
char*s113_1494914262A=" Ignore=93,194,304";
char*s117_5980A=" C;\n";
char*s439_983618541A=" Constraint Generic Violation.";
char*s728_341361877A="int bdw_in_assign";
char*s729_1869700848A="*)eiffel_root_object)->header.flag=FSOH_UNMARKED;\n";
char*s111_1568923104A=" must have a feature named `";
char*s115_448859A="wcl386";
char*s33_1553736287A="REAL_EXTENDED";
char*s34_1980461A="convert";
char*s848_744114A="&&(((gc";
char*s104_1575461624A="A feature name cannot be used to indicate exportation status in a client list. Only plain class names are allowed here (class names must use only uppercase letters).";
char*s104_1181926797A="Added \"end\" for inspect instruction.";
char*s648_531809155A=">>8);\n#else\n";
char*s117_8359055A="set_dump_stack_top(";
char*s33_9712276A="as_16_ne";
char*s728_2005219697A="void*bdw_markna;";
char*s729_172080A="*)o);\n";
char*s117_1427351705A="*(volatile T6*)&(C->_is_started)=1;\nsignal(sigdata);\n";
char*s34_1168210079A="cpp_linker_path";
char*s844_1664195965A="void*bdw_na_assign_innerT";
char*s647_42916A="(uint";
char*s29_24284008A=": missing compiler name after -cc flag.\n";
char*s729_249330648A="gc_info_nb";
char*s289_1145998825A="\" (forbidden or not yet implemented).";
char*s647_842552A="*)R)=*C";
char*s117_431043495A="*sizeof(se_profile_t));\n";
char*s117_490486762A="local_profile.profile=&atexit_profile;\n";
char*s104_727903062A="Bad create expression (\'\173""\' expected).";
char*s113_165012750A="\"[General] os\" key is missing.";
char*s113_2075119688A="#1#2#3#4#5#6#7#8#9#\?.o";
char*s435_306215109A="An assertion must be a BOOLEAN expression.";
char*s104_1583181163A="Void is not a valid inspect expression (just after keyword \"inspect\").";
char*s117_1377208779A=";\nstart_profile(parent_profile, &local_profile);\n";
char*s647_153655A="&(C->_";
char*s111_212031001A="The main procedure must not have arguments.";
char*s104_12184A="NONE";
char*s110_1152235958A=" transitions.\n";
char*s117_1160736641A="Manifest String";
char*s86_1501391323A="Adapting Cecil features.\n";
char*s117_12188A="T7*g";
char*s650_1985290496A="*id=_r->id;R=&_r;break;\ndefault:*id=0;break;\n\175""\n\175""\n\175""\n";
char*s117_113036818A="local_profile.profile=agent_switch_profile+";
char*s117_12201A="T7*t";
char*s104_34383990A="Error while reading a number.";
char*s105_35386613A="...............................................";
char*s460_498169402A=". An expanded type must have one unique creation procedure with no argument: the creation procedure used for automatic initialization. Please, consider to add explicitely the `default_create\' procedure from ANY or some other existing procedure with no arguments. For expanded class with no creation clause, the `default_create\' procedure is the one used for automatic initialization.";
char*s640_781095A="(\'*/CA_";
char*s104_1593742473A="Closing \">>\" of manifest generic creation expected.";
char*s120_740900172A="Assigned feature not found in type";
char*s104_2018315248A="Parsing Cecil File: \"";
char*s117_1009317511A="Compiling/Sorting ";
char*s104_124311631A="Void cannot be the left-hand side of the binary \"^\" operator.";
char*s538_1359629264A="The old manifest ARRAY notation can only be used when the common type mark for all items of the manifest ARRAY exists, is not ambiguous and is easy to compute! By the way, it is not easy or possible to compute the most general type for the following set of types: \173""";
char*s439_1920465143A="Actual generic derivation ";
char*s710_8777401A="Universe";
char*s117_1838958244A="/*agent*/T0*a";
char*s104_1962710217A="\")\" expected to end debug string list.";
char*s848_1901427808A="T0* obj_ptr = item->o;\nif (obj_ptr != NULL)\173""\nint obj_size=se_strucT[obj_ptr->id];\nint swept";
char*s848_365929075A=".count_minus_one;\nn=";
char*s850_958639438A=".store->header.magic_flag=RSOH_FREE;\n";
char*s34_1593051A="Liberty";
char*s113_5578901A="-include";
char*s342_176865800A="Developer_exception";
char*s640_7227375A="INT64_C(";
char*s104_431394186A="Character \'%\"\' inserted.";
char*s674_1159783306A="FAKE_TUPLE.collect called";
char*s625_9589368A="agent_eq";
char*s844_1048179568A="GC_disable();\nif(wr->o)GC_unregister_disappearing_link((void**)&(wr->o));\nwr->o=r;\nif(r)GC_GENERAL_REGISTER_DISAPPEARING_LINK((void**)&(wr->o),(void*)r);\nGC_enable();\n";
char*s35_388005040A="case_insensitive";
char*s113_1319327951A="loadpath.se";
char*s660_374042271A="The \"feature\" clause declares a narrower client list than";
char*s111_3579844A=" (type \"";
char*s34_1747646688A="c_strip_path";
char*s589_51582255A="int R=0;\n";
char*s727_264935842A="))->o)=(T0*)(";
char*s126_141444A="\" as \"";
char*s105_432335312A="Same identifier appears twice (local/formal).";
char*s848_1265395998A=".store))+size));\n\175""\nelse \173""\nr->header.size=size+";
char*s640_40430500A="UINT64_C(";
char*s625_5794220A="=(u->CA_";
char*s283_1598804806A="At this point in the ACE file, you are supposed to say \"yes\", \"no\", or \"all\".";
char*s640_860088160A="(/*OUTCL:OUT*/*CL_";
char*s106_356743A="Bad program.\n(No program name found.)";
char*s904_1377633305A="No header paths";
char*s729_1958195441A="collector_counter++;\n";
char*s117_209121A="(live)";
char*s104_1615234134A="Since february 2006, for SmartEiffel release 2.3, the old legacy NONE type mark is obsolete. Keep in mind that an empty class name list like \173""\175"" do indicate no exportation at all, hence making NONE unuseful and probably misleading for newcomers. So, just remove this NONE class name right now. Please update your code now.";
char*s625_338723264A="This routine is actually deferred is still in the live code set. (You will have a crash at run-time if the dynamic type of Current is ";
char*s467_1573210512A="The type of this constant feature should be CHARACTER.";
char*s117_1790869799A="C++ external definitions.\n";
char*s625_3912034A="(&(a1->c";
char*s680_1257368965A="ensure then";

#ifdef __cplusplus
}
#endif
