# This file is part of the Dive framework.
#
# Dive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Additional permission under section 7 of the GNU General Public
# License, version 3 ("GPLv3"):
#
# If you convey this file as part of a work that contains a
# configuration script generated by Autoconf, you may do so under
# terms of your choice.
#
# Dive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Dive.  If not, see <http://www.gnu.org/licenses/>.


# -------#
# README #
# -------#

# This file should be included in Makefile.am associated to a directory which
# contains an Autotest test suite.
#
# This file assumes that:
#
# - you include *before* this file init.mk or make sure that any global
# variable can be used with the += syntax.
# - package.m4 is located in $(top_builddir)/tests
# - you provides atlocal and testsuite.at files (see Autotest
#   documentation in the Autoconf manual).
# - you defines TESTSUITE_AT which contains the list of the .at files
#   included by this test suite.


# -----#
# TODO #
# -----#

# - Make it more generic.


# Define how autom4te is called to generate the testsuite file.
AUTOTEST = $(AUTOM4TE) --language=autotest

# Package following files.
EXTRA_DIST += atlocal testsuite.at $(TESTSUITE) $(TESTSUITE_AT)

# Run testsuite in this directory.
TESTSUITE = $(srcdir)/testsuite

# Define where package.m4.in is located.
PACKAGE_M4_IN=$(top_srcdir)/tests/package.m4.in


# ----- #
# RULES #
# ----- #

check-local: atconfig atlocal $(TESTSUITE)
	$(SHELL) $(TESTSUITE) $(TESTSUITEFLAGS)

installcheck-local: atconfig atlocal $(TESTSUITE)
	$(SHELL) $(TESTSUITE) AUTOTEST_PATH="$(bindir)" $(TESTSUITEFLAGS)

clean-local:
	test ! -f $(TESTSUITE) || $(SHELL) $(TESTSUITE) --clean
	rm -f -r autom4te.cache

$(TESTSUITE): $(PACKAGE_M4_IN) $(srcdir)/testsuite.at $(TESTSUITE_AT)
	$(AUTOTEST) -I '$(srcdir)' -I'$(top_builddir)/tests' $@.at -o $@.tmp
	mv $@.tmp $@

atconfig: $(top_builddir)/config.status
	cd $(top_builddir) && $(SHELL) ./config.status tests/$@
