/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <string.h>
#include <stdint.h>
#include "_knit.h"

void cbc_encrypt(void (*cipher)(uint64_t, uint64_t *), size_t block_size, size_t n_blocks, uint64_t iv, void *p, void *c) {
	uint64_t pb;
	uint64_t cb;

        for (uint32_t i = 0; i < n_blocks; i++) {
                pb = s2i(p + i * block_size, block_size);

		pb ^= iv;

		(*cipher)(pb, &cb);

		iv = cb;

		memcpy(c + i * block_size, i2s(cb, block_size), block_size);
	}
}

void cbc_decrypt(void (*cipher)(uint64_t, uint64_t *), size_t block_size, size_t n_blocks, uint64_t iv, void *c, void *p) {
	uint64_t cb;
	uint64_t pb;

	for (uint32_t i = 0; i < n_blocks; i++) {
		cb = s2i(c + i * block_size, block_size);

		(*cipher)(cb, &pb);

		pb ^= iv;

		iv = cb;

		memcpy(p + i * block_size, i2s(pb, block_size), block_size);
	}
}
