/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <stdint.h>

uint8_t * hmac(uint8_t * (*H)(uint8_t *, uint64_t), uint16_t B, uint16_t L, uint8_t *k, size_t k_length, uint8_t *m, size_t m_length) {
	uint8_t *ipad;
	uint8_t *opad;
	uint8_t *K;

	ipad = calloc(B + m_length, 1);
	opad = calloc(B + L, 1);
 
	memset(ipad, 0x36, B);
	memset(opad, 0x5c, B);

	if (k_length > B) {
		k = (*H)(k, k_length);
		k_length = L;
	}

	K = calloc(B, 1);

	memcpy(K, k, k_length);

	// 1
	if (k_length < B)
		memset(K + k_length, 0x00, B - k_length);

	// 2
	for (uint16_t i = 0; i < B; i++)
		ipad[i] ^= K[i];

	// 3
	memcpy(ipad + B, m, m_length);

	// 4
	ipad = (*H)(ipad, B + m_length);

	// 5
	for (uint16_t i = 0; i < B; i++)
		opad[i] ^= K[i];

	// 6
	memcpy(opad + B, ipad, L);

	// 7
	opad = (*H)(opad, B + L);

	free(ipad);

	return opad;
}
