/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007  Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/** @file Ogg.H                                                              *
/*===========================================================================*/
#ifndef __OGGPLUSPLUS__
#define __OGGPLUSPLUS__
///
/// @mainpage
/// 
/// @em libogg++ is a c++ library for the %Ogg transport format.
///
/// %Ogg is an interleaving data container developed by Monty
/// at <a href="http://www.xiph.org/">Xiph.Org</a>, originally to
/// support the %Ogg Vorbis audio format.
///
/// @em libogg++ provides encapsulation/multiplexing and demultiplexing/decapsulation.
/// It overlaps in functionality with liboggz, which depends on libogg
/// for the lower-level capabilities. But @em libogg++ is not a c++ wrapper
/// of liboggz or libogg.
///
/// @section goals Design Goals
/// <ul>
/// <li> Minimally gnostic transport and logical layers.
///      The logical layer assumes only that the transport layer
///      transports with fidelity.
///
///      The transport layer knows that the logical streams, distinguishable
///      by a serial number,come in packets of specified sizes, and marked
///      each with a granule position which is monotonically increasing.
///
/// <li> The transport layer can be elaborated for interleave ordering
///      for codecs of multiple contemporaneous streams of more than
///      one logical type, which may not be all time-continuous.
///
/// <li> The logical layer can be elaborated for specific codecs.
///
/// <li> The transport and logical layers can run in separate threads.
/// </ul>
///
///
/// @section licensing Licensing
///
///
/// @verbatim
/// Copyright (C) 2006, 2007  Elaine Tsiang YueLien
///
/// libogg++ is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the
/// Free Software Foundation, Inc.
/// 51 Franklin Street, Fifth Floor
/// Boston, MA  02110-1301, USA
/// @endverbatim
///

/// @defgroup overrides	Specialization via Overloading
///
/// These are either Ogg:: functions or virtual class methods.
/// The Ogg:: functions relate either to sequence ordering among logical streams
/// (termed media mapping in the %Ogg specification)
/// or conversion between granule position and some codec-specific time-like unit.
/// Overriding these functions provide a first level of specialization
/// without class derivation.


/// @defgroup derivables Derivable and Nonderivable Classes
///

/// @defgroup errorHandling Error and Excception Handling
///

#ifdef __GNUG__
#pragma interface
#endif

#include <cstddef>

namespace Ogg
{
  typedef long long int		Position;
  typedef long long int		PacketNo;
}

#include <Ogg/Transport.H>
#include <Ogg/Logical.H>

#endif
