/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/** @file Exception.H                                                        *
 *                                                                           *
 *  Ogg::Exception base class for exceptions                                 *
 *                                                                           */
/*===========================================================================*/
#ifndef	OggException
#define	OggException

#ifdef __GNUG__
#pragma interface
#endif

#include	<exception>
#include	<string>
#include	<sstream>


namespace	Ogg
{
  using	std::exception;
  using std::string;
  using	std::ostringstream;

  /// @brief Exceptions base class
  ///
  /// @ingroup errorHandling
  class Exception : public exception, public ostringstream
  {
  public:
    Exception(
	      const	char *	nm
	      ) throw()
      ;

    /// @brief For suppressing copy construction of ostringstream.
    Exception(
	      const	Exception &	ex
	      ) throw()
      : exception()
    {
      str() = ex.str();
    }

    virtual
    ~Exception() throw()
    {}

    virtual
    const char* what() const throw()
    {
      return(str().c_str());
    }
  }
  ;


  /// @brief Transport errors testable with Logical::Reader::transportError.
  ///
  /// @ingroup errorHandling
  class Error
  {
  private:
    Error &
    operator=(const Error &);

  public:
    enum ErrorNo
      {
	None
	,BeyondCurrentVersion
	,SomeStreamsIgnored
	,PacketNonContinuation
	,PacketContinuation
	,NonContinuity
	,BadGranulePosition
	,StreamBegin
	,StreamEnd
	,PrematureEnd
      };

    Error &
    operator |=(ErrorNo);

    Error &
    operator |=(Error &);

    bool
    operator [](ErrorNo);

    const char *
    operator ()(ErrorNo);

  }
  ;
}
#endif
