/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for transport of the Ogg format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/** @file Thread.H                                                           *
 *                                                                           */
/* Examples::Thread - base class for threaded classes                        */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleThread
#define	ExampleThread


#ifdef __GNUG__
#pragma interface
#endif

#include	<Ogg/Exception.H>

extern	"C"
{
#include	<pthread.h>
}

namespace	Examples
{
  using		namespace Ogg;

  void *	runThread(
			  void * 
			  );

  class	Thread
  {
  protected:
    pthread_t *		thread;
    pthread_attr_t 	attr;


    friend void *	runThread(
				  void * 
				  )
      // calls	Thread::run
      ;

  public:
    Thread()
      : thread(0)
    {}

    virtual
    ~Thread()
    {}
						   
    virtual
    void	start();

    virtual
    void	run() = 0;

    virtual
    void	finish();

    
    class FailedToSpawnThread : public Exception
    {
      int	dummy;

    public:
      FailedToSpawnThread() throw()
	: Exception("Failed to spawn thread")
      {
	*this << std::endl;
      }


      FailedToSpawnThread(
			  const FailedToSpawnThread & ex
			  ) throw()
	: Exception(ex)
      {}

      ~FailedToSpawnThread() throw()
      {}
    }
    ;

    class FailedToFinishThread : public Exception
    {
    public:
      FailedToFinishThread() throw()
	: Exception("Failed to finish thread")
      {
	*this << std::endl;
      }


      FailedToFinishThread(
			   const FailedToFinishThread & ex
			   ) throw()
	: Exception(ex)
      {}

      ~FailedToFinishThread() throw()
      {}
    }
    ;

  }
  ;

}
#endif
