/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Ogg::Transport to Logical interface                                       */
/*                                                                           */
/*===========================================================================*/
#ifndef TransportToLogicalInterface
#define	TransportToLogicalInterface

#ifdef __GNUG__
#pragma interface
#endif

namespace	Ogg
{
  class		TransportToLogical;
}

#include	<LogicalImpl.H>


///
///@file <src/lib/TransportToLogical.H>
///
namespace	Ogg
{
  /// @brief Transport to Logical implementation interface
  ///
  /// @ingroup transportImplementation
  ///
  /// Deques packets from each of its Logical streams.
  /// Encapsulates packet(s) into the corresponding page.
  /// Or decapsulates packets from an Ogg stream
  /// and enques them to the appropriate Logical stream.
  ///

  class TransportToLogical
  {
    friend class	Logical;
    friend class	LogicalImpl;
    friend class	ReaderImpl;

  protected:
    Transport &
    intf();

    /// @brief What this transport was set up to do
    bool
    encapsulating();

    //@{
    /// @brief Called by Logical constructor to enter the mux process
    void
    enterMux();

    /// @brief Called by Logical destructor to exit the mux process
    void
    exitMux();

    /// @brief Add a logical stream
    ///
    /// Called by LogicalImpl::Writer
    ///
    void
    add(
	LogicalToTransport &
	);

    //@{
    /// @brief Called by Logical constructor to enter the reader selection process
    void
    enterSelect();

    /// @brief Called by Logical destructor to exit the reader selection process
    void
    exitSelect();

    /// @brief Select the stream for this Logical
    ///
    /// Return serialNo of stream claimed, 0 if failure.
    //@}
    long
    select(
	   LogicalToTransport &
	   );

    /// @brief Seek forward to packetNo and position in logical stream
    Packet *
    seek(
	 LogicalToTransport &
	 ,PacketNo
	 ,Position
	 );

    /// @brief Called by ~Writer to wait for Transport to be done with the last packet
    void
    lastPacket(
		long	serialNo
		);

  };
};
#endif
