/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* BuildObservables                                                          */
/*                                                                           */
/*===========================================================================*/
#include	<Observ.H>
#include	<GoBase.H>

extern "C"
{
#include	<stdlib.h>
}
/*===========================================================================
  =========================================================================*/
int main(
	 int     	argc
	 , const char**	argv
	 )
{
  using namespace Persistence;
  using namespace Examples;

  struct 
  {
    const char*			name;
    const Obs::ObsType		type;
    const Obs::SomeProperty	skew;
  } simpleObss[] =
    {
      {"a:",	Obs::SHWA,	Obs::CENTER},	// schwa
      {"e:",	Obs::MIDFRONT,	Obs::CENTER},
      {"i:",	Obs::CLOSFRONT,	Obs::CENTER},
      {"o:",	Obs::MIDBACK,	Obs::CENTER},
      {"u:",	Obs::CLOSBACK,	Obs::CENTER},
      {"A:",	Obs::OPENBACK,	Obs::CENTER},
      {"U:",	Obs::CLOSROUND,	Obs::CENTER},
      {"O:",	Obs::MIDROUND,	Obs::CENTER},
      {"W:",	Obs::CLOSSHWA,	Obs::CENTER},
      {"f:",	Obs::LABIAL,	Obs::CENTER},
      {"s:",	Obs::DENTAL,	Obs::CENTER},
      {"T:",	Obs::ALVEOLAR,	Obs::CENTER},
      {"S:",	Obs::PALATAL,	Obs::CENTER},
      {"K:",	Obs::VELAR,	Obs::CENTER},
      {"l:",	Obs::LATERAL,	Obs::CENTER},
      {"r:",	Obs::RETROFLEX,	Obs::CENTER},
      {"w:",	Obs::CLOSBACK,	Obs::CENTER},
      {"y:",	Obs::CLOSFRONT,	Obs::CENTER},
      {"m:",	Obs::LABIAL,	Obs::CENTER},
      {"n:",	Obs::ALVEOLAR,	Obs::CENTER},
      {"N:",	Obs::VELAR,	Obs::CENTER},
      {"~:",	Obs::PALATAL,	Obs::CENTER},

      {"!",	Obs::NONS,	Obs::UP},    
      {"@",	Obs::NONS,	Obs::UP},    
      {"#",	Obs::NONS,	Obs::UP},    
      {"$",	Obs::NONS,	Obs::UP},    

      {"%",	Obs::NONS,	Obs::DOWN},  
      {"^",	Obs::NONS,	Obs::DOWN},  
      {"&",	Obs::NONS,	Obs::DOWN},  
      {"*",	Obs::NONS,	Obs::DOWN},  

      {"-",	Obs::NONS,	Obs::CENTER},

      {"+",	Obs::NONS,	Obs::UP},    
      {":",	Obs::NONS,	Obs::DOWN},  

      {"",	Obs::NONS,	Obs::CENTER}
    
    };

  //------------------------------------------------------------------------------
  //	open object data base
  //
  GoBase *	ob = new GoBase(
				"objects"
				,"."
				);


  Class * cla;
  cla = get<Class>(Observ::classId());
  if ( cla )
    cla->dump(std::cout);
  cla = get<Class>(Class::classId());
  if ( cla )
    cla->dump(std::cout);

  for ( int i=0
	  ;
	!(std::string(simpleObss[i].name)).empty()
	  ;
	++i
	)
    {
      Obs	* obs = get<Obs>(
				 simpleObss[i].name
				 );

      char *	lastnm = "";

      /*
      if ( i )
	lastnm = simpleObss[i-1].name;
      */

      if ( !obs )
	{
	  obs = new Obs(simpleObss[i].name
			,simpleObss[i].type
			,simpleObss[i].skew
			,lastnm
			);
	  std::cout << "created Obs #" << i << " " << obs->cname() << std::endl;
	}
      else
	{
	  obs->updateProp(simpleObss[i].type
			  ,simpleObss[i].skew
			  ,lastnm
			  );
	  std::cout << "updated Obs #" << i << " " << obs->cname() << std::endl;
	}
    }

  Status sta;
	     
  //
  //	dump them
  //
  std::cout << "::Class objects in memory::::::::::::::::::::::::::" << std::endl;
  
  
  for ( cla = first<Class>()
	  ;
	0 != cla
	  ;
	cla = next<Class>(*cla)
	)
    {
      sta = cla->put();
      if ( sta.succeeded() )
	{
	  std::cout << "saved Class '" << cla->cname() << "'" << std::endl;
	}
      else
	std::cout << sta;
    }

  std::cout << "::Observ objects in memory:::::::::::::::::::::::::" << std::endl;
  for ( Obs * obs = first<Obs>()
	  ;
	0 != obs
	  ;
	obs = next<Obs>(*obs)
	)
    {
      sta = obs->put();
      if ( sta.succeeded() )
	{
	  std::cout << "saved Obs '" << obs->cname() << "'" << std::endl;
	}
      else
	std::cout << sta;
    }

  delete ob;

}


