/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Class Object-derived class object class implementation          */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif


#include	<Class.H>

namespace	Examples
{
  using namespace Persistence;

  void
  ClassInfo::init(
		  const Id	clid
		  ,const char *	clnam
		  ,const char *	cldecl
		  ,const char *	climpl
		  ,const size_t	nobjs
		  )
  {
    Class *cla = get<Class>(clid);

    if ( !cla )
      {
	cla = new Class(clid
			,clnam
			,cldecl
			,climpl
			,nobjs
			);

	std::cout << "created:" << std::endl;
	cla->dump(std::cout);
      }
    else if ( !cla->toBeUpdated() )
      {
	std::cout << "updated:" << std::endl;
	cla->dump(std::cout);
	cla->updateDclImp(cldecl
			  ,climpl
			  );
      }
  }


  Id		Class::ClassId(ExampleClass);
  Name		Class::ClassName("Class");
  LongName	Class::ClassDecl(ClassClassDecl);
  LongName	Class::ClassImpl("Class.C $Id$ keyword substitution from version control");

  //---------------------------------------------------------------------------
  Class::Class(
	       const	Id	i
	       ,const	char *	nm
	       ,const	char *	dcl
	       ,const	char *	imp
	       ,size_t		nobjs
	       )
    : Obj(nm, ClassId, i)
      , OwnsObjs(nobjs)
      , decl(dcl)
      , impl(imp)
  {
    if ( (0 < nobjs)
	 &&
	 (nobjs < MinObjs)
	 )
      {
	nobjs = MinObjs;
      }

    init(
	 ClassId		// Class ClassId
	 ,ClassName.cstr()
	 ,ClassDecl.cstr()
	 ,ClassImpl.cstr()	// Class Class Impl
	 ,MinObjs
	 );

    if ( (0 < nobjs)
	 && !has_objs()
	 )
      {
	mrefObjs mr(
		    *this
		    ,objName + ".objs"
		    ,nobjs
		    );
	objs() = mr;
      }

    Class *cla = get<Class>(ClassId);

    if ( cla->has_objs() )
      {
	cla->insert_obj(*this);
      }
  }

  Class::~Class()
  {
    if ( (dtorCommand() == DtorCommand::DEL)
	 ||
	 (dtorCommand() == DtorCommand::DELETE)
	 )
      {
	// reverse the insertion in Class(...)
	// if we are obliterating this
	Class *cla = get<Class>(ClassId);
	
	if ( cla->has_objs() )
	  {
	    cla->remove_obj(*this);
	  }
      }

  }

  //------------------------------------------------------------------------------
  void		Class::dump(
			    ostream &	out
			    ) const
  {
    this->Object::dump(out);

    out << "Class decl = " << decl.cstr() << std::endl;
    out << "Class impl = " << impl.cstr() << std::endl;
    out << "Class objs : " << std::endl;

    this->OwnsObjs::dump_objs(out);

  }
  //------------------------------------------------------------------------------
  Status
  Class::put()
  {
    Status s(Persistence::put<Class>(*this));

    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("Class"
		   ,"put"
		   ,cname()
		   );
	sta << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }

  Status
  Class::del()
  {
    Status s(Persistence::del<Class>(*this));
    
    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("Class"
		   ,"del"
		   ,cname()
		   );
	sta << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }


}

