/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Class Object-derived class object class interface               */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleClass
#define	ExampleClass	1

#define	ClassClassDecl  "Class.H $Id$ keyword substitution from version control"

#ifdef __GNUG__
#pragma interface
#endif

#include	<persist/Object.H>
#include	<persist/DtorCommand.H>
#include	<persist/mref.H>
#include	<persist/GetPutDelTemplates.H>
#include	<persist/RelocateTemplates.H>

namespace	Examples
{
  using namespace Persistence;

  class ClassInfo
  {
    //
    // class methods
    //
  public:
    static
    void		init(
			     const Id		clid
			     ,const char *	clnam
			     ,const char *	cldecl
			     ,const char *	climpl
			     ,const size_t	nobjs
			     );
  }
  ;


  class Class;
  typedef	ref<Class *>	refClass;

  //mDefineMrefOwner(Class, Obj, obj)
  typedef Owns_objs<Class, Obj>	OwnsObjs;
  typedef OwnsObjs::mref_objs	mrefObjs;
  typedef OwnsObjs::i_objs	iObjs;

  class Class: public ClassInfo, public Obj, public OwnsObjs
  {
    friend class ClassInfo;
    // class data common to all persistent classes ------------------------------------
  private:
    static
    Id			ClassId;
    static
    Name		ClassName;
    static
    LongName		ClassDecl;
    static
    LongName		ClassImpl;
  public:
    static
    Id    		classId()
    {
      return(ClassId);
    }
    
    static
    const char *	className()
    {
      return(ClassName.cstr());
    }
    
    static
    const char *	classDecl()
    {
      return(ClassDecl.cstr());
    }

    static
    const char *	classImpl()
    {
      return(ClassImpl.cstr());
    }
    // -------------------------------------------------------------------------------

  private:
    // particular to this class
    static
    const size_t	MinObjs = 11;


    // object attributes
  private:
    LongName	decl;			// declarations versioin string
    LongName	impl;			// implementation version string

    //
    // object methods
    //
  public:
    Class()
      : Obj()
	, OwnsObjs()
    {}

    Class(
	  const		Id	i
	  ,const	char *	nm
	  ,const	char *	dcl
	  ,const	char *	imp
	  ,size_t		nobjs = 0
	)
      ;

    ~Class();

    
    // called by init() of each class derived from ClassInfo
    // including this Class
    void		updateDclImp(
				     const char * 	dcl
				     ,const char *	imp
				     )
    {
      decl = dcl;
      impl = imp;
      Obj::update();				/* mark for syncing of persistent object
						   to current changes
						*/
    }

    Status		put();
    Status		del();

    void	dump(
		     ostream &	out
		     ) const;

  }
  ;  

}

namespace	Persistence
{
  using namespace Examples;

  //
  // instantiate template functions
  //
  template
  Class *	get(
		    const char *	name
		    );

  template
  Class *	get(
		    const Id		id
		    );
  template
  Status	put(
		    Class &	cla
		    );
  template
  Status	del(
		    Class & 	cla
		    );
  template
  Class *	first();

  template
  Class *	next(const Class	&);

}
#endif
