/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Filter - base filter implementation                             */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif


#include	<Sync.H>
#include	<BlockStream.H>

namespace	Examples
{
  using namespace	Persistence;

  Filter::Filter(
		 const char *	nm	// name
		 ,Id		clasid	// class id
		 ,bool	first	// first thread ever?
		 ,int		cp	// which node to run thread on
		 ,Sync &	syn
		 )
    : Obj(nm, clasid)
    , DtorCommand()
    , Thread(first
	     ,cp
	     )
    , rsync(syn)
  {
    syn.insert(*this);
  }



  Filter::~Filter()
  {
    if ( (dtorCommand() == DtorCommand::DEL)
	 ||
	 (dtorCommand() == DtorCommand::DELETE)
	 )
      {
	rsync->remove(*this);
      }
  }

  void
  Filter::sync()
  {
    rsync->sync();
  }

  void *
  runFilter(void *	filtr)
  {
    Filter *	filter = static_cast<Filter *>(filtr);

    Status & s = *(filter->runStatus);

    s << "Filter " << filter->cname() << " run status : " << std::endl;

    Bout.begin();
    s &= filter->bind();
    // wait for everybody to have been spawned
    std::cout << filter->cname() << " syncing after bind" << std::endl;
    Bout.end();
    filter->sync();

    if ( s.succeeded() )
      {
	Bout.begin();
	filter = filter->relocate();
	// wait for everybody to have relocated
	std::cout << filter->cname() << " syncing after relocate" << std::endl;
	Bout.end();
	filter->sync();

	if ( filter )
	  {
	    Bout.begin();
	    filter->swizzle();
	    // wait for everybody to have swizzled
	    std::cout << filter->cname() << " syncing after swizzle" << std::endl;
	    Bout.end();
	    filter->sync();

	    filter->run();
	    // don't leave till everybody is done
	    Bout.begin();
	    std::cout << filter->cname() << " syncing after run" << std::endl;
	    Bout.end();
	    filter->sync();
	  }
      }
    // no provision for when some thread gets stuck
    // or when a thread bombs, and others are still waiting
    return(filter->runStatus);
  }
}
