/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* RunNUMAThreads                                                            */
/*                                                                           */
/*===========================================================================*/
#include	<GoBase.H>
#include	<SrcFilter.H>
#include	<ThruFilter.H>
#include	<SinkFilter.H>
#include	<BlockStream.H>

extern "C"
{
#include <unistd.h>
}

/*===========================================================================
  =========================================================================*/
int main(int argc, const char* argv[])
{
  using namespace	Examples;
  using namespace	Persistence;

  GoBase *	ob = new GoBase(
				"objects"
				,"."
				);
  
  // get all relevant derived Filters
  // the Ques would be automatically loaded.
  // So should the sync.
  Bout.begin();
  SrcFilter *	src = get<SrcFilter>("->Que1");
  Bout.end();

  Bout.begin();
  if ( src )
    src->dump(std::cout);
  Bout.end();

  Bout.begin();
  ThruFilter *	thru = get<ThruFilter>("Que1->Que2");
  std::cout << "Thru middleOfOutput:" << thru->middleOfOutput.start() << " " << thru->middleOfOutput.size() <<std::endl;
  std::cout << "Thru middleOfInput:" << thru->middleOfInput.start() << " " << thru->middleOfInput.size() <<std::endl;
  Bout.end();

  Bout.begin();
  if ( thru )
    thru->dump(std::cout);
  Bout.end();

  Bout.begin();
  SinkFilter *	sink = get<SinkFilter>("Que2->");
  Bout.end();

  Bout.begin();
  if ( sink )
    sink->dump(std::cout);
  Bout.end();
  
  Bout.begin();
  Sync *	sync = get<Sync>("ExampleNUMAThreads");
  Bout.end();

  if ( sync )
    {
      Bout.begin();
      sync->dump(std::cout);
      Bout.end();

      // this starts everything
      src->start();

      // getting the relocated srcFilter
      // creates write race condition between
      // this exec thread and the srcFilter's thread
      // and may lead to fields (like head_) being used
      // before they have been properly copied in relocation
      // so use this sleep kludge here
      //
      // With Sync providing barriers for the exec thread as well,
      // the barriers will prevent this race condition.
      sleep(2);
      
      // wait till relocated
      SrcFilter * relocSrc;
      while ( src == (relocSrc = get<SrcFilter>("->Que1")) )
	;

      // must finish each thread separately
      // because they have been relocated
      // each thread is no longer available
      // after it has been finished
      Status s = relocSrc->finish();
      std::cout << s;

      thru = get<ThruFilter>("Que1->Que2");
      s = thru->finish();
      std::cout << s;

      sink = get<SinkFilter>("Que2->");
      s = sink->finish();
      std::cout << s;
    }

  exit(0);

}
