/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::SinkFilter - sink Filter implementation                         */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif


#include	<SinkFilter.H>
#include	<persist/GetPutDelTemplates.H>
#include	<persist/RelocateTemplates.H>
#include	<BlockStream.H>

namespace	Persistence
{
  using namespace Examples;

  //
  // instantiate template functions
  //
  template
  SinkFilter *	get(
		    const char *	name
		    );

  template
  SinkFilter *	get(
		    const Id
		    );
  template
  Status	put(
		    SinkFilter &
		    );
  template
  Status	del(
		    SinkFilter &
		    );
  template
  SinkFilter *	first();

  template
  SinkFilter *	next(const SinkFilter	&);

  template
  SinkFilter *	relocate(
			 SinkFilter &
			 );

  template
  void		swizzle(
			SinkFilter &
			);

}


namespace	Examples
{
  using namespace	Persistence;

  Id		SinkFilter::ClassId(ExampleSinkFilter);
  Name		SinkFilter::ClassName("SinkFilter");
  LongName	SinkFilter::ClassDecl(SinkFilterClassDecl);
  LongName	SinkFilter::ClassImpl("SinkFilter.C $Id$ keyword substitution from version control");

  SinkFilter::SinkFilter(
			 bool		first	// first thread ever?
			 ,int		nod	// which node to run thread on
			 ,Sync &	syn
			 ,Que &		inque
			 )
    : Filter((Name(inque.cname()) + "->").cstr()
	     ,classId()
	     ,first
	     ,nod
	     ,syn
	     )
    , inputQue(inque)
  {
    init(
	 ClassId		// Class ClassId
	 ,ClassName.cstr()
	 ,ClassDecl.cstr()
	 ,ClassImpl.cstr()	// Class Class Impl
	 ,0			// don't keep track of SinkFilters
	 );

    inque.output(this->id());
  }

  SinkFilter::~SinkFilter()
  {
    if ( (dtorCommand() == DtorCommand::DEL)
	 ||
	 (dtorCommand() == DtorCommand::DELETE)
	 )
      {
	refQue r(inputQue);	// check to see whether inputQue still there
	if ( r != 0 )
	  r->output(0);
      }
  }
						   

  Status
  SinkFilter::start()
  {
    Status s = Filter::start();
    if ( !s.succeeded() )
      {
	s = Status(
		   "SinkFilter"
		   ,"start"
		   ,cname()
		   );
	s << " failed to start on separate thread" << std::endl;
      }
    return(s);
  }
  
  //------------------------------------------------------------------------------
  Status
  SinkFilter::put()
  {
    Status s(Persistence::put<SinkFilter>(*this));

    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("SinkFilter"
		   ,"put"
		   ,cname()
		   );
	sta << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }

  Status
  SinkFilter::del()
  {
    Status s(Persistence::del<SinkFilter>(*this));
    
    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("SinkFilter"
		   ,"del"
		   ,cname()
		   );
	sta << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }
  //------------------------------------------------------------------------------
  SinkFilter *
  SinkFilter::relocate()
  {
    return(Persistence::relocate<SinkFilter>(*this));
  }

  void
  SinkFilter::swizzle()
  {
    Persistence::swizzle<SinkFilter>(*this);
  }

  void
  SinkFilter::run()
  {
    // sink
	    
    for ( iRead r = inputQue->beginRead()
	    ;
	  
	  r != inputQue->endRead()
	    ;
	  ++r
	  )
      {
	Array frames(*r);
	Bout.begin();
	std::cout << "read frame:" << std::endl;
	for ( size_t j = 0; j < frames.size(); j++ )
	  {
	    if ( 0 != j )
	      std::cout << ", ";
	    std::cout << frames[j];
	  }
	std::cout << std::endl;
	Bout.end();
      }
  }
  //------------------------------------------------------------------------------
  void		SinkFilter::dump(
				 ostream &	out
				 ) const
  {
    Object::dump(out);

    out << "input Que is " << inputQue->cname() << std::endl;
  }

}
