/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Sync - thread synchronizer                                      */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleSync
#define	ExampleSync	241

#define	SyncClassDecl  "Sync.H $Id$ keyword substitution from version control"

#ifdef __GNUG__
#pragma interface
#endif

#include	<persist/Object.H>
#include	<persist/mref.H>
#include	<Class.H>

namespace	Examples
{
  class Sync;
  typedef ref<Sync *>			refSync;
}

#include	<Filter.H>

extern "C" 
{
# include	<pthread.h>
}


namespace	Examples
{
  using namespace	Persistence;

  mDefineMrefOwner(Sync, Filter, filt)
  typedef Owns_filts			OwnsFilts;
  typedef Owns_filts::mref_filts	mrefFilts;
  typedef Owns_filts::i_filts		iFilts;

  class	Sync: public Obj, public OwnsFilts, public ClassInfo
  {
    friend class ClassInfo;
    // class data and methods
  private:
    // common to all persistent classes
    static
    Id			ClassId;
    static
    Name		ClassName;
    static
    LongName		ClassDecl;
    static
    LongName		ClassImpl;
  public:
    static
    Id    		classId()
    {
      return(ClassId);
    }
    
    static
    const char *	className()
    {
      return(ClassName.cstr());
    }
    
    static
    const char *	classDecl()
    {
      return(ClassDecl.cstr());
    }

    static
    const char *	classImpl()
    {
      return(ClassImpl.cstr());
    }

  private:
    size_t		nToSync;
    pthread_mutex_t	syncLock;
    bool		syncing;
    pthread_cond_t	beginSyncCond;
    pthread_cond_t	endSyncCond;
    size_t		nSyncing;
    
  public:
    Sync()
      : Obj()
	, OwnsFilts()
    {
      pthread_mutex_init(&syncLock, 0);
      pthread_cond_init(&beginSyncCond, 0);
      pthread_cond_init(&endSyncCond, 0);
    }

    Sync(
	 const char * nm
	 )
      ;

    ~Sync()
    {}

    void	insert(
		       Filter &		o
		       );

    void	remove(
		       Filter &		o
		       );

    void	sync();

    Status	put();
    Status	del();

    void	dump(
		     ostream &	out
		     ) const;

  }
  ;
}

#endif
