/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Thread - filter base class implementation                       */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif

#include	<Thread.H>
#include	<Sync.H>

extern	"C"
{
#include	<numa.h>
#include	<sched.h>   
}

namespace	Examples
{
  using namespace	Persistence;

  Status
  Thread::bind()
  {
    if ( 0 > numa_available() )
      {
	Status sta(
		   "NUMA not available"
		   ,"Thread"
		   ,"bind"
		   );
	return(sta);
      }

    // set NUMA node
    int		max_node = numa_max_node();
    std::cout << "max node # is " << max_node << std::endl;
    int		max_cpu = (max_node+1) * CpusPerNode -1; 
    std::cout << "max cpu # is " << max_cpu << std::endl;

    // are we running on our assigned cpu?
    cpu_set_t	cpumask;
    CPU_ZERO(&cpumask);

    pthread_getaffinity_np(*thread
			   , sizeof(cpumask)
			   , &cpumask
			   );
    if ( CPU_ISSET(cpu, &cpumask) )
      {
	std::cout << "running on cpu" << cpu << std::endl;
	for ( short i = 0
		;
	      i <= max_cpu
		;
	      ++i
	      )
	  {
	    if ( !CPU_ISSET(i, &cpumask) )
	      std::cout << "NOT running on cpu" << i << std::endl;
	  }
      }
    else
      {
	Status sta(
		   "affinity failed"
		   ,"Thread"
		   ,"bind"
		   );
	sta << " on cpu " << cpu << std::endl;
	return(sta);
      }
	


    struct bitmask	nodemask = *numa_no_nodes_ptr;
    numa_bitmask_setbit(&nodemask, node);
    numa_set_membind(&nodemask);
      // memory allocation is limited to node
      ;
    //numa_set_preferred(-1)
      // memory allocation is preferred on local node
      ;

    nodemask = *numa_get_membind();
    if ( numa_bitmask_isbitset(&nodemask, node) )
      {
	std::cout << "allocating memory preferably on node "
		  << node << std::endl;
	for ( short i = 0
		;
	      i <= max_node
		;
	      ++i
	      )
	  {
	    if ( !numa_bitmask_isbitset(&nodemask, i) )
	      std::cout << "NOT on node" << i << std::endl;
	  }
      }
    else
      {
	Status sta = Status(
			    "preference failed"
			    ,"Thread"
			    ,"bind"
			    );
	sta << " for node " << node << std::endl;
	return(sta);
      }
			 
    return(true);

  }


  Status
  Thread::start()
  {
    pthread_attr_init(&attr);	// default values

    // set scheduling policy
    if ( inherit_sched )
      {
	pthread_attr_setinheritsched(&attr, PTHREAD_INHERIT_SCHED);
      }
    else
      {
	pthread_attr_setinheritsched(&attr, PTHREAD_EXPLICIT_SCHED);
	pthread_attr_setschedpolicy(&attr, SCHED_OTHER);	// default, but not realistic
      }

    // assume spawner runs on all
    // so its affinity includes all cpus
    cpu_set_t	cpumask;

    pthread_getaffinity_np(
			   pthread_self()
			   ,sizeof(cpumask)
			   ,&cpumask
			   );

    if ( !CPU_ISSET(cpu, &cpumask) )
      {
	Status sta(
		   "cpu"
		   ,"Thread"
		   ,"start"
		   );
	sta << "# " << cpu << " not available" << std::endl;
	return(sta);
      }

    CPU_ZERO(&cpumask);
    CPU_SET(cpu, &cpumask);
    // sets thread to run on cpu
    pthread_attr_setaffinity_np(&attr, sizeof(cpumask)
				,&cpumask
				)
      ;
    thread = new pthread_t;
    // allocate here so it won't go away after finish
    runStatus = new Status(true);
    *runStatus << "";
    Filter * f = static_cast<Filter *>(this);
    if ( 0 != 
	 pthread_create(thread
			,&attr
			,runFilter
			,static_cast<void *>(f)
			)
	 )
      {
	delete thread;
	thread = 0;
	Status s(
		 "thread creation failed"
		 ,"Thread"
		 ,"start"
		 );
	return(s);
      }

    return(true);
  }

  Status
  Thread::finish()
  {
    void *	pretval;
    
    if ( 0 ==
	 pthread_join(*thread
		      ,&pretval
		      )
	 )
      {
	return(*static_cast<Status *>(pretval));
      }
    else
      {
	Status s(
		 "join failed"
		 ,"Thread"
		 ,"finish"
		 );
	return(s);
      }
  }
}
