/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Thread - base class for filters                                 */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleThread
#define	ExampleThread


#ifdef __GNUG__
#pragma interface
#endif

extern	"C"
{
#include	<pthread.h>
}

#include	<persist/Basic.H>

namespace	Examples
{
  using namespace	Persistence;

  class	Thread
  {
  protected:
    // could deduce from "distance information"
    // to be provided by kernel >=2.6.10?
    static
    const size_t	CpusPerNode = 2;

    bool	inherit_sched;
    size_t	cpu;		// which cpu to bind to
    size_t	node;		// which node to bind to
    pthread_t *	thread;
    pthread_attr_t attr;

    //
    // returned by friend run
    //
    Status	 * runStatus;


    Status	bind()
      // sets memory binding once started
      ;

  public:
    Thread()
    {}
    
    Thread(
	   bool		first	// first thread ever?
	   ,size_t	cp	// which cpu to run thread on
	   )
      : inherit_sched(!first)	// inherit scheduling policy if not first
	, cpu(cp)
	, node(cp/CpusPerNode)
	, thread(0)
	, runStatus(0)
    {}

    virtual
    ~Thread()
    {}
						   
    virtual
    Status	start();		/* called by spawner
					   starts this thread
					*/
    bool	started()
    {
      if ( thread )
	return(true);
      else
	return(false);
    }

    virtual
    Status	finish();		/* called by spawner
					   finishes this thread when thread ends
					*/
    bool	finished()
    {
      return(!started());
    }
  }
  ;

}
#endif
