/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::OMan in memory object manager class implementation           */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif

#include	<persist/OMan.H>
#include	<persist/GetPutDelTemplates.H>

namespace	Persistence
{
  template
  Obj *		get(
		    const Id		id
		    );

  OMan * OMan::oman(static_cast<OMan *>(0));

  ObjectManager::ObjectManager()
    : ReadWriteLock()
      , idGen()
  {
    oman = this;
  }

  //
  // only one in shared memory space
  //
  OMan *
  ObjectManager::obj()
  {
    if ( !oman )
	oman = new OMan;
    return(oman);
  }

  void
  OMan::registr(
		Obj &	obj
		)
  {
    startWrite();
    {
      // new or overwrite
      byAddress[obj.head()] = &obj;
      byNames[std::string(obj.cname())] = &obj;
      byIds[obj.id()] = &obj;
    }
    endWrite();

    //std::cerr << "Registered Object " << obj.cname() << " @" << &obj << " at head " << obj.head() << std::endl;
  }

  void
  OMan::unregistr(
		  void *	o
		  )
  {

    Object *	po = 0;

    startWrite();
    {
      iByAddress ia = byAddress.find(o);
      if ( ia == byAddress.end() )
	{
	  endWrite();
	  // not say a thing, bad!
	  return;
	}

      po = ia->second;

      iByNames i = byNames.find(ia->second->cname());
      if ( i != byNames.end() )
	{
	  if ( ia->second == i->second )	// unique by address, not content!
	    byNames.erase(i);
	}

      iByIds ii = byIds.find(ia->second->id());
      if ( ii != byIds.end() )
	{
	  if ( ia->second == ii->second )	// unique by address, not content!
	    byIds.erase(ii);
	}
      
      byAddress.erase(ia);

    }

    endWrite();

    //std::cerr << "Unregistered Object " << po->cname() << " at head " << po->head() << std::endl;

  }

}
