/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::OBase object database virtual class interface                */
/*                                                                           */
/*===========================================================================*/
#ifndef	PersistObjectBase
#define	PersistObjectBase

#ifdef __GNUG__
#pragma interface
#endif

extern "C" 
{
#include	<gdbm.h>
#include	<signal.h>
}

#include	<persist/Object.H>
#include	<persist/ReadWriteLock.H>


namespace	Persistence
{

  class		ObjectBase;
  typedef	ObjectBase		OBase;

  class ObjectBase : protected ReadWriteLock
  {
  private:
    static
    OBase *	DefaultOBase;

  public:
    static
    void	defaultOBase(		// derived class sets it
			     OBase * ob
			     );
    static
    OBase *	defaultOBase();		// called by library classes

  public:
    ObjectBase()
    {}

    virtual
    ~ObjectBase()
    {}

    virtual
    Obj *	get(
		    const Id		id
		    ) = 0;
    virtual
    Obj *	get(
		    const char *	nam
		    ) = 0;

    virtual
    Status	put(
		    Obj &		obj
		    ) = 0;
    virtual
    Status	del(
		    Obj &		obj
		    ) = 0;

    virtual
    Obj	*	first() = 0;
    virtual
    Obj *	next(
		     const Obj &	obj
		     ) = 0;
  };

}
#endif
