/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::relocate, swizzle function definitions                       */
/*                                                                           */
/*===========================================================================*/
#ifndef PersistRelocateTemplates
#define	PersistRelocateTemplates

#include	<persist/Object.H>
#include	<persist/DtorCommand.H>
#include	<persist/GetPutDel.H>

#include	<iostream>

namespace Persistence
{
  //------------------------------------------------------------------------------
  template<class T>
  T *		relocate(
			 T &		o
			 )
  {
    if ( o.dtorCommand() == DtorCommand::RELOCATE )
      {
	// necessary to break cyclicity
	// been here before
	return(0);
      }
    
    o.setDtorCommand(DtorCommand::RELOCATE);
    Obj * obj = static_cast<Obj *>(&o);
    o.~T();				// recurse via ~tref()
    Obj * ro = obj->relocate();

    T * to = 0;
    if ( ro )
      {
	to = reconstruct<T>(ro);
	if ( to )
	  {
	    to->resetDtorCommand();
	    std::cerr << T::classId() << " class object " << ro->cname() << " @" << &o << " relocated to " << ro << std::endl;
	  }
      }

    return(to);
  }

  template<class T>
  void		swizzle(
			T &		o
			)
  {
    if ( o.dtorCommand() == DtorCommand::SWIZZLE )
      {
	// been here before
	return;
      }

    o.setDtorCommand(DtorCommand::SWIZZLE);
    Obj * obj = static_cast<Obj *>(&o);
    o.~T();				// recurse via ~tref() first
    reconstruct<T>(obj);

    return;
  }

}

#endif
