/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::tref transitive reference template class interface           */
/*                                                                           */
/*===========================================================================*/
#ifndef	PersistTransitiveReference
#define	PersistTransitiveReference

#include	<iostream>

#include	<persist/ref.H>
#include	<persist/DtorCommand.H>
#include	<persist/GetPutDel.H>

namespace	Persistence
{
  template<class W, class V> class tref : public ref<V *>
  {
    typedef ref<V *>	refV;

  protected:
    ref<W *>	ownr;
    

  public:
    tref()
      : ref<V *>()
	, ownr()
    {}

    tref(
	 const W &	own
	 ,const V &	nee
	 ) throw()
      : ref<V *>(nee)
	, ownr(own)
    {
      if ( ownr != 0 )
	ownr->update();
    }

    tref(
	 const V & 	nee
	 )
      : ref<V *>(nee)
	, ownr()
    {
      if ( ownr != 0 )
	ownr->update();
    }

    explicit
    tref(Id	nee)
      : ref<V *>(nee)
	,ownr()
    {
      if ( ownr != 0 )
	ownr->update();
    }

    explicit
    tref(Id 	own
	 ,Id	nee)
      : ref<V *>(nee)
	,ownr(own)
    {
      if ( ownr != 0 )
	ownr->update();
    }

    explicit
    tref(bool)
      :ref<V *>(0)
      , ownr(0)
    {
      if ( ownr != 0 )
	ownr->update();
    }

    W *
    owner()
    {
      return(ownr.operator->());
    }

    ~tref()
    {
      Id oldId = refV::id_;
      // clean up
      refV::operator = (oldId);
      W * own = owner();

      if ( refV::id_ ) {
	V * o = get<V>(refV::id_);
	// do this so that swizzle DOES repair
	refV::object_ = o;

	if ( o  && own )
	  {
	    if ( own->dtorCommand() == DtorCommand::PUT )
	      {
		Status s(o->put());
		own->setDtorStatus(s);
	      }
	    else if ( own->dtorCommand() == DtorCommand::DEL )
	      {
		Status s(o->del());
		refV::operator =( Id(0) );
		own->setDtorStatus(s);
		own->update();
	      }
	    else if ( own->dtorCommand() == DtorCommand::RELOCATE )
	      {
		o->relocate();
	      }
	    else if ( own->dtorCommand() == DtorCommand::SWIZZLE )
	      {
		o->swizzle();
	      }
	  }
      }
      else if ( oldId && own )
	{
	  // object not found, this (owner) was cleaned up
	  own->update();
	}
    }

    tref &	operator = (const tref & r) throw()
    {
      ownr = r.ownr;
      ref<V *>::operator=(*static_cast<const refV *>(&r));
      return(*this);
    }
      
    bool operator == (const tref & r) const throw()
    {
      return ( (ownr == r.ownr)
	       &&
	       (ref<V *>::operator==(*static_cast<const refV *>(&r)))
	       );
    }

    bool operator != (const tref & r) const throw()
    {
      return ( ! operator==(r) );
    }

    tref &
    operator = (Id	i)
    {
      ref<V *>::operator = (i);
      return(*this);
    }

    bool
    operator == (Id i) const throw()
    {
      return(ref<V *>::operator == (i));
    }

    bool
    operator != (Id i) const throw()
    {
      return( ! operator == (i) );
    }

  };

}
#endif
