/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* basic Persistence::BlockStream interface                                  */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExamplesBlockStream
#define	ExamplesBlockStream

#ifdef __GNUG__
#pragma interface
#endif

#include	<string>
#include	<iostream>

extern	"C"
{
#include	<pthread.h>
}

namespace Examples
{
  class BlockStream;
  typedef BlockStream	BS;

  using std::string;

  class	BlockStream
  {
  private:
    pthread_mutex_t	lock;


  public:
    BlockStream() throw()
    {
      pthread_mutex_init(&lock, 0);
    }

    virtual
    ~BlockStream() throw ()
    {}

    void
    begin()
    {
      pthread_mutex_lock(&lock);
      std::cout << std::endl << "[";
    }

    void
    end()
    {
      std::cout << "]" << std::endl;
      pthread_mutex_unlock(&lock);
    }
  }
  ;

  extern BS	Bout;
  
}
#endif
