/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Filter - base filter interface                                  */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleFilter
#define	ExampleFilter


#ifdef __GNUG__
#pragma interface
#endif

#include	<persist/Object.H>
#include	<persist/DtorCommand.H>

namespace	Examples
{
  class Filter;
}
#include	<Sync.H>
#include	<Thread.H>

namespace	Examples
{
  using namespace	Persistence;

  void *	runFilter(void *);

  class	Filter : public Object, public DtorCommand, public Thread
  {
  protected:
    refSync	rsync;

    void	sync();

    friend void *	runFilter(
				  void * filtr
				  )
      // calls	Filter::bind
      //	Filter::relocate with sync
      //	Filter::swizzle with sync
      //	Filter::run
      // returns runStatus
      ;

  public:
    Filter()
      : Obj()
      , DtorCommand()
    {}
    
    // ctor and dtor are compiled
    // due to Sync/Filter cross reference
    Filter(
	   const char *	nm	// name
	   ,Id		clasid	// class id
	   ,bool	first	// first thread ever?
	   ,int		cp	// which node to run thread on
	   ,Sync &	syn
	   );

    virtual
    ~Filter();

    virtual
    Filter *	relocate(){return(0);}
    virtual
    void	swizzle(){}
    virtual
    void	run(){}
    virtual
    Status	put(){return(Status(false));}
    virtual
    Status	del(){return(Status(false));}
    virtual
    void	dump(
		     ostream &	out
		     ) const{};

  }
  ;
}
#endif

