/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::SrcFilter - source Filter interface                             */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleSrcFilter
#define	ExampleSrcFilter	211

#define	SrcFilterClassDecl  "SrcFilter.H $Id$ keyword substitution from version control"

#ifdef __GNUG__
#pragma interface
#endif


#include	<Sync.H>
#include	<Que.H>
#include	<Class.H>


namespace	Examples
{
  using namespace	Persistence;

  class	SrcFilter : public Filter, public ClassInfo
  {
    typedef Que::iterwriter		iWrite;
    typedef tref<SrcFilter, Que>	trefQue;

    friend class ClassInfo;
    // class data and methods
  private:
    // common to all persistent classes
    static
    Id			ClassId;
    static
    Name		ClassName;
    static
    LongName		ClassDecl;
    static
    LongName		ClassImpl;
  public:
    static
    Id    		classId()
    {
      return(ClassId);
    }
    
    static
    const char *	className()
    {
      return(ClassName.cstr());
    }
    
    static
    const char *	classDecl()
    {
      return(ClassDecl.cstr());
    }

    static
    const char *	classImpl()
    {
      return(ClassImpl.cstr());
    }

  private:
    trefQue	outputQue;
    size_t	testLength;

  public:
    SrcFilter()
      : Filter()
      , outputQue()
    {}

    SrcFilter(
	      bool	first	// first thread ever?
	      ,int	nod	// which node to run thread on
	      ,Sync &	syn
	      ,Que &	outque
	      ,size_t	tlen
	      );

    virtual
    ~SrcFilter();
						   

    Status	start();		/* called by spawner
					   starts this filter on a separate thread
					*/

    SrcFilter *	relocate();
    void	swizzle();
    void	run();
    Status	put();
    Status	del();

    void	dump(
		     ostream &	out
		     ) const;


  }
  ;

}
#endif

