/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::ThruFilter - through Filter implementation                      */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif

#include	<ThruFilter.H>
#include	<persist/GetPutDelTemplates.H>
#include	<persist/RelocateTemplates.H>
#include	<BlockStream.H>

namespace	Persistence
{
  using namespace Examples;

  //
  // instantiate template functions
  //
  template
  ThruFilter *	get(
		    const char *	name
		    );

  template
  ThruFilter *	get(
		    const Id
		    );
  template
  Status	put(
		    ThruFilter &
		    );
  template
  Status	del(
		    ThruFilter &
		    );
  template
  ThruFilter *	first();

  template
  ThruFilter *	next(const ThruFilter	&);

  template
  ThruFilter *	relocate(
			 ThruFilter &
			 );

  template
  void		swizzle(
			ThruFilter &
			);

}


namespace	Examples
{
  using namespace	Persistence;

  Id		ThruFilter::ClassId(ExampleThruFilter);
  Name		ThruFilter::ClassName("ThruFilter");
  LongName	ThruFilter::ClassDecl(ThruFilterClassDecl);
  LongName	ThruFilter::ClassImpl("ThruFilter.C $Id$ keyword substitution from version control");

  ThruFilter::ThruFilter(
			 bool		first	// first thread ever?
			 ,int		nod	// which node to run thread on
			 ,Sync &	syn
			 ,Que &		inque
			 ,Que &		outque
			 )
    : Filter(((Name(inque.cname())
	       + "->"
	       )
	      + outque.cname()
	      ).cstr()
	     ,classId()
	     ,first
	     ,nod
	     ,syn
	     )
    , inputQue(inque)
    , outputQue(*this
		,outque
		)
  {
    init(
	 ClassId		// Class ClassId
	 ,ClassName.cstr()
	 ,ClassDecl.cstr()
	 ,ClassImpl.cstr()	// Class Class Impl
	 ,0			// don't keep track of ThruFilter objects
	 );
    inque.output(this->id());
    outque.input(this->id());

    middleOfInput = inque - outque;
    middleOfOutput = outque - inque;
    std::cout << "middleOfOutput:" << middleOfOutput.start() << " " << middleOfOutput.size() <<std::endl;
    std::cout << "middleOfInput:" << middleOfInput.start() << " " << middleOfInput.size() <<std::endl;
  }

  ThruFilter::~ThruFilter()
  {
    /*
    if ( (dtorCommand() == DtorCommand::DEL)
	 ||
	 (dtorCommand() == DtorCommand::DELETE)
	 )
      {
	refQue r(inputQue);	// check to see whether inputQue still there
	if ( r != 0 )
	  r->output(0);

	outputQue->input(0);
      }
    */
  }

  Status
  ThruFilter::start()
  {
    // first initialize outputQue
    outputQue->initReadWrite();

    Status s = outputQue->start();
    if ( s.succeeded() )
      {
	s &= Filter::start();
      }

    if ( !s.succeeded() )
      {
	s &= Status (
		     "SrcFilter"
		     ,"start"
		     ,cname()
		     );
	s.os() << " failed to start on separate thread" << std::endl;
      }
    return(s);
  }
  
  //------------------------------------------------------------------------------
  Status
  ThruFilter::put()
  {
    Status s(Persistence::put<ThruFilter>(*this));

    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("ThruFilter"
		   ,"put"
		   ,cname()
		   );
	sta.os() << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }

  Status
  ThruFilter::del()
  {
    Status s(Persistence::del<ThruFilter>(*this));
    
    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("ThruFilter"
		   ,"del"
		   ,cname()
		   );
	sta.os() << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }
  //------------------------------------------------------------------------------
  ThruFilter *
  ThruFilter::relocate()
  {
    return(Persistence::relocate<ThruFilter>(*this));
  }

  void
  ThruFilter::swizzle()
  {
    Persistence::swizzle<ThruFilter>(*this);
  }

  void
  ThruFilter::run()
  {
    iRead r = inputQue->beginRead();
    for ( 
	 iWrite w = outputQue->beginWrite()
	   ;
	 r != inputQue->endRead()
	   ;
	 ++r
	   , ++w
	 )
      {
	Array		input(*r);
	Array		output(*w);
	SubArray 	subout = *w;

	Bout.begin();
	std::cout << "input frame:" << std::endl;
	for ( size_t j = 0
		;
	      j < input.size()
		;
	      j++
	      )
	  {
	    if ( 0 != j )
	      std::cout << ", ";
	    std::cout << input[j];
	  }
	std::cout << std::endl;
	std::cout << "middleOfOutput:" << middleOfOutput.start() << " " << middleOfOutput.size() <<std::endl;
	std::cout << "middleOfInput:" << middleOfInput.start() << " " << middleOfInput.size() <<std::endl;
	Bout.end();

	output[middleOfOutput] = input[middleOfInput];

	subout = output;

	//std::cout << cname() << " passed frame " << output[middleOfOutput.start()] << std::endl;

      }
  }
  //------------------------------------------------------------------------------
  void		ThruFilter::dump(
			       ostream &	out
			       ) const
  {
    Object::dump(out);

    out << "input  que is " << inputQue->cname()  << std::endl;
    out << "output que is " << outputQue->cname() << std::endl;
  }

}
