/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::ThruFilter - throughput Filter interface                        */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleThruFilter
#define	ExampleThruFilter	213

#define	ThruFilterClassDecl  "ThruFilter.H $Id$ keyword substitution from version control"

#ifdef __GNUG__
#pragma interface
#endif


#include	<Sync.H>
#include	<Que.H>


namespace	Examples
{
  using namespace	Persistence;


  class	ThruFilter : public Filter, public ClassInfo
  {
    typedef Que::iterwriter		iWrite;
    typedef Que::itereader		iRead;
    typedef tref<ThruFilter, Que>	trefQue;


    friend class ClassInfo;
    // class data and methods
  private:
    // common to all persistent classes
    static
    Id			ClassId;
    static
    Name		ClassName;
    static
    LongName		ClassDecl;
    static
    LongName		ClassImpl;
  public:
    static
    Id    		classId()
    {
      return(ClassId);
    }
    
    static
    const char *	className()
    {
      return(ClassName.cstr());
    }
    
    static
    const char *	classDecl()
    {
      return(ClassDecl.cstr());
    }

    static
    const char *	classImpl()
    {
      return(ClassImpl.cstr());
    }

  private:
    refQue	inputQue;		// no relocating input (read) que here
    trefQue	outputQue;		// relocating output (write) que here

  public:
    slice	middleOfInput;
    slice	middleOfOutput;

    ThruFilter()
      : Filter()
      , inputQue()
      , outputQue()
	// slice() works differently with g++4.2 than with g++4.3.
	// In g++ 4.2, slice() does not presume to initialize.
	// In g++ 4.3, slice() seems to initialize to 0.
	// This breaks object persistence on reconstruction.
	// However, this problem show up only with these embedded slices.
	// This means you should not embed any libstdc++ object
	// in a persistent object.
      , middleOfInput()
      , middleOfOutput()
    {}

    ThruFilter(
	       bool		first	// first thread ever?
	       ,int		nod	// which node to run thread on
	       ,Sync &		syn
	       ,Que &		inque
	       ,Que &		outque
	       );

    virtual
    ~ThruFilter();
					   

    Status	start();		/* called by spawner
					   starts this filter on a separate thread
					*/

    ThruFilter *relocate();
    void	swizzle();
    void	run();
    Status	put();
    Status	del();

    void	dump(
		     ostream &	out
		     ) const;


  }
  ;

}
#endif

