/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::Exception class interface                                    */
/*                                                                           */
/*===========================================================================*/
#ifndef	PersistException
#define	PersistException

#ifdef __GNUG__
#pragma interface
#endif

#include	<exception>
#include	<string>
#include	<sstream>


namespace	Persistence
{
  using	std::exception;
  using std::string;
  using	std::ostringstream;
    
  class Exception : public exception
  {
  protected:
    ostringstream os_;

  public:
    Exception()
      : exception()
    {}

    Exception(
	      const char *	nm
	      ,const char *	clasnm
	      ,const char *	funnm
	      ,const char *	objnm = ""
	      ) throw()
      ;

    Exception(
	      const	Exception &	ex
	      ) throw()
      ;

    virtual
    ~Exception() throw()
    {}

    ostringstream &
    os()
    {
      return(os_);
    }

    virtual
    const char* what() const throw()
      ;
  }
  ;
}
#endif
