/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <cstdio>
#include <iostream>
#include <string>
#include "parser.h"
#include "my_string.h"
#include "net.h"
#include "netpthread.h"

int main(int argc, char *argv[])
{

	// Non-multi-core parsing

	cola::Parser<std::string, cola::my_string<std::string> > parser(std::string("./loadfile"),std::string("./parsefile"),1);
	parser.parse();
	std::cout<<"123"<<std::endl;	


	// Multi-core-parsing
/*
	cola::Net<std::string, cola::my_string<std::string> > net;
	net.fork(std::string("./loadfile"), std::string("./parsefile"), 0);
	net.fork(std::string("./loadfile"), std::string("./parsefile"), 1);
*/

	return 0;

}
