/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <sys/types.h>
#include <signal.h>
#include <iostream>
#include <cstring>
#include "parser.h"
#include "my_string.h"

namespace cola {
template <class S, class T>
Parser<S,T>::Parser(S const& fn, S const& parsefn, int wid) 
	: _filename(fn), _parsefilename(parsefn)
{
	_wordid = wid;
}

template <class S, class T>
int Parser<S,T>::parse()
{
	std::map<int, T> m;
	T buf;
	this->load(_filename, _parsefilename, m, buf);
	std::cout << "parsing ..." << std::endl;
	int j = 0;
		/* FIXME: parse_for(T("root"), j, buf); */
		this->parse_for(m[_wordid], j, buf);
		if (j < buf.length()-1) {
			switch (_wordid) {
			case 0:{	
				std::cout << "parsing 0 case..." << std::endl;
				return 0;
				break;
			}
			case 1:{	
				std::cout << "parsing 1 case..." << std::endl;
				return 0;
				break;
			}
			case 2:{	
				std::cout << "parsing 2 case..." << std::endl;
				return 0;
				break;
			}
			case 3:{	
				std::cout << "parsing 3 case..." << std::endl;
				return 0;
				break;
			}
			case 4:{	
				std::cout << "parsing texteditor..." << std::endl;
				return 0;
				break;
			}
			default:{
			}
		}
		}

	return -1;

};

}
template class cola::Parser<std::string, cola::my_string<std::string> >;

