/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "matrix.h"
#include <string>
#include <cstring>
#include <iostream>

namespace cola {

template<class I>	
matrix<I>::matrix(int nrows, int mcols)
{
	int i;
	while (i++ < nrows) {
		std::vector<I> v;
		v.reserve(mcols);
		this->_rows.push_back(v);
	}
}

template<class I>	
matrix<I>::matrix(matrix const& s)
{
//	if (s == *this)
//		return;

	this->_rows = s._rows;
}

template<class I>	
matrix<I>& matrix<I>::operator=(matrix const& s)
{
//	if (s == *this)
//		return *this;

	this->_rows = s._rows;

	return *this;
}

template<class I>
std::vector<I> matrix<I>::operator[](int index)
{
	return _rows[index];
}

template<class I>
void matrix<I>::set(I data, int r, int c)
{

	_rows[r][c] = data;

}

}

template class cola::matrix<double>;
