/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <functional> 
#include <unistd.h> 
#include <signal.h> 
#include <cstdlib> 
#include "net.h"
#include "my_string.h"

namespace cola {


inline void signalforkfunc(int) {

	//auto unpause

/*
	if (globals::gui.askinitialized() == 0) {

	//		raise(31); //SIGUSR2

	}	
*/
}

template <class S, class T>
int Net<S,T>::waitforall() 
{

	killpg(_pgid, 30); //SIGUSR1
	return 0;
}

template <class S, class T>
int Net<S,T>::fork(S const& loadfilename, S const& parsefilename, int const& wordid)
{
	pid_t pid, pid2 = -1;
	if ((pid = ::fork()) < 0)
		return -1;
	else if (pid2 == 0) { //child
		if ((pid = ::fork()) < 0)
			return -1;
		else if (pid == 0) { //child
			setpgid(pid, _pgid);
			_scheduler[_scheduler.size()] = pid;//FIXME -1 	
			signal(30,signalforkfunc);

			//wait for root window to be initialized
			if (pid != _scheduler[0])
				pause();
			parse(Parser<S,T>(loadfilename, parsefilename,wordid));
		} else { /* parent 2 */ }
		std::exit(0);
	} else { //parent
		std::exit(0);
	}

	return 0;
}

template <class S, class T>
int Net<S,T>::parse(Parser<S,T> parser)
{
	return parser.parse();

}

}

template class cola::Net<std::string, cola::my_string<std::string> >;
