/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "transition_matrix.h"
#include <string>
#include <cstring>
#include <iostream>

namespace cola {

transition_matrix::transition_matrix(int nrows, int mcols)
	: matrix(nrows, mcols)
{
}
/***
transition_matrix::transition_matrix(transition_matrix const& s)
{
//	if (s == *this)
//		return;

	this->_rows = s._rows;
}
***/
transition_matrix& transition_matrix::operator=(transition_matrix const& s)
{
//	if (s == *this)
//		return *this;

	this->_rows = s._rows;

	return *this;
}

transition_matrix transition_matrix::operator*(transition_matrix const& m)
{
	//FIXME
	transition_matrix returnm(const_cast<transition_matrix&>(m).getnrows(), const_cast<transition_matrix&>(m).getncols());
	//must be equal length

	int i = 0;
	for (std::vector<std::vector<double> >::iterator vi = _rows.begin();
		vi != _rows.end();
		vi++, i++) {

		double result;
		int j = 0;
		for (j = 0; j < _rows.size(); j++) {

	
			result += ((const_cast<transition_matrix&>(m))[i])[j] * (*vi)[j];

		}
		returnm.set(result, j,i);
		result = 0;
		i = 0;
	}	
	return returnm;
}

std::vector<double> transition_matrix::operator*(std::vector<double>  const& v)
{
	std::vector<double> resultv;
	resultv.reserve(const_cast<std::vector<double>& >(v).size());
	//must be equal length

	int k = 0;
	int i = 0;
	int j = 0;
	for (std::vector<std::vector<double> >::iterator vi = _rows.begin();
		vi != _rows.end();
		vi++, i++) {
		for (std::vector<double>::iterator wi = const_cast<std::vector<double>& >(v).begin();
			wi != v.end();
			wi++,j++) {
			double d = (*wi) * (*vi)[i] + resultv[k];  
			resultv[k] = d; 
		}
		k++;
		i = 0;
		j = 0;
	}
	return resultv;
}

}
